/*
 * Decompiled with CFR 0.152.
 */
package action;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import data.Log;
import data.task.GetTranslationTask;
import java.io.IOException;
import java.util.List;
import language_engine.TranslationEngineType;
import module.AndroidString;
import module.SupportedLanguages;
import org.jetbrains.annotations.Nullable;
import ui.MultiSelectDialog;

public class ConvertToOtherLanguages
extends AnAction
implements MultiSelectDialog.OnOKClickedListener {
    private static final String LOCALIZATION_TITLE = "Choose alternative string resources";
    private static final String LOCALIZATION_MSG = "Warning: The string resources are translated by %s, try keeping your string resources simple, so that the result is more satisfied.";
    private static final String OVERRIDE_EXITS_STRINGS = "Override the existing strings";
    private Project project;
    private List<AndroidString> androidStringsInStringFile = null;
    public TranslationEngineType defaultTranslationEngine = TranslationEngineType.Bing;
    private VirtualFile clickedFile;

    public ConvertToOtherLanguages() {
        super("Convert to other languages", null, IconLoader.getIcon((String)"/icons/globe.png"));
    }

    public void update(AnActionEvent e) {
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        boolean isStringXML = ConvertToOtherLanguages.isStringXML(file);
        e.getPresentation().setEnabled(isStringXML);
        e.getPresentation().setVisible(isStringXML);
    }

    public void actionPerformed(AnActionEvent e) {
        this.project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (this.project == null) {
            return;
        }
        this.clickedFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        Log.i("clicked file: " + this.clickedFile.getPath());
        if (PropertiesComponent.getInstance().isValueSet("SettingLanguageEngine")) {
            this.defaultTranslationEngine = TranslationEngineType.fromName(PropertiesComponent.getInstance().getValue("SettingLanguageEngine"));
        }
        try {
            this.androidStringsInStringFile = AndroidString.getAndroidStringsList(this.clickedFile.contentsToByteArray());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (this.androidStringsInStringFile == null || this.androidStringsInStringFile.isEmpty()) {
            ConvertToOtherLanguages.showErrorDialog(this.project, "Target file does not contain any strings.");
            return;
        }
        MultiSelectDialog multiSelectDialog = new MultiSelectDialog(this.project, String.format(LOCALIZATION_MSG, this.defaultTranslationEngine.getDisplayName()), LOCALIZATION_TITLE, OVERRIDE_EXITS_STRINGS, PropertiesComponent.getInstance((Project)this.project).getBoolean("AL_OverrideCheckBoxStatus", false), this.defaultTranslationEngine, false);
        multiSelectDialog.setOnOKClickedListener(this);
        multiSelectDialog.show();
    }

    @Override
    public void onClick(List<SupportedLanguages> selectedLanguages, boolean overrideChecked) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.project);
        propertiesComponent.setValue("AL_OverrideCheckBoxStatus", String.valueOf(overrideChecked));
        List<SupportedLanguages> allData = SupportedLanguages.getAllSupportedLanguages(this.defaultTranslationEngine);
        for (SupportedLanguages language : allData) {
            propertiesComponent.setValue("AL_SupportedLanguageCheckStatus_" + language.getLanguageCode(), String.valueOf(selectedLanguages.contains((Object)language)));
        }
        new GetTranslationTask(this.project, "Translation in progress, using " + this.defaultTranslationEngine.getDisplayName(), selectedLanguages, this.androidStringsInStringFile, this.defaultTranslationEngine, overrideChecked, this.clickedFile).setCancelText("Translation has been canceled").queue();
    }

    public static void showErrorDialog(Project project, String msg) {
        Messages.showErrorDialog((Project)project, (String)msg, (String)"Error");
    }

    private static boolean isStringXML(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        if (!file.getName().equals("strings.xml")) {
            return false;
        }
        if (file.getParent() == null) {
            return false;
        }
        return file.getParent().getName().equals("values") || file.getParent().getName().startsWith("values-en");
    }
}

