<?php

/*
 * Textpattern Content Management System
 * https://textpattern.com/
 *
 * Copyright (C) 2026 The Textpattern Development Team
 *
 * This file is part of Textpattern.
 *
 * Textpattern is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, version 2.
 *
 * Textpattern is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Textpattern. If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * Constants.
 */

/**
 * Textpattern version.
 */

$thisversion = '5.0.0-dev';

/**
 * Development environment?
 *
 * Set false for releases.
 */

$txp_is_dev = true;

if (!defined('TXP_DEBUG')) {
    /**
     * If set to "1", dumps debug log to the temp directory.
     *
     * This constant can be overridden from the config.php.
     *
     * @package Debug
     * @example
     * define('TXP_DEBUG', 1);
     */

    define('TXP_DEBUG', 0);
}

/**
 * Comment spam status.
 *
 * @package Comment
 */

define('SPAM', -1);

/**
 * Comment moderate status.
 *
 * @package Comment
 */

define('MODERATE', 0);

/**
 * Comment spam status.
 *
 * @package Comment
 */

define('VISIBLE', 1);

/**
 * Comment reload status.
 *
 * @package Comment
 */

define('RELOAD', -99);

if (!defined('HELP_URL')) {
    /**
     * The location where help documentation is fetched.
     *
     * This constant can be overridden from the config.php.
     *
     * @example
     * define('HELP_URL', 'https://example.com/help/');
     */

    define('HELP_URL', 'https://textile-lang.com');
}

/**
 * Do not format text.
 *
 * @var     string
 * @package Textfilter
 */

define('LEAVE_TEXT_UNTOUCHED', '0');

/**
 * Format text with Textile.
 *
 * @var     string
 * @package Textfilter
 */

define('USE_TEXTILE', '1');

/**
 * Replace line breaks with HTML &lt;br /&gt; tag.
 *
 * @var     string
 * @package Textfilter
 */

define('CONVERT_LINEBREAKS', '2');

/**
 * System is Windows if TRUE.
 *
 * @package System
 */

define('IS_WIN', strpos(strtoupper(PHP_OS), 'WIN') === 0);

/**
 * Directory separator character.
 *
 * @package File
 */

define('DS', defined('DIRECTORY_SEPARATOR') ? DIRECTORY_SEPARATOR : (IS_WIN ? '\\' : '/'));

/**
 * Magic quotes GPC, TRUE if on.
 *
 * @package Network
 * @deprecated in 4.8.0
 */

define('MAGIC_QUOTES_GPC', false);

if (!defined('REGEXP_UTF8')) {
    /**
     * TRUE if the system supports UTF-8 regex patterns.
     *
     * This constant can be overridden from the config.php in case UTF-8 regex
     * patterns cause issues.
     *
     * @package System
     * @example
     * define('REGEXP_UTF8', false);
     */

    define('REGEXP_UTF8', @preg_match('@\pL@u', 'q'));
}

/**
 * Permlink URL mode.
 *
 * @package    URL
 * @deprecated ?
 */

define('PERMLINKURL', 0);

/**
 * Pagelink URL mode.
 *
 * @package    URL
 * @deprecated ?
 */

define('PAGELINKURL', 1);

if (!defined('EXTRA_MEMORY')) {
    /**
     * Allocated extra memory.
     *
     * Used when creating thumbnails for instance.
     *
     * This constant can be overridden from the config.php.
     *
     * @package System
     * @example
     * define('EXTRA_MEMORY', '64M');
     */

    define('EXTRA_MEMORY', '32M');
}

/**
 * PHP is run as CGI.
 *
 * @package System
 */

define('IS_CGI', strpos(PHP_SAPI, 'cgi') === 0);

/**
 * PHP is run as FCGI.
 *
 * @package System
 */

define('IS_FASTCGI', IS_CGI and empty($_SERVER['FCGI_ROLE']) and empty($_ENV['FCGI_ROLE']));

/**
 * PHP is run as Apache module.
 *
 * @package System
 */

define('IS_APACHE', !IS_CGI and strpos(PHP_SAPI, 'apache') === 0);

/**
 * Preference is user-private.
 *
 * @package Pref
 * @see     set_pref()
 */

define('PREF_PRIVATE', true);

/**
 * Preference is global.
 *
 * @package Pref
 * @see     set_pref()
 */

define('PREF_GLOBAL', false);

/**
 * Preference type is basic.
 *
 * @package    Pref
 * @deprecated in 4.6.0
 * @see        PREF_CORE
 * @see        set_pref()
 */

define('PREF_BASIC', 0);

/**
 * Preference type is a core setting.
 *
 * @package Pref
 * @see     set_pref()
 */

define('PREF_CORE', 0);

/**
 * Preference type is advanced.
 *
 * @package    Pref
 * @deprecated in 4.6.0
 * @see        PREF_CORE
 * @see        PREF_PLUGIN
 * @see        set_pref()
 */

define('PREF_ADVANCED', 1);

/**
 * Preference type is a plugin or third party setting.
 *
 * @package Pref
 * @see     set_pref()
 */

define('PREF_PLUGIN', 1);

/**
 * Preference type is hidden.
 *
 * @package Pref
 * @see     set_pref()
 */

define('PREF_HIDDEN', 2);

/**
 * Preference type is from a theme
 *
 * @package Pref
 * @see     \Textpattern\Admin\Theme
 */

define('PREF_THEME', 3);

/**
 * The character to use between items in key/name fields
 *
 * NB: Don't use dot (.) because they are often stripped out of HTML
 * form name= attributes during transmission to the server.
 *
 * @package Pref
 * @see     \Textpattern\Admin\Theme
 */

define('PREF_THEME_DELIMITER', '|');

/**
 * Plugin flag: has an options page.
 */

define('PLUGIN_HAS_PREFS', 0x0001);

/**
 * Plugin flag: offers lifecycle callbacks.
 */

define('PLUGIN_LIFECYCLE_NOTIFY', 0x0002);

/**
 * Reserved bits for use by Textpattern core.
 */

define('PLUGIN_RESERVED_FLAGS', 0x0fff);

if (!defined('PLUGINPATH')) {
    /**
     * Plugin storage directory.
     *
     * This constant can be overridden from the config.php.
     *
     * @package Files
     * @example
     * define('PLUGINPATH', $txpcfg['txpath'] . '/plugins');
     */

    global $txpcfg;
    $admin_path = (isset($txpcfg['multisite_root_path'])) ? $txpcfg['multisite_root_path'].DS.'admin' : txpath;
    define('PLUGINPATH', $admin_path.DS.'plugins');
}

if (!defined('PLUGIN_REPO_URL')) {
    /**
     * Remote plugin repository.
     *
     * This constant can be overridden from the config.php.
     *
     * @package Plugin
     * @since   4.9.0
     * @example
     * define('PLUGIN_REPO_URL', 'https://example.com/my-plugins');
     */

    define('PLUGIN_REPO_URL', 'https://plugins.textpattern.com');
}

if (!defined('LOG_REFERER_PROTOCOLS')) {
    /**
     * Sets accepted protocols for HTTP referrer header.
     *
     * This constant can be overridden from the config.php.
     *
     * @package Log
     * @since   4.6.0
     * @example
     * define('LOG_REFERER_PROTOCOLS', 'http');
     */

    define('LOG_REFERER_PROTOCOLS', 'http, https');
}

if (!defined('PASSWORD_LENGTH')) {
    /**
     * Password default length, in characters.
     *
     * This constant can be overridden from the config.php.
     *
     * @package User
     * @example
     * define('PASSWORD_LENGTH', 14);
     */

    define('PASSWORD_LENGTH', 16);
}

if (!defined('PASSWORD_COMPLEXITY')) {
    /**
     * Password iteration strength count.
     *
     * This constant can be overridden from the config.php.
     *
     * @package User
     * @example
     * define('PASSWORD_COMPLEXITY', 2);
     */

    define('PASSWORD_COMPLEXITY', 8);
}

if (!defined('PASSWORD_PORTABILITY')) {
    /**
     * Passwords are created portable if TRUE.
     *
     * This constant can be overridden from the config.php.
     *
     * @package User
     * @example
     * define('PASSWORD_PORTABILITY', false);
     */

    define('PASSWORD_PORTABILITY', true);
}

if (!defined('PASSWORD_SYMBOLS')) {
    /**
     * Symbols used in auto-generated passwords.
     *
     * This constant can be overridden from the config.php.
     *
     * @package User
     * @since   4.6.0
     * @see     Textpattern\Password\Generator
     * @example
     * define('PASSWORD_SYMBOLS', '23456789ABCDEFGHJKLMNPQRSTUYXZabcdefghijkmnopqrstuvwxyz_?!-@$%^*;:');
     */

    define('PASSWORD_SYMBOLS', '23456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz_-!?.');
}

if (!defined('HASHING_ALGORITHM')) {
    /**
     * Algorithm to use for hashing passwords/reset requests.
     *
     * This constant can be overridden from the config.php.
     *
     * @package User
     * @since   4.6.0
     * @see     PHP's hash_algos() function
     * @example
     * define('HASHING_ALGORITHM', 'whirlpool');
     */

    define('HASHING_ALGORITHM', 'ripemd256');
}

if (!defined('SALT_LENGTH')) {
    /**
     * Length of salt/selector hashes.
     *
     * This constant can be overridden from the config.php.
     *
     * @package User
     * @since   4.6.0
     * @example
     * define('SALT_LENGTH', '80');
     */

    define('SALT_LENGTH', '64');
}

if (!defined('RESET_EXPIRY_MINUTES')) {
    /**
     * Length of time (in minutes) that a password reset request remains valid.
     *
     * This constant can be overridden from the config.php.
     * Values under 60 may fall foul of DST changeover times, but meh.
     *
     * @package User
     * @since   4.6.0
     * @example
     * define('RESET_EXPIRY_MINUTES', '120');
     */

    define('RESET_EXPIRY_MINUTES', '90');
}

if (!defined('RESET_RATE_LIMIT_MINUTES')) {
    /**
     * Minutes during which multiple user-submitted password reset requests are ignored.
     *
     * This constant can be overridden from the config.php.
     *
     * @package User
     * @since   4.6.0
     * @example
     * define('RESET_RATE_LIMIT_MINUTES', '15');
     */

    define('RESET_RATE_LIMIT_MINUTES', '5');
}

if (!defined('ACTIVATION_EXPIRY_HOURS')) {
    /**
     * Length of time (in hours) that a password activation (new account) link remains valid.
     *
     * This constant can be overridden from the config.php.
     *
     * @package User
     * @since   4.6.0
     * @example
     * define('ACTIVATION_EXPIRY_HOURS', '48');
     */

    define('ACTIVATION_EXPIRY_HOURS', '168');
}

if (!defined('LOGIN_COOKIE_HTTP_ONLY')) {
    /**
     * If TRUE, login cookie is set just for HTTP.
     *
     * This constant can be overridden from the config.php.
     *
     * @package CSRF
     * @example
     * define('LOGIN_COOKIE_HTTP_ONLY', false);
     */

    define('LOGIN_COOKIE_HTTP_ONLY', true);
}

if (!defined('X_FRAME_OPTIONS')) {
    /**
     * Sets X-Frame-Options HTTP header's value.
     *
     * This is used to prevent framing of authenticated pages.
     *
     * This constant can be overridden from the config.php.
     *
     * @package CSRF
     * @example
     * define('X_FRAME_OPTIONS', 'DENY');
     */

    define('X_FRAME_OPTIONS', 'SAMEORIGIN');
}

if (!defined('CONTENT_SECURITY_POLICY')) {
    /**
     * Sets Content-Security-Policy HTTP header's value.
     *
     * This constant can be overridden from the config.php.
     *
     * @since   4.7.0
     * @package CSRF
     */

    define('CONTENT_SECURITY_POLICY', "frame-ancestors 'self'");
}

if (!defined('AJAX_TIMEOUT')) {
    /**
     * AJAX timeout in seconds.
     *
     * This constant can be overridden from the config.php.
     *
     * @package Ajax
     * @example
     * define('AJAX_TIMEOUT', 10);
     */

    define('AJAX_TIMEOUT', 1000 * max(30, (int)ini_get('max_execution_time')));
}

/**
 * Render on initial synchronous page load.
 *
 * @since   4.5.0
 * @package Ajax
 */

define('PARTIAL_STATIC', 0);

/**
 * Render as HTML partial on every page load.
 *
 * @since   4.5.0
 * @package Ajax
 */

define('PARTIAL_VOLATILE', 1);

/**
 * Render as an element's jQuery.val() on every page load.
 *
 * @since   4.5.0
 * @package Ajax
 */

define('PARTIAL_VOLATILE_VALUE', 2);

/**
 * Draft article status ID.
 *
 * @package Article
 */

define('STATUS_DRAFT', 1);

/**
 * Hidden article status ID.
 *
 * @package Article
 */

define('STATUS_HIDDEN', 2);

/**
 * Pending article status ID.
 *
 * @package Article
 */

define('STATUS_PENDING', 3);

/**
 * Live article status ID.
 *
 * @package Article
 */

define('STATUS_LIVE', 4);

/**
 * Sticky article status ID.
 *
 * @package Article
 */

define('STATUS_STICKY', 5);

if (!defined('WRITE_RECENT_ARTICLES_COUNT')) {
    /**
     * Number of recent articles displayed on the Write panel.
     *
     * This constant can be overridden from the config.php.
     *
     * @package Admin\Article
     * @since   4.6.0
     * @example
     * define('WRITE_RECENT_ARTICLES_COUNT', 5);
     */

    define('WRITE_RECENT_ARTICLES_COUNT', 10);
}

/**
 * Input size extra large.
 *
 * @since   4.5.0
 * @package Form
 */

define('INPUT_XLARGE', 96);

/**
 * Input size large.
 *
 * @since   4.5.0
 * @package Form
 */

define('INPUT_LARGE', 64);

/**
 * Input size regular.
 *
 * @since   4.5.0
 * @package Form
 */

define('INPUT_REGULAR', 32);

/**
 * Input size medium.
 *
 * @since   4.5.0
 * @package Form
 */

define('INPUT_MEDIUM', 16);

/**
 * Input size small.
 *
 * @since   4.5.0
 * @package Form
 */

define('INPUT_SMALL', 8);

/**
 * Input size extra small.
 *
 * @since   4.5.0
 * @package Form
 */

define('INPUT_XSMALL', 4);

/**
 * Input size tiny.
 *
 * @since   4.5.0
 * @package Form
 */

define('INPUT_TINY', 2);

/**
 * Textarea height large.
 *
 * @since   4.6.0
 * @package Form
 */

define('TEXTAREA_HEIGHT_LARGE', 32);

/**
 * Textarea height regular.
 *
 * @since   4.6.0
 * @package Form
 */

define('TEXTAREA_HEIGHT_REGULAR', 16);

/**
 * Textarea height medium.
 *
 * @since   4.6.0
 * @package Form
 */

define('TEXTAREA_HEIGHT_MEDIUM', 8);

/**
 * Textarea height small.
 *
 * @since   4.6.0
 * @package Form
 */

define('TEXTAREA_HEIGHT_SMALL', 4);

/**
 * Required PHP version.
 *
 * @since   4.5.0
 * @package System
 */

define('REQUIRED_PHP_VERSION', '5.6.0');

/**
 * Required OPENSSL version.
 *
 * Used when fetching resources via file_get_contents() or cURL.
 *
 * @since   4.8.5
 * @package System
 */

define('REQUIRED_OPENSSL_VERSION', '268439567');

/**
 * Hashing algorithm used for checksums (and its strlen() output in bytes).
 *
 * Can be cryptographically weaker than the password hashing algorithm, with
 * focus on speed and minimising collisions.
 *
 * @since   4.9.0
 * @package Debug
 * @see     check_file_integrity()
 */

define('CHECKSUM_ALGORITHM', 'tiger192,3');
define('CHECKSUM_BYTES', 48);

/**
 * File integrity status good.
 *
 * @since   4.6.0
 * @package Debug
 * @see     check_file_integrity()
 */

define('INTEGRITY_GOOD', 1);

/**
 * File integrity status modified.
 *
 * @since   4.6.0
 * @package Debug
 * @see     check_file_integrity()
 */

define('INTEGRITY_MODIFIED', 2);

/**
 * File integrity not readable.
 *
 * @since   4.6.0
 * @package Debug
 * @see     check_file_integrity()
 */

define('INTEGRITY_NOT_READABLE', 3);

/**
 * File integrity file missing.
 *
 * @since   4.6.0
 * @package Debug
 * @see     check_file_integrity()
 */

define('INTEGRITY_MISSING', 4);

/**
 * File integrity not a file.
 *
 * @since   4.6.0
 * @package Debug
 * @see     check_file_integrity()
 */

define('INTEGRITY_NOT_FILE', 5);

/**
 * Return integrity status.
 *
 * @since   4.6.0
 * @package Debug
 * @see     check_file_integrity()
 */

define('INTEGRITY_STATUS', 0x1);

/**
 * Return integrity MD5 hashes.
 *
 * @since   4.6.0
 * @deprecated 4.9.0
 * @package Debug
 * @see     check_file_integrity()
 */

define('INTEGRITY_MD5', 0x2);

/**
 * Return integrity hashes using the current CHECKSUM_ALGORITHM.
 *
 * Replaces INTEGRITY_MD5 (and has the same value so can be used interchangably).
 *
 * @since   4.9.0
 * @package Debug
 * @see     check_file_integrity()
 */

define('INTEGRITY_HASH', 0x2);

/**
 * Return full paths.
 *
 * @since   4.6.0
 * @package Debug
 * @see     check_file_integrity()
 */

define('INTEGRITY_REALPATH', 0x4);

/**
 * Return a digest.
 *
 * @since   4.6.0
 * @package Debug
 * @see     check_file_integrity()
 */

define('INTEGRITY_DIGEST', 0x8);

/**
 * Return a parsed checksum file's contents.
 *
 * @since   4.6.0
 * @package Debug
 * @see     check_file_integrity()
 */

define('INTEGRITY_TABLE', 0x10);

/**
 * Link to an external script.
 *
 * @since   4.6.0
 * @package HTML
 * @see     script_js()
 */

define('TEXTPATTERN_SCRIPT_URL', 0x1);

/**
 * Attach version number to script URL if stable.
 *
 * The install is considered as a 'stable' if the version number doesn't contain
 * a '-dev' tag.
 *
 * @since   4.6.0
 * @package HTML
 * @see     script_js()
 */

define('TEXTPATTERN_SCRIPT_ATTACH_VERSION', 0x2);

/**
 * The localised string is owned by the core system.
 *
 * The string will be updated from the remote language server.
 *
 * @since   4.6.0
 * @package L10n
 */

define('TEXTPATTERN_LANG_OWNER_SYSTEM', '');

/**
 * The localised string is owned by the individual site.
 *
 * @since   4.6.0
 * @package L10n
 */

define('TEXTPATTERN_LANG_OWNER_SITE', 'site');

if (!defined('TEXTPATTERN_DEFAULT_LANG')) {
    /**
     * The default/fallback language identifier.
     *
     * @since   4.7.0
     * @package L10n
     */

    define('TEXTPATTERN_DEFAULT_LANG', 'en');
}

/**
 * Language flags;
 *
 * @since    4.7.0
 * @package  L10n
 */
define('TEXTPATTERN_LANG_ACTIVE', 0x1);
define('TEXTPATTERN_LANG_INSTALLED', 0x2);
define('TEXTPATTERN_LANG_AVAILABLE', 0x4);

/**
 * Strip empty values.
 *
 * @since   4.6.0
 * @package HTML
 * @see     join_atts(), do_list_unique()
 */

define('TEXTPATTERN_STRIP_NONE', 0);
define('TEXTPATTERN_STRIP_EMPTY', 0x1);
define('TEXTPATTERN_STRIP_EMPTY_STRING', 0x2);
define('TEXTPATTERN_STRIP_TXP', 0x4);

/**
 * Sends an adaptive announcement.
 *
 * The rendered message type is based on the context mode.
 *
 * @since   4.6.0
 * @package Announce
 * @see     announce()
 */

define('TEXTPATTERN_ANNOUNCE_ADAPTIVE', 0x1);

/**
 * Sends a modal announcement.
 *
 * The announcement is instructed to be rendered as soon as possible, as a modal
 * alert window.
 *
 * @since   4.6.0
 * @package Announce
 * @see     announce()
 */

define('TEXTPATTERN_ANNOUNCE_MODAL', 0x2);

/**
 * Sends an asynchronous announcement.
 *
 * @since   4.6.0
 * @package Announce
 * @see     announce()
 */

define('TEXTPATTERN_ANNOUNCE_ASYNC', 0x4);

/**
 * Sends a synchronous announcement.
 *
 * @since   4.6.0
 * @package Announce
 * @see     announce()
 */

define('TEXTPATTERN_ANNOUNCE_REGULAR', 0x8);

/**
 * Define the default JSON option for json_encode()
 *
 * @since   4.7.0
 */

define('TEXTPATTERN_JSON', JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);

 /**
 * Define the default parser hash algo
 *
 * @since   4.8.8
 */

if (!defined('TEXTPATTERN_HASH_ALGO')) {
    $algos = array_intersect(array('xxh128', 'murmur3f', 'murmur3c'), hash_algos());
    define('TEXTPATTERN_HASH_ALGO', $algos ? $algos[0] : 'md5');
}

/**
 * Define the default parser hash length
 *
 * @since   4.8.8
 */

if (!defined('TEXTPATTERN_HASH_LENGTH')) {
    define('TEXTPATTERN_HASH_LENGTH', strlen(hash(TEXTPATTERN_HASH_ALGO, '')));
}

/**
 * Define the default theme directories
 *
 * @since   4.9.0
 */

 const TXP_THEME_TREE = array(
     'forms'  => 'forms',
     'pages'  => 'pages',
     'styles' => 'styles'
 );

 /**
  * Define txp tag/attribute name pattern
  *
  * @since   4.9.0
  */
 
  const TXP_TAG = '[\w\-\x80-\xffff]+'; //'[^\x00-\x2c\x2f\x3a-\x3f\x5b-\x5d\x7b-\x7f]+';

/**
  * Define valid HTML5 void tags
  *
  * @since   4.9.0
  */

const HTML5_VOID_TAGS = array(
    'area', 'base', 'br', 'col', 'embed', 'hr', 'img', 'input', 'link', 'meta', 'source', 'track', 'wbr'
);

if (!defined('TEXTPATTERN_THUMB_TTL')) {
    /**
     * Thumbnail time-to-live value for cache headers (Cache-control max-age/Expires)
     *
     * Default = 7 days (7 * 24 * 60 *60)
     *
     * @since   4.9.0
     * @package Image
     */
    define('TEXTPATTERN_THUMB_TTL', 604800);
}

if (!defined('TEXTPATTERN_THUMB_QUALITY')) {
    /**
     * Thumbnail quality percent
     *
     * @since   4.9.0
     * @package Image
     */
    define('TEXTPATTERN_THUMB_QUALITY', 80);
}

if (!defined('TEXTPATTERN_THUMB_WIDTH')) {
    /**
     * Thumbnail width (fallback dimension) in px
     *
     * @since   4.9.0
     * @package Image
     */
    define('TEXTPATTERN_THUMB_WIDTH', 200);
}

if (!defined('TEXTPATTERN_THUMB_HEIGHT')) {
    /**
     * Thumbnail height (fallback dimension) in px
     *
     * @since   4.9.0
     * @package Image
     */
    define('TEXTPATTERN_THUMB_HEIGHT', 200);
}

if (!defined('TEXTPATTERN_THUMB_CROPPING')) {
    /**
     * Thumbnail crop ratio (wxh)
     *
     * @since   4.9.0
     * @package Image
     */
    define('TEXTPATTERN_THUMB_CROPPING', '1x1');
}

if (!defined('TEXTPATTERN_THUMB_DIR')) {
    /**
     * Thumbnail subdirectory name
     *
     * @since   4.9.0
     * @package Image
     */
    define('TEXTPATTERN_THUMB_DIR', 'thumb');
}

if (!defined('THUMB_REDIRECT')) {
    /**
     * Whether to redirect to the cached thumb or serve it as-is.
     *
     * Redirects _should_ work better than raw requests, but if thumbs are missing or caches are a bit
     * too aggressive, set this to a different redirect type, or use false or 0 to turn it off.
     *
     * You may use any valid 300-style redirect code here:
     * * 301 or 308 (permanent)
     * * 302, 303, or 307 (temporary)
     * * 304 (not-modified)
     *
     * @since   4.9.0
     * @package Image
     */
    define('THUMB_REDIRECT', 307);
}

if (!defined('THUMB_CACHE_SECONDS')) {
    /**
     * Number of seconds after which an unaccessed, cached image becomes eligible for deletion
     *
     * Default: 30 days (30 * 24 * 60 * 60)
     *
     * @since   4.9.0
     * @package Image
     */
    define('THUMB_CACHE_SECONDS', 2592000);
}

if (!defined('THUMB_SECRET_REGEN_SECONDS')) {
    /**
     * After this many seconds, a new thumbnail random token is generated,
     *
     * Making it change frequently increases security (less likelhood of someone guessing/obtaining it and
     * being able to generate thumbnails en masse).
     *
     * Default: Around 7 days (7 * 24 * 60 * 60).
     *
     * @since   4.9.0
     * @package Image
     */
    define('THUMB_SECRET_REGEN_SECONDS', '604800');
}

/**
  * 'No thumbnail' value
  *
  * @since   4.9.0
  */
if (!defined('THUMB_NONE')) {
    define('THUMB_NONE', '0');
}

/**
  * 'Custom thumbnail' value
  *
  * @since   4.9.0
  */
if (!defined('THUMB_CUSTOM')) {
    define('THUMB_CUSTOM', '1');
}

/**
  * 'Auto thumbnail' value
  *
  * @since   4.9.0
  */
if (!defined('THUMB_AUTO')) {
    define('THUMB_AUTO', '2');
}

/**
  * Custom image type for SVG
  *
  * @since   4.9.0
  */
if (!defined('IMAGETYPE_SVG')) {
    define('IMAGETYPE_SVG', 21);
}

/**
 * A tab character.
 *
 * @var string
 */

define("t", "\t");

/**
 * A line feed.
 *
 * @var string
 */

define("n", "\n");

/**
 * A self-closing HTML line-break tag.
 *
 * @var string
 */

define("br", "<br />");

/**
 * A non-breaking space as a HTML entity.
 *
 * @var string
 */

define("sp", "&#160;");

/**
 * An ampersand as a HTML entity.
 *
 * @var string
 */

define("a", "&#38;");
