<?php

namespace PhpBrew\Tests\Tasks;

use CLIFramework\Logger;
use GetOptionKit\OptionResult;
use PhpBrew\Buildable;
use PhpBrew\Tasks\MakeTask;
use PHPUnit\Framework\TestCase;

/**
 * @small
 */
class MakeTaskTest extends TestCase
{
    private $make;

    public function createLogger()
    {
        $logger = new Logger();
        $logger->setQuiet();
        return $logger;
    }

    protected function setUp(): void
    {
        $this->make = new MakeTask($this->createLogger(), new OptionResult());
        $this->make->setQuiet();
    }

    public function testMakeInstall()
    {
        $this->assertTrue($this->make->install(new MakeTaskTestBuild()));
    }

    public function testMakeClean()
    {
        $this->assertTrue($this->make->clean(new MakeTaskTestBuild()));
    }

    public function testRunWithValidTarget()
    {
        $build = new MakeTaskTestBuild();
        $this->assertTrue($this->make->run($build));
    }

    public function testWhenThereIsNoMakefile()
    {
        // ignores error messages generated by make command
        ob_start();
        $this->assertFalse($this->make->install(new MakeTaskTestNoSuchFileBuild()));
        ob_end_clean();
    }

    public function testSetQuiet()
    {
        $make = new MakeTask($this->createLogger(), new OptionResult());

        $this->assertFalse($make->isQuiet());

        $make->setQuiet();

        $this->assertTrue($make->isQuiet());
    }
}

class MakeTaskTestBuild implements Buildable
{
    public function getSourceDirectory()
    {
        return __DIR__ . '/../../fixtures/make/';
    }

    public function getBuildLogPath()
    {
        return null;
    }

    public function isBuildable()
    {
        return true;
    }
}

class MakeTaskTestNoSuchFileBuild implements Buildable
{
    public function getSourceDirectory()
    {
        return __DIR__ . '/../../fixtures/make/dummy';
    }

    public function getBuildLogPath()
    {
        return null;
    }

    public function isBuildable()
    {
        return false;
    }
}
