/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.rule;

import static com.google.common.truth.Truth.assertThat;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SystemsOutRule implements TestRule {
  private ByteArrayOutputStream currentOut;

  @Override
  public Statement apply(Statement statement, Description description) {
    return new Statement() {
      @Override
      public void evaluate() throws Throwable {
        // Setting up customized PrintStream
        final PrintStream originalOut = System.out;
        currentOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(currentOut));

        // Running tests
        statement.evaluate();

        // Restoring original PrintStream
        System.setOut(originalOut);
        currentOut = null;
      }
    };
  }

  public void assertContains(String content) {
    assertThat(currentOut.toString().toLowerCase()).contains(content.toLowerCase());
  }
}
