/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/datastore.proto

// Protobuf Java Version: 3.25.8
package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * Options for beginning a new transaction.
 *
 * Transactions can be created explicitly with calls to
 * [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction]
 * or implicitly by setting
 * [ReadOptions.new_transaction][google.datastore.v1.ReadOptions.new_transaction]
 * in read requests.
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.TransactionOptions}
 */
public final class TransactionOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.TransactionOptions)
    TransactionOptionsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TransactionOptions.newBuilder() to construct.
  private TransactionOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransactionOptions() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransactionOptions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_TransactionOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_TransactionOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.TransactionOptions.class,
            com.google.datastore.v1.TransactionOptions.Builder.class);
  }

  public interface ReadWriteOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.datastore.v1.TransactionOptions.ReadWrite)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The transaction identifier of the transaction being retried.
     * </pre>
     *
     * <code>bytes previous_transaction = 1;</code>
     *
     * @return The previousTransaction.
     */
    com.google.protobuf.ByteString getPreviousTransaction();
  }

  /**
   *
   *
   * <pre>
   * Options specific to read / write transactions.
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.TransactionOptions.ReadWrite}
   */
  public static final class ReadWrite extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.datastore.v1.TransactionOptions.ReadWrite)
      ReadWriteOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ReadWrite.newBuilder() to construct.
    private ReadWrite(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReadWrite() {
      previousTransaction_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReadWrite();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_TransactionOptions_ReadWrite_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_TransactionOptions_ReadWrite_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.TransactionOptions.ReadWrite.class,
              com.google.datastore.v1.TransactionOptions.ReadWrite.Builder.class);
    }

    public static final int PREVIOUS_TRANSACTION_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString previousTransaction_ =
        com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * The transaction identifier of the transaction being retried.
     * </pre>
     *
     * <code>bytes previous_transaction = 1;</code>
     *
     * @return The previousTransaction.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPreviousTransaction() {
      return previousTransaction_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!previousTransaction_.isEmpty()) {
        output.writeBytes(1, previousTransaction_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!previousTransaction_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, previousTransaction_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.datastore.v1.TransactionOptions.ReadWrite)) {
        return super.equals(obj);
      }
      com.google.datastore.v1.TransactionOptions.ReadWrite other =
          (com.google.datastore.v1.TransactionOptions.ReadWrite) obj;

      if (!getPreviousTransaction().equals(other.getPreviousTransaction())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PREVIOUS_TRANSACTION_FIELD_NUMBER;
      hash = (53 * hash) + getPreviousTransaction().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.datastore.v1.TransactionOptions.ReadWrite parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadWrite parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadWrite parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadWrite parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadWrite parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadWrite parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadWrite parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadWrite parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.datastore.v1.TransactionOptions.ReadWrite prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Options specific to read / write transactions.
     * </pre>
     *
     * Protobuf type {@code google.datastore.v1.TransactionOptions.ReadWrite}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.datastore.v1.TransactionOptions.ReadWrite)
        com.google.datastore.v1.TransactionOptions.ReadWriteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.datastore.v1.DatastoreProto
            .internal_static_google_datastore_v1_TransactionOptions_ReadWrite_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.datastore.v1.DatastoreProto
            .internal_static_google_datastore_v1_TransactionOptions_ReadWrite_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.datastore.v1.TransactionOptions.ReadWrite.class,
                com.google.datastore.v1.TransactionOptions.ReadWrite.Builder.class);
      }

      // Construct using com.google.datastore.v1.TransactionOptions.ReadWrite.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        previousTransaction_ = com.google.protobuf.ByteString.EMPTY;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.datastore.v1.DatastoreProto
            .internal_static_google_datastore_v1_TransactionOptions_ReadWrite_descriptor;
      }

      @java.lang.Override
      public com.google.datastore.v1.TransactionOptions.ReadWrite getDefaultInstanceForType() {
        return com.google.datastore.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.datastore.v1.TransactionOptions.ReadWrite build() {
        com.google.datastore.v1.TransactionOptions.ReadWrite result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.datastore.v1.TransactionOptions.ReadWrite buildPartial() {
        com.google.datastore.v1.TransactionOptions.ReadWrite result =
            new com.google.datastore.v1.TransactionOptions.ReadWrite(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.datastore.v1.TransactionOptions.ReadWrite result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.previousTransaction_ = previousTransaction_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.datastore.v1.TransactionOptions.ReadWrite) {
          return mergeFrom((com.google.datastore.v1.TransactionOptions.ReadWrite) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.datastore.v1.TransactionOptions.ReadWrite other) {
        if (other == com.google.datastore.v1.TransactionOptions.ReadWrite.getDefaultInstance())
          return this;
        if (other.getPreviousTransaction() != com.google.protobuf.ByteString.EMPTY) {
          setPreviousTransaction(other.getPreviousTransaction());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  previousTransaction_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.ByteString previousTransaction_ =
          com.google.protobuf.ByteString.EMPTY;

      /**
       *
       *
       * <pre>
       * The transaction identifier of the transaction being retried.
       * </pre>
       *
       * <code>bytes previous_transaction = 1;</code>
       *
       * @return The previousTransaction.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPreviousTransaction() {
        return previousTransaction_;
      }

      /**
       *
       *
       * <pre>
       * The transaction identifier of the transaction being retried.
       * </pre>
       *
       * <code>bytes previous_transaction = 1;</code>
       *
       * @param value The previousTransaction to set.
       * @return This builder for chaining.
       */
      public Builder setPreviousTransaction(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        previousTransaction_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The transaction identifier of the transaction being retried.
       * </pre>
       *
       * <code>bytes previous_transaction = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPreviousTransaction() {
        bitField0_ = (bitField0_ & ~0x00000001);
        previousTransaction_ = getDefaultInstance().getPreviousTransaction();
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.datastore.v1.TransactionOptions.ReadWrite)
    }

    // @@protoc_insertion_point(class_scope:google.datastore.v1.TransactionOptions.ReadWrite)
    private static final com.google.datastore.v1.TransactionOptions.ReadWrite DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.datastore.v1.TransactionOptions.ReadWrite();
    }

    public static com.google.datastore.v1.TransactionOptions.ReadWrite getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReadWrite> PARSER =
        new com.google.protobuf.AbstractParser<ReadWrite>() {
          @java.lang.Override
          public ReadWrite parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReadWrite> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReadWrite> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.datastore.v1.TransactionOptions.ReadWrite getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReadOnlyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.datastore.v1.TransactionOptions.ReadOnly)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Reads entities at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 1;</code>
     *
     * @return Whether the readTime field is set.
     */
    boolean hasReadTime();

    /**
     *
     *
     * <pre>
     * Reads entities at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 1;</code>
     *
     * @return The readTime.
     */
    com.google.protobuf.Timestamp getReadTime();

    /**
     *
     *
     * <pre>
     * Reads entities at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Options specific to read-only transactions.
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.TransactionOptions.ReadOnly}
   */
  public static final class ReadOnly extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.datastore.v1.TransactionOptions.ReadOnly)
      ReadOnlyOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ReadOnly.newBuilder() to construct.
    private ReadOnly(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReadOnly() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReadOnly();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_TransactionOptions_ReadOnly_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_TransactionOptions_ReadOnly_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.TransactionOptions.ReadOnly.class,
              com.google.datastore.v1.TransactionOptions.ReadOnly.Builder.class);
    }

    private int bitField0_;
    public static final int READ_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp readTime_;

    /**
     *
     *
     * <pre>
     * Reads entities at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 1;</code>
     *
     * @return Whether the readTime field is set.
     */
    @java.lang.Override
    public boolean hasReadTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Reads entities at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 1;</code>
     *
     * @return The readTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getReadTime() {
      return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
    }

    /**
     *
     *
     * <pre>
     * Reads entities at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getReadTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getReadTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.datastore.v1.TransactionOptions.ReadOnly)) {
        return super.equals(obj);
      }
      com.google.datastore.v1.TransactionOptions.ReadOnly other =
          (com.google.datastore.v1.TransactionOptions.ReadOnly) obj;

      if (hasReadTime() != other.hasReadTime()) return false;
      if (hasReadTime()) {
        if (!getReadTime().equals(other.getReadTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasReadTime()) {
        hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getReadTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.datastore.v1.TransactionOptions.ReadOnly parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadOnly parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadOnly parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadOnly parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadOnly parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadOnly parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadOnly parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadOnly parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.datastore.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.datastore.v1.TransactionOptions.ReadOnly prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Options specific to read-only transactions.
     * </pre>
     *
     * Protobuf type {@code google.datastore.v1.TransactionOptions.ReadOnly}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.datastore.v1.TransactionOptions.ReadOnly)
        com.google.datastore.v1.TransactionOptions.ReadOnlyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.datastore.v1.DatastoreProto
            .internal_static_google_datastore_v1_TransactionOptions_ReadOnly_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.datastore.v1.DatastoreProto
            .internal_static_google_datastore_v1_TransactionOptions_ReadOnly_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.datastore.v1.TransactionOptions.ReadOnly.class,
                com.google.datastore.v1.TransactionOptions.ReadOnly.Builder.class);
      }

      // Construct using com.google.datastore.v1.TransactionOptions.ReadOnly.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getReadTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        readTime_ = null;
        if (readTimeBuilder_ != null) {
          readTimeBuilder_.dispose();
          readTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.datastore.v1.DatastoreProto
            .internal_static_google_datastore_v1_TransactionOptions_ReadOnly_descriptor;
      }

      @java.lang.Override
      public com.google.datastore.v1.TransactionOptions.ReadOnly getDefaultInstanceForType() {
        return com.google.datastore.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.datastore.v1.TransactionOptions.ReadOnly build() {
        com.google.datastore.v1.TransactionOptions.ReadOnly result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.datastore.v1.TransactionOptions.ReadOnly buildPartial() {
        com.google.datastore.v1.TransactionOptions.ReadOnly result =
            new com.google.datastore.v1.TransactionOptions.ReadOnly(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.datastore.v1.TransactionOptions.ReadOnly result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.readTime_ = readTimeBuilder_ == null ? readTime_ : readTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.datastore.v1.TransactionOptions.ReadOnly) {
          return mergeFrom((com.google.datastore.v1.TransactionOptions.ReadOnly) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.datastore.v1.TransactionOptions.ReadOnly other) {
        if (other == com.google.datastore.v1.TransactionOptions.ReadOnly.getDefaultInstance())
          return this;
        if (other.hasReadTime()) {
          mergeReadTime(other.getReadTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getReadTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp readTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          readTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Reads entities at the given time.
       *
       * This must be a microsecond precision timestamp within the past one hour,
       * or if Point-in-Time Recovery is enabled, can additionally be a whole
       * minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 1;</code>
       *
       * @return Whether the readTime field is set.
       */
      public boolean hasReadTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Reads entities at the given time.
       *
       * This must be a microsecond precision timestamp within the past one hour,
       * or if Point-in-Time Recovery is enabled, can additionally be a whole
       * minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 1;</code>
       *
       * @return The readTime.
       */
      public com.google.protobuf.Timestamp getReadTime() {
        if (readTimeBuilder_ == null) {
          return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
        } else {
          return readTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Reads entities at the given time.
       *
       * This must be a microsecond precision timestamp within the past one hour,
       * or if Point-in-Time Recovery is enabled, can additionally be a whole
       * minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 1;</code>
       */
      public Builder setReadTime(com.google.protobuf.Timestamp value) {
        if (readTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          readTime_ = value;
        } else {
          readTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reads entities at the given time.
       *
       * This must be a microsecond precision timestamp within the past one hour,
       * or if Point-in-Time Recovery is enabled, can additionally be a whole
       * minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 1;</code>
       */
      public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (readTimeBuilder_ == null) {
          readTime_ = builderForValue.build();
        } else {
          readTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reads entities at the given time.
       *
       * This must be a microsecond precision timestamp within the past one hour,
       * or if Point-in-Time Recovery is enabled, can additionally be a whole
       * minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 1;</code>
       */
      public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
        if (readTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && readTime_ != null
              && readTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getReadTimeBuilder().mergeFrom(value);
          } else {
            readTime_ = value;
          }
        } else {
          readTimeBuilder_.mergeFrom(value);
        }
        if (readTime_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reads entities at the given time.
       *
       * This must be a microsecond precision timestamp within the past one hour,
       * or if Point-in-Time Recovery is enabled, can additionally be a whole
       * minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 1;</code>
       */
      public Builder clearReadTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        readTime_ = null;
        if (readTimeBuilder_ != null) {
          readTimeBuilder_.dispose();
          readTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reads entities at the given time.
       *
       * This must be a microsecond precision timestamp within the past one hour,
       * or if Point-in-Time Recovery is enabled, can additionally be a whole
       * minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getReadTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Reads entities at the given time.
       *
       * This must be a microsecond precision timestamp within the past one hour,
       * or if Point-in-Time Recovery is enabled, can additionally be a whole
       * minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
        if (readTimeBuilder_ != null) {
          return readTimeBuilder_.getMessageOrBuilder();
        } else {
          return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Reads entities at the given time.
       *
       * This must be a microsecond precision timestamp within the past one hour,
       * or if Point-in-Time Recovery is enabled, can additionally be a whole
       * minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getReadTimeFieldBuilder() {
        if (readTimeBuilder_ == null) {
          readTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getReadTime(), getParentForChildren(), isClean());
          readTime_ = null;
        }
        return readTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.datastore.v1.TransactionOptions.ReadOnly)
    }

    // @@protoc_insertion_point(class_scope:google.datastore.v1.TransactionOptions.ReadOnly)
    private static final com.google.datastore.v1.TransactionOptions.ReadOnly DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.datastore.v1.TransactionOptions.ReadOnly();
    }

    public static com.google.datastore.v1.TransactionOptions.ReadOnly getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReadOnly> PARSER =
        new com.google.protobuf.AbstractParser<ReadOnly>() {
          @java.lang.Override
          public ReadOnly parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReadOnly> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReadOnly> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.datastore.v1.TransactionOptions.ReadOnly getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int modeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object mode_;

  public enum ModeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    READ_WRITE(1),
    READ_ONLY(2),
    MODE_NOT_SET(0);
    private final int value;

    private ModeCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ModeCase forNumber(int value) {
      switch (value) {
        case 1:
          return READ_WRITE;
        case 2:
          return READ_ONLY;
        case 0:
          return MODE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ModeCase getModeCase() {
    return ModeCase.forNumber(modeCase_);
  }

  public static final int READ_WRITE_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * The transaction should allow both reads and writes.
   * </pre>
   *
   * <code>.google.datastore.v1.TransactionOptions.ReadWrite read_write = 1;</code>
   *
   * @return Whether the readWrite field is set.
   */
  @java.lang.Override
  public boolean hasReadWrite() {
    return modeCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * The transaction should allow both reads and writes.
   * </pre>
   *
   * <code>.google.datastore.v1.TransactionOptions.ReadWrite read_write = 1;</code>
   *
   * @return The readWrite.
   */
  @java.lang.Override
  public com.google.datastore.v1.TransactionOptions.ReadWrite getReadWrite() {
    if (modeCase_ == 1) {
      return (com.google.datastore.v1.TransactionOptions.ReadWrite) mode_;
    }
    return com.google.datastore.v1.TransactionOptions.ReadWrite.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The transaction should allow both reads and writes.
   * </pre>
   *
   * <code>.google.datastore.v1.TransactionOptions.ReadWrite read_write = 1;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.TransactionOptions.ReadWriteOrBuilder getReadWriteOrBuilder() {
    if (modeCase_ == 1) {
      return (com.google.datastore.v1.TransactionOptions.ReadWrite) mode_;
    }
    return com.google.datastore.v1.TransactionOptions.ReadWrite.getDefaultInstance();
  }

  public static final int READ_ONLY_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * The transaction should only allow reads.
   * </pre>
   *
   * <code>.google.datastore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
   *
   * @return Whether the readOnly field is set.
   */
  @java.lang.Override
  public boolean hasReadOnly() {
    return modeCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * The transaction should only allow reads.
   * </pre>
   *
   * <code>.google.datastore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
   *
   * @return The readOnly.
   */
  @java.lang.Override
  public com.google.datastore.v1.TransactionOptions.ReadOnly getReadOnly() {
    if (modeCase_ == 2) {
      return (com.google.datastore.v1.TransactionOptions.ReadOnly) mode_;
    }
    return com.google.datastore.v1.TransactionOptions.ReadOnly.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The transaction should only allow reads.
   * </pre>
   *
   * <code>.google.datastore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.TransactionOptions.ReadOnlyOrBuilder getReadOnlyOrBuilder() {
    if (modeCase_ == 2) {
      return (com.google.datastore.v1.TransactionOptions.ReadOnly) mode_;
    }
    return com.google.datastore.v1.TransactionOptions.ReadOnly.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (modeCase_ == 1) {
      output.writeMessage(1, (com.google.datastore.v1.TransactionOptions.ReadWrite) mode_);
    }
    if (modeCase_ == 2) {
      output.writeMessage(2, (com.google.datastore.v1.TransactionOptions.ReadOnly) mode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (modeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.datastore.v1.TransactionOptions.ReadWrite) mode_);
    }
    if (modeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.datastore.v1.TransactionOptions.ReadOnly) mode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.TransactionOptions)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.TransactionOptions other =
        (com.google.datastore.v1.TransactionOptions) obj;

    if (!getModeCase().equals(other.getModeCase())) return false;
    switch (modeCase_) {
      case 1:
        if (!getReadWrite().equals(other.getReadWrite())) return false;
        break;
      case 2:
        if (!getReadOnly().equals(other.getReadOnly())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (modeCase_) {
      case 1:
        hash = (37 * hash) + READ_WRITE_FIELD_NUMBER;
        hash = (53 * hash) + getReadWrite().hashCode();
        break;
      case 2:
        hash = (37 * hash) + READ_ONLY_FIELD_NUMBER;
        hash = (53 * hash) + getReadOnly().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.TransactionOptions parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.TransactionOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.TransactionOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.TransactionOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.TransactionOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.TransactionOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.TransactionOptions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.TransactionOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.TransactionOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.TransactionOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.TransactionOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.TransactionOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.TransactionOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Options for beginning a new transaction.
   *
   * Transactions can be created explicitly with calls to
   * [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction]
   * or implicitly by setting
   * [ReadOptions.new_transaction][google.datastore.v1.ReadOptions.new_transaction]
   * in read requests.
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.TransactionOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.TransactionOptions)
      com.google.datastore.v1.TransactionOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_TransactionOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_TransactionOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.TransactionOptions.class,
              com.google.datastore.v1.TransactionOptions.Builder.class);
    }

    // Construct using com.google.datastore.v1.TransactionOptions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (readWriteBuilder_ != null) {
        readWriteBuilder_.clear();
      }
      if (readOnlyBuilder_ != null) {
        readOnlyBuilder_.clear();
      }
      modeCase_ = 0;
      mode_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_TransactionOptions_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.TransactionOptions getDefaultInstanceForType() {
      return com.google.datastore.v1.TransactionOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.TransactionOptions build() {
      com.google.datastore.v1.TransactionOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.TransactionOptions buildPartial() {
      com.google.datastore.v1.TransactionOptions result =
          new com.google.datastore.v1.TransactionOptions(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.datastore.v1.TransactionOptions result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.datastore.v1.TransactionOptions result) {
      result.modeCase_ = modeCase_;
      result.mode_ = this.mode_;
      if (modeCase_ == 1 && readWriteBuilder_ != null) {
        result.mode_ = readWriteBuilder_.build();
      }
      if (modeCase_ == 2 && readOnlyBuilder_ != null) {
        result.mode_ = readOnlyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.TransactionOptions) {
        return mergeFrom((com.google.datastore.v1.TransactionOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.TransactionOptions other) {
      if (other == com.google.datastore.v1.TransactionOptions.getDefaultInstance()) return this;
      switch (other.getModeCase()) {
        case READ_WRITE:
          {
            mergeReadWrite(other.getReadWrite());
            break;
          }
        case READ_ONLY:
          {
            mergeReadOnly(other.getReadOnly());
            break;
          }
        case MODE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getReadWriteFieldBuilder().getBuilder(), extensionRegistry);
                modeCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getReadOnlyFieldBuilder().getBuilder(), extensionRegistry);
                modeCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int modeCase_ = 0;
    private java.lang.Object mode_;

    public ModeCase getModeCase() {
      return ModeCase.forNumber(modeCase_);
    }

    public Builder clearMode() {
      modeCase_ = 0;
      mode_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.TransactionOptions.ReadWrite,
            com.google.datastore.v1.TransactionOptions.ReadWrite.Builder,
            com.google.datastore.v1.TransactionOptions.ReadWriteOrBuilder>
        readWriteBuilder_;

    /**
     *
     *
     * <pre>
     * The transaction should allow both reads and writes.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     *
     * @return Whether the readWrite field is set.
     */
    @java.lang.Override
    public boolean hasReadWrite() {
      return modeCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * The transaction should allow both reads and writes.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     *
     * @return The readWrite.
     */
    @java.lang.Override
    public com.google.datastore.v1.TransactionOptions.ReadWrite getReadWrite() {
      if (readWriteBuilder_ == null) {
        if (modeCase_ == 1) {
          return (com.google.datastore.v1.TransactionOptions.ReadWrite) mode_;
        }
        return com.google.datastore.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      } else {
        if (modeCase_ == 1) {
          return readWriteBuilder_.getMessage();
        }
        return com.google.datastore.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The transaction should allow both reads and writes.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public Builder setReadWrite(com.google.datastore.v1.TransactionOptions.ReadWrite value) {
      if (readWriteBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        readWriteBuilder_.setMessage(value);
      }
      modeCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The transaction should allow both reads and writes.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public Builder setReadWrite(
        com.google.datastore.v1.TransactionOptions.ReadWrite.Builder builderForValue) {
      if (readWriteBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        readWriteBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The transaction should allow both reads and writes.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public Builder mergeReadWrite(com.google.datastore.v1.TransactionOptions.ReadWrite value) {
      if (readWriteBuilder_ == null) {
        if (modeCase_ == 1
            && mode_ != com.google.datastore.v1.TransactionOptions.ReadWrite.getDefaultInstance()) {
          mode_ =
              com.google.datastore.v1.TransactionOptions.ReadWrite.newBuilder(
                      (com.google.datastore.v1.TransactionOptions.ReadWrite) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 1) {
          readWriteBuilder_.mergeFrom(value);
        } else {
          readWriteBuilder_.setMessage(value);
        }
      }
      modeCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The transaction should allow both reads and writes.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public Builder clearReadWrite() {
      if (readWriteBuilder_ == null) {
        if (modeCase_ == 1) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 1) {
          modeCase_ = 0;
          mode_ = null;
        }
        readWriteBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The transaction should allow both reads and writes.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    public com.google.datastore.v1.TransactionOptions.ReadWrite.Builder getReadWriteBuilder() {
      return getReadWriteFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The transaction should allow both reads and writes.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.TransactionOptions.ReadWriteOrBuilder getReadWriteOrBuilder() {
      if ((modeCase_ == 1) && (readWriteBuilder_ != null)) {
        return readWriteBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 1) {
          return (com.google.datastore.v1.TransactionOptions.ReadWrite) mode_;
        }
        return com.google.datastore.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The transaction should allow both reads and writes.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadWrite read_write = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.TransactionOptions.ReadWrite,
            com.google.datastore.v1.TransactionOptions.ReadWrite.Builder,
            com.google.datastore.v1.TransactionOptions.ReadWriteOrBuilder>
        getReadWriteFieldBuilder() {
      if (readWriteBuilder_ == null) {
        if (!(modeCase_ == 1)) {
          mode_ = com.google.datastore.v1.TransactionOptions.ReadWrite.getDefaultInstance();
        }
        readWriteBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.TransactionOptions.ReadWrite,
                com.google.datastore.v1.TransactionOptions.ReadWrite.Builder,
                com.google.datastore.v1.TransactionOptions.ReadWriteOrBuilder>(
                (com.google.datastore.v1.TransactionOptions.ReadWrite) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 1;
      onChanged();
      return readWriteBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.TransactionOptions.ReadOnly,
            com.google.datastore.v1.TransactionOptions.ReadOnly.Builder,
            com.google.datastore.v1.TransactionOptions.ReadOnlyOrBuilder>
        readOnlyBuilder_;

    /**
     *
     *
     * <pre>
     * The transaction should only allow reads.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     *
     * @return Whether the readOnly field is set.
     */
    @java.lang.Override
    public boolean hasReadOnly() {
      return modeCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * The transaction should only allow reads.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     *
     * @return The readOnly.
     */
    @java.lang.Override
    public com.google.datastore.v1.TransactionOptions.ReadOnly getReadOnly() {
      if (readOnlyBuilder_ == null) {
        if (modeCase_ == 2) {
          return (com.google.datastore.v1.TransactionOptions.ReadOnly) mode_;
        }
        return com.google.datastore.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      } else {
        if (modeCase_ == 2) {
          return readOnlyBuilder_.getMessage();
        }
        return com.google.datastore.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The transaction should only allow reads.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder setReadOnly(com.google.datastore.v1.TransactionOptions.ReadOnly value) {
      if (readOnlyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        readOnlyBuilder_.setMessage(value);
      }
      modeCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The transaction should only allow reads.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder setReadOnly(
        com.google.datastore.v1.TransactionOptions.ReadOnly.Builder builderForValue) {
      if (readOnlyBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        readOnlyBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The transaction should only allow reads.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder mergeReadOnly(com.google.datastore.v1.TransactionOptions.ReadOnly value) {
      if (readOnlyBuilder_ == null) {
        if (modeCase_ == 2
            && mode_ != com.google.datastore.v1.TransactionOptions.ReadOnly.getDefaultInstance()) {
          mode_ =
              com.google.datastore.v1.TransactionOptions.ReadOnly.newBuilder(
                      (com.google.datastore.v1.TransactionOptions.ReadOnly) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 2) {
          readOnlyBuilder_.mergeFrom(value);
        } else {
          readOnlyBuilder_.setMessage(value);
        }
      }
      modeCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The transaction should only allow reads.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder clearReadOnly() {
      if (readOnlyBuilder_ == null) {
        if (modeCase_ == 2) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 2) {
          modeCase_ = 0;
          mode_ = null;
        }
        readOnlyBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The transaction should only allow reads.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public com.google.datastore.v1.TransactionOptions.ReadOnly.Builder getReadOnlyBuilder() {
      return getReadOnlyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The transaction should only allow reads.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.TransactionOptions.ReadOnlyOrBuilder getReadOnlyOrBuilder() {
      if ((modeCase_ == 2) && (readOnlyBuilder_ != null)) {
        return readOnlyBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 2) {
          return (com.google.datastore.v1.TransactionOptions.ReadOnly) mode_;
        }
        return com.google.datastore.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The transaction should only allow reads.
     * </pre>
     *
     * <code>.google.datastore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.TransactionOptions.ReadOnly,
            com.google.datastore.v1.TransactionOptions.ReadOnly.Builder,
            com.google.datastore.v1.TransactionOptions.ReadOnlyOrBuilder>
        getReadOnlyFieldBuilder() {
      if (readOnlyBuilder_ == null) {
        if (!(modeCase_ == 2)) {
          mode_ = com.google.datastore.v1.TransactionOptions.ReadOnly.getDefaultInstance();
        }
        readOnlyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.TransactionOptions.ReadOnly,
                com.google.datastore.v1.TransactionOptions.ReadOnly.Builder,
                com.google.datastore.v1.TransactionOptions.ReadOnlyOrBuilder>(
                (com.google.datastore.v1.TransactionOptions.ReadOnly) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 2;
      onChanged();
      return readOnlyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.TransactionOptions)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.TransactionOptions)
  private static final com.google.datastore.v1.TransactionOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.TransactionOptions();
  }

  public static com.google.datastore.v1.TransactionOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransactionOptions> PARSER =
      new com.google.protobuf.AbstractParser<TransactionOptions>() {
        @java.lang.Override
        public TransactionOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransactionOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransactionOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.TransactionOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
