/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/datastore.proto

// Protobuf Java Version: 3.25.8
package com.google.datastore.v1;

public interface PropertyMaskOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.datastore.v1.PropertyMask)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The paths to the properties covered by this mask.
   *
   * A path is a list of property names separated by dots (`.`), for example
   * `foo.bar` means the property `bar` inside the entity property `foo` inside
   * the entity associated with this path.
   *
   * If a property name contains a dot `.` or a backslash `&#92;`, then that
   * name must be escaped.
   *
   * A path must not be empty, and may not reference a value inside an
   * [array value][google.datastore.v1.Value.array_value].
   * </pre>
   *
   * <code>repeated string paths = 1;</code>
   *
   * @return A list containing the paths.
   */
  java.util.List<java.lang.String> getPathsList();

  /**
   *
   *
   * <pre>
   * The paths to the properties covered by this mask.
   *
   * A path is a list of property names separated by dots (`.`), for example
   * `foo.bar` means the property `bar` inside the entity property `foo` inside
   * the entity associated with this path.
   *
   * If a property name contains a dot `.` or a backslash `&#92;`, then that
   * name must be escaped.
   *
   * A path must not be empty, and may not reference a value inside an
   * [array value][google.datastore.v1.Value.array_value].
   * </pre>
   *
   * <code>repeated string paths = 1;</code>
   *
   * @return The count of paths.
   */
  int getPathsCount();

  /**
   *
   *
   * <pre>
   * The paths to the properties covered by this mask.
   *
   * A path is a list of property names separated by dots (`.`), for example
   * `foo.bar` means the property `bar` inside the entity property `foo` inside
   * the entity associated with this path.
   *
   * If a property name contains a dot `.` or a backslash `&#92;`, then that
   * name must be escaped.
   *
   * A path must not be empty, and may not reference a value inside an
   * [array value][google.datastore.v1.Value.array_value].
   * </pre>
   *
   * <code>repeated string paths = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The paths at the given index.
   */
  java.lang.String getPaths(int index);

  /**
   *
   *
   * <pre>
   * The paths to the properties covered by this mask.
   *
   * A path is a list of property names separated by dots (`.`), for example
   * `foo.bar` means the property `bar` inside the entity property `foo` inside
   * the entity associated with this path.
   *
   * If a property name contains a dot `.` or a backslash `&#92;`, then that
   * name must be escaped.
   *
   * A path must not be empty, and may not reference a value inside an
   * [array value][google.datastore.v1.Value.array_value].
   * </pre>
   *
   * <code>repeated string paths = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the paths at the given index.
   */
  com.google.protobuf.ByteString getPathsBytes(int index);
}
