/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/query.proto

// Protobuf Java Version: 3.25.8
package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * Nearest Neighbors search config. The ordering provided by FindNearest
 * supersedes the order_by stage. If multiple documents have the same vector
 * distance, the returned document order is not guaranteed to be stable between
 * queries.
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.FindNearest}
 */
public final class FindNearest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.FindNearest)
    FindNearestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use FindNearest.newBuilder() to construct.
  private FindNearest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FindNearest() {
    distanceMeasure_ = 0;
    distanceResultProperty_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FindNearest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.QueryProto
        .internal_static_google_datastore_v1_FindNearest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.QueryProto
        .internal_static_google_datastore_v1_FindNearest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.FindNearest.class,
            com.google.datastore.v1.FindNearest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The distance measure to use when comparing vectors.
   * </pre>
   *
   * Protobuf enum {@code google.datastore.v1.FindNearest.DistanceMeasure}
   */
  public enum DistanceMeasure implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Should not be set.
     * </pre>
     *
     * <code>DISTANCE_MEASURE_UNSPECIFIED = 0;</code>
     */
    DISTANCE_MEASURE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Measures the EUCLIDEAN distance between the vectors. See
     * [Euclidean](https://en.wikipedia.org/wiki/Euclidean_distance) to learn
     * more. The resulting distance decreases the more similar two vectors are.
     * </pre>
     *
     * <code>EUCLIDEAN = 1;</code>
     */
    EUCLIDEAN(1),
    /**
     *
     *
     * <pre>
     * COSINE distance compares vectors based on the angle between them, which
     * allows you to measure similarity that isn't based on the vectors
     * magnitude. We recommend using DOT_PRODUCT with unit normalized vectors
     * instead of COSINE distance, which is mathematically equivalent with
     * better performance. See [Cosine
     * Similarity](https://en.wikipedia.org/wiki/Cosine_similarity) to learn
     * more about COSINE similarity and COSINE distance. The resulting COSINE
     * distance decreases the more similar two vectors are.
     * </pre>
     *
     * <code>COSINE = 2;</code>
     */
    COSINE(2),
    /**
     *
     *
     * <pre>
     * Similar to cosine but is affected by the magnitude of the vectors. See
     * [Dot Product](https://en.wikipedia.org/wiki/Dot_product) to learn more.
     * The resulting distance increases the more similar two vectors are.
     * </pre>
     *
     * <code>DOT_PRODUCT = 3;</code>
     */
    DOT_PRODUCT(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Should not be set.
     * </pre>
     *
     * <code>DISTANCE_MEASURE_UNSPECIFIED = 0;</code>
     */
    public static final int DISTANCE_MEASURE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Measures the EUCLIDEAN distance between the vectors. See
     * [Euclidean](https://en.wikipedia.org/wiki/Euclidean_distance) to learn
     * more. The resulting distance decreases the more similar two vectors are.
     * </pre>
     *
     * <code>EUCLIDEAN = 1;</code>
     */
    public static final int EUCLIDEAN_VALUE = 1;

    /**
     *
     *
     * <pre>
     * COSINE distance compares vectors based on the angle between them, which
     * allows you to measure similarity that isn't based on the vectors
     * magnitude. We recommend using DOT_PRODUCT with unit normalized vectors
     * instead of COSINE distance, which is mathematically equivalent with
     * better performance. See [Cosine
     * Similarity](https://en.wikipedia.org/wiki/Cosine_similarity) to learn
     * more about COSINE similarity and COSINE distance. The resulting COSINE
     * distance decreases the more similar two vectors are.
     * </pre>
     *
     * <code>COSINE = 2;</code>
     */
    public static final int COSINE_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Similar to cosine but is affected by the magnitude of the vectors. See
     * [Dot Product](https://en.wikipedia.org/wiki/Dot_product) to learn more.
     * The resulting distance increases the more similar two vectors are.
     * </pre>
     *
     * <code>DOT_PRODUCT = 3;</code>
     */
    public static final int DOT_PRODUCT_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DistanceMeasure valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DistanceMeasure forNumber(int value) {
      switch (value) {
        case 0:
          return DISTANCE_MEASURE_UNSPECIFIED;
        case 1:
          return EUCLIDEAN;
        case 2:
          return COSINE;
        case 3:
          return DOT_PRODUCT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DistanceMeasure> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DistanceMeasure>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DistanceMeasure>() {
              public DistanceMeasure findValueByNumber(int number) {
                return DistanceMeasure.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.datastore.v1.FindNearest.getDescriptor().getEnumTypes().get(0);
    }

    private static final DistanceMeasure[] VALUES = values();

    public static DistanceMeasure valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DistanceMeasure(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.datastore.v1.FindNearest.DistanceMeasure)
  }

  private int bitField0_;
  public static final int VECTOR_PROPERTY_FIELD_NUMBER = 1;
  private com.google.datastore.v1.PropertyReference vectorProperty_;

  /**
   *
   *
   * <pre>
   * Required. An indexed vector property to search upon. Only documents which
   * contain vectors whose dimensionality match the query_vector can be
   * returned.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the vectorProperty field is set.
   */
  @java.lang.Override
  public boolean hasVectorProperty() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. An indexed vector property to search upon. Only documents which
   * contain vectors whose dimensionality match the query_vector can be
   * returned.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The vectorProperty.
   */
  @java.lang.Override
  public com.google.datastore.v1.PropertyReference getVectorProperty() {
    return vectorProperty_ == null
        ? com.google.datastore.v1.PropertyReference.getDefaultInstance()
        : vectorProperty_;
  }

  /**
   *
   *
   * <pre>
   * Required. An indexed vector property to search upon. Only documents which
   * contain vectors whose dimensionality match the query_vector can be
   * returned.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.datastore.v1.PropertyReferenceOrBuilder getVectorPropertyOrBuilder() {
    return vectorProperty_ == null
        ? com.google.datastore.v1.PropertyReference.getDefaultInstance()
        : vectorProperty_;
  }

  public static final int QUERY_VECTOR_FIELD_NUMBER = 2;
  private com.google.datastore.v1.Value queryVector_;

  /**
   *
   *
   * <pre>
   * Required. The query vector that we are searching on. Must be a vector of no
   * more than 2048 dimensions.
   * </pre>
   *
   * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the queryVector field is set.
   */
  @java.lang.Override
  public boolean hasQueryVector() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The query vector that we are searching on. Must be a vector of no
   * more than 2048 dimensions.
   * </pre>
   *
   * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The queryVector.
   */
  @java.lang.Override
  public com.google.datastore.v1.Value getQueryVector() {
    return queryVector_ == null ? com.google.datastore.v1.Value.getDefaultInstance() : queryVector_;
  }

  /**
   *
   *
   * <pre>
   * Required. The query vector that we are searching on. Must be a vector of no
   * more than 2048 dimensions.
   * </pre>
   *
   * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.datastore.v1.ValueOrBuilder getQueryVectorOrBuilder() {
    return queryVector_ == null ? com.google.datastore.v1.Value.getDefaultInstance() : queryVector_;
  }

  public static final int DISTANCE_MEASURE_FIELD_NUMBER = 3;
  private int distanceMeasure_ = 0;

  /**
   *
   *
   * <pre>
   * Required. The Distance Measure to use, required.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.FindNearest.DistanceMeasure distance_measure = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for distanceMeasure.
   */
  @java.lang.Override
  public int getDistanceMeasureValue() {
    return distanceMeasure_;
  }

  /**
   *
   *
   * <pre>
   * Required. The Distance Measure to use, required.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.FindNearest.DistanceMeasure distance_measure = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The distanceMeasure.
   */
  @java.lang.Override
  public com.google.datastore.v1.FindNearest.DistanceMeasure getDistanceMeasure() {
    com.google.datastore.v1.FindNearest.DistanceMeasure result =
        com.google.datastore.v1.FindNearest.DistanceMeasure.forNumber(distanceMeasure_);
    return result == null
        ? com.google.datastore.v1.FindNearest.DistanceMeasure.UNRECOGNIZED
        : result;
  }

  public static final int LIMIT_FIELD_NUMBER = 4;
  private com.google.protobuf.Int32Value limit_;

  /**
   *
   *
   * <pre>
   * Required. The number of nearest neighbors to return. Must be a positive
   * integer of no more than 100.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the limit field is set.
   */
  @java.lang.Override
  public boolean hasLimit() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The number of nearest neighbors to return. Must be a positive
   * integer of no more than 100.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The limit.
   */
  @java.lang.Override
  public com.google.protobuf.Int32Value getLimit() {
    return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
  }

  /**
   *
   *
   * <pre>
   * Required. The number of nearest neighbors to return. Must be a positive
   * integer of no more than 100.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int32ValueOrBuilder getLimitOrBuilder() {
    return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
  }

  public static final int DISTANCE_RESULT_PROPERTY_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object distanceResultProperty_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Optional name of the field to output the result of the vector
   * distance calculation. Must conform to [entity
   * property][google.datastore.v1.Entity.properties] limitations.
   * </pre>
   *
   * <code>string distance_result_property = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The distanceResultProperty.
   */
  @java.lang.Override
  public java.lang.String getDistanceResultProperty() {
    java.lang.Object ref = distanceResultProperty_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      distanceResultProperty_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Optional name of the field to output the result of the vector
   * distance calculation. Must conform to [entity
   * property][google.datastore.v1.Entity.properties] limitations.
   * </pre>
   *
   * <code>string distance_result_property = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for distanceResultProperty.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDistanceResultPropertyBytes() {
    java.lang.Object ref = distanceResultProperty_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      distanceResultProperty_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISTANCE_THRESHOLD_FIELD_NUMBER = 6;
  private com.google.protobuf.DoubleValue distanceThreshold_;

  /**
   *
   *
   * <pre>
   * Optional. Option to specify a threshold for which no less similar documents
   * will be returned. The behavior of the specified `distance_measure` will
   * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
   * increase when the vectors are more similar, the comparison is inverted.
   *
   * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
   * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
   * </pre>
   *
   * <code>
   * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the distanceThreshold field is set.
   */
  @java.lang.Override
  public boolean hasDistanceThreshold() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Option to specify a threshold for which no less similar documents
   * will be returned. The behavior of the specified `distance_measure` will
   * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
   * increase when the vectors are more similar, the comparison is inverted.
   *
   * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
   * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
   * </pre>
   *
   * <code>
   * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The distanceThreshold.
   */
  @java.lang.Override
  public com.google.protobuf.DoubleValue getDistanceThreshold() {
    return distanceThreshold_ == null
        ? com.google.protobuf.DoubleValue.getDefaultInstance()
        : distanceThreshold_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Option to specify a threshold for which no less similar documents
   * will be returned. The behavior of the specified `distance_measure` will
   * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
   * increase when the vectors are more similar, the comparison is inverted.
   *
   * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
   * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
   * </pre>
   *
   * <code>
   * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DoubleValueOrBuilder getDistanceThresholdOrBuilder() {
    return distanceThreshold_ == null
        ? com.google.protobuf.DoubleValue.getDefaultInstance()
        : distanceThreshold_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getVectorProperty());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getQueryVector());
    }
    if (distanceMeasure_
        != com.google.datastore.v1.FindNearest.DistanceMeasure.DISTANCE_MEASURE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, distanceMeasure_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getLimit());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(distanceResultProperty_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, distanceResultProperty_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getDistanceThreshold());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getVectorProperty());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getQueryVector());
    }
    if (distanceMeasure_
        != com.google.datastore.v1.FindNearest.DistanceMeasure.DISTANCE_MEASURE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, distanceMeasure_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getLimit());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(distanceResultProperty_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, distanceResultProperty_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDistanceThreshold());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.FindNearest)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.FindNearest other = (com.google.datastore.v1.FindNearest) obj;

    if (hasVectorProperty() != other.hasVectorProperty()) return false;
    if (hasVectorProperty()) {
      if (!getVectorProperty().equals(other.getVectorProperty())) return false;
    }
    if (hasQueryVector() != other.hasQueryVector()) return false;
    if (hasQueryVector()) {
      if (!getQueryVector().equals(other.getQueryVector())) return false;
    }
    if (distanceMeasure_ != other.distanceMeasure_) return false;
    if (hasLimit() != other.hasLimit()) return false;
    if (hasLimit()) {
      if (!getLimit().equals(other.getLimit())) return false;
    }
    if (!getDistanceResultProperty().equals(other.getDistanceResultProperty())) return false;
    if (hasDistanceThreshold() != other.hasDistanceThreshold()) return false;
    if (hasDistanceThreshold()) {
      if (!getDistanceThreshold().equals(other.getDistanceThreshold())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasVectorProperty()) {
      hash = (37 * hash) + VECTOR_PROPERTY_FIELD_NUMBER;
      hash = (53 * hash) + getVectorProperty().hashCode();
    }
    if (hasQueryVector()) {
      hash = (37 * hash) + QUERY_VECTOR_FIELD_NUMBER;
      hash = (53 * hash) + getQueryVector().hashCode();
    }
    hash = (37 * hash) + DISTANCE_MEASURE_FIELD_NUMBER;
    hash = (53 * hash) + distanceMeasure_;
    if (hasLimit()) {
      hash = (37 * hash) + LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getLimit().hashCode();
    }
    hash = (37 * hash) + DISTANCE_RESULT_PROPERTY_FIELD_NUMBER;
    hash = (53 * hash) + getDistanceResultProperty().hashCode();
    if (hasDistanceThreshold()) {
      hash = (37 * hash) + DISTANCE_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + getDistanceThreshold().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.FindNearest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.FindNearest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.FindNearest parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.FindNearest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.FindNearest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.FindNearest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.FindNearest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.FindNearest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.FindNearest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.FindNearest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.FindNearest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.FindNearest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.FindNearest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Nearest Neighbors search config. The ordering provided by FindNearest
   * supersedes the order_by stage. If multiple documents have the same vector
   * distance, the returned document order is not guaranteed to be stable between
   * queries.
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.FindNearest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.FindNearest)
      com.google.datastore.v1.FindNearestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_FindNearest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_FindNearest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.FindNearest.class,
              com.google.datastore.v1.FindNearest.Builder.class);
    }

    // Construct using com.google.datastore.v1.FindNearest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getVectorPropertyFieldBuilder();
        getQueryVectorFieldBuilder();
        getLimitFieldBuilder();
        getDistanceThresholdFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      vectorProperty_ = null;
      if (vectorPropertyBuilder_ != null) {
        vectorPropertyBuilder_.dispose();
        vectorPropertyBuilder_ = null;
      }
      queryVector_ = null;
      if (queryVectorBuilder_ != null) {
        queryVectorBuilder_.dispose();
        queryVectorBuilder_ = null;
      }
      distanceMeasure_ = 0;
      limit_ = null;
      if (limitBuilder_ != null) {
        limitBuilder_.dispose();
        limitBuilder_ = null;
      }
      distanceResultProperty_ = "";
      distanceThreshold_ = null;
      if (distanceThresholdBuilder_ != null) {
        distanceThresholdBuilder_.dispose();
        distanceThresholdBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_FindNearest_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.FindNearest getDefaultInstanceForType() {
      return com.google.datastore.v1.FindNearest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.FindNearest build() {
      com.google.datastore.v1.FindNearest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.FindNearest buildPartial() {
      com.google.datastore.v1.FindNearest result = new com.google.datastore.v1.FindNearest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.datastore.v1.FindNearest result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.vectorProperty_ =
            vectorPropertyBuilder_ == null ? vectorProperty_ : vectorPropertyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.queryVector_ =
            queryVectorBuilder_ == null ? queryVector_ : queryVectorBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.distanceMeasure_ = distanceMeasure_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.limit_ = limitBuilder_ == null ? limit_ : limitBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.distanceResultProperty_ = distanceResultProperty_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.distanceThreshold_ =
            distanceThresholdBuilder_ == null
                ? distanceThreshold_
                : distanceThresholdBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.FindNearest) {
        return mergeFrom((com.google.datastore.v1.FindNearest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.FindNearest other) {
      if (other == com.google.datastore.v1.FindNearest.getDefaultInstance()) return this;
      if (other.hasVectorProperty()) {
        mergeVectorProperty(other.getVectorProperty());
      }
      if (other.hasQueryVector()) {
        mergeQueryVector(other.getQueryVector());
      }
      if (other.distanceMeasure_ != 0) {
        setDistanceMeasureValue(other.getDistanceMeasureValue());
      }
      if (other.hasLimit()) {
        mergeLimit(other.getLimit());
      }
      if (!other.getDistanceResultProperty().isEmpty()) {
        distanceResultProperty_ = other.distanceResultProperty_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasDistanceThreshold()) {
        mergeDistanceThreshold(other.getDistanceThreshold());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getVectorPropertyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getQueryVectorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                distanceMeasure_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getLimitFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                distanceResultProperty_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getDistanceThresholdFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.datastore.v1.PropertyReference vectorProperty_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.PropertyReference,
            com.google.datastore.v1.PropertyReference.Builder,
            com.google.datastore.v1.PropertyReferenceOrBuilder>
        vectorPropertyBuilder_;

    /**
     *
     *
     * <pre>
     * Required. An indexed vector property to search upon. Only documents which
     * contain vectors whose dimensionality match the query_vector can be
     * returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the vectorProperty field is set.
     */
    public boolean hasVectorProperty() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. An indexed vector property to search upon. Only documents which
     * contain vectors whose dimensionality match the query_vector can be
     * returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The vectorProperty.
     */
    public com.google.datastore.v1.PropertyReference getVectorProperty() {
      if (vectorPropertyBuilder_ == null) {
        return vectorProperty_ == null
            ? com.google.datastore.v1.PropertyReference.getDefaultInstance()
            : vectorProperty_;
      } else {
        return vectorPropertyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. An indexed vector property to search upon. Only documents which
     * contain vectors whose dimensionality match the query_vector can be
     * returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setVectorProperty(com.google.datastore.v1.PropertyReference value) {
      if (vectorPropertyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vectorProperty_ = value;
      } else {
        vectorPropertyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. An indexed vector property to search upon. Only documents which
     * contain vectors whose dimensionality match the query_vector can be
     * returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setVectorProperty(
        com.google.datastore.v1.PropertyReference.Builder builderForValue) {
      if (vectorPropertyBuilder_ == null) {
        vectorProperty_ = builderForValue.build();
      } else {
        vectorPropertyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. An indexed vector property to search upon. Only documents which
     * contain vectors whose dimensionality match the query_vector can be
     * returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeVectorProperty(com.google.datastore.v1.PropertyReference value) {
      if (vectorPropertyBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && vectorProperty_ != null
            && vectorProperty_ != com.google.datastore.v1.PropertyReference.getDefaultInstance()) {
          getVectorPropertyBuilder().mergeFrom(value);
        } else {
          vectorProperty_ = value;
        }
      } else {
        vectorPropertyBuilder_.mergeFrom(value);
      }
      if (vectorProperty_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. An indexed vector property to search upon. Only documents which
     * contain vectors whose dimensionality match the query_vector can be
     * returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearVectorProperty() {
      bitField0_ = (bitField0_ & ~0x00000001);
      vectorProperty_ = null;
      if (vectorPropertyBuilder_ != null) {
        vectorPropertyBuilder_.dispose();
        vectorPropertyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. An indexed vector property to search upon. Only documents which
     * contain vectors whose dimensionality match the query_vector can be
     * returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.datastore.v1.PropertyReference.Builder getVectorPropertyBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getVectorPropertyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. An indexed vector property to search upon. Only documents which
     * contain vectors whose dimensionality match the query_vector can be
     * returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.datastore.v1.PropertyReferenceOrBuilder getVectorPropertyOrBuilder() {
      if (vectorPropertyBuilder_ != null) {
        return vectorPropertyBuilder_.getMessageOrBuilder();
      } else {
        return vectorProperty_ == null
            ? com.google.datastore.v1.PropertyReference.getDefaultInstance()
            : vectorProperty_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. An indexed vector property to search upon. Only documents which
     * contain vectors whose dimensionality match the query_vector can be
     * returned.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.PropertyReference vector_property = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.PropertyReference,
            com.google.datastore.v1.PropertyReference.Builder,
            com.google.datastore.v1.PropertyReferenceOrBuilder>
        getVectorPropertyFieldBuilder() {
      if (vectorPropertyBuilder_ == null) {
        vectorPropertyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.PropertyReference,
                com.google.datastore.v1.PropertyReference.Builder,
                com.google.datastore.v1.PropertyReferenceOrBuilder>(
                getVectorProperty(), getParentForChildren(), isClean());
        vectorProperty_ = null;
      }
      return vectorPropertyBuilder_;
    }

    private com.google.datastore.v1.Value queryVector_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Value,
            com.google.datastore.v1.Value.Builder,
            com.google.datastore.v1.ValueOrBuilder>
        queryVectorBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The query vector that we are searching on. Must be a vector of no
     * more than 2048 dimensions.
     * </pre>
     *
     * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the queryVector field is set.
     */
    public boolean hasQueryVector() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The query vector that we are searching on. Must be a vector of no
     * more than 2048 dimensions.
     * </pre>
     *
     * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The queryVector.
     */
    public com.google.datastore.v1.Value getQueryVector() {
      if (queryVectorBuilder_ == null) {
        return queryVector_ == null
            ? com.google.datastore.v1.Value.getDefaultInstance()
            : queryVector_;
      } else {
        return queryVectorBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The query vector that we are searching on. Must be a vector of no
     * more than 2048 dimensions.
     * </pre>
     *
     * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQueryVector(com.google.datastore.v1.Value value) {
      if (queryVectorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryVector_ = value;
      } else {
        queryVectorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The query vector that we are searching on. Must be a vector of no
     * more than 2048 dimensions.
     * </pre>
     *
     * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQueryVector(com.google.datastore.v1.Value.Builder builderForValue) {
      if (queryVectorBuilder_ == null) {
        queryVector_ = builderForValue.build();
      } else {
        queryVectorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The query vector that we are searching on. Must be a vector of no
     * more than 2048 dimensions.
     * </pre>
     *
     * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeQueryVector(com.google.datastore.v1.Value value) {
      if (queryVectorBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && queryVector_ != null
            && queryVector_ != com.google.datastore.v1.Value.getDefaultInstance()) {
          getQueryVectorBuilder().mergeFrom(value);
        } else {
          queryVector_ = value;
        }
      } else {
        queryVectorBuilder_.mergeFrom(value);
      }
      if (queryVector_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The query vector that we are searching on. Must be a vector of no
     * more than 2048 dimensions.
     * </pre>
     *
     * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearQueryVector() {
      bitField0_ = (bitField0_ & ~0x00000002);
      queryVector_ = null;
      if (queryVectorBuilder_ != null) {
        queryVectorBuilder_.dispose();
        queryVectorBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The query vector that we are searching on. Must be a vector of no
     * more than 2048 dimensions.
     * </pre>
     *
     * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.datastore.v1.Value.Builder getQueryVectorBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getQueryVectorFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. The query vector that we are searching on. Must be a vector of no
     * more than 2048 dimensions.
     * </pre>
     *
     * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.datastore.v1.ValueOrBuilder getQueryVectorOrBuilder() {
      if (queryVectorBuilder_ != null) {
        return queryVectorBuilder_.getMessageOrBuilder();
      } else {
        return queryVector_ == null
            ? com.google.datastore.v1.Value.getDefaultInstance()
            : queryVector_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The query vector that we are searching on. Must be a vector of no
     * more than 2048 dimensions.
     * </pre>
     *
     * <code>.google.datastore.v1.Value query_vector = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Value,
            com.google.datastore.v1.Value.Builder,
            com.google.datastore.v1.ValueOrBuilder>
        getQueryVectorFieldBuilder() {
      if (queryVectorBuilder_ == null) {
        queryVectorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Value,
                com.google.datastore.v1.Value.Builder,
                com.google.datastore.v1.ValueOrBuilder>(
                getQueryVector(), getParentForChildren(), isClean());
        queryVector_ = null;
      }
      return queryVectorBuilder_;
    }

    private int distanceMeasure_ = 0;

    /**
     *
     *
     * <pre>
     * Required. The Distance Measure to use, required.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.FindNearest.DistanceMeasure distance_measure = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for distanceMeasure.
     */
    @java.lang.Override
    public int getDistanceMeasureValue() {
      return distanceMeasure_;
    }

    /**
     *
     *
     * <pre>
     * Required. The Distance Measure to use, required.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.FindNearest.DistanceMeasure distance_measure = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for distanceMeasure to set.
     * @return This builder for chaining.
     */
    public Builder setDistanceMeasureValue(int value) {
      distanceMeasure_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The Distance Measure to use, required.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.FindNearest.DistanceMeasure distance_measure = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The distanceMeasure.
     */
    @java.lang.Override
    public com.google.datastore.v1.FindNearest.DistanceMeasure getDistanceMeasure() {
      com.google.datastore.v1.FindNearest.DistanceMeasure result =
          com.google.datastore.v1.FindNearest.DistanceMeasure.forNumber(distanceMeasure_);
      return result == null
          ? com.google.datastore.v1.FindNearest.DistanceMeasure.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Required. The Distance Measure to use, required.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.FindNearest.DistanceMeasure distance_measure = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The distanceMeasure to set.
     * @return This builder for chaining.
     */
    public Builder setDistanceMeasure(com.google.datastore.v1.FindNearest.DistanceMeasure value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      distanceMeasure_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The Distance Measure to use, required.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.FindNearest.DistanceMeasure distance_measure = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDistanceMeasure() {
      bitField0_ = (bitField0_ & ~0x00000004);
      distanceMeasure_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Int32Value limit_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int32Value,
            com.google.protobuf.Int32Value.Builder,
            com.google.protobuf.Int32ValueOrBuilder>
        limitBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The number of nearest neighbors to return. Must be a positive
     * integer of no more than 100.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the limit field is set.
     */
    public boolean hasLimit() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The number of nearest neighbors to return. Must be a positive
     * integer of no more than 100.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The limit.
     */
    public com.google.protobuf.Int32Value getLimit() {
      if (limitBuilder_ == null) {
        return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
      } else {
        return limitBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The number of nearest neighbors to return. Must be a positive
     * integer of no more than 100.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setLimit(com.google.protobuf.Int32Value value) {
      if (limitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        limit_ = value;
      } else {
        limitBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The number of nearest neighbors to return. Must be a positive
     * integer of no more than 100.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setLimit(com.google.protobuf.Int32Value.Builder builderForValue) {
      if (limitBuilder_ == null) {
        limit_ = builderForValue.build();
      } else {
        limitBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The number of nearest neighbors to return. Must be a positive
     * integer of no more than 100.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder mergeLimit(com.google.protobuf.Int32Value value) {
      if (limitBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && limit_ != null
            && limit_ != com.google.protobuf.Int32Value.getDefaultInstance()) {
          getLimitBuilder().mergeFrom(value);
        } else {
          limit_ = value;
        }
      } else {
        limitBuilder_.mergeFrom(value);
      }
      if (limit_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The number of nearest neighbors to return. Must be a positive
     * integer of no more than 100.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearLimit() {
      bitField0_ = (bitField0_ & ~0x00000008);
      limit_ = null;
      if (limitBuilder_ != null) {
        limitBuilder_.dispose();
        limitBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The number of nearest neighbors to return. Must be a positive
     * integer of no more than 100.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.protobuf.Int32Value.Builder getLimitBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getLimitFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. The number of nearest neighbors to return. Must be a positive
     * integer of no more than 100.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.protobuf.Int32ValueOrBuilder getLimitOrBuilder() {
      if (limitBuilder_ != null) {
        return limitBuilder_.getMessageOrBuilder();
      } else {
        return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The number of nearest neighbors to return. Must be a positive
     * integer of no more than 100.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int32Value,
            com.google.protobuf.Int32Value.Builder,
            com.google.protobuf.Int32ValueOrBuilder>
        getLimitFieldBuilder() {
      if (limitBuilder_ == null) {
        limitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int32Value,
                com.google.protobuf.Int32Value.Builder,
                com.google.protobuf.Int32ValueOrBuilder>(
                getLimit(), getParentForChildren(), isClean());
        limit_ = null;
      }
      return limitBuilder_;
    }

    private java.lang.Object distanceResultProperty_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Optional name of the field to output the result of the vector
     * distance calculation. Must conform to [entity
     * property][google.datastore.v1.Entity.properties] limitations.
     * </pre>
     *
     * <code>string distance_result_property = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The distanceResultProperty.
     */
    public java.lang.String getDistanceResultProperty() {
      java.lang.Object ref = distanceResultProperty_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        distanceResultProperty_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional name of the field to output the result of the vector
     * distance calculation. Must conform to [entity
     * property][google.datastore.v1.Entity.properties] limitations.
     * </pre>
     *
     * <code>string distance_result_property = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for distanceResultProperty.
     */
    public com.google.protobuf.ByteString getDistanceResultPropertyBytes() {
      java.lang.Object ref = distanceResultProperty_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        distanceResultProperty_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional name of the field to output the result of the vector
     * distance calculation. Must conform to [entity
     * property][google.datastore.v1.Entity.properties] limitations.
     * </pre>
     *
     * <code>string distance_result_property = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The distanceResultProperty to set.
     * @return This builder for chaining.
     */
    public Builder setDistanceResultProperty(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      distanceResultProperty_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional name of the field to output the result of the vector
     * distance calculation. Must conform to [entity
     * property][google.datastore.v1.Entity.properties] limitations.
     * </pre>
     *
     * <code>string distance_result_property = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDistanceResultProperty() {
      distanceResultProperty_ = getDefaultInstance().getDistanceResultProperty();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional name of the field to output the result of the vector
     * distance calculation. Must conform to [entity
     * property][google.datastore.v1.Entity.properties] limitations.
     * </pre>
     *
     * <code>string distance_result_property = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for distanceResultProperty to set.
     * @return This builder for chaining.
     */
    public Builder setDistanceResultPropertyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      distanceResultProperty_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.DoubleValue distanceThreshold_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.DoubleValue,
            com.google.protobuf.DoubleValue.Builder,
            com.google.protobuf.DoubleValueOrBuilder>
        distanceThresholdBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Option to specify a threshold for which no less similar documents
     * will be returned. The behavior of the specified `distance_measure` will
     * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
     * increase when the vectors are more similar, the comparison is inverted.
     *
     * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
     * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
     * </pre>
     *
     * <code>
     * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the distanceThreshold field is set.
     */
    public boolean hasDistanceThreshold() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Option to specify a threshold for which no less similar documents
     * will be returned. The behavior of the specified `distance_measure` will
     * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
     * increase when the vectors are more similar, the comparison is inverted.
     *
     * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
     * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
     * </pre>
     *
     * <code>
     * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The distanceThreshold.
     */
    public com.google.protobuf.DoubleValue getDistanceThreshold() {
      if (distanceThresholdBuilder_ == null) {
        return distanceThreshold_ == null
            ? com.google.protobuf.DoubleValue.getDefaultInstance()
            : distanceThreshold_;
      } else {
        return distanceThresholdBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Option to specify a threshold for which no less similar documents
     * will be returned. The behavior of the specified `distance_measure` will
     * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
     * increase when the vectors are more similar, the comparison is inverted.
     *
     * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
     * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
     * </pre>
     *
     * <code>
     * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDistanceThreshold(com.google.protobuf.DoubleValue value) {
      if (distanceThresholdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        distanceThreshold_ = value;
      } else {
        distanceThresholdBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Option to specify a threshold for which no less similar documents
     * will be returned. The behavior of the specified `distance_measure` will
     * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
     * increase when the vectors are more similar, the comparison is inverted.
     *
     * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
     * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
     * </pre>
     *
     * <code>
     * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDistanceThreshold(com.google.protobuf.DoubleValue.Builder builderForValue) {
      if (distanceThresholdBuilder_ == null) {
        distanceThreshold_ = builderForValue.build();
      } else {
        distanceThresholdBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Option to specify a threshold for which no less similar documents
     * will be returned. The behavior of the specified `distance_measure` will
     * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
     * increase when the vectors are more similar, the comparison is inverted.
     *
     * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
     * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
     * </pre>
     *
     * <code>
     * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDistanceThreshold(com.google.protobuf.DoubleValue value) {
      if (distanceThresholdBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && distanceThreshold_ != null
            && distanceThreshold_ != com.google.protobuf.DoubleValue.getDefaultInstance()) {
          getDistanceThresholdBuilder().mergeFrom(value);
        } else {
          distanceThreshold_ = value;
        }
      } else {
        distanceThresholdBuilder_.mergeFrom(value);
      }
      if (distanceThreshold_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Option to specify a threshold for which no less similar documents
     * will be returned. The behavior of the specified `distance_measure` will
     * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
     * increase when the vectors are more similar, the comparison is inverted.
     *
     * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
     * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
     * </pre>
     *
     * <code>
     * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDistanceThreshold() {
      bitField0_ = (bitField0_ & ~0x00000020);
      distanceThreshold_ = null;
      if (distanceThresholdBuilder_ != null) {
        distanceThresholdBuilder_.dispose();
        distanceThresholdBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Option to specify a threshold for which no less similar documents
     * will be returned. The behavior of the specified `distance_measure` will
     * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
     * increase when the vectors are more similar, the comparison is inverted.
     *
     * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
     * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
     * </pre>
     *
     * <code>
     * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DoubleValue.Builder getDistanceThresholdBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getDistanceThresholdFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Option to specify a threshold for which no less similar documents
     * will be returned. The behavior of the specified `distance_measure` will
     * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
     * increase when the vectors are more similar, the comparison is inverted.
     *
     * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
     * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
     * </pre>
     *
     * <code>
     * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DoubleValueOrBuilder getDistanceThresholdOrBuilder() {
      if (distanceThresholdBuilder_ != null) {
        return distanceThresholdBuilder_.getMessageOrBuilder();
      } else {
        return distanceThreshold_ == null
            ? com.google.protobuf.DoubleValue.getDefaultInstance()
            : distanceThreshold_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Option to specify a threshold for which no less similar documents
     * will be returned. The behavior of the specified `distance_measure` will
     * affect the meaning of the distance threshold. Since DOT_PRODUCT distances
     * increase when the vectors are more similar, the comparison is inverted.
     *
     * For EUCLIDEAN, COSINE: WHERE distance &lt;= distance_threshold
     * For DOT_PRODUCT:       WHERE distance &gt;= distance_threshold
     * </pre>
     *
     * <code>
     * .google.protobuf.DoubleValue distance_threshold = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.DoubleValue,
            com.google.protobuf.DoubleValue.Builder,
            com.google.protobuf.DoubleValueOrBuilder>
        getDistanceThresholdFieldBuilder() {
      if (distanceThresholdBuilder_ == null) {
        distanceThresholdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.DoubleValue,
                com.google.protobuf.DoubleValue.Builder,
                com.google.protobuf.DoubleValueOrBuilder>(
                getDistanceThreshold(), getParentForChildren(), isClean());
        distanceThreshold_ = null;
      }
      return distanceThresholdBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.FindNearest)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.FindNearest)
  private static final com.google.datastore.v1.FindNearest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.FindNearest();
  }

  public static com.google.datastore.v1.FindNearest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FindNearest> PARSER =
      new com.google.protobuf.AbstractParser<FindNearest>() {
        @java.lang.Override
        public FindNearest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FindNearest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FindNearest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.FindNearest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
