/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/admin/v1/migration.proto

// Protobuf Java Version: 3.25.8
package com.google.datastore.admin.v1;

/**
 *
 *
 * <pre>
 * An event signifying the start of a new step in a [migration from Cloud
 * Datastore to Cloud Firestore in Datastore
 * mode](https://cloud.google.com/datastore/docs/upgrade-to-firestore).
 * </pre>
 *
 * Protobuf type {@code google.datastore.admin.v1.MigrationProgressEvent}
 */
public final class MigrationProgressEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.admin.v1.MigrationProgressEvent)
    MigrationProgressEventOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use MigrationProgressEvent.newBuilder() to construct.
  private MigrationProgressEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MigrationProgressEvent() {
    step_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MigrationProgressEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.admin.v1.MigrationProto
        .internal_static_google_datastore_admin_v1_MigrationProgressEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.admin.v1.MigrationProto
        .internal_static_google_datastore_admin_v1_MigrationProgressEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.admin.v1.MigrationProgressEvent.class,
            com.google.datastore.admin.v1.MigrationProgressEvent.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Concurrency modes for transactions in Cloud Firestore.
   * </pre>
   *
   * Protobuf enum {@code google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode}
   */
  public enum ConcurrencyMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>CONCURRENCY_MODE_UNSPECIFIED = 0;</code>
     */
    CONCURRENCY_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Pessimistic concurrency.
     * </pre>
     *
     * <code>PESSIMISTIC = 1;</code>
     */
    PESSIMISTIC(1),
    /**
     *
     *
     * <pre>
     * Optimistic concurrency.
     * </pre>
     *
     * <code>OPTIMISTIC = 2;</code>
     */
    OPTIMISTIC(2),
    /**
     *
     *
     * <pre>
     * Optimistic concurrency with entity groups.
     * </pre>
     *
     * <code>OPTIMISTIC_WITH_ENTITY_GROUPS = 3;</code>
     */
    OPTIMISTIC_WITH_ENTITY_GROUPS(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>CONCURRENCY_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int CONCURRENCY_MODE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Pessimistic concurrency.
     * </pre>
     *
     * <code>PESSIMISTIC = 1;</code>
     */
    public static final int PESSIMISTIC_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Optimistic concurrency.
     * </pre>
     *
     * <code>OPTIMISTIC = 2;</code>
     */
    public static final int OPTIMISTIC_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Optimistic concurrency with entity groups.
     * </pre>
     *
     * <code>OPTIMISTIC_WITH_ENTITY_GROUPS = 3;</code>
     */
    public static final int OPTIMISTIC_WITH_ENTITY_GROUPS_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConcurrencyMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConcurrencyMode forNumber(int value) {
      switch (value) {
        case 0:
          return CONCURRENCY_MODE_UNSPECIFIED;
        case 1:
          return PESSIMISTIC;
        case 2:
          return OPTIMISTIC;
        case 3:
          return OPTIMISTIC_WITH_ENTITY_GROUPS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConcurrencyMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConcurrencyMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ConcurrencyMode>() {
              public ConcurrencyMode findValueByNumber(int number) {
                return ConcurrencyMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.datastore.admin.v1.MigrationProgressEvent.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ConcurrencyMode[] VALUES = values();

    public static ConcurrencyMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConcurrencyMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode)
  }

  public interface PrepareStepDetailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The concurrency mode this database will use when it reaches the
     * `REDIRECT_WRITES` step.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for concurrencyMode.
     */
    int getConcurrencyModeValue();

    /**
     *
     *
     * <pre>
     * The concurrency mode this database will use when it reaches the
     * `REDIRECT_WRITES` step.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
     * </code>
     *
     * @return The concurrencyMode.
     */
    com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode getConcurrencyMode();
  }

  /**
   *
   *
   * <pre>
   * Details for the `PREPARE` step.
   * </pre>
   *
   * Protobuf type {@code google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails}
   */
  public static final class PrepareStepDetails extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails)
      PrepareStepDetailsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PrepareStepDetails.newBuilder() to construct.
    private PrepareStepDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PrepareStepDetails() {
      concurrencyMode_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PrepareStepDetails();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.admin.v1.MigrationProto
          .internal_static_google_datastore_admin_v1_MigrationProgressEvent_PrepareStepDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.admin.v1.MigrationProto
          .internal_static_google_datastore_admin_v1_MigrationProgressEvent_PrepareStepDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails.class,
              com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails.Builder
                  .class);
    }

    public static final int CONCURRENCY_MODE_FIELD_NUMBER = 1;
    private int concurrencyMode_ = 0;

    /**
     *
     *
     * <pre>
     * The concurrency mode this database will use when it reaches the
     * `REDIRECT_WRITES` step.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for concurrencyMode.
     */
    @java.lang.Override
    public int getConcurrencyModeValue() {
      return concurrencyMode_;
    }

    /**
     *
     *
     * <pre>
     * The concurrency mode this database will use when it reaches the
     * `REDIRECT_WRITES` step.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
     * </code>
     *
     * @return The concurrencyMode.
     */
    @java.lang.Override
    public com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode
        getConcurrencyMode() {
      com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode result =
          com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode.forNumber(
              concurrencyMode_);
      return result == null
          ? com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (concurrencyMode_
          != com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode
              .CONCURRENCY_MODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, concurrencyMode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (concurrencyMode_
          != com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode
              .CONCURRENCY_MODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, concurrencyMode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails)) {
        return super.equals(obj);
      }
      com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails other =
          (com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails) obj;

      if (concurrencyMode_ != other.concurrencyMode_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONCURRENCY_MODE_FIELD_NUMBER;
      hash = (53 * hash) + concurrencyMode_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Details for the `PREPARE` step.
     * </pre>
     *
     * Protobuf type {@code google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails)
        com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.datastore.admin.v1.MigrationProto
            .internal_static_google_datastore_admin_v1_MigrationProgressEvent_PrepareStepDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.datastore.admin.v1.MigrationProto
            .internal_static_google_datastore_admin_v1_MigrationProgressEvent_PrepareStepDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails.class,
                com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails.Builder
                    .class);
      }

      // Construct using
      // com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        concurrencyMode_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.datastore.admin.v1.MigrationProto
            .internal_static_google_datastore_admin_v1_MigrationProgressEvent_PrepareStepDetails_descriptor;
      }

      @java.lang.Override
      public com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
          getDefaultInstanceForType() {
        return com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails build() {
        com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
          buildPartial() {
        com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails result =
            new com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.concurrencyMode_ = concurrencyMode_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails) {
          return mergeFrom(
              (com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails other) {
        if (other
            == com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
                .getDefaultInstance()) return this;
        if (other.concurrencyMode_ != 0) {
          setConcurrencyModeValue(other.getConcurrencyModeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  concurrencyMode_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int concurrencyMode_ = 0;

      /**
       *
       *
       * <pre>
       * The concurrency mode this database will use when it reaches the
       * `REDIRECT_WRITES` step.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for concurrencyMode.
       */
      @java.lang.Override
      public int getConcurrencyModeValue() {
        return concurrencyMode_;
      }

      /**
       *
       *
       * <pre>
       * The concurrency mode this database will use when it reaches the
       * `REDIRECT_WRITES` step.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for concurrencyMode to set.
       * @return This builder for chaining.
       */
      public Builder setConcurrencyModeValue(int value) {
        concurrencyMode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The concurrency mode this database will use when it reaches the
       * `REDIRECT_WRITES` step.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
       * </code>
       *
       * @return The concurrencyMode.
       */
      @java.lang.Override
      public com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode
          getConcurrencyMode() {
        com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode result =
            com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode.forNumber(
                concurrencyMode_);
        return result == null
            ? com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The concurrency mode this database will use when it reaches the
       * `REDIRECT_WRITES` step.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
       * </code>
       *
       * @param value The concurrencyMode to set.
       * @return This builder for chaining.
       */
      public Builder setConcurrencyMode(
          com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        concurrencyMode_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The concurrency mode this database will use when it reaches the
       * `REDIRECT_WRITES` step.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConcurrencyMode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        concurrencyMode_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails)
    }

    // @@protoc_insertion_point(class_scope:google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails)
    private static final com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails();
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PrepareStepDetails> PARSER =
        new com.google.protobuf.AbstractParser<PrepareStepDetails>() {
          @java.lang.Override
          public PrepareStepDetails parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PrepareStepDetails> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PrepareStepDetails> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RedirectWritesStepDetailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Ths concurrency mode for this database.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for concurrencyMode.
     */
    int getConcurrencyModeValue();

    /**
     *
     *
     * <pre>
     * Ths concurrency mode for this database.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
     * </code>
     *
     * @return The concurrencyMode.
     */
    com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode getConcurrencyMode();
  }

  /**
   *
   *
   * <pre>
   * Details for the `REDIRECT_WRITES` step.
   * </pre>
   *
   * Protobuf type {@code
   * google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails}
   */
  public static final class RedirectWritesStepDetails extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails)
      RedirectWritesStepDetailsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use RedirectWritesStepDetails.newBuilder() to construct.
    private RedirectWritesStepDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RedirectWritesStepDetails() {
      concurrencyMode_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RedirectWritesStepDetails();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.admin.v1.MigrationProto
          .internal_static_google_datastore_admin_v1_MigrationProgressEvent_RedirectWritesStepDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.admin.v1.MigrationProto
          .internal_static_google_datastore_admin_v1_MigrationProgressEvent_RedirectWritesStepDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails.class,
              com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails.Builder
                  .class);
    }

    public static final int CONCURRENCY_MODE_FIELD_NUMBER = 1;
    private int concurrencyMode_ = 0;

    /**
     *
     *
     * <pre>
     * Ths concurrency mode for this database.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for concurrencyMode.
     */
    @java.lang.Override
    public int getConcurrencyModeValue() {
      return concurrencyMode_;
    }

    /**
     *
     *
     * <pre>
     * Ths concurrency mode for this database.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
     * </code>
     *
     * @return The concurrencyMode.
     */
    @java.lang.Override
    public com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode
        getConcurrencyMode() {
      com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode result =
          com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode.forNumber(
              concurrencyMode_);
      return result == null
          ? com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (concurrencyMode_
          != com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode
              .CONCURRENCY_MODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, concurrencyMode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (concurrencyMode_
          != com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode
              .CONCURRENCY_MODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, concurrencyMode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails)) {
        return super.equals(obj);
      }
      com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails other =
          (com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails) obj;

      if (concurrencyMode_ != other.concurrencyMode_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONCURRENCY_MODE_FIELD_NUMBER;
      hash = (53 * hash) + concurrencyMode_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Details for the `REDIRECT_WRITES` step.
     * </pre>
     *
     * Protobuf type {@code
     * google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails)
        com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.datastore.admin.v1.MigrationProto
            .internal_static_google_datastore_admin_v1_MigrationProgressEvent_RedirectWritesStepDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.datastore.admin.v1.MigrationProto
            .internal_static_google_datastore_admin_v1_MigrationProgressEvent_RedirectWritesStepDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
                    .class,
                com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
                    .Builder.class);
      }

      // Construct using
      // com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        concurrencyMode_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.datastore.admin.v1.MigrationProto
            .internal_static_google_datastore_admin_v1_MigrationProgressEvent_RedirectWritesStepDetails_descriptor;
      }

      @java.lang.Override
      public com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
          getDefaultInstanceForType() {
        return com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
          build() {
        com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
          buildPartial() {
        com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails result =
            new com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.concurrencyMode_ = concurrencyMode_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails) {
          return mergeFrom(
              (com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails other) {
        if (other
            == com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
                .getDefaultInstance()) return this;
        if (other.concurrencyMode_ != 0) {
          setConcurrencyModeValue(other.getConcurrencyModeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  concurrencyMode_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int concurrencyMode_ = 0;

      /**
       *
       *
       * <pre>
       * Ths concurrency mode for this database.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for concurrencyMode.
       */
      @java.lang.Override
      public int getConcurrencyModeValue() {
        return concurrencyMode_;
      }

      /**
       *
       *
       * <pre>
       * Ths concurrency mode for this database.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for concurrencyMode to set.
       * @return This builder for chaining.
       */
      public Builder setConcurrencyModeValue(int value) {
        concurrencyMode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Ths concurrency mode for this database.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
       * </code>
       *
       * @return The concurrencyMode.
       */
      @java.lang.Override
      public com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode
          getConcurrencyMode() {
        com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode result =
            com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode.forNumber(
                concurrencyMode_);
        return result == null
            ? com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Ths concurrency mode for this database.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
       * </code>
       *
       * @param value The concurrencyMode to set.
       * @return This builder for chaining.
       */
      public Builder setConcurrencyMode(
          com.google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        concurrencyMode_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Ths concurrency mode for this database.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.MigrationProgressEvent.ConcurrencyMode concurrency_mode = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConcurrencyMode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        concurrencyMode_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails)
    }

    // @@protoc_insertion_point(class_scope:google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails)
    private static final com.google.datastore.admin.v1.MigrationProgressEvent
            .RedirectWritesStepDetails
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails();
    }

    public static com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RedirectWritesStepDetails> PARSER =
        new com.google.protobuf.AbstractParser<RedirectWritesStepDetails>() {
          @java.lang.Override
          public RedirectWritesStepDetails parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RedirectWritesStepDetails> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RedirectWritesStepDetails> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int stepDetailsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object stepDetails_;

  public enum StepDetailsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PREPARE_STEP_DETAILS(2),
    REDIRECT_WRITES_STEP_DETAILS(3),
    STEPDETAILS_NOT_SET(0);
    private final int value;

    private StepDetailsCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StepDetailsCase valueOf(int value) {
      return forNumber(value);
    }

    public static StepDetailsCase forNumber(int value) {
      switch (value) {
        case 2:
          return PREPARE_STEP_DETAILS;
        case 3:
          return REDIRECT_WRITES_STEP_DETAILS;
        case 0:
          return STEPDETAILS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public StepDetailsCase getStepDetailsCase() {
    return StepDetailsCase.forNumber(stepDetailsCase_);
  }

  public static final int STEP_FIELD_NUMBER = 1;
  private int step_ = 0;

  /**
   *
   *
   * <pre>
   * The step that is starting.
   *
   * An event with step set to `START` indicates that the migration
   * has been reverted back to the initial pre-migration state.
   * </pre>
   *
   * <code>.google.datastore.admin.v1.MigrationStep step = 1;</code>
   *
   * @return The enum numeric value on the wire for step.
   */
  @java.lang.Override
  public int getStepValue() {
    return step_;
  }

  /**
   *
   *
   * <pre>
   * The step that is starting.
   *
   * An event with step set to `START` indicates that the migration
   * has been reverted back to the initial pre-migration state.
   * </pre>
   *
   * <code>.google.datastore.admin.v1.MigrationStep step = 1;</code>
   *
   * @return The step.
   */
  @java.lang.Override
  public com.google.datastore.admin.v1.MigrationStep getStep() {
    com.google.datastore.admin.v1.MigrationStep result =
        com.google.datastore.admin.v1.MigrationStep.forNumber(step_);
    return result == null ? com.google.datastore.admin.v1.MigrationStep.UNRECOGNIZED : result;
  }

  public static final int PREPARE_STEP_DETAILS_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Details for the `PREPARE` step.
   * </pre>
   *
   * <code>
   * .google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails prepare_step_details = 2;
   * </code>
   *
   * @return Whether the prepareStepDetails field is set.
   */
  @java.lang.Override
  public boolean hasPrepareStepDetails() {
    return stepDetailsCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Details for the `PREPARE` step.
   * </pre>
   *
   * <code>
   * .google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails prepare_step_details = 2;
   * </code>
   *
   * @return The prepareStepDetails.
   */
  @java.lang.Override
  public com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
      getPrepareStepDetails() {
    if (stepDetailsCase_ == 2) {
      return (com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails) stepDetails_;
    }
    return com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Details for the `PREPARE` step.
   * </pre>
   *
   * <code>
   * .google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails prepare_step_details = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetailsOrBuilder
      getPrepareStepDetailsOrBuilder() {
    if (stepDetailsCase_ == 2) {
      return (com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails) stepDetails_;
    }
    return com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
        .getDefaultInstance();
  }

  public static final int REDIRECT_WRITES_STEP_DETAILS_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Details for the `REDIRECT_WRITES` step.
   * </pre>
   *
   * <code>
   * .google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails redirect_writes_step_details = 3;
   * </code>
   *
   * @return Whether the redirectWritesStepDetails field is set.
   */
  @java.lang.Override
  public boolean hasRedirectWritesStepDetails() {
    return stepDetailsCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Details for the `REDIRECT_WRITES` step.
   * </pre>
   *
   * <code>
   * .google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails redirect_writes_step_details = 3;
   * </code>
   *
   * @return The redirectWritesStepDetails.
   */
  @java.lang.Override
  public com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
      getRedirectWritesStepDetails() {
    if (stepDetailsCase_ == 3) {
      return (com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails)
          stepDetails_;
    }
    return com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Details for the `REDIRECT_WRITES` step.
   * </pre>
   *
   * <code>
   * .google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails redirect_writes_step_details = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetailsOrBuilder
      getRedirectWritesStepDetailsOrBuilder() {
    if (stepDetailsCase_ == 3) {
      return (com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails)
          stepDetails_;
    }
    return com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (step_
        != com.google.datastore.admin.v1.MigrationStep.MIGRATION_STEP_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, step_);
    }
    if (stepDetailsCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails) stepDetails_);
    }
    if (stepDetailsCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails)
              stepDetails_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (step_
        != com.google.datastore.admin.v1.MigrationStep.MIGRATION_STEP_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, step_);
    }
    if (stepDetailsCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails)
                  stepDetails_);
    }
    if (stepDetailsCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails)
                  stepDetails_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.admin.v1.MigrationProgressEvent)) {
      return super.equals(obj);
    }
    com.google.datastore.admin.v1.MigrationProgressEvent other =
        (com.google.datastore.admin.v1.MigrationProgressEvent) obj;

    if (step_ != other.step_) return false;
    if (!getStepDetailsCase().equals(other.getStepDetailsCase())) return false;
    switch (stepDetailsCase_) {
      case 2:
        if (!getPrepareStepDetails().equals(other.getPrepareStepDetails())) return false;
        break;
      case 3:
        if (!getRedirectWritesStepDetails().equals(other.getRedirectWritesStepDetails()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STEP_FIELD_NUMBER;
    hash = (53 * hash) + step_;
    switch (stepDetailsCase_) {
      case 2:
        hash = (37 * hash) + PREPARE_STEP_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getPrepareStepDetails().hashCode();
        break;
      case 3:
        hash = (37 * hash) + REDIRECT_WRITES_STEP_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getRedirectWritesStepDetails().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.admin.v1.MigrationProgressEvent parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.admin.v1.MigrationProgressEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.MigrationProgressEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.admin.v1.MigrationProgressEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.MigrationProgressEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.admin.v1.MigrationProgressEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.MigrationProgressEvent parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.admin.v1.MigrationProgressEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.MigrationProgressEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.admin.v1.MigrationProgressEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.MigrationProgressEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.admin.v1.MigrationProgressEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.admin.v1.MigrationProgressEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An event signifying the start of a new step in a [migration from Cloud
   * Datastore to Cloud Firestore in Datastore
   * mode](https://cloud.google.com/datastore/docs/upgrade-to-firestore).
   * </pre>
   *
   * Protobuf type {@code google.datastore.admin.v1.MigrationProgressEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.admin.v1.MigrationProgressEvent)
      com.google.datastore.admin.v1.MigrationProgressEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.admin.v1.MigrationProto
          .internal_static_google_datastore_admin_v1_MigrationProgressEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.admin.v1.MigrationProto
          .internal_static_google_datastore_admin_v1_MigrationProgressEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.admin.v1.MigrationProgressEvent.class,
              com.google.datastore.admin.v1.MigrationProgressEvent.Builder.class);
    }

    // Construct using com.google.datastore.admin.v1.MigrationProgressEvent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      step_ = 0;
      if (prepareStepDetailsBuilder_ != null) {
        prepareStepDetailsBuilder_.clear();
      }
      if (redirectWritesStepDetailsBuilder_ != null) {
        redirectWritesStepDetailsBuilder_.clear();
      }
      stepDetailsCase_ = 0;
      stepDetails_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.admin.v1.MigrationProto
          .internal_static_google_datastore_admin_v1_MigrationProgressEvent_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.admin.v1.MigrationProgressEvent getDefaultInstanceForType() {
      return com.google.datastore.admin.v1.MigrationProgressEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.admin.v1.MigrationProgressEvent build() {
      com.google.datastore.admin.v1.MigrationProgressEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.admin.v1.MigrationProgressEvent buildPartial() {
      com.google.datastore.admin.v1.MigrationProgressEvent result =
          new com.google.datastore.admin.v1.MigrationProgressEvent(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.datastore.admin.v1.MigrationProgressEvent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.step_ = step_;
      }
    }

    private void buildPartialOneofs(com.google.datastore.admin.v1.MigrationProgressEvent result) {
      result.stepDetailsCase_ = stepDetailsCase_;
      result.stepDetails_ = this.stepDetails_;
      if (stepDetailsCase_ == 2 && prepareStepDetailsBuilder_ != null) {
        result.stepDetails_ = prepareStepDetailsBuilder_.build();
      }
      if (stepDetailsCase_ == 3 && redirectWritesStepDetailsBuilder_ != null) {
        result.stepDetails_ = redirectWritesStepDetailsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.admin.v1.MigrationProgressEvent) {
        return mergeFrom((com.google.datastore.admin.v1.MigrationProgressEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.admin.v1.MigrationProgressEvent other) {
      if (other == com.google.datastore.admin.v1.MigrationProgressEvent.getDefaultInstance())
        return this;
      if (other.step_ != 0) {
        setStepValue(other.getStepValue());
      }
      switch (other.getStepDetailsCase()) {
        case PREPARE_STEP_DETAILS:
          {
            mergePrepareStepDetails(other.getPrepareStepDetails());
            break;
          }
        case REDIRECT_WRITES_STEP_DETAILS:
          {
            mergeRedirectWritesStepDetails(other.getRedirectWritesStepDetails());
            break;
          }
        case STEPDETAILS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                step_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(
                    getPrepareStepDetailsFieldBuilder().getBuilder(), extensionRegistry);
                stepDetailsCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getRedirectWritesStepDetailsFieldBuilder().getBuilder(), extensionRegistry);
                stepDetailsCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int stepDetailsCase_ = 0;
    private java.lang.Object stepDetails_;

    public StepDetailsCase getStepDetailsCase() {
      return StepDetailsCase.forNumber(stepDetailsCase_);
    }

    public Builder clearStepDetails() {
      stepDetailsCase_ = 0;
      stepDetails_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private int step_ = 0;

    /**
     *
     *
     * <pre>
     * The step that is starting.
     *
     * An event with step set to `START` indicates that the migration
     * has been reverted back to the initial pre-migration state.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.MigrationStep step = 1;</code>
     *
     * @return The enum numeric value on the wire for step.
     */
    @java.lang.Override
    public int getStepValue() {
      return step_;
    }

    /**
     *
     *
     * <pre>
     * The step that is starting.
     *
     * An event with step set to `START` indicates that the migration
     * has been reverted back to the initial pre-migration state.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.MigrationStep step = 1;</code>
     *
     * @param value The enum numeric value on the wire for step to set.
     * @return This builder for chaining.
     */
    public Builder setStepValue(int value) {
      step_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The step that is starting.
     *
     * An event with step set to `START` indicates that the migration
     * has been reverted back to the initial pre-migration state.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.MigrationStep step = 1;</code>
     *
     * @return The step.
     */
    @java.lang.Override
    public com.google.datastore.admin.v1.MigrationStep getStep() {
      com.google.datastore.admin.v1.MigrationStep result =
          com.google.datastore.admin.v1.MigrationStep.forNumber(step_);
      return result == null ? com.google.datastore.admin.v1.MigrationStep.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * The step that is starting.
     *
     * An event with step set to `START` indicates that the migration
     * has been reverted back to the initial pre-migration state.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.MigrationStep step = 1;</code>
     *
     * @param value The step to set.
     * @return This builder for chaining.
     */
    public Builder setStep(com.google.datastore.admin.v1.MigrationStep value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      step_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The step that is starting.
     *
     * An event with step set to `START` indicates that the migration
     * has been reverted back to the initial pre-migration state.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.MigrationStep step = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStep() {
      bitField0_ = (bitField0_ & ~0x00000001);
      step_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails,
            com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails.Builder,
            com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetailsOrBuilder>
        prepareStepDetailsBuilder_;

    /**
     *
     *
     * <pre>
     * Details for the `PREPARE` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails prepare_step_details = 2;
     * </code>
     *
     * @return Whether the prepareStepDetails field is set.
     */
    @java.lang.Override
    public boolean hasPrepareStepDetails() {
      return stepDetailsCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Details for the `PREPARE` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails prepare_step_details = 2;
     * </code>
     *
     * @return The prepareStepDetails.
     */
    @java.lang.Override
    public com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
        getPrepareStepDetails() {
      if (prepareStepDetailsBuilder_ == null) {
        if (stepDetailsCase_ == 2) {
          return (com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails)
              stepDetails_;
        }
        return com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
            .getDefaultInstance();
      } else {
        if (stepDetailsCase_ == 2) {
          return prepareStepDetailsBuilder_.getMessage();
        }
        return com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Details for the `PREPARE` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails prepare_step_details = 2;
     * </code>
     */
    public Builder setPrepareStepDetails(
        com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails value) {
      if (prepareStepDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepDetails_ = value;
        onChanged();
      } else {
        prepareStepDetailsBuilder_.setMessage(value);
      }
      stepDetailsCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details for the `PREPARE` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails prepare_step_details = 2;
     * </code>
     */
    public Builder setPrepareStepDetails(
        com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails.Builder
            builderForValue) {
      if (prepareStepDetailsBuilder_ == null) {
        stepDetails_ = builderForValue.build();
        onChanged();
      } else {
        prepareStepDetailsBuilder_.setMessage(builderForValue.build());
      }
      stepDetailsCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details for the `PREPARE` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails prepare_step_details = 2;
     * </code>
     */
    public Builder mergePrepareStepDetails(
        com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails value) {
      if (prepareStepDetailsBuilder_ == null) {
        if (stepDetailsCase_ == 2
            && stepDetails_
                != com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
                    .getDefaultInstance()) {
          stepDetails_ =
              com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails.newBuilder(
                      (com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails)
                          stepDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepDetails_ = value;
        }
        onChanged();
      } else {
        if (stepDetailsCase_ == 2) {
          prepareStepDetailsBuilder_.mergeFrom(value);
        } else {
          prepareStepDetailsBuilder_.setMessage(value);
        }
      }
      stepDetailsCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details for the `PREPARE` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails prepare_step_details = 2;
     * </code>
     */
    public Builder clearPrepareStepDetails() {
      if (prepareStepDetailsBuilder_ == null) {
        if (stepDetailsCase_ == 2) {
          stepDetailsCase_ = 0;
          stepDetails_ = null;
          onChanged();
        }
      } else {
        if (stepDetailsCase_ == 2) {
          stepDetailsCase_ = 0;
          stepDetails_ = null;
        }
        prepareStepDetailsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details for the `PREPARE` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails prepare_step_details = 2;
     * </code>
     */
    public com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails.Builder
        getPrepareStepDetailsBuilder() {
      return getPrepareStepDetailsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Details for the `PREPARE` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails prepare_step_details = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetailsOrBuilder
        getPrepareStepDetailsOrBuilder() {
      if ((stepDetailsCase_ == 2) && (prepareStepDetailsBuilder_ != null)) {
        return prepareStepDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (stepDetailsCase_ == 2) {
          return (com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails)
              stepDetails_;
        }
        return com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Details for the `PREPARE` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails prepare_step_details = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails,
            com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails.Builder,
            com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetailsOrBuilder>
        getPrepareStepDetailsFieldBuilder() {
      if (prepareStepDetailsBuilder_ == null) {
        if (!(stepDetailsCase_ == 2)) {
          stepDetails_ =
              com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails
                  .getDefaultInstance();
        }
        prepareStepDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails,
                com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails.Builder,
                com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetailsOrBuilder>(
                (com.google.datastore.admin.v1.MigrationProgressEvent.PrepareStepDetails)
                    stepDetails_,
                getParentForChildren(),
                isClean());
        stepDetails_ = null;
      }
      stepDetailsCase_ = 2;
      onChanged();
      return prepareStepDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails,
            com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails.Builder,
            com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetailsOrBuilder>
        redirectWritesStepDetailsBuilder_;

    /**
     *
     *
     * <pre>
     * Details for the `REDIRECT_WRITES` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails redirect_writes_step_details = 3;
     * </code>
     *
     * @return Whether the redirectWritesStepDetails field is set.
     */
    @java.lang.Override
    public boolean hasRedirectWritesStepDetails() {
      return stepDetailsCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Details for the `REDIRECT_WRITES` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails redirect_writes_step_details = 3;
     * </code>
     *
     * @return The redirectWritesStepDetails.
     */
    @java.lang.Override
    public com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
        getRedirectWritesStepDetails() {
      if (redirectWritesStepDetailsBuilder_ == null) {
        if (stepDetailsCase_ == 3) {
          return (com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails)
              stepDetails_;
        }
        return com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
            .getDefaultInstance();
      } else {
        if (stepDetailsCase_ == 3) {
          return redirectWritesStepDetailsBuilder_.getMessage();
        }
        return com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Details for the `REDIRECT_WRITES` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails redirect_writes_step_details = 3;
     * </code>
     */
    public Builder setRedirectWritesStepDetails(
        com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails value) {
      if (redirectWritesStepDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stepDetails_ = value;
        onChanged();
      } else {
        redirectWritesStepDetailsBuilder_.setMessage(value);
      }
      stepDetailsCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details for the `REDIRECT_WRITES` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails redirect_writes_step_details = 3;
     * </code>
     */
    public Builder setRedirectWritesStepDetails(
        com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails.Builder
            builderForValue) {
      if (redirectWritesStepDetailsBuilder_ == null) {
        stepDetails_ = builderForValue.build();
        onChanged();
      } else {
        redirectWritesStepDetailsBuilder_.setMessage(builderForValue.build());
      }
      stepDetailsCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details for the `REDIRECT_WRITES` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails redirect_writes_step_details = 3;
     * </code>
     */
    public Builder mergeRedirectWritesStepDetails(
        com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails value) {
      if (redirectWritesStepDetailsBuilder_ == null) {
        if (stepDetailsCase_ == 3
            && stepDetails_
                != com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
                    .getDefaultInstance()) {
          stepDetails_ =
              com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
                  .newBuilder(
                      (com.google.datastore.admin.v1.MigrationProgressEvent
                              .RedirectWritesStepDetails)
                          stepDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stepDetails_ = value;
        }
        onChanged();
      } else {
        if (stepDetailsCase_ == 3) {
          redirectWritesStepDetailsBuilder_.mergeFrom(value);
        } else {
          redirectWritesStepDetailsBuilder_.setMessage(value);
        }
      }
      stepDetailsCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details for the `REDIRECT_WRITES` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails redirect_writes_step_details = 3;
     * </code>
     */
    public Builder clearRedirectWritesStepDetails() {
      if (redirectWritesStepDetailsBuilder_ == null) {
        if (stepDetailsCase_ == 3) {
          stepDetailsCase_ = 0;
          stepDetails_ = null;
          onChanged();
        }
      } else {
        if (stepDetailsCase_ == 3) {
          stepDetailsCase_ = 0;
          stepDetails_ = null;
        }
        redirectWritesStepDetailsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details for the `REDIRECT_WRITES` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails redirect_writes_step_details = 3;
     * </code>
     */
    public com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails.Builder
        getRedirectWritesStepDetailsBuilder() {
      return getRedirectWritesStepDetailsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Details for the `REDIRECT_WRITES` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails redirect_writes_step_details = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetailsOrBuilder
        getRedirectWritesStepDetailsOrBuilder() {
      if ((stepDetailsCase_ == 3) && (redirectWritesStepDetailsBuilder_ != null)) {
        return redirectWritesStepDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (stepDetailsCase_ == 3) {
          return (com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails)
              stepDetails_;
        }
        return com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Details for the `REDIRECT_WRITES` step.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails redirect_writes_step_details = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails,
            com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails.Builder,
            com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetailsOrBuilder>
        getRedirectWritesStepDetailsFieldBuilder() {
      if (redirectWritesStepDetailsBuilder_ == null) {
        if (!(stepDetailsCase_ == 3)) {
          stepDetails_ =
              com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
                  .getDefaultInstance();
        }
        redirectWritesStepDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails,
                com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails
                    .Builder,
                com.google.datastore.admin.v1.MigrationProgressEvent
                    .RedirectWritesStepDetailsOrBuilder>(
                (com.google.datastore.admin.v1.MigrationProgressEvent.RedirectWritesStepDetails)
                    stepDetails_,
                getParentForChildren(),
                isClean());
        stepDetails_ = null;
      }
      stepDetailsCase_ = 3;
      onChanged();
      return redirectWritesStepDetailsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.admin.v1.MigrationProgressEvent)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.admin.v1.MigrationProgressEvent)
  private static final com.google.datastore.admin.v1.MigrationProgressEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.admin.v1.MigrationProgressEvent();
  }

  public static com.google.datastore.admin.v1.MigrationProgressEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MigrationProgressEvent> PARSER =
      new com.google.protobuf.AbstractParser<MigrationProgressEvent>() {
        @java.lang.Override
        public MigrationProgressEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MigrationProgressEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MigrationProgressEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.admin.v1.MigrationProgressEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
