# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import synthtool as s
from synthtool.languages import java
protobuf_header = "// Generated by the protocol buffer compiler.  DO NOT EDIT!"
# License header
license_header = """/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
"""
service = 'datastore'
version = 'v1'

for library in s.get_staging_dirs():
    # put any special-case replacements here
    s.replace(
        f'owl-bot-staging/v1/proto-google-cloud-{service}-{version}-java/src/**/*.java',
        protobuf_header,
        f'{license_header}{protobuf_header}'
    )
    s.move(library)

s.remove_staging_dirs()
java.common_templates(excludes=[
    '.kokoro/build.sh',
    '.kokoro/presubmit/integration.cfg',
    '.kokoro/presubmit/graalvm-native.cfg',
    '.kokoro/presubmit/graalvm-native-17.cfg',
    '.kokoro/nightly/integration.cfg',
    '.kokoro/nightly/java11-integration.cfg',
    '.kokoro/requirements.in',
    '.kokoro/requirements.txt',
    '.github/dependabot.yml',
    '.github/workflows/ci.yaml'
])
