# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Grafeas
  module V1
    # A security vulnerability that can be found in resources.
    # @!attribute [rw] cvss_score
    #   @return [::Float]
    #     The CVSS score of this vulnerability. CVSS score is on a scale of 0 - 10
    #     where 0 indicates low severity and 10 indicates high severity.
    # @!attribute [rw] severity
    #   @return [::Grafeas::V1::Severity]
    #     The note provider assigned severity of this vulnerability.
    # @!attribute [rw] details
    #   @return [::Array<::Grafeas::V1::VulnerabilityNote::Detail>]
    #     Details of all known distros and packages affected by this vulnerability.
    # @!attribute [rw] cvss_v3
    #   @return [::Grafeas::V1::CVSSv3]
    #     The full description of the CVSSv3 for this vulnerability.
    # @!attribute [rw] windows_details
    #   @return [::Array<::Grafeas::V1::VulnerabilityNote::WindowsDetail>]
    #     Windows details get their own format because the information format and
    #     model don't match a normal detail. Specifically Windows updates are done as
    #     patches, thus Windows vulnerabilities really are a missing package, rather
    #     than a package being at an incorrect version.
    # @!attribute [rw] source_update_time
    #   @return [::Google::Protobuf::Timestamp]
    #     The time this information was last changed at the source. This is an
    #     upstream timestamp from the underlying information source - e.g. Ubuntu
    #     security tracker.
    # @!attribute [rw] cvss_version
    #   @return [::Grafeas::V1::CVSSVersion]
    #     CVSS version used to populate cvss_score and severity.
    # @!attribute [rw] cvss_v2
    #   @return [::Grafeas::V1::CVSS]
    #     The full description of the v2 CVSS for this vulnerability.
    class VulnerabilityNote
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods

      # A detail for a distro and package affected by this vulnerability and its
      # associated fix (if one is available).
      # @!attribute [rw] severity_name
      #   @return [::String]
      #     The distro assigned severity of this vulnerability.
      # @!attribute [rw] description
      #   @return [::String]
      #     A vendor-specific description of this vulnerability.
      # @!attribute [rw] package_type
      #   @return [::String]
      #     The type of package; whether native or non native (e.g., ruby gems,
      #     node.js packages, etc.).
      # @!attribute [rw] affected_cpe_uri
      #   @return [::String]
      #     Required. The [CPE URI](https://cpe.mitre.org/specification/) this
      #     vulnerability affects.
      # @!attribute [rw] affected_package
      #   @return [::String]
      #     Required. The package this vulnerability affects.
      # @!attribute [rw] affected_version_start
      #   @return [::Grafeas::V1::Version]
      #     The version number at the start of an interval in which this
      #     vulnerability exists. A vulnerability can affect a package between
      #     version numbers that are disjoint sets of intervals (example:
      #     [1.0.0-1.1.0], [2.4.6-2.4.8] and [4.5.6-4.6.8]) each of which will be
      #     represented in its own Detail. If a specific affected version is provided
      #     by a vulnerability database, affected_version_start and
      #     affected_version_end will be the same in that Detail.
      # @!attribute [rw] affected_version_end
      #   @return [::Grafeas::V1::Version]
      #     The version number at the end of an interval in which this vulnerability
      #     exists. A vulnerability can affect a package between version numbers
      #     that are disjoint sets of intervals (example: [1.0.0-1.1.0],
      #     [2.4.6-2.4.8] and [4.5.6-4.6.8]) each of which will be represented in its
      #     own Detail. If a specific affected version is provided by a vulnerability
      #     database, affected_version_start and affected_version_end will be the
      #     same in that Detail.
      # @!attribute [rw] fixed_cpe_uri
      #   @return [::String]
      #     The distro recommended [CPE URI](https://cpe.mitre.org/specification/)
      #     to update to that contains a fix for this vulnerability. It is possible
      #     for this to be different from the affected_cpe_uri.
      # @!attribute [rw] fixed_package
      #   @return [::String]
      #     The distro recommended package to update to that contains a fix for this
      #     vulnerability. It is possible for this to be different from the
      #     affected_package.
      # @!attribute [rw] fixed_version
      #   @return [::Grafeas::V1::Version]
      #     The distro recommended version to update to that contains a
      #     fix for this vulnerability. Setting this to VersionKind.MAXIMUM means no
      #     such version is yet available.
      # @!attribute [rw] is_obsolete
      #   @return [::Boolean]
      #     Whether this detail is obsolete. Occurrences are expected not to point to
      #     obsolete details.
      # @!attribute [rw] source_update_time
      #   @return [::Google::Protobuf::Timestamp]
      #     The time this information was last changed at the source. This is an
      #     upstream timestamp from the underlying information source - e.g. Ubuntu
      #     security tracker.
      # @!attribute [rw] source
      #   @return [::String]
      #     The source from which the information in this Detail was obtained.
      # @!attribute [rw] vendor
      #   @return [::String]
      #     The name of the vendor of the product.
      class Detail
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # @!attribute [rw] cpe_uri
      #   @return [::String]
      #     Required. The [CPE URI](https://cpe.mitre.org/specification/) this
      #     vulnerability affects.
      # @!attribute [rw] name
      #   @return [::String]
      #     Required. The name of this vulnerability.
      # @!attribute [rw] description
      #   @return [::String]
      #     The description of this vulnerability.
      # @!attribute [rw] fixing_kbs
      #   @return [::Array<::Grafeas::V1::VulnerabilityNote::WindowsDetail::KnowledgeBase>]
      #     Required. The names of the KBs which have hotfixes to mitigate this
      #     vulnerability. Note that there may be multiple hotfixes (and thus
      #     multiple KBs) that mitigate a given vulnerability. Currently any listed
      #     KBs presence is considered a fix.
      class WindowsDetail
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods

        # @!attribute [rw] name
        #   @return [::String]
        #     The KB name (generally of the form KB[0-9]+ (e.g., KB123456)).
        # @!attribute [rw] url
        #   @return [::String]
        #     A link to the KB in the [Windows update catalog]
        #     (https://www.catalog.update.microsoft.com/).
        class KnowledgeBase
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end

    # An occurrence of a severity vulnerability on a resource.
    # @!attribute [rw] type
    #   @return [::String]
    #     The type of package; whether native or non native (e.g., ruby gems, node.js
    #     packages, etc.).
    # @!attribute [rw] severity
    #   @return [::Grafeas::V1::Severity]
    #     Output only. The note provider assigned severity of this vulnerability.
    # @!attribute [rw] cvss_score
    #   @return [::Float]
    #     Output only. The CVSS score of this vulnerability. CVSS score is on a
    #     scale of 0 - 10 where 0 indicates low severity and 10 indicates high
    #     severity.
    # @!attribute [rw] cvssv3
    #   @return [::Grafeas::V1::CVSS]
    #     The cvss v3 score for the vulnerability.
    # @!attribute [rw] package_issue
    #   @return [::Array<::Grafeas::V1::VulnerabilityOccurrence::PackageIssue>]
    #     Required. The set of affected locations and their fixes (if available)
    #     within the associated resource.
    # @!attribute [rw] short_description
    #   @return [::String]
    #     Output only. A one sentence description of this vulnerability.
    # @!attribute [rw] long_description
    #   @return [::String]
    #     Output only. A detailed description of this vulnerability.
    # @!attribute [rw] related_urls
    #   @return [::Array<::Grafeas::V1::RelatedUrl>]
    #     Output only. URLs related to this vulnerability.
    # @!attribute [rw] effective_severity
    #   @return [::Grafeas::V1::Severity]
    #     The distro assigned severity for this vulnerability when it is available,
    #     otherwise this is the note provider assigned severity.
    #
    #     When there are multiple PackageIssues for this vulnerability, they can have
    #     different effective severities because some might be provided by the distro
    #     while others are provided by the language ecosystem for a language pack.
    #     For this reason, it is advised to use the effective severity on the
    #     PackageIssue level. In the case where multiple PackageIssues have differing
    #     effective severities, this field should be the highest severity for any of
    #     the PackageIssues.
    # @!attribute [rw] fix_available
    #   @return [::Boolean]
    #     Output only. Whether at least one of the affected packages has a fix
    #     available.
    # @!attribute [rw] cvss_version
    #   @return [::Grafeas::V1::CVSSVersion]
    #     Output only. CVSS version used to populate cvss_score and severity.
    # @!attribute [rw] cvss_v2
    #   @return [::Grafeas::V1::CVSS]
    #     The cvss v2 score for the vulnerability.
    # @!attribute [rw] vex_assessment
    #   @return [::Grafeas::V1::VulnerabilityOccurrence::VexAssessment]
    # @!attribute [rw] extra_details
    #   @return [::String]
    #     Occurrence-specific extra details about the vulnerability.
    # @!attribute [rw] risk
    #   @return [::Grafeas::V1::Risk]
    #     Risk information about the vulnerability, such as CISA, EPSS, etc.
    class VulnerabilityOccurrence
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods

      # A detail for a distro and package this vulnerability occurrence was found
      # in and its associated fix (if one is available).
      # @!attribute [rw] affected_cpe_uri
      #   @return [::String]
      #     Required. The [CPE URI](https://cpe.mitre.org/specification/) this
      #     vulnerability was found in.
      # @!attribute [rw] affected_package
      #   @return [::String]
      #     Required. The package this vulnerability was found in.
      # @!attribute [rw] affected_version
      #   @return [::Grafeas::V1::Version]
      #     Required. The version of the package that is installed on the resource
      #     affected by this vulnerability.
      # @!attribute [rw] fixed_cpe_uri
      #   @return [::String]
      #     The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability
      #     was fixed in. It is possible for this to be different from the
      #     affected_cpe_uri.
      # @!attribute [rw] fixed_package
      #   @return [::String]
      #     The package this vulnerability was fixed in. It is possible for this to
      #     be different from the affected_package.
      # @!attribute [rw] fixed_version
      #   @return [::Grafeas::V1::Version]
      #     Required. The version of the package this vulnerability was fixed in.
      #     Setting this to VersionKind.MAXIMUM means no fix is yet available.
      # @!attribute [rw] fix_available
      #   @return [::Boolean]
      #     Output only. Whether a fix is available for this package.
      # @!attribute [rw] package_type
      #   @return [::String]
      #     The type of package (e.g. OS, MAVEN, GO).
      # @!attribute [r] effective_severity
      #   @return [::Grafeas::V1::Severity]
      #     The distro or language system assigned severity for this vulnerability
      #     when that is available and note provider assigned severity when it is not
      #     available.
      # @!attribute [rw] file_location
      #   @return [::Array<::Grafeas::V1::FileLocation>]
      #     The location at which this package was found.
      class PackageIssue
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # VexAssessment provides all publisher provided Vex information that is
      # related to this vulnerability.
      # @!attribute [rw] cve
      #   @deprecated This field is deprecated and may be removed in the next major version update.
      #   @return [::String]
      #     Holds the MITRE standard Common Vulnerabilities and Exposures (CVE)
      #     tracking number for the vulnerability.
      #     Deprecated: Use vulnerability_id instead to denote CVEs.
      # @!attribute [rw] vulnerability_id
      #   @return [::String]
      #     The vulnerability identifier for this Assessment. Will hold one of
      #     common identifiers e.g. CVE, GHSA etc.
      # @!attribute [rw] related_uris
      #   @return [::Array<::Grafeas::V1::RelatedUrl>]
      #     Holds a list of references associated with this vulnerability item and
      #     assessment.
      # @!attribute [rw] note_name
      #   @return [::String]
      #     The VulnerabilityAssessment note from which this VexAssessment was
      #     generated.
      #     This will be of the form: `projects/[PROJECT_ID]/notes/[NOTE_ID]`.
      #     (-- api-linter: core::0122::name-suffix=disabled
      #         aip.dev/not-precedent: The suffix is kept for consistency. --)
      # @!attribute [rw] state
      #   @return [::Grafeas::V1::VulnerabilityAssessmentNote::Assessment::State]
      #     Provides the state of this Vulnerability assessment.
      # @!attribute [rw] impacts
      #   @return [::Array<::String>]
      #     Contains information about the impact of this vulnerability,
      #     this will change with time.
      # @!attribute [rw] remediations
      #   @return [::Array<::Grafeas::V1::VulnerabilityAssessmentNote::Assessment::Remediation>]
      #     Specifies details on how to handle (and presumably, fix) a vulnerability.
      # @!attribute [rw] justification
      #   @return [::Grafeas::V1::VulnerabilityAssessmentNote::Assessment::Justification]
      #     Justification provides the justification when the state of the
      #     assessment if NOT_AFFECTED.
      class VexAssessment
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end
    end
  end
end
