# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Grafeas
  module V1
    # The note representing a secret.
    class SecretNote
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # The occurrence provides details of a secret.
    # @!attribute [rw] kind
    #   @return [::Grafeas::V1::SecretKind]
    #     Type of secret.
    # @!attribute [rw] locations
    #   @return [::Array<::Grafeas::V1::SecretLocation>]
    #     Locations where the secret is detected.
    # @!attribute [rw] statuses
    #   @return [::Array<::Grafeas::V1::SecretStatus>]
    #     Status of the secret.
    # @!attribute [rw] data
    #   @return [::Google::Protobuf::Any]
    #     Scan result of the secret.
    # @!attribute [rw] digest
    #   @return [::Grafeas::V1::Digest]
    #     Hash value, typically a digest for the secret data, that allows unique
    #     identification of a specific secret.
    class SecretOccurrence
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # The location of the secret.
    # @!attribute [rw] file_location
    #   @return [::Grafeas::V1::FileLocation]
    #     The secret is found from a file.
    class SecretLocation
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # The status of the secret with a timestamp.
    # @!attribute [rw] status
    #   @return [::Grafeas::V1::SecretStatus::Status]
    #     The status of the secret.
    # @!attribute [rw] update_time
    #   @return [::Google::Protobuf::Timestamp]
    #     The time the secret status was last updated.
    # @!attribute [rw] message
    #   @return [::String]
    #     Optional message about the status code.
    class SecretStatus
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods

      # The status of the secret.
      module Status
        # Unspecified
        STATUS_UNSPECIFIED = 0

        # The status of the secret is unknown.
        UNKNOWN = 1

        # The secret is valid.
        VALID = 2

        # The secret is invalid.
        INVALID = 3
      end
    end

    # Kind of secret.
    module SecretKind
      # Unspecified
      SECRET_KIND_UNSPECIFIED = 0

      # The secret kind is unknown.
      SECRET_KIND_UNKNOWN = 1

      # A Google Cloud service account key per:
      # https://cloud.google.com/iam/docs/creating-managing-service-account-keys
      SECRET_KIND_GCP_SERVICE_ACCOUNT_KEY = 2

      # A Google Cloud API key per:
      # https://cloud.google.com/docs/authentication/api-keys
      SECRET_KIND_GCP_API_KEY = 3

      # A Google Cloud OAuth2 client credentials per:
      # https://developers.google.com/identity/protocols/oauth2
      SECRET_KIND_GCP_OAUTH2_CLIENT_CREDENTIALS = 4

      # A Google Cloud OAuth2 access token per:
      # https://cloud.google.com/docs/authentication/token-types#access
      SECRET_KIND_GCP_OAUTH2_ACCESS_TOKEN = 5

      # An Anthropic Admin API key.
      SECRET_KIND_ANTHROPIC_ADMIN_API_KEY = 6

      # An Anthropic API key.
      SECRET_KIND_ANTHROPIC_API_KEY = 7

      # An Azure access token.
      SECRET_KIND_AZURE_ACCESS_TOKEN = 8

      # An Azure Identity Platform ID token.
      SECRET_KIND_AZURE_IDENTITY_TOKEN = 9

      # A Docker Hub personal access token.
      SECRET_KIND_DOCKER_HUB_PERSONAL_ACCESS_TOKEN = 10

      # A GitHub App refresh token.
      SECRET_KIND_GITHUB_APP_REFRESH_TOKEN = 11

      # A GitHub App server-to-server token.
      SECRET_KIND_GITHUB_APP_SERVER_TO_SERVER_TOKEN = 12

      # A GitHub App user-to-server token.
      SECRET_KIND_GITHUB_APP_USER_TO_SERVER_TOKEN = 13

      # A GitHub personal access token (classic).
      SECRET_KIND_GITHUB_CLASSIC_PERSONAL_ACCESS_TOKEN = 14

      # A GitHub fine-grained personal access token.
      SECRET_KIND_GITHUB_FINE_GRAINED_PERSONAL_ACCESS_TOKEN = 15

      # A GitHub OAuth token.
      SECRET_KIND_GITHUB_OAUTH_TOKEN = 16

      # A Hugging Face API key.
      SECRET_KIND_HUGGINGFACE_API_KEY = 17

      # An OpenAI API key.
      SECRET_KIND_OPENAI_API_KEY = 18

      # A Perplexity API key.
      SECRET_KIND_PERPLEXITY_API_KEY = 19

      # A Stripe secret key.
      SECRET_KIND_STRIPE_SECRET_KEY = 20

      # A Stripe restricted key.
      SECRET_KIND_STRIPE_RESTRICTED_KEY = 21

      # A Stripe webhook secret.
      SECRET_KIND_STRIPE_WEBHOOK_SECRET = 22
    end
  end
end
