# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Grafeas
  module V1
    # @!attribute [rw] cisa_kev
    #   @return [::Grafeas::V1::CISAKnownExploitedVulnerabilities]
    #     CISA maintains the authoritative source of vulnerabilities that have been
    #     exploited in the wild.
    # @!attribute [rw] epss
    #   @return [::Grafeas::V1::ExploitPredictionScoringSystem]
    #     The Exploit Prediction Scoring System (EPSS) estimates the likelihood
    #     (probability) that a software vulnerability will be exploited in the wild.
    class Risk
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # @!attribute [rw] known_ransomware_campaign_use
    #   @return [::String]
    #     Whether the vulnerability is known to have been leveraged as part of a
    #     ransomware campaign.
    class CISAKnownExploitedVulnerabilities
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # @!attribute [rw] percentile
    #   @return [::Float]
    #     The percentile of the current score, the proportion of all scored
    #     vulnerabilities with the same or a lower EPSS score
    # @!attribute [rw] score
    #   @return [::Float]
    #     The EPSS score representing the probability [0-1] of exploitation in the
    #     wild in the next 30 days
    class ExploitPredictionScoringSystem
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end
  end
end
