# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Grafeas
  module V1
    # Provenance of a build. Contains all information needed to verify the full
    # details about the build from source to completion.
    # @!attribute [rw] id
    #   @return [::String]
    #     Required. Unique identifier of the build.
    # @!attribute [rw] project_id
    #   @return [::String]
    #     ID of the project.
    # @!attribute [rw] commands
    #   @return [::Array<::Grafeas::V1::Command>]
    #     Commands requested by the build.
    # @!attribute [rw] built_artifacts
    #   @return [::Array<::Grafeas::V1::Artifact>]
    #     Output of the build.
    # @!attribute [rw] create_time
    #   @return [::Google::Protobuf::Timestamp]
    #     Time at which the build was created.
    # @!attribute [rw] start_time
    #   @return [::Google::Protobuf::Timestamp]
    #     Time at which execution of the build was started.
    # @!attribute [rw] end_time
    #   @return [::Google::Protobuf::Timestamp]
    #     Time at which execution of the build was finished.
    # @!attribute [rw] creator
    #   @return [::String]
    #     E-mail address of the user who initiated this build. Note that this was the
    #     user's e-mail address at the time the build was initiated; this address may
    #     not represent the same end-user for all time.
    # @!attribute [rw] logs_uri
    #   @return [::String]
    #     URI where any logs for this provenance were written.
    # @!attribute [rw] source_provenance
    #   @return [::Grafeas::V1::Source]
    #     Details of the Source input to the build.
    # @!attribute [rw] trigger_id
    #   @return [::String]
    #     Trigger identifier if the build was triggered automatically; empty if not.
    # @!attribute [rw] build_options
    #   @return [::Google::Protobuf::Map{::String => ::String}]
    #     Special options applied to this build. This is a catch-all field where
    #     build providers can enter any desired additional details.
    # @!attribute [rw] builder_version
    #   @return [::String]
    #     Version string of the builder at the time this build was executed.
    class BuildProvenance
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods

      # @!attribute [rw] key
      #   @return [::String]
      # @!attribute [rw] value
      #   @return [::String]
      class BuildOptionsEntry
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end
    end

    # Source describes the location of the source used for the build.
    # @!attribute [rw] artifact_storage_source_uri
    #   @return [::String]
    #     If provided, the input binary artifacts for the build came from this
    #     location.
    # @!attribute [rw] file_hashes
    #   @return [::Google::Protobuf::Map{::String => ::Grafeas::V1::FileHashes}]
    #     Hash(es) of the build source, which can be used to verify that the original
    #     source integrity was maintained in the build.
    #
    #     The keys to this map are file paths used as build source and the values
    #     contain the hash values for those files.
    #
    #     If the build source came in a single package such as a gzipped tarfile
    #     (.tar.gz), the FileHash will be for the single path to that file.
    # @!attribute [rw] context
    #   @return [::Grafeas::V1::SourceContext]
    #     If provided, the source code used for the build came from this location.
    # @!attribute [rw] additional_contexts
    #   @return [::Array<::Grafeas::V1::SourceContext>]
    #     If provided, some of the source code used for the build may be found in
    #     these locations, in the case where the source repository had multiple
    #     remotes or submodules. This list will not include the context specified in
    #     the context field.
    class Source
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods

      # @!attribute [rw] key
      #   @return [::String]
      # @!attribute [rw] value
      #   @return [::Grafeas::V1::FileHashes]
      class FileHashesEntry
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end
    end

    # Container message for hashes of byte content of files, used in source
    # messages to verify integrity of source input to the build.
    # @!attribute [rw] file_hash
    #   @return [::Array<::Grafeas::V1::Hash>]
    #     Required. Collection of file hashes.
    class FileHashes
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # Container message for hash values.
    # @!attribute [rw] type
    #   @return [::String]
    #     Required. The type of hash that was performed, e.g. "SHA-256".
    # @!attribute [rw] value
    #   @return [::String]
    #     Required. The hash value.
    class Hash
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # Command describes a step performed as part of the build pipeline.
    # @!attribute [rw] name
    #   @return [::String]
    #     Required. Name of the command, as presented on the command line, or if the
    #     command is packaged as a Docker container, as presented to `docker pull`.
    # @!attribute [rw] env
    #   @return [::Array<::String>]
    #     Environment variables set before running this command.
    # @!attribute [rw] args
    #   @return [::Array<::String>]
    #     Command-line arguments used when executing this command.
    # @!attribute [rw] dir
    #   @return [::String]
    #     Working directory (relative to project source root) used when running this
    #     command.
    # @!attribute [rw] id
    #   @return [::String]
    #     Optional unique identifier for this command, used in wait_for to reference
    #     this command as a dependency.
    # @!attribute [rw] wait_for
    #   @return [::Array<::String>]
    #     The ID(s) of the command(s) that this command depends on.
    class Command
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # Artifact describes a build product.
    # @!attribute [rw] checksum
    #   @return [::String]
    #     Hash or checksum value of a binary, or Docker Registry 2.0 digest of a
    #     container.
    # @!attribute [rw] id
    #   @return [::String]
    #     Artifact ID, if any; for container images, this will be a URL by digest
    #     like `gcr.io/projectID/imagename@sha256:123456`.
    # @!attribute [rw] names
    #   @return [::Array<::String>]
    #     Related artifact names. This may be the path to a binary or jar file, or in
    #     the case of a container build, the name used to push the container image to
    #     Google Container Registry, as presented to `docker push`. Note that a
    #     single Artifact ID can have multiple names, for example if two tags are
    #     applied to one image.
    class Artifact
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # A SourceContext is a reference to a tree of files. A SourceContext together
    # with a path point to a unique revision of a single file or directory.
    # @!attribute [rw] cloud_repo
    #   @return [::Grafeas::V1::CloudRepoSourceContext]
    #     A SourceContext referring to a revision in a Google Cloud Source Repo.
    #
    #     Note: The following fields are mutually exclusive: `cloud_repo`, `gerrit`, `git`. If a field in that set is populated, all other fields in the set will automatically be cleared.
    # @!attribute [rw] gerrit
    #   @return [::Grafeas::V1::GerritSourceContext]
    #     A SourceContext referring to a Gerrit project.
    #
    #     Note: The following fields are mutually exclusive: `gerrit`, `cloud_repo`, `git`. If a field in that set is populated, all other fields in the set will automatically be cleared.
    # @!attribute [rw] git
    #   @return [::Grafeas::V1::GitSourceContext]
    #     A SourceContext referring to any third party Git repo (e.g., GitHub).
    #
    #     Note: The following fields are mutually exclusive: `git`, `cloud_repo`, `gerrit`. If a field in that set is populated, all other fields in the set will automatically be cleared.
    # @!attribute [rw] labels
    #   @return [::Google::Protobuf::Map{::String => ::String}]
    #     Labels with user defined metadata.
    class SourceContext
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods

      # @!attribute [rw] key
      #   @return [::String]
      # @!attribute [rw] value
      #   @return [::String]
      class LabelsEntry
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end
    end

    # An alias to a repo revision.
    # @!attribute [rw] kind
    #   @return [::Grafeas::V1::AliasContext::Kind]
    #     The alias kind.
    # @!attribute [rw] name
    #   @return [::String]
    #     The alias name.
    class AliasContext
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods

      # The type of an alias.
      module Kind
        # Unknown.
        KIND_UNSPECIFIED = 0

        # Git tag.
        FIXED = 1

        # Git branch.
        MOVABLE = 2

        # Used to specify non-standard aliases. For example, if a Git repo has a
        # ref named "refs/foo/bar".
        OTHER = 4
      end
    end

    # A CloudRepoSourceContext denotes a particular revision in a Google Cloud
    # Source Repo.
    # @!attribute [rw] repo_id
    #   @return [::Grafeas::V1::RepoId]
    #     The ID of the repo.
    # @!attribute [rw] revision_id
    #   @return [::String]
    #     A revision ID.
    #
    #     Note: The following fields are mutually exclusive: `revision_id`, `alias_context`. If a field in that set is populated, all other fields in the set will automatically be cleared.
    # @!attribute [rw] alias_context
    #   @return [::Grafeas::V1::AliasContext]
    #     An alias, which may be a branch or tag.
    #
    #     Note: The following fields are mutually exclusive: `alias_context`, `revision_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
    class CloudRepoSourceContext
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # A SourceContext referring to a Gerrit project.
    # @!attribute [rw] host_uri
    #   @return [::String]
    #     The URI of a running Gerrit instance.
    # @!attribute [rw] gerrit_project
    #   @return [::String]
    #     The full project name within the host. Projects may be nested, so
    #     "project/subproject" is a valid project name. The "repo name" is the
    #     hostURI/project.
    # @!attribute [rw] revision_id
    #   @return [::String]
    #     A revision (commit) ID.
    #
    #     Note: The following fields are mutually exclusive: `revision_id`, `alias_context`. If a field in that set is populated, all other fields in the set will automatically be cleared.
    # @!attribute [rw] alias_context
    #   @return [::Grafeas::V1::AliasContext]
    #     An alias, which may be a branch or tag.
    #
    #     Note: The following fields are mutually exclusive: `alias_context`, `revision_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
    class GerritSourceContext
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # A GitSourceContext denotes a particular revision in a third party Git
    # repository (e.g., GitHub).
    # @!attribute [rw] url
    #   @return [::String]
    #     Git repository URL.
    # @!attribute [rw] revision_id
    #   @return [::String]
    #     Git commit hash.
    class GitSourceContext
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # A unique identifier for a Cloud Repo.
    # @!attribute [rw] project_repo_id
    #   @return [::Grafeas::V1::ProjectRepoId]
    #     A combination of a project ID and a repo name.
    #
    #     Note: The following fields are mutually exclusive: `project_repo_id`, `uid`. If a field in that set is populated, all other fields in the set will automatically be cleared.
    # @!attribute [rw] uid
    #   @return [::String]
    #     A server-assigned, globally unique identifier.
    #
    #     Note: The following fields are mutually exclusive: `uid`, `project_repo_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
    class RepoId
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # Selects a repo using a Google Cloud Platform project ID (e.g.,
    # winged-cargo-31) and a repo name within that project.
    # @!attribute [rw] project_id
    #   @return [::String]
    #     The ID of the project.
    # @!attribute [rw] repo_name
    #   @return [::String]
    #     The name of the repo. Leave empty for the default repo.
    class ProjectRepoId
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end
  end
end
