# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Grafeas
  module V1
    # Spec defined at
    # https://github.com/in-toto/attestation/tree/main/spec#statement The
    # serialized InTotoStatement will be stored as Envelope.payload.
    # Envelope.payloadType is always "application/vnd.in-toto+json".
    # @!attribute [rw] type
    #   @return [::String]
    #     Always `https://in-toto.io/Statement/v0.1`.
    # @!attribute [rw] subject
    #   @return [::Array<::Grafeas::V1::Subject>]
    # @!attribute [rw] predicate_type
    #   @return [::String]
    #     `https://slsa.dev/provenance/v0.1` for SlsaProvenance.
    # @!attribute [rw] provenance
    #   @return [::Grafeas::V1::InTotoProvenance]
    #     Note: The following fields are mutually exclusive: `provenance`, `slsa_provenance`, `slsa_provenance_zero_two`. If a field in that set is populated, all other fields in the set will automatically be cleared.
    # @!attribute [rw] slsa_provenance
    #   @return [::Grafeas::V1::SlsaProvenance]
    #     Note: The following fields are mutually exclusive: `slsa_provenance`, `provenance`, `slsa_provenance_zero_two`. If a field in that set is populated, all other fields in the set will automatically be cleared.
    # @!attribute [rw] slsa_provenance_zero_two
    #   @return [::Grafeas::V1::SlsaProvenanceZeroTwo]
    #     Note: The following fields are mutually exclusive: `slsa_provenance_zero_two`, `provenance`, `slsa_provenance`. If a field in that set is populated, all other fields in the set will automatically be cleared.
    class InTotoStatement
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # @!attribute [rw] name
    #   @return [::String]
    # @!attribute [rw] digest
    #   @return [::Google::Protobuf::Map{::String => ::String}]
    #     `"<ALGORITHM>": "<HEX_VALUE>"`
    #     Algorithms can be e.g. sha256, sha512
    #     See
    #     https://github.com/in-toto/attestation/blob/main/spec/field_types.md#DigestSet
    class Subject
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods

      # @!attribute [rw] key
      #   @return [::String]
      # @!attribute [rw] value
      #   @return [::String]
      class DigestEntry
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end
    end

    # @!attribute [rw] type
    #   @return [::String]
    #     InToto spec defined at
    #     https://github.com/in-toto/attestation/tree/main/spec#statement
    # @!attribute [rw] subject
    #   @return [::Array<::Grafeas::V1::Subject>]
    # @!attribute [rw] predicate_type
    #   @return [::String]
    # @!attribute [rw] predicate
    #   @return [::Grafeas::V1::InTotoSlsaProvenanceV1::SlsaProvenanceV1]
    class InTotoSlsaProvenanceV1
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods

      # Keep in sync with schema at
      # https://github.com/slsa-framework/slsa/blob/main/docs/provenance/schema/v1/provenance.proto
      # Builder renamed to ProvenanceBuilder because of Java conflicts.
      # @!attribute [rw] build_definition
      #   @return [::Grafeas::V1::InTotoSlsaProvenanceV1::BuildDefinition]
      # @!attribute [rw] run_details
      #   @return [::Grafeas::V1::InTotoSlsaProvenanceV1::RunDetails]
      class SlsaProvenanceV1
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # @!attribute [rw] build_type
      #   @return [::String]
      # @!attribute [rw] external_parameters
      #   @return [::Google::Protobuf::Struct]
      # @!attribute [rw] internal_parameters
      #   @return [::Google::Protobuf::Struct]
      # @!attribute [rw] resolved_dependencies
      #   @return [::Array<::Grafeas::V1::InTotoSlsaProvenanceV1::ResourceDescriptor>]
      class BuildDefinition
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # @!attribute [rw] name
      #   @return [::String]
      # @!attribute [rw] uri
      #   @return [::String]
      # @!attribute [rw] digest
      #   @return [::Google::Protobuf::Map{::String => ::String}]
      # @!attribute [rw] content
      #   @return [::String]
      # @!attribute [rw] download_location
      #   @return [::String]
      # @!attribute [rw] media_type
      #   @return [::String]
      # @!attribute [rw] annotations
      #   @return [::Google::Protobuf::Map{::String => ::Google::Protobuf::Value}]
      class ResourceDescriptor
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods

        # @!attribute [rw] key
        #   @return [::String]
        # @!attribute [rw] value
        #   @return [::String]
        class DigestEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] key
        #   @return [::String]
        # @!attribute [rw] value
        #   @return [::Google::Protobuf::Value]
        class AnnotationsEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end

      # @!attribute [rw] builder
      #   @return [::Grafeas::V1::InTotoSlsaProvenanceV1::ProvenanceBuilder]
      # @!attribute [rw] metadata
      #   @return [::Grafeas::V1::InTotoSlsaProvenanceV1::BuildMetadata]
      # @!attribute [rw] byproducts
      #   @return [::Array<::Grafeas::V1::InTotoSlsaProvenanceV1::ResourceDescriptor>]
      class RunDetails
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # @!attribute [rw] id
      #   @return [::String]
      # @!attribute [rw] version
      #   @return [::Google::Protobuf::Map{::String => ::String}]
      # @!attribute [rw] builder_dependencies
      #   @return [::Array<::Grafeas::V1::InTotoSlsaProvenanceV1::ResourceDescriptor>]
      class ProvenanceBuilder
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods

        # @!attribute [rw] key
        #   @return [::String]
        # @!attribute [rw] value
        #   @return [::String]
        class VersionEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end

      # @!attribute [rw] invocation_id
      #   @return [::String]
      # @!attribute [rw] started_on
      #   @return [::Google::Protobuf::Timestamp]
      # @!attribute [rw] finished_on
      #   @return [::Google::Protobuf::Timestamp]
      class BuildMetadata
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end
    end
  end
end
