# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Grafeas
  module V1
    # A note that indicates a type of analysis a provider would perform. This note
    # exists in a provider's project. A `Discovery` occurrence is created in a
    # consumer's project at the start of analysis.
    # @!attribute [rw] analysis_kind
    #   @return [::Grafeas::V1::NoteKind]
    #     Required. Immutable. The kind of analysis that is handled by this
    #     discovery.
    class DiscoveryNote
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # Provides information about the analysis status of a discovered resource.
    # @!attribute [rw] continuous_analysis
    #   @return [::Grafeas::V1::DiscoveryOccurrence::ContinuousAnalysis]
    #     Whether the resource is continuously analyzed.
    # @!attribute [rw] analysis_status
    #   @return [::Grafeas::V1::DiscoveryOccurrence::AnalysisStatus]
    #     The status of discovery for the resource.
    # @!attribute [rw] analysis_completed
    #   @return [::Grafeas::V1::DiscoveryOccurrence::AnalysisCompleted]
    # @!attribute [rw] analysis_error
    #   @return [::Array<::Google::Rpc::Status>]
    #     Indicates any errors encountered during analysis of a resource. There
    #     could be 0 or more of these errors.
    # @!attribute [rw] analysis_status_error
    #   @return [::Google::Rpc::Status]
    #     When an error is encountered this will contain a LocalizedMessage under
    #     details to show to the user. The LocalizedMessage is output only and
    #     populated by the API.
    # @!attribute [rw] cpe
    #   @return [::String]
    #     The CPE of the resource being scanned.
    # @!attribute [rw] last_scan_time
    #   @return [::Google::Protobuf::Timestamp]
    #     The last time this resource was scanned.
    # @!attribute [r] archive_time
    #   @return [::Google::Protobuf::Timestamp]
    #     The time occurrences related to this discovery occurrence were archived.
    # @!attribute [rw] sbom_status
    #   @return [::Grafeas::V1::DiscoveryOccurrence::SBOMStatus]
    #     The status of an SBOM generation.
    # @!attribute [rw] vulnerability_attestation
    #   @return [::Grafeas::V1::DiscoveryOccurrence::VulnerabilityAttestation]
    #     The status of an vulnerability attestation generation.
    # @!attribute [rw] files
    #   @return [::Array<::Grafeas::V1::DiscoveryOccurrence::File>]
    #     Files that make up the resource described by the occurrence.
    class DiscoveryOccurrence
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods

      # Indicates which analysis completed successfully. Multiple types of
      # analysis can be performed on a single resource.
      # @!attribute [rw] analysis_type
      #   @return [::Array<::String>]
      class AnalysisCompleted
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # The status of an SBOM generation.
      # @!attribute [rw] sbom_state
      #   @return [::Grafeas::V1::DiscoveryOccurrence::SBOMStatus::SBOMState]
      #     The progress of the SBOM generation.
      # @!attribute [rw] error
      #   @return [::String]
      #     If there was an error generating an SBOM, this will indicate what that
      #     error was.
      class SBOMStatus
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods

        # An enum indicating the progress of the SBOM generation.
        module SBOMState
          # Default unknown state.
          SBOM_STATE_UNSPECIFIED = 0

          # SBOM scanning is pending.
          PENDING = 1

          # SBOM scanning has completed.
          COMPLETE = 2
        end
      end

      # The status of an vulnerability attestation generation.
      # @!attribute [rw] last_attempt_time
      #   @return [::Google::Protobuf::Timestamp]
      #     The last time we attempted to generate an attestation.
      # @!attribute [rw] state
      #   @return [::Grafeas::V1::DiscoveryOccurrence::VulnerabilityAttestation::VulnerabilityAttestationState]
      #     The success/failure state of the latest attestation attempt.
      # @!attribute [rw] error
      #   @return [::String]
      #     If failure, the error reason for why the attestation generation failed.
      class VulnerabilityAttestation
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods

        # An enum indicating the state of the attestation generation.
        module VulnerabilityAttestationState
          # Default unknown state.
          VULNERABILITY_ATTESTATION_STATE_UNSPECIFIED = 0

          # Attestation was successfully generated and stored.
          SUCCESS = 1

          # Attestation was unsuccessfully generated and stored.
          FAILURE = 2
        end
      end

      # @!attribute [rw] name
      #   @return [::String]
      # @!attribute [rw] digest
      #   @return [::Google::Protobuf::Map{::String => ::String}]
      class File
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods

        # @!attribute [rw] key
        #   @return [::String]
        # @!attribute [rw] value
        #   @return [::String]
        class DigestEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end

      # Whether the resource is continuously analyzed.
      module ContinuousAnalysis
        # Unknown.
        CONTINUOUS_ANALYSIS_UNSPECIFIED = 0

        # The resource is continuously analyzed.
        ACTIVE = 1

        # The resource is ignored for continuous analysis.
        INACTIVE = 2
      end

      # Analysis status for a resource. Currently for initial analysis only (not
      # updated in continuous analysis).
      module AnalysisStatus
        # Unknown.
        ANALYSIS_STATUS_UNSPECIFIED = 0

        # Resource is known but no action has been taken yet.
        PENDING = 1

        # Resource is being analyzed.
        SCANNING = 2

        # Analysis has finished successfully.
        FINISHED_SUCCESS = 3

        # Analysis has completed.
        COMPLETE = 3

        # Analysis has finished unsuccessfully, the analysis itself is in a bad
        # state.
        FINISHED_FAILED = 4

        # The resource is known not to be supported.
        FINISHED_UNSUPPORTED = 5
      end
    end
  end
end
