# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Grafeas
  module V1
    # Note holding the version of the provider's builder and the signature of the
    # provenance message in the build details occurrence.
    # @!attribute [rw] builder_version
    #   @return [::String]
    #     Required. Immutable. Version of the builder which produced this build.
    class BuildNote
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end

    # Details of a build occurrence.
    # @!attribute [rw] provenance
    #   @return [::Grafeas::V1::BuildProvenance]
    #     The actual provenance for the build.
    # @!attribute [rw] provenance_bytes
    #   @return [::String]
    #     Serialized JSON representation of the provenance, used in generating the
    #     build signature in the corresponding build note. After verifying the
    #     signature, `provenance_bytes` can be unmarshalled and compared to the
    #     provenance to confirm that it is unchanged. A base64-encoded string
    #     representation of the provenance bytes is used for the signature in order
    #     to interoperate with openssl which expects this format for signature
    #     verification.
    #
    #     The serialized form is captured both to avoid ambiguity in how the
    #     provenance is marshalled to json as well to prevent incompatibilities with
    #     future changes.
    # @!attribute [rw] intoto_provenance
    #   @return [::Grafeas::V1::InTotoProvenance]
    #     Deprecated. See InTotoStatement for the replacement.
    #     In-toto Provenance representation as defined in spec.
    # @!attribute [rw] intoto_statement
    #   @return [::Grafeas::V1::InTotoStatement]
    #     In-toto Statement representation as defined in spec.
    #     The intoto_statement can contain any type of provenance. The serialized
    #     payload of the statement can be stored and signed in the Occurrence's
    #     envelope.
    # @!attribute [rw] in_toto_slsa_provenance_v1
    #   @return [::Grafeas::V1::InTotoSlsaProvenanceV1]
    #     In-Toto Slsa Provenance V1 represents a slsa provenance meeting the slsa
    #     spec, wrapped in an in-toto statement. This allows for direct
    #     jsonification of a to-spec in-toto slsa statement with a to-spec
    #     slsa provenance.
    class BuildOccurrence
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end
  end
end
