# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: grafeas/v1/grafeas.proto for package 'grafeas.v1'
# Original file comments:
# Copyright 2019 The Grafeas Authors. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'grafeas/v1/grafeas_pb'

module Grafeas
  module V1
    module Grafeas
      # [Grafeas](https://grafeas.io) API.
      #
      # Retrieves analysis results of Cloud components such as Docker container
      # images.
      #
      # Analysis results are stored as a series of occurrences. An `Occurrence`
      # contains information about a specific analysis instance on a resource. An
      # occurrence refers to a `Note`. A note contains details describing the
      # analysis and is generally stored in a separate project, called a `Provider`.
      # Multiple occurrences can refer to the same note.
      #
      # For example, an SSL vulnerability could affect multiple images. In this case,
      # there would be one note for the vulnerability and an occurrence for each
      # image with the vulnerability referring to that note.
      class Service

        include ::GRPC::GenericService

        self.marshal_class_method = :encode
        self.unmarshal_class_method = :decode
        self.service_name = 'grafeas.v1.Grafeas'

        # Gets the specified occurrence.
        rpc :GetOccurrence, ::Grafeas::V1::GetOccurrenceRequest, ::Grafeas::V1::Occurrence
        # Lists occurrences for the specified project.
        rpc :ListOccurrences, ::Grafeas::V1::ListOccurrencesRequest, ::Grafeas::V1::ListOccurrencesResponse
        # Deletes the specified occurrence. For example, use this method to delete an
        # occurrence when the occurrence is no longer applicable for the given
        # resource.
        rpc :DeleteOccurrence, ::Grafeas::V1::DeleteOccurrenceRequest, ::Google::Protobuf::Empty
        # Creates a new occurrence.
        rpc :CreateOccurrence, ::Grafeas::V1::CreateOccurrenceRequest, ::Grafeas::V1::Occurrence
        # Creates new occurrences in batch.
        rpc :BatchCreateOccurrences, ::Grafeas::V1::BatchCreateOccurrencesRequest, ::Grafeas::V1::BatchCreateOccurrencesResponse
        # Updates the specified occurrence.
        rpc :UpdateOccurrence, ::Grafeas::V1::UpdateOccurrenceRequest, ::Grafeas::V1::Occurrence
        # Gets the note attached to the specified occurrence. Consumer projects can
        # use this method to get a note that belongs to a provider project.
        rpc :GetOccurrenceNote, ::Grafeas::V1::GetOccurrenceNoteRequest, ::Grafeas::V1::Note
        # Gets the specified note.
        rpc :GetNote, ::Grafeas::V1::GetNoteRequest, ::Grafeas::V1::Note
        # Lists notes for the specified project.
        rpc :ListNotes, ::Grafeas::V1::ListNotesRequest, ::Grafeas::V1::ListNotesResponse
        # Deletes the specified note.
        rpc :DeleteNote, ::Grafeas::V1::DeleteNoteRequest, ::Google::Protobuf::Empty
        # Creates a new note.
        rpc :CreateNote, ::Grafeas::V1::CreateNoteRequest, ::Grafeas::V1::Note
        # Creates new notes in batch.
        rpc :BatchCreateNotes, ::Grafeas::V1::BatchCreateNotesRequest, ::Grafeas::V1::BatchCreateNotesResponse
        # Updates the specified note.
        rpc :UpdateNote, ::Grafeas::V1::UpdateNoteRequest, ::Grafeas::V1::Note
        # Lists occurrences referencing the specified note. Provider projects can use
        # this method to get all occurrences across consumer projects referencing the
        # specified note.
        rpc :ListNoteOccurrences, ::Grafeas::V1::ListNoteOccurrencesRequest, ::Grafeas::V1::ListNoteOccurrencesResponse
      end

      Stub = Service.rpc_stub_class
    end
  end
end
