# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "grafeas/v1/grafeas_pb"

module Grafeas
  module V1
    module Grafeas
      ##
      # Client for the Grafeas service.
      #
      # [Grafeas](https://grafeas.io) API.
      #
      # Retrieves analysis results of Cloud components such as Docker container
      # images.
      #
      # Analysis results are stored as a series of occurrences. An `Occurrence`
      # contains information about a specific analysis instance on a resource. An
      # occurrence refers to a `Note`. A note contains details describing the
      # analysis and is generally stored in a separate project, called a `Provider`.
      # Multiple occurrences can refer to the same note.
      #
      # For example, an SSL vulnerability could affect multiple images. In this case,
      # there would be one note for the vulnerability and an occurrence for each
      # image with the vulnerability referring to that note.
      #
      class Client
        # @private
        API_VERSION = ""

        # @private
        DEFAULT_ENDPOINT_TEMPLATE = nil

        include Paths

        # @private
        attr_reader :grafeas_stub

        ##
        # Configure the Grafeas Client class.
        #
        # See {::Grafeas::V1::Grafeas::Client::Configuration}
        # for a description of the configuration fields.
        #
        # @example
        #
        #   # Modify the configuration for all Grafeas clients
        #   ::Grafeas::V1::Grafeas::Client.configure do |config|
        #     config.timeout = 10.0
        #   end
        #
        # @yield [config] Configure the Client client.
        # @yieldparam config [Client::Configuration]
        #
        # @return [Client::Configuration]
        #
        def self.configure
          @configure ||= begin
            namespace = ["Grafeas", "V1"]
            parent_config = while namespace.any?
                              parent_name = namespace.join "::"
                              parent_const = const_get parent_name
                              break parent_const.configure if parent_const.respond_to? :configure
                              namespace.pop
                            end
            default_config = Client::Configuration.new parent_config

            default_config.rpcs.get_occurrence.timeout = 30.0
            default_config.rpcs.get_occurrence.retry_policy = {
              initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
            }

            default_config.rpcs.list_occurrences.timeout = 30.0
            default_config.rpcs.list_occurrences.retry_policy = {
              initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
            }

            default_config.rpcs.delete_occurrence.timeout = 30.0
            default_config.rpcs.delete_occurrence.retry_policy = {
              initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
            }

            default_config.rpcs.create_occurrence.timeout = 30.0

            default_config.rpcs.batch_create_occurrences.timeout = 30.0

            default_config.rpcs.update_occurrence.timeout = 30.0

            default_config.rpcs.get_occurrence_note.timeout = 30.0
            default_config.rpcs.get_occurrence_note.retry_policy = {
              initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
            }

            default_config.rpcs.get_note.timeout = 30.0
            default_config.rpcs.get_note.retry_policy = {
              initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
            }

            default_config.rpcs.list_notes.timeout = 30.0
            default_config.rpcs.list_notes.retry_policy = {
              initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
            }

            default_config.rpcs.delete_note.timeout = 30.0
            default_config.rpcs.delete_note.retry_policy = {
              initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
            }

            default_config.rpcs.create_note.timeout = 30.0

            default_config.rpcs.batch_create_notes.timeout = 30.0

            default_config.rpcs.update_note.timeout = 30.0

            default_config.rpcs.list_note_occurrences.timeout = 30.0
            default_config.rpcs.list_note_occurrences.retry_policy = {
              initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
            }

            default_config
          end
          yield @configure if block_given?
          @configure
        end

        ##
        # Configure the Grafeas Client instance.
        #
        # The configuration is set to the derived mode, meaning that values can be changed,
        # but structural changes (adding new fields, etc.) are not allowed. Structural changes
        # should be made on {Client.configure}.
        #
        # See {::Grafeas::V1::Grafeas::Client::Configuration}
        # for a description of the configuration fields.
        #
        # @yield [config] Configure the Client client.
        # @yieldparam config [Client::Configuration]
        #
        # @return [Client::Configuration]
        #
        def configure
          yield @config if block_given?
          @config
        end

        ##
        # The effective universe domain
        #
        # @return [String]
        #
        def universe_domain
          @grafeas_stub.universe_domain
        end

        ##
        # Create a new Grafeas client object.
        #
        # @example
        #
        #   # Create a client using the default configuration
        #   client = ::Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a client using a custom configuration
        #   client = ::Grafeas::V1::Grafeas::Client.new do |config|
        #     config.timeout = 10.0
        #   end
        #
        # @yield [config] Configure the Grafeas client.
        # @yieldparam config [Client::Configuration]
        #
        def initialize
          # These require statements are intentionally placed here to initialize
          # the gRPC module only when it's required.
          # See https://github.com/googleapis/toolkit/issues/446
          require "gapic/grpc"
          require "grafeas/v1/grafeas_services_pb"

          # Create the configuration object
          @config = Configuration.new Client.configure

          # Yield the configuration if needed
          yield @config if block_given?

          # Create credentials
          credentials = @config.credentials
          @quota_project_id = @config.quota_project
          @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

          @grafeas_stub = ::Gapic::ServiceStub.new(
            ::Grafeas::V1::Grafeas::Stub,
            credentials: credentials,
            endpoint: @config.endpoint,
            endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
            universe_domain: @config.universe_domain,
            channel_args: @config.channel_args,
            interceptors: @config.interceptors,
            channel_pool_config: @config.channel_pool,
            logger: @config.logger
          )

          @grafeas_stub.stub_logger&.info do |entry|
            entry.set_system_name
            entry.set_service
            entry.message = "Created client for #{entry.service}"
            entry.set_credentials_fields credentials
            entry.set "customEndpoint", @config.endpoint if @config.endpoint
            entry.set "defaultTimeout", @config.timeout if @config.timeout
            entry.set "quotaProject", @quota_project_id if @quota_project_id
          end
        end

        ##
        # The logger used for request/response debug logging.
        #
        # @return [Logger]
        #
        def logger
          @grafeas_stub.logger
        end

        # Service calls

        ##
        # Gets the specified occurrence.
        #
        # @overload get_occurrence(request, options = nil)
        #   Pass arguments to `get_occurrence` via a request object, either of type
        #   {::Grafeas::V1::GetOccurrenceRequest} or an equivalent Hash.
        #
        #   @param request [::Grafeas::V1::GetOccurrenceRequest, ::Hash]
        #     A request object representing the call parameters. Required. To specify no
        #     parameters, or to keep all the default parameter values, pass an empty Hash.
        #   @param options [::Gapic::CallOptions, ::Hash]
        #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
        #
        # @overload get_occurrence(name: nil)
        #   Pass arguments to `get_occurrence` via keyword arguments. Note that at
        #   least one keyword argument is required. To specify no parameters, or to keep all
        #   the default parameter values, pass an empty Hash as a request object (see above).
        #
        #   @param name [::String]
        #     The name of the occurrence in the form of
        #     `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
        #
        # @yield [response, operation] Access the result along with the RPC operation
        # @yieldparam response [::Grafeas::V1::Occurrence]
        # @yieldparam operation [::GRPC::ActiveCall::Operation]
        #
        # @return [::Grafeas::V1::Occurrence]
        #
        # @raise [::Google::Cloud::Error] if the RPC is aborted.
        #
        # @example Basic example
        #   require "grafeas/v1"
        #
        #   # Create a client object. The client can be reused for multiple calls.
        #   client = Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a request. To set request fields, pass in keyword arguments.
        #   request = Grafeas::V1::GetOccurrenceRequest.new
        #
        #   # Call the get_occurrence method.
        #   result = client.get_occurrence request
        #
        #   # The returned object is of type Grafeas::V1::Occurrence.
        #   p result
        #
        def get_occurrence request, options = nil
          raise ::ArgumentError, "request must be provided" if request.nil?

          request = ::Gapic::Protobuf.coerce request, to: ::Grafeas::V1::GetOccurrenceRequest

          # Converts hash and nil to an options object
          options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

          # Customize the options with defaults
          metadata = @config.rpcs.get_occurrence.metadata.to_h

          # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
          metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
            lib_name: @config.lib_name, lib_version: @config.lib_version,
            gapic_version: ::Grafeas::V1::VERSION
          metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
          metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

          header_params = {}
          if request.name
            header_params["name"] = request.name
          end

          request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
          metadata[:"x-goog-request-params"] ||= request_params_header

          options.apply_defaults timeout:      @config.rpcs.get_occurrence.timeout,
                                 metadata:     metadata,
                                 retry_policy: @config.rpcs.get_occurrence.retry_policy

          options.apply_defaults timeout:      @config.timeout,
                                 metadata:     @config.metadata,
                                 retry_policy: @config.retry_policy

          @grafeas_stub.call_rpc :get_occurrence, request, options: options do |response, operation|
            yield response, operation if block_given?
          end
        rescue ::GRPC::BadStatus => e
          raise ::Google::Cloud::Error.from_error(e)
        end

        ##
        # Lists occurrences for the specified project.
        #
        # @overload list_occurrences(request, options = nil)
        #   Pass arguments to `list_occurrences` via a request object, either of type
        #   {::Grafeas::V1::ListOccurrencesRequest} or an equivalent Hash.
        #
        #   @param request [::Grafeas::V1::ListOccurrencesRequest, ::Hash]
        #     A request object representing the call parameters. Required. To specify no
        #     parameters, or to keep all the default parameter values, pass an empty Hash.
        #   @param options [::Gapic::CallOptions, ::Hash]
        #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
        #
        # @overload list_occurrences(parent: nil, filter: nil, page_size: nil, page_token: nil, return_partial_success: nil)
        #   Pass arguments to `list_occurrences` via keyword arguments. Note that at
        #   least one keyword argument is required. To specify no parameters, or to keep all
        #   the default parameter values, pass an empty Hash as a request object (see above).
        #
        #   @param parent [::String]
        #     The name of the project to list occurrences for in the form of
        #     `projects/[PROJECT_ID]`.
        #   @param filter [::String]
        #     The filter expression.
        #   @param page_size [::Integer]
        #     Number of occurrences to return in the list. Must be positive. Max allowed
        #     page size is 1000. If not specified, page size defaults to 20.
        #   @param page_token [::String]
        #     Token to provide to skip to a particular spot in the list.
        #   @param return_partial_success [::Boolean]
        #     If set, the request will return all reachable Occurrences
        #     and report all unreachable regions in the `unreachable` field in
        #     the response.
        #
        #     Only applicable for requests in the global region.
        #
        # @yield [response, operation] Access the result along with the RPC operation
        # @yieldparam response [::Gapic::PagedEnumerable<::Grafeas::V1::Occurrence>]
        # @yieldparam operation [::GRPC::ActiveCall::Operation]
        #
        # @return [::Gapic::PagedEnumerable<::Grafeas::V1::Occurrence>]
        #
        # @raise [::Google::Cloud::Error] if the RPC is aborted.
        #
        # @example Basic example
        #   require "grafeas/v1"
        #
        #   # Create a client object. The client can be reused for multiple calls.
        #   client = Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a request. To set request fields, pass in keyword arguments.
        #   request = Grafeas::V1::ListOccurrencesRequest.new
        #
        #   # Call the list_occurrences method.
        #   result = client.list_occurrences request
        #
        #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
        #   # over elements, and API calls will be issued to fetch pages as needed.
        #   result.each do |item|
        #     # Each element is of type ::Grafeas::V1::Occurrence.
        #     p item
        #   end
        #
        def list_occurrences request, options = nil
          raise ::ArgumentError, "request must be provided" if request.nil?

          request = ::Gapic::Protobuf.coerce request, to: ::Grafeas::V1::ListOccurrencesRequest

          # Converts hash and nil to an options object
          options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

          # Customize the options with defaults
          metadata = @config.rpcs.list_occurrences.metadata.to_h

          # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
          metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
            lib_name: @config.lib_name, lib_version: @config.lib_version,
            gapic_version: ::Grafeas::V1::VERSION
          metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
          metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

          header_params = {}
          if request.parent
            header_params["parent"] = request.parent
          end

          request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
          metadata[:"x-goog-request-params"] ||= request_params_header

          options.apply_defaults timeout:      @config.rpcs.list_occurrences.timeout,
                                 metadata:     metadata,
                                 retry_policy: @config.rpcs.list_occurrences.retry_policy

          options.apply_defaults timeout:      @config.timeout,
                                 metadata:     @config.metadata,
                                 retry_policy: @config.retry_policy

          @grafeas_stub.call_rpc :list_occurrences, request, options: options do |response, operation|
            response = ::Gapic::PagedEnumerable.new @grafeas_stub, :list_occurrences, request, response, operation, options
            yield response, operation if block_given?
            throw :response, response
          end
        rescue ::GRPC::BadStatus => e
          raise ::Google::Cloud::Error.from_error(e)
        end

        ##
        # Deletes the specified occurrence. For example, use this method to delete an
        # occurrence when the occurrence is no longer applicable for the given
        # resource.
        #
        # @overload delete_occurrence(request, options = nil)
        #   Pass arguments to `delete_occurrence` via a request object, either of type
        #   {::Grafeas::V1::DeleteOccurrenceRequest} or an equivalent Hash.
        #
        #   @param request [::Grafeas::V1::DeleteOccurrenceRequest, ::Hash]
        #     A request object representing the call parameters. Required. To specify no
        #     parameters, or to keep all the default parameter values, pass an empty Hash.
        #   @param options [::Gapic::CallOptions, ::Hash]
        #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
        #
        # @overload delete_occurrence(name: nil)
        #   Pass arguments to `delete_occurrence` via keyword arguments. Note that at
        #   least one keyword argument is required. To specify no parameters, or to keep all
        #   the default parameter values, pass an empty Hash as a request object (see above).
        #
        #   @param name [::String]
        #     The name of the occurrence in the form of
        #     `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
        #
        # @yield [response, operation] Access the result along with the RPC operation
        # @yieldparam response [::Google::Protobuf::Empty]
        # @yieldparam operation [::GRPC::ActiveCall::Operation]
        #
        # @return [::Google::Protobuf::Empty]
        #
        # @raise [::Google::Cloud::Error] if the RPC is aborted.
        #
        # @example Basic example
        #   require "grafeas/v1"
        #
        #   # Create a client object. The client can be reused for multiple calls.
        #   client = Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a request. To set request fields, pass in keyword arguments.
        #   request = Grafeas::V1::DeleteOccurrenceRequest.new
        #
        #   # Call the delete_occurrence method.
        #   result = client.delete_occurrence request
        #
        #   # The returned object is of type Google::Protobuf::Empty.
        #   p result
        #
        def delete_occurrence request, options = nil
          raise ::ArgumentError, "request must be provided" if request.nil?

          request = ::Gapic::Protobuf.coerce request, to: ::Grafeas::V1::DeleteOccurrenceRequest

          # Converts hash and nil to an options object
          options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

          # Customize the options with defaults
          metadata = @config.rpcs.delete_occurrence.metadata.to_h

          # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
          metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
            lib_name: @config.lib_name, lib_version: @config.lib_version,
            gapic_version: ::Grafeas::V1::VERSION
          metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
          metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

          header_params = {}
          if request.name
            header_params["name"] = request.name
          end

          request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
          metadata[:"x-goog-request-params"] ||= request_params_header

          options.apply_defaults timeout:      @config.rpcs.delete_occurrence.timeout,
                                 metadata:     metadata,
                                 retry_policy: @config.rpcs.delete_occurrence.retry_policy

          options.apply_defaults timeout:      @config.timeout,
                                 metadata:     @config.metadata,
                                 retry_policy: @config.retry_policy

          @grafeas_stub.call_rpc :delete_occurrence, request, options: options do |response, operation|
            yield response, operation if block_given?
          end
        rescue ::GRPC::BadStatus => e
          raise ::Google::Cloud::Error.from_error(e)
        end

        ##
        # Creates a new occurrence.
        #
        # @overload create_occurrence(request, options = nil)
        #   Pass arguments to `create_occurrence` via a request object, either of type
        #   {::Grafeas::V1::CreateOccurrenceRequest} or an equivalent Hash.
        #
        #   @param request [::Grafeas::V1::CreateOccurrenceRequest, ::Hash]
        #     A request object representing the call parameters. Required. To specify no
        #     parameters, or to keep all the default parameter values, pass an empty Hash.
        #   @param options [::Gapic::CallOptions, ::Hash]
        #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
        #
        # @overload create_occurrence(parent: nil, occurrence: nil)
        #   Pass arguments to `create_occurrence` via keyword arguments. Note that at
        #   least one keyword argument is required. To specify no parameters, or to keep all
        #   the default parameter values, pass an empty Hash as a request object (see above).
        #
        #   @param parent [::String]
        #     The name of the project in the form of `projects/[PROJECT_ID]`, under which
        #     the occurrence is to be created.
        #   @param occurrence [::Grafeas::V1::Occurrence, ::Hash]
        #     The occurrence to create.
        #
        # @yield [response, operation] Access the result along with the RPC operation
        # @yieldparam response [::Grafeas::V1::Occurrence]
        # @yieldparam operation [::GRPC::ActiveCall::Operation]
        #
        # @return [::Grafeas::V1::Occurrence]
        #
        # @raise [::Google::Cloud::Error] if the RPC is aborted.
        #
        # @example Basic example
        #   require "grafeas/v1"
        #
        #   # Create a client object. The client can be reused for multiple calls.
        #   client = Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a request. To set request fields, pass in keyword arguments.
        #   request = Grafeas::V1::CreateOccurrenceRequest.new
        #
        #   # Call the create_occurrence method.
        #   result = client.create_occurrence request
        #
        #   # The returned object is of type Grafeas::V1::Occurrence.
        #   p result
        #
        def create_occurrence request, options = nil
          raise ::ArgumentError, "request must be provided" if request.nil?

          request = ::Gapic::Protobuf.coerce request, to: ::Grafeas::V1::CreateOccurrenceRequest

          # Converts hash and nil to an options object
          options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

          # Customize the options with defaults
          metadata = @config.rpcs.create_occurrence.metadata.to_h

          # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
          metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
            lib_name: @config.lib_name, lib_version: @config.lib_version,
            gapic_version: ::Grafeas::V1::VERSION
          metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
          metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

          header_params = {}
          if request.parent
            header_params["parent"] = request.parent
          end

          request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
          metadata[:"x-goog-request-params"] ||= request_params_header

          options.apply_defaults timeout:      @config.rpcs.create_occurrence.timeout,
                                 metadata:     metadata,
                                 retry_policy: @config.rpcs.create_occurrence.retry_policy

          options.apply_defaults timeout:      @config.timeout,
                                 metadata:     @config.metadata,
                                 retry_policy: @config.retry_policy

          @grafeas_stub.call_rpc :create_occurrence, request, options: options do |response, operation|
            yield response, operation if block_given?
          end
        rescue ::GRPC::BadStatus => e
          raise ::Google::Cloud::Error.from_error(e)
        end

        ##
        # Creates new occurrences in batch.
        #
        # @overload batch_create_occurrences(request, options = nil)
        #   Pass arguments to `batch_create_occurrences` via a request object, either of type
        #   {::Grafeas::V1::BatchCreateOccurrencesRequest} or an equivalent Hash.
        #
        #   @param request [::Grafeas::V1::BatchCreateOccurrencesRequest, ::Hash]
        #     A request object representing the call parameters. Required. To specify no
        #     parameters, or to keep all the default parameter values, pass an empty Hash.
        #   @param options [::Gapic::CallOptions, ::Hash]
        #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
        #
        # @overload batch_create_occurrences(parent: nil, occurrences: nil)
        #   Pass arguments to `batch_create_occurrences` via keyword arguments. Note that at
        #   least one keyword argument is required. To specify no parameters, or to keep all
        #   the default parameter values, pass an empty Hash as a request object (see above).
        #
        #   @param parent [::String]
        #     The name of the project in the form of `projects/[PROJECT_ID]`, under which
        #     the occurrences are to be created.
        #   @param occurrences [::Array<::Grafeas::V1::Occurrence, ::Hash>]
        #     The occurrences to create. Max allowed length is 1000.
        #
        # @yield [response, operation] Access the result along with the RPC operation
        # @yieldparam response [::Grafeas::V1::BatchCreateOccurrencesResponse]
        # @yieldparam operation [::GRPC::ActiveCall::Operation]
        #
        # @return [::Grafeas::V1::BatchCreateOccurrencesResponse]
        #
        # @raise [::Google::Cloud::Error] if the RPC is aborted.
        #
        # @example Basic example
        #   require "grafeas/v1"
        #
        #   # Create a client object. The client can be reused for multiple calls.
        #   client = Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a request. To set request fields, pass in keyword arguments.
        #   request = Grafeas::V1::BatchCreateOccurrencesRequest.new
        #
        #   # Call the batch_create_occurrences method.
        #   result = client.batch_create_occurrences request
        #
        #   # The returned object is of type Grafeas::V1::BatchCreateOccurrencesResponse.
        #   p result
        #
        def batch_create_occurrences request, options = nil
          raise ::ArgumentError, "request must be provided" if request.nil?

          request = ::Gapic::Protobuf.coerce request, to: ::Grafeas::V1::BatchCreateOccurrencesRequest

          # Converts hash and nil to an options object
          options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

          # Customize the options with defaults
          metadata = @config.rpcs.batch_create_occurrences.metadata.to_h

          # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
          metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
            lib_name: @config.lib_name, lib_version: @config.lib_version,
            gapic_version: ::Grafeas::V1::VERSION
          metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
          metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

          header_params = {}
          if request.parent
            header_params["parent"] = request.parent
          end

          request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
          metadata[:"x-goog-request-params"] ||= request_params_header

          options.apply_defaults timeout:      @config.rpcs.batch_create_occurrences.timeout,
                                 metadata:     metadata,
                                 retry_policy: @config.rpcs.batch_create_occurrences.retry_policy

          options.apply_defaults timeout:      @config.timeout,
                                 metadata:     @config.metadata,
                                 retry_policy: @config.retry_policy

          @grafeas_stub.call_rpc :batch_create_occurrences, request, options: options do |response, operation|
            yield response, operation if block_given?
          end
        rescue ::GRPC::BadStatus => e
          raise ::Google::Cloud::Error.from_error(e)
        end

        ##
        # Updates the specified occurrence.
        #
        # @overload update_occurrence(request, options = nil)
        #   Pass arguments to `update_occurrence` via a request object, either of type
        #   {::Grafeas::V1::UpdateOccurrenceRequest} or an equivalent Hash.
        #
        #   @param request [::Grafeas::V1::UpdateOccurrenceRequest, ::Hash]
        #     A request object representing the call parameters. Required. To specify no
        #     parameters, or to keep all the default parameter values, pass an empty Hash.
        #   @param options [::Gapic::CallOptions, ::Hash]
        #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
        #
        # @overload update_occurrence(name: nil, occurrence: nil, update_mask: nil)
        #   Pass arguments to `update_occurrence` via keyword arguments. Note that at
        #   least one keyword argument is required. To specify no parameters, or to keep all
        #   the default parameter values, pass an empty Hash as a request object (see above).
        #
        #   @param name [::String]
        #     The name of the occurrence in the form of
        #     `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
        #   @param occurrence [::Grafeas::V1::Occurrence, ::Hash]
        #     The updated occurrence.
        #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
        #     The fields to update.
        #
        # @yield [response, operation] Access the result along with the RPC operation
        # @yieldparam response [::Grafeas::V1::Occurrence]
        # @yieldparam operation [::GRPC::ActiveCall::Operation]
        #
        # @return [::Grafeas::V1::Occurrence]
        #
        # @raise [::Google::Cloud::Error] if the RPC is aborted.
        #
        # @example Basic example
        #   require "grafeas/v1"
        #
        #   # Create a client object. The client can be reused for multiple calls.
        #   client = Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a request. To set request fields, pass in keyword arguments.
        #   request = Grafeas::V1::UpdateOccurrenceRequest.new
        #
        #   # Call the update_occurrence method.
        #   result = client.update_occurrence request
        #
        #   # The returned object is of type Grafeas::V1::Occurrence.
        #   p result
        #
        def update_occurrence request, options = nil
          raise ::ArgumentError, "request must be provided" if request.nil?

          request = ::Gapic::Protobuf.coerce request, to: ::Grafeas::V1::UpdateOccurrenceRequest

          # Converts hash and nil to an options object
          options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

          # Customize the options with defaults
          metadata = @config.rpcs.update_occurrence.metadata.to_h

          # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
          metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
            lib_name: @config.lib_name, lib_version: @config.lib_version,
            gapic_version: ::Grafeas::V1::VERSION
          metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
          metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

          header_params = {}
          if request.name
            header_params["name"] = request.name
          end

          request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
          metadata[:"x-goog-request-params"] ||= request_params_header

          options.apply_defaults timeout:      @config.rpcs.update_occurrence.timeout,
                                 metadata:     metadata,
                                 retry_policy: @config.rpcs.update_occurrence.retry_policy

          options.apply_defaults timeout:      @config.timeout,
                                 metadata:     @config.metadata,
                                 retry_policy: @config.retry_policy

          @grafeas_stub.call_rpc :update_occurrence, request, options: options do |response, operation|
            yield response, operation if block_given?
          end
        rescue ::GRPC::BadStatus => e
          raise ::Google::Cloud::Error.from_error(e)
        end

        ##
        # Gets the note attached to the specified occurrence. Consumer projects can
        # use this method to get a note that belongs to a provider project.
        #
        # @overload get_occurrence_note(request, options = nil)
        #   Pass arguments to `get_occurrence_note` via a request object, either of type
        #   {::Grafeas::V1::GetOccurrenceNoteRequest} or an equivalent Hash.
        #
        #   @param request [::Grafeas::V1::GetOccurrenceNoteRequest, ::Hash]
        #     A request object representing the call parameters. Required. To specify no
        #     parameters, or to keep all the default parameter values, pass an empty Hash.
        #   @param options [::Gapic::CallOptions, ::Hash]
        #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
        #
        # @overload get_occurrence_note(name: nil)
        #   Pass arguments to `get_occurrence_note` via keyword arguments. Note that at
        #   least one keyword argument is required. To specify no parameters, or to keep all
        #   the default parameter values, pass an empty Hash as a request object (see above).
        #
        #   @param name [::String]
        #     The name of the occurrence in the form of
        #     `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
        #
        # @yield [response, operation] Access the result along with the RPC operation
        # @yieldparam response [::Grafeas::V1::Note]
        # @yieldparam operation [::GRPC::ActiveCall::Operation]
        #
        # @return [::Grafeas::V1::Note]
        #
        # @raise [::Google::Cloud::Error] if the RPC is aborted.
        #
        # @example Basic example
        #   require "grafeas/v1"
        #
        #   # Create a client object. The client can be reused for multiple calls.
        #   client = Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a request. To set request fields, pass in keyword arguments.
        #   request = Grafeas::V1::GetOccurrenceNoteRequest.new
        #
        #   # Call the get_occurrence_note method.
        #   result = client.get_occurrence_note request
        #
        #   # The returned object is of type Grafeas::V1::Note.
        #   p result
        #
        def get_occurrence_note request, options = nil
          raise ::ArgumentError, "request must be provided" if request.nil?

          request = ::Gapic::Protobuf.coerce request, to: ::Grafeas::V1::GetOccurrenceNoteRequest

          # Converts hash and nil to an options object
          options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

          # Customize the options with defaults
          metadata = @config.rpcs.get_occurrence_note.metadata.to_h

          # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
          metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
            lib_name: @config.lib_name, lib_version: @config.lib_version,
            gapic_version: ::Grafeas::V1::VERSION
          metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
          metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

          header_params = {}
          if request.name
            header_params["name"] = request.name
          end

          request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
          metadata[:"x-goog-request-params"] ||= request_params_header

          options.apply_defaults timeout:      @config.rpcs.get_occurrence_note.timeout,
                                 metadata:     metadata,
                                 retry_policy: @config.rpcs.get_occurrence_note.retry_policy

          options.apply_defaults timeout:      @config.timeout,
                                 metadata:     @config.metadata,
                                 retry_policy: @config.retry_policy

          @grafeas_stub.call_rpc :get_occurrence_note, request, options: options do |response, operation|
            yield response, operation if block_given?
          end
        rescue ::GRPC::BadStatus => e
          raise ::Google::Cloud::Error.from_error(e)
        end

        ##
        # Gets the specified note.
        #
        # @overload get_note(request, options = nil)
        #   Pass arguments to `get_note` via a request object, either of type
        #   {::Grafeas::V1::GetNoteRequest} or an equivalent Hash.
        #
        #   @param request [::Grafeas::V1::GetNoteRequest, ::Hash]
        #     A request object representing the call parameters. Required. To specify no
        #     parameters, or to keep all the default parameter values, pass an empty Hash.
        #   @param options [::Gapic::CallOptions, ::Hash]
        #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
        #
        # @overload get_note(name: nil)
        #   Pass arguments to `get_note` via keyword arguments. Note that at
        #   least one keyword argument is required. To specify no parameters, or to keep all
        #   the default parameter values, pass an empty Hash as a request object (see above).
        #
        #   @param name [::String]
        #     The name of the note in the form of
        #     `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
        #
        # @yield [response, operation] Access the result along with the RPC operation
        # @yieldparam response [::Grafeas::V1::Note]
        # @yieldparam operation [::GRPC::ActiveCall::Operation]
        #
        # @return [::Grafeas::V1::Note]
        #
        # @raise [::Google::Cloud::Error] if the RPC is aborted.
        #
        # @example Basic example
        #   require "grafeas/v1"
        #
        #   # Create a client object. The client can be reused for multiple calls.
        #   client = Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a request. To set request fields, pass in keyword arguments.
        #   request = Grafeas::V1::GetNoteRequest.new
        #
        #   # Call the get_note method.
        #   result = client.get_note request
        #
        #   # The returned object is of type Grafeas::V1::Note.
        #   p result
        #
        def get_note request, options = nil
          raise ::ArgumentError, "request must be provided" if request.nil?

          request = ::Gapic::Protobuf.coerce request, to: ::Grafeas::V1::GetNoteRequest

          # Converts hash and nil to an options object
          options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

          # Customize the options with defaults
          metadata = @config.rpcs.get_note.metadata.to_h

          # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
          metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
            lib_name: @config.lib_name, lib_version: @config.lib_version,
            gapic_version: ::Grafeas::V1::VERSION
          metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
          metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

          header_params = {}
          if request.name
            header_params["name"] = request.name
          end

          request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
          metadata[:"x-goog-request-params"] ||= request_params_header

          options.apply_defaults timeout:      @config.rpcs.get_note.timeout,
                                 metadata:     metadata,
                                 retry_policy: @config.rpcs.get_note.retry_policy

          options.apply_defaults timeout:      @config.timeout,
                                 metadata:     @config.metadata,
                                 retry_policy: @config.retry_policy

          @grafeas_stub.call_rpc :get_note, request, options: options do |response, operation|
            yield response, operation if block_given?
          end
        rescue ::GRPC::BadStatus => e
          raise ::Google::Cloud::Error.from_error(e)
        end

        ##
        # Lists notes for the specified project.
        #
        # @overload list_notes(request, options = nil)
        #   Pass arguments to `list_notes` via a request object, either of type
        #   {::Grafeas::V1::ListNotesRequest} or an equivalent Hash.
        #
        #   @param request [::Grafeas::V1::ListNotesRequest, ::Hash]
        #     A request object representing the call parameters. Required. To specify no
        #     parameters, or to keep all the default parameter values, pass an empty Hash.
        #   @param options [::Gapic::CallOptions, ::Hash]
        #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
        #
        # @overload list_notes(parent: nil, filter: nil, page_size: nil, page_token: nil, return_partial_success: nil)
        #   Pass arguments to `list_notes` via keyword arguments. Note that at
        #   least one keyword argument is required. To specify no parameters, or to keep all
        #   the default parameter values, pass an empty Hash as a request object (see above).
        #
        #   @param parent [::String]
        #     The name of the project to list notes for in the form of
        #     `projects/[PROJECT_ID]`.
        #   @param filter [::String]
        #     The filter expression.
        #   @param page_size [::Integer]
        #     Number of notes to return in the list. Must be positive. Max allowed page
        #     size is 1000. If not specified, page size defaults to 20.
        #   @param page_token [::String]
        #     Token to provide to skip to a particular spot in the list.
        #   @param return_partial_success [::Boolean]
        #     If set, the request will return all reachable Notes
        #     and report all unreachable regions in the `unreachable` field in
        #     the response.
        #
        #     Only applicable for requests in the global region.
        #
        # @yield [response, operation] Access the result along with the RPC operation
        # @yieldparam response [::Gapic::PagedEnumerable<::Grafeas::V1::Note>]
        # @yieldparam operation [::GRPC::ActiveCall::Operation]
        #
        # @return [::Gapic::PagedEnumerable<::Grafeas::V1::Note>]
        #
        # @raise [::Google::Cloud::Error] if the RPC is aborted.
        #
        # @example Basic example
        #   require "grafeas/v1"
        #
        #   # Create a client object. The client can be reused for multiple calls.
        #   client = Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a request. To set request fields, pass in keyword arguments.
        #   request = Grafeas::V1::ListNotesRequest.new
        #
        #   # Call the list_notes method.
        #   result = client.list_notes request
        #
        #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
        #   # over elements, and API calls will be issued to fetch pages as needed.
        #   result.each do |item|
        #     # Each element is of type ::Grafeas::V1::Note.
        #     p item
        #   end
        #
        def list_notes request, options = nil
          raise ::ArgumentError, "request must be provided" if request.nil?

          request = ::Gapic::Protobuf.coerce request, to: ::Grafeas::V1::ListNotesRequest

          # Converts hash and nil to an options object
          options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

          # Customize the options with defaults
          metadata = @config.rpcs.list_notes.metadata.to_h

          # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
          metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
            lib_name: @config.lib_name, lib_version: @config.lib_version,
            gapic_version: ::Grafeas::V1::VERSION
          metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
          metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

          header_params = {}
          if request.parent
            header_params["parent"] = request.parent
          end

          request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
          metadata[:"x-goog-request-params"] ||= request_params_header

          options.apply_defaults timeout:      @config.rpcs.list_notes.timeout,
                                 metadata:     metadata,
                                 retry_policy: @config.rpcs.list_notes.retry_policy

          options.apply_defaults timeout:      @config.timeout,
                                 metadata:     @config.metadata,
                                 retry_policy: @config.retry_policy

          @grafeas_stub.call_rpc :list_notes, request, options: options do |response, operation|
            response = ::Gapic::PagedEnumerable.new @grafeas_stub, :list_notes, request, response, operation, options
            yield response, operation if block_given?
            throw :response, response
          end
        rescue ::GRPC::BadStatus => e
          raise ::Google::Cloud::Error.from_error(e)
        end

        ##
        # Deletes the specified note.
        #
        # @overload delete_note(request, options = nil)
        #   Pass arguments to `delete_note` via a request object, either of type
        #   {::Grafeas::V1::DeleteNoteRequest} or an equivalent Hash.
        #
        #   @param request [::Grafeas::V1::DeleteNoteRequest, ::Hash]
        #     A request object representing the call parameters. Required. To specify no
        #     parameters, or to keep all the default parameter values, pass an empty Hash.
        #   @param options [::Gapic::CallOptions, ::Hash]
        #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
        #
        # @overload delete_note(name: nil)
        #   Pass arguments to `delete_note` via keyword arguments. Note that at
        #   least one keyword argument is required. To specify no parameters, or to keep all
        #   the default parameter values, pass an empty Hash as a request object (see above).
        #
        #   @param name [::String]
        #     The name of the note in the form of
        #     `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
        #
        # @yield [response, operation] Access the result along with the RPC operation
        # @yieldparam response [::Google::Protobuf::Empty]
        # @yieldparam operation [::GRPC::ActiveCall::Operation]
        #
        # @return [::Google::Protobuf::Empty]
        #
        # @raise [::Google::Cloud::Error] if the RPC is aborted.
        #
        # @example Basic example
        #   require "grafeas/v1"
        #
        #   # Create a client object. The client can be reused for multiple calls.
        #   client = Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a request. To set request fields, pass in keyword arguments.
        #   request = Grafeas::V1::DeleteNoteRequest.new
        #
        #   # Call the delete_note method.
        #   result = client.delete_note request
        #
        #   # The returned object is of type Google::Protobuf::Empty.
        #   p result
        #
        def delete_note request, options = nil
          raise ::ArgumentError, "request must be provided" if request.nil?

          request = ::Gapic::Protobuf.coerce request, to: ::Grafeas::V1::DeleteNoteRequest

          # Converts hash and nil to an options object
          options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

          # Customize the options with defaults
          metadata = @config.rpcs.delete_note.metadata.to_h

          # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
          metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
            lib_name: @config.lib_name, lib_version: @config.lib_version,
            gapic_version: ::Grafeas::V1::VERSION
          metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
          metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

          header_params = {}
          if request.name
            header_params["name"] = request.name
          end

          request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
          metadata[:"x-goog-request-params"] ||= request_params_header

          options.apply_defaults timeout:      @config.rpcs.delete_note.timeout,
                                 metadata:     metadata,
                                 retry_policy: @config.rpcs.delete_note.retry_policy

          options.apply_defaults timeout:      @config.timeout,
                                 metadata:     @config.metadata,
                                 retry_policy: @config.retry_policy

          @grafeas_stub.call_rpc :delete_note, request, options: options do |response, operation|
            yield response, operation if block_given?
          end
        rescue ::GRPC::BadStatus => e
          raise ::Google::Cloud::Error.from_error(e)
        end

        ##
        # Creates a new note.
        #
        # @overload create_note(request, options = nil)
        #   Pass arguments to `create_note` via a request object, either of type
        #   {::Grafeas::V1::CreateNoteRequest} or an equivalent Hash.
        #
        #   @param request [::Grafeas::V1::CreateNoteRequest, ::Hash]
        #     A request object representing the call parameters. Required. To specify no
        #     parameters, or to keep all the default parameter values, pass an empty Hash.
        #   @param options [::Gapic::CallOptions, ::Hash]
        #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
        #
        # @overload create_note(parent: nil, note_id: nil, note: nil)
        #   Pass arguments to `create_note` via keyword arguments. Note that at
        #   least one keyword argument is required. To specify no parameters, or to keep all
        #   the default parameter values, pass an empty Hash as a request object (see above).
        #
        #   @param parent [::String]
        #     The name of the project in the form of `projects/[PROJECT_ID]`, under which
        #     the note is to be created.
        #   @param note_id [::String]
        #     The ID to use for this note.
        #   @param note [::Grafeas::V1::Note, ::Hash]
        #     The note to create.
        #
        # @yield [response, operation] Access the result along with the RPC operation
        # @yieldparam response [::Grafeas::V1::Note]
        # @yieldparam operation [::GRPC::ActiveCall::Operation]
        #
        # @return [::Grafeas::V1::Note]
        #
        # @raise [::Google::Cloud::Error] if the RPC is aborted.
        #
        # @example Basic example
        #   require "grafeas/v1"
        #
        #   # Create a client object. The client can be reused for multiple calls.
        #   client = Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a request. To set request fields, pass in keyword arguments.
        #   request = Grafeas::V1::CreateNoteRequest.new
        #
        #   # Call the create_note method.
        #   result = client.create_note request
        #
        #   # The returned object is of type Grafeas::V1::Note.
        #   p result
        #
        def create_note request, options = nil
          raise ::ArgumentError, "request must be provided" if request.nil?

          request = ::Gapic::Protobuf.coerce request, to: ::Grafeas::V1::CreateNoteRequest

          # Converts hash and nil to an options object
          options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

          # Customize the options with defaults
          metadata = @config.rpcs.create_note.metadata.to_h

          # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
          metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
            lib_name: @config.lib_name, lib_version: @config.lib_version,
            gapic_version: ::Grafeas::V1::VERSION
          metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
          metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

          header_params = {}
          if request.parent
            header_params["parent"] = request.parent
          end

          request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
          metadata[:"x-goog-request-params"] ||= request_params_header

          options.apply_defaults timeout:      @config.rpcs.create_note.timeout,
                                 metadata:     metadata,
                                 retry_policy: @config.rpcs.create_note.retry_policy

          options.apply_defaults timeout:      @config.timeout,
                                 metadata:     @config.metadata,
                                 retry_policy: @config.retry_policy

          @grafeas_stub.call_rpc :create_note, request, options: options do |response, operation|
            yield response, operation if block_given?
          end
        rescue ::GRPC::BadStatus => e
          raise ::Google::Cloud::Error.from_error(e)
        end

        ##
        # Creates new notes in batch.
        #
        # @overload batch_create_notes(request, options = nil)
        #   Pass arguments to `batch_create_notes` via a request object, either of type
        #   {::Grafeas::V1::BatchCreateNotesRequest} or an equivalent Hash.
        #
        #   @param request [::Grafeas::V1::BatchCreateNotesRequest, ::Hash]
        #     A request object representing the call parameters. Required. To specify no
        #     parameters, or to keep all the default parameter values, pass an empty Hash.
        #   @param options [::Gapic::CallOptions, ::Hash]
        #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
        #
        # @overload batch_create_notes(parent: nil, notes: nil)
        #   Pass arguments to `batch_create_notes` via keyword arguments. Note that at
        #   least one keyword argument is required. To specify no parameters, or to keep all
        #   the default parameter values, pass an empty Hash as a request object (see above).
        #
        #   @param parent [::String]
        #     The name of the project in the form of `projects/[PROJECT_ID]`, under which
        #     the notes are to be created.
        #   @param notes [::Hash{::String => ::Grafeas::V1::Note, ::Hash}]
        #     The notes to create. Max allowed length is 1000.
        #
        # @yield [response, operation] Access the result along with the RPC operation
        # @yieldparam response [::Grafeas::V1::BatchCreateNotesResponse]
        # @yieldparam operation [::GRPC::ActiveCall::Operation]
        #
        # @return [::Grafeas::V1::BatchCreateNotesResponse]
        #
        # @raise [::Google::Cloud::Error] if the RPC is aborted.
        #
        # @example Basic example
        #   require "grafeas/v1"
        #
        #   # Create a client object. The client can be reused for multiple calls.
        #   client = Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a request. To set request fields, pass in keyword arguments.
        #   request = Grafeas::V1::BatchCreateNotesRequest.new
        #
        #   # Call the batch_create_notes method.
        #   result = client.batch_create_notes request
        #
        #   # The returned object is of type Grafeas::V1::BatchCreateNotesResponse.
        #   p result
        #
        def batch_create_notes request, options = nil
          raise ::ArgumentError, "request must be provided" if request.nil?

          request = ::Gapic::Protobuf.coerce request, to: ::Grafeas::V1::BatchCreateNotesRequest

          # Converts hash and nil to an options object
          options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

          # Customize the options with defaults
          metadata = @config.rpcs.batch_create_notes.metadata.to_h

          # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
          metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
            lib_name: @config.lib_name, lib_version: @config.lib_version,
            gapic_version: ::Grafeas::V1::VERSION
          metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
          metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

          header_params = {}
          if request.parent
            header_params["parent"] = request.parent
          end

          request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
          metadata[:"x-goog-request-params"] ||= request_params_header

          options.apply_defaults timeout:      @config.rpcs.batch_create_notes.timeout,
                                 metadata:     metadata,
                                 retry_policy: @config.rpcs.batch_create_notes.retry_policy

          options.apply_defaults timeout:      @config.timeout,
                                 metadata:     @config.metadata,
                                 retry_policy: @config.retry_policy

          @grafeas_stub.call_rpc :batch_create_notes, request, options: options do |response, operation|
            yield response, operation if block_given?
          end
        rescue ::GRPC::BadStatus => e
          raise ::Google::Cloud::Error.from_error(e)
        end

        ##
        # Updates the specified note.
        #
        # @overload update_note(request, options = nil)
        #   Pass arguments to `update_note` via a request object, either of type
        #   {::Grafeas::V1::UpdateNoteRequest} or an equivalent Hash.
        #
        #   @param request [::Grafeas::V1::UpdateNoteRequest, ::Hash]
        #     A request object representing the call parameters. Required. To specify no
        #     parameters, or to keep all the default parameter values, pass an empty Hash.
        #   @param options [::Gapic::CallOptions, ::Hash]
        #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
        #
        # @overload update_note(name: nil, note: nil, update_mask: nil)
        #   Pass arguments to `update_note` via keyword arguments. Note that at
        #   least one keyword argument is required. To specify no parameters, or to keep all
        #   the default parameter values, pass an empty Hash as a request object (see above).
        #
        #   @param name [::String]
        #     The name of the note in the form of
        #     `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
        #   @param note [::Grafeas::V1::Note, ::Hash]
        #     The updated note.
        #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
        #     The fields to update.
        #
        # @yield [response, operation] Access the result along with the RPC operation
        # @yieldparam response [::Grafeas::V1::Note]
        # @yieldparam operation [::GRPC::ActiveCall::Operation]
        #
        # @return [::Grafeas::V1::Note]
        #
        # @raise [::Google::Cloud::Error] if the RPC is aborted.
        #
        # @example Basic example
        #   require "grafeas/v1"
        #
        #   # Create a client object. The client can be reused for multiple calls.
        #   client = Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a request. To set request fields, pass in keyword arguments.
        #   request = Grafeas::V1::UpdateNoteRequest.new
        #
        #   # Call the update_note method.
        #   result = client.update_note request
        #
        #   # The returned object is of type Grafeas::V1::Note.
        #   p result
        #
        def update_note request, options = nil
          raise ::ArgumentError, "request must be provided" if request.nil?

          request = ::Gapic::Protobuf.coerce request, to: ::Grafeas::V1::UpdateNoteRequest

          # Converts hash and nil to an options object
          options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

          # Customize the options with defaults
          metadata = @config.rpcs.update_note.metadata.to_h

          # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
          metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
            lib_name: @config.lib_name, lib_version: @config.lib_version,
            gapic_version: ::Grafeas::V1::VERSION
          metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
          metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

          header_params = {}
          if request.name
            header_params["name"] = request.name
          end

          request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
          metadata[:"x-goog-request-params"] ||= request_params_header

          options.apply_defaults timeout:      @config.rpcs.update_note.timeout,
                                 metadata:     metadata,
                                 retry_policy: @config.rpcs.update_note.retry_policy

          options.apply_defaults timeout:      @config.timeout,
                                 metadata:     @config.metadata,
                                 retry_policy: @config.retry_policy

          @grafeas_stub.call_rpc :update_note, request, options: options do |response, operation|
            yield response, operation if block_given?
          end
        rescue ::GRPC::BadStatus => e
          raise ::Google::Cloud::Error.from_error(e)
        end

        ##
        # Lists occurrences referencing the specified note. Provider projects can use
        # this method to get all occurrences across consumer projects referencing the
        # specified note.
        #
        # @overload list_note_occurrences(request, options = nil)
        #   Pass arguments to `list_note_occurrences` via a request object, either of type
        #   {::Grafeas::V1::ListNoteOccurrencesRequest} or an equivalent Hash.
        #
        #   @param request [::Grafeas::V1::ListNoteOccurrencesRequest, ::Hash]
        #     A request object representing the call parameters. Required. To specify no
        #     parameters, or to keep all the default parameter values, pass an empty Hash.
        #   @param options [::Gapic::CallOptions, ::Hash]
        #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
        #
        # @overload list_note_occurrences(name: nil, filter: nil, page_size: nil, page_token: nil)
        #   Pass arguments to `list_note_occurrences` via keyword arguments. Note that at
        #   least one keyword argument is required. To specify no parameters, or to keep all
        #   the default parameter values, pass an empty Hash as a request object (see above).
        #
        #   @param name [::String]
        #     The name of the note to list occurrences for in the form of
        #     `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
        #   @param filter [::String]
        #     The filter expression.
        #   @param page_size [::Integer]
        #     Number of occurrences to return in the list.
        #   @param page_token [::String]
        #     Token to provide to skip to a particular spot in the list.
        #
        # @yield [response, operation] Access the result along with the RPC operation
        # @yieldparam response [::Gapic::PagedEnumerable<::Grafeas::V1::Occurrence>]
        # @yieldparam operation [::GRPC::ActiveCall::Operation]
        #
        # @return [::Gapic::PagedEnumerable<::Grafeas::V1::Occurrence>]
        #
        # @raise [::Google::Cloud::Error] if the RPC is aborted.
        #
        # @example Basic example
        #   require "grafeas/v1"
        #
        #   # Create a client object. The client can be reused for multiple calls.
        #   client = Grafeas::V1::Grafeas::Client.new
        #
        #   # Create a request. To set request fields, pass in keyword arguments.
        #   request = Grafeas::V1::ListNoteOccurrencesRequest.new
        #
        #   # Call the list_note_occurrences method.
        #   result = client.list_note_occurrences request
        #
        #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
        #   # over elements, and API calls will be issued to fetch pages as needed.
        #   result.each do |item|
        #     # Each element is of type ::Grafeas::V1::Occurrence.
        #     p item
        #   end
        #
        def list_note_occurrences request, options = nil
          raise ::ArgumentError, "request must be provided" if request.nil?

          request = ::Gapic::Protobuf.coerce request, to: ::Grafeas::V1::ListNoteOccurrencesRequest

          # Converts hash and nil to an options object
          options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

          # Customize the options with defaults
          metadata = @config.rpcs.list_note_occurrences.metadata.to_h

          # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
          metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
            lib_name: @config.lib_name, lib_version: @config.lib_version,
            gapic_version: ::Grafeas::V1::VERSION
          metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
          metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

          header_params = {}
          if request.name
            header_params["name"] = request.name
          end

          request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
          metadata[:"x-goog-request-params"] ||= request_params_header

          options.apply_defaults timeout:      @config.rpcs.list_note_occurrences.timeout,
                                 metadata:     metadata,
                                 retry_policy: @config.rpcs.list_note_occurrences.retry_policy

          options.apply_defaults timeout:      @config.timeout,
                                 metadata:     @config.metadata,
                                 retry_policy: @config.retry_policy

          @grafeas_stub.call_rpc :list_note_occurrences, request, options: options do |response, operation|
            response = ::Gapic::PagedEnumerable.new @grafeas_stub, :list_note_occurrences, request, response, operation, options
            yield response, operation if block_given?
            throw :response, response
          end
        rescue ::GRPC::BadStatus => e
          raise ::Google::Cloud::Error.from_error(e)
        end

        ##
        # Configuration class for the Grafeas API.
        #
        # This class represents the configuration for Grafeas,
        # providing control over timeouts, retry behavior, logging, transport
        # parameters, and other low-level controls. Certain parameters can also be
        # applied individually to specific RPCs. See
        # {::Grafeas::V1::Grafeas::Client::Configuration::Rpcs}
        # for a list of RPCs that can be configured independently.
        #
        # Configuration can be applied globally to all clients, or to a single client
        # on construction.
        #
        # @example
        #
        #   # Modify the global config, setting the timeout for
        #   # get_occurrence to 20 seconds,
        #   # and all remaining timeouts to 10 seconds.
        #   ::Grafeas::V1::Grafeas::Client.configure do |config|
        #     config.timeout = 10.0
        #     config.rpcs.get_occurrence.timeout = 20.0
        #   end
        #
        #   # Apply the above configuration only to a new client.
        #   client = ::Grafeas::V1::Grafeas::Client.new do |config|
        #     config.timeout = 10.0
        #     config.rpcs.get_occurrence.timeout = 20.0
        #   end
        #
        # @!attribute [rw] endpoint
        #   A custom service endpoint, as a hostname or hostname:port. The default is
        #   nil, indicating to use the default endpoint in the current universe domain.
        #   @return [::String,nil]
        # @!attribute [rw] credentials
        #   Credentials to send with calls. You may provide any of the following types:
        #    *  (`Google::Auth::Credentials`) A googleauth credentials object
        #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
        #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
        #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
        #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
        #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
        #    *  (`nil`) indicating no credentials
        #
        #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
        #     is deprecated. Providing an unvalidated credential configuration to
        #     Google APIs can compromise the security of your systems and data.
        #
        #   @example
        #
        #     # The recommended way to provide credentials is to use the `make_creds` method
        #     # on the appropriate credentials class for your environment.
        #
        #     require "googleauth"
        #
        #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
        #       json_key_io: ::File.open("/path/to/keyfile.json")
        #     )
        #
        #     client = ::Grafeas::V1::Grafeas::Client.new do |config|
        #       config.credentials = credentials
        #     end
        #
        #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
        #   external source for authentication to Google Cloud, you must validate it before
        #   providing it to a Google API client library. Providing an unvalidated credential
        #   configuration to Google APIs can compromise the security of your systems and data.
        #   For more information, refer to [Validate credential configurations from external
        #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
        #   @return [::Object]
        # @!attribute [rw] scope
        #   The OAuth scopes
        #   @return [::Array<::String>]
        # @!attribute [rw] lib_name
        #   The library name as recorded in instrumentation and logging
        #   @return [::String]
        # @!attribute [rw] lib_version
        #   The library version as recorded in instrumentation and logging
        #   @return [::String]
        # @!attribute [rw] channel_args
        #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
        #   `GRPC::Core::Channel` object is provided as the credential.
        #   @return [::Hash]
        # @!attribute [rw] interceptors
        #   An array of interceptors that are run before calls are executed.
        #   @return [::Array<::GRPC::ClientInterceptor>]
        # @!attribute [rw] timeout
        #   The call timeout in seconds.
        #   @return [::Numeric]
        # @!attribute [rw] metadata
        #   Additional gRPC headers to be sent with the call.
        #   @return [::Hash{::Symbol=>::String}]
        # @!attribute [rw] retry_policy
        #   The retry policy. The value is a hash with the following keys:
        #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
        #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
        #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
        #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
        #       trigger a retry.
        #   @return [::Hash]
        # @!attribute [rw] quota_project
        #   A separate project against which to charge quota.
        #   @return [::String]
        # @!attribute [rw] universe_domain
        #   The universe domain within which to make requests. This determines the
        #   default endpoint URL. The default value of nil uses the environment
        #   universe (usually the default "googleapis.com" universe).
        #   @return [::String,nil]
        # @!attribute [rw] logger
        #   A custom logger to use for request/response debug logging, or the value
        #   `:default` (the default) to construct a default logger, or `nil` to
        #   explicitly disable logging.
        #   @return [::Logger,:default,nil]
        #
        class Configuration
          extend ::Gapic::Config

          # @private
          # The endpoint specific to the default "googleapis.com" universe. Deprecated.
          DEFAULT_ENDPOINT = nil

          config_attr :endpoint,      nil, ::String, nil
          config_attr :credentials,   nil do |value|
            allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
            allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
            allowed.any? { |klass| klass === value }
          end
          config_attr :scope,         nil, ::String, ::Array, nil
          config_attr :lib_name,      nil, ::String, nil
          config_attr :lib_version,   nil, ::String, nil
          config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
          config_attr :interceptors,  nil, ::Array, nil
          config_attr :timeout,       nil, ::Numeric, nil
          config_attr :metadata,      nil, ::Hash, nil
          config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
          config_attr :quota_project, nil, ::String, nil
          config_attr :universe_domain, nil, ::String, nil
          config_attr :logger, :default, ::Logger, nil, :default

          # @private
          def initialize parent_config = nil
            @parent_config = parent_config unless parent_config.nil?

            yield self if block_given?
          end

          ##
          # Configurations for individual RPCs
          # @return [Rpcs]
          #
          def rpcs
            @rpcs ||= begin
              parent_rpcs = nil
              parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
              Rpcs.new parent_rpcs
            end
          end

          ##
          # Configuration for the channel pool
          # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
          #
          def channel_pool
            @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
          end

          ##
          # Configuration RPC class for the Grafeas API.
          #
          # Includes fields providing the configuration for each RPC in this service.
          # Each configuration object is of type `Gapic::Config::Method` and includes
          # the following configuration fields:
          #
          #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
          #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
          #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
          #     include the following keys:
          #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
          #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
          #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
          #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
          #         trigger a retry.
          #
          class Rpcs
            ##
            # RPC-specific configuration for `get_occurrence`
            # @return [::Gapic::Config::Method]
            #
            attr_reader :get_occurrence
            ##
            # RPC-specific configuration for `list_occurrences`
            # @return [::Gapic::Config::Method]
            #
            attr_reader :list_occurrences
            ##
            # RPC-specific configuration for `delete_occurrence`
            # @return [::Gapic::Config::Method]
            #
            attr_reader :delete_occurrence
            ##
            # RPC-specific configuration for `create_occurrence`
            # @return [::Gapic::Config::Method]
            #
            attr_reader :create_occurrence
            ##
            # RPC-specific configuration for `batch_create_occurrences`
            # @return [::Gapic::Config::Method]
            #
            attr_reader :batch_create_occurrences
            ##
            # RPC-specific configuration for `update_occurrence`
            # @return [::Gapic::Config::Method]
            #
            attr_reader :update_occurrence
            ##
            # RPC-specific configuration for `get_occurrence_note`
            # @return [::Gapic::Config::Method]
            #
            attr_reader :get_occurrence_note
            ##
            # RPC-specific configuration for `get_note`
            # @return [::Gapic::Config::Method]
            #
            attr_reader :get_note
            ##
            # RPC-specific configuration for `list_notes`
            # @return [::Gapic::Config::Method]
            #
            attr_reader :list_notes
            ##
            # RPC-specific configuration for `delete_note`
            # @return [::Gapic::Config::Method]
            #
            attr_reader :delete_note
            ##
            # RPC-specific configuration for `create_note`
            # @return [::Gapic::Config::Method]
            #
            attr_reader :create_note
            ##
            # RPC-specific configuration for `batch_create_notes`
            # @return [::Gapic::Config::Method]
            #
            attr_reader :batch_create_notes
            ##
            # RPC-specific configuration for `update_note`
            # @return [::Gapic::Config::Method]
            #
            attr_reader :update_note
            ##
            # RPC-specific configuration for `list_note_occurrences`
            # @return [::Gapic::Config::Method]
            #
            attr_reader :list_note_occurrences

            # @private
            def initialize parent_rpcs = nil
              get_occurrence_config = parent_rpcs.get_occurrence if parent_rpcs.respond_to? :get_occurrence
              @get_occurrence = ::Gapic::Config::Method.new get_occurrence_config
              list_occurrences_config = parent_rpcs.list_occurrences if parent_rpcs.respond_to? :list_occurrences
              @list_occurrences = ::Gapic::Config::Method.new list_occurrences_config
              delete_occurrence_config = parent_rpcs.delete_occurrence if parent_rpcs.respond_to? :delete_occurrence
              @delete_occurrence = ::Gapic::Config::Method.new delete_occurrence_config
              create_occurrence_config = parent_rpcs.create_occurrence if parent_rpcs.respond_to? :create_occurrence
              @create_occurrence = ::Gapic::Config::Method.new create_occurrence_config
              batch_create_occurrences_config = parent_rpcs.batch_create_occurrences if parent_rpcs.respond_to? :batch_create_occurrences
              @batch_create_occurrences = ::Gapic::Config::Method.new batch_create_occurrences_config
              update_occurrence_config = parent_rpcs.update_occurrence if parent_rpcs.respond_to? :update_occurrence
              @update_occurrence = ::Gapic::Config::Method.new update_occurrence_config
              get_occurrence_note_config = parent_rpcs.get_occurrence_note if parent_rpcs.respond_to? :get_occurrence_note
              @get_occurrence_note = ::Gapic::Config::Method.new get_occurrence_note_config
              get_note_config = parent_rpcs.get_note if parent_rpcs.respond_to? :get_note
              @get_note = ::Gapic::Config::Method.new get_note_config
              list_notes_config = parent_rpcs.list_notes if parent_rpcs.respond_to? :list_notes
              @list_notes = ::Gapic::Config::Method.new list_notes_config
              delete_note_config = parent_rpcs.delete_note if parent_rpcs.respond_to? :delete_note
              @delete_note = ::Gapic::Config::Method.new delete_note_config
              create_note_config = parent_rpcs.create_note if parent_rpcs.respond_to? :create_note
              @create_note = ::Gapic::Config::Method.new create_note_config
              batch_create_notes_config = parent_rpcs.batch_create_notes if parent_rpcs.respond_to? :batch_create_notes
              @batch_create_notes = ::Gapic::Config::Method.new batch_create_notes_config
              update_note_config = parent_rpcs.update_note if parent_rpcs.respond_to? :update_note
              @update_note = ::Gapic::Config::Method.new update_note_config
              list_note_occurrences_config = parent_rpcs.list_note_occurrences if parent_rpcs.respond_to? :list_note_occurrences
              @list_note_occurrences = ::Gapic::Config::Method.new list_note_occurrences_config

              yield self if block_given?
            end
          end
        end
      end
    end
  end
end
