# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Reviews
        module V1beta
          # Attributes.
          # @!attribute [rw] aggregator_name
          #   @return [::String]
          #     Optional. The name of the aggregator of the product reviews.
          #
          #     A publisher may use a reviews aggregator to manage reviews and provide
          #     the feeds. This element indicates the use of an aggregator and contains
          #     information about the aggregator.
          # @!attribute [rw] subclient_name
          #   @return [::String]
          #     Optional. The name of the subclient of the product reviews.
          #
          #     The subclient is an identifier of the product review source.
          #     It should be equivalent to the directory provided in the file data source
          #     path.
          # @!attribute [rw] publisher_name
          #   @return [::String]
          #     Optional. The name of the publisher of the product reviews.
          #
          #     The information about the publisher, which may be a retailer,
          #     manufacturer, reviews service company, or any entity that publishes
          #     product reviews.
          # @!attribute [rw] publisher_favicon
          #   @return [::String]
          #     Optional. A link to the company favicon of the publisher. The image
          #     dimensions should be favicon size: 16x16 pixels. The image format should be
          #     GIF, JPG or PNG.
          # @!attribute [rw] reviewer_id
          #   @return [::String]
          #     Optional. The author of the product review.
          #
          #     A permanent, unique identifier for the author of the review in the
          #     publisher's system.
          # @!attribute [rw] reviewer_is_anonymous
          #   @return [::Boolean]
          #     Optional. Set to true if the reviewer should remain anonymous.
          # @!attribute [rw] reviewer_username
          #   @return [::String]
          #     Optional. The name of the reviewer of the product review.
          # @!attribute [rw] review_language
          #   @return [::String]
          #     Optional. The language of the review defined by BCP-47 language code.
          # @!attribute [rw] review_country
          #   @return [::String]
          #     Optional. The country of the review defined by ISO 3166-1 Alpha-2 Country
          #     Code.
          # @!attribute [rw] review_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Required. The timestamp indicating when the review was written.
          # @!attribute [rw] title
          #   @return [::String]
          #     Optional. The title of the review.
          # @!attribute [rw] content
          #   @return [::String]
          #     Optional. The content of the review. If empty, the content might still get
          #     populated from pros and cons.
          # @!attribute [rw] pros
          #   @return [::Array<::String>]
          #     Optional. Contains the advantages based on the opinion of the reviewer.
          #     Omit boilerplate text like "pro:" unless it was written by the reviewer.
          # @!attribute [rw] cons
          #   @return [::Array<::String>]
          #     Optional. Contains the disadvantages based on the opinion of the reviewer.
          #     Omit boilerplate text like "con:" unless it was written by the reviewer.
          # @!attribute [rw] review_link
          #   @return [::Google::Shopping::Merchant::Reviews::V1beta::ProductReviewAttributes::ReviewLink]
          #     Optional. The URI of the review landing page.
          # @!attribute [rw] reviewer_image_links
          #   @return [::Array<::String>]
          #     Optional. A URI to an image of the reviewed product created by the review
          #     author. The URI does not have to end with an image file extension.
          # @!attribute [rw] min_rating
          #   @return [::Integer]
          #     Optional. Contains the ratings associated with the review.
          #     The minimum possible number for the rating. This should be the worst
          #     possible rating and should not be a value for no rating.
          # @!attribute [rw] max_rating
          #   @return [::Integer]
          #     Optional. The maximum possible number for the rating. The value of the max
          #     rating must be greater than the value of the min attribute.
          # @!attribute [rw] rating
          #   @return [::Float]
          #     Optional. The reviewer's overall rating of the product.
          # @!attribute [rw] product_names
          #   @return [::Array<::String>]
          #     Optional. Descriptive name of a product.
          # @!attribute [rw] product_links
          #   @return [::Array<::String>]
          #     Optional. The URI of the product. This URI can have the same value as the
          #     `review_link` element, if the review URI and the product URI are the
          #     same.
          # @!attribute [rw] asins
          #   @return [::Array<::String>]
          #     Optional. Contains ASINs (Amazon Standard Identification Numbers)
          #     associated with a product.
          # @!attribute [rw] gtins
          #   @return [::Array<::String>]
          #     Optional. Contains GTINs (global trade item numbers) associated with a
          #     product. Sub-types of GTINs (e.g. UPC, EAN, ISBN, JAN) are supported.
          # @!attribute [rw] mpns
          #   @return [::Array<::String>]
          #     Optional. Contains MPNs (manufacturer part numbers) associated with a
          #     product.
          # @!attribute [rw] skus
          #   @return [::Array<::String>]
          #     Optional. Contains SKUs (stock keeping units) associated with a product.
          #     Often this matches the product Offer Id in the product feed.
          # @!attribute [rw] brands
          #   @return [::Array<::String>]
          #     Optional. Contains brand names associated with a product.
          # @!attribute [rw] is_spam
          #   @return [::Boolean]
          #     Optional. Indicates whether the review is marked as spam in the publisher's
          #     system.
          # @!attribute [rw] is_verified_purchase
          #   @return [::Boolean]
          #     Optional. Indicates whether the reviewer's purchase is verified.
          # @!attribute [rw] is_incentivized_review
          #   @return [::Boolean]
          #     Optional. Indicates whether the review is incentivized.
          # @!attribute [rw] collection_method
          #   @return [::Google::Shopping::Merchant::Reviews::V1beta::ProductReviewAttributes::CollectionMethod]
          #     Optional. The method used to collect the review.
          # @!attribute [rw] transaction_id
          #   @return [::String]
          #     Optional. A permanent, unique identifier for the transaction associated
          #     with the review in the publisher's system. This ID can be used to indicate
          #     that multiple reviews are associated with the same transaction.
          class ProductReviewAttributes
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The URI of the review landing page.
            # @!attribute [rw] type
            #   @return [::Google::Shopping::Merchant::Reviews::V1beta::ProductReviewAttributes::ReviewLink::Type]
            #     Optional. Type of the review URI.
            # @!attribute [rw] link
            #   @return [::String]
            #     Optional. The URI of the review landing page.
            #     For example: `http://www.example.com/review_5.html`.
            class ReviewLink
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Type of the review URI.
              module Type
                # Type unspecified.
                TYPE_UNSPECIFIED = 0

                # The review page contains only this single review.
                SINGLETON = 1

                # The review page contains a group of reviews including this review.
                GROUP = 2
              end
            end

            # The method used to collect the review.
            module CollectionMethod
              # Collection method unspecified.
              COLLECTION_METHOD_UNSPECIFIED = 0

              # The user was not responding to a specific solicitation when they
              # submitted the review.
              UNSOLICITED = 1

              # The user submitted the review in response to a solicitation after
              # fulfillment of the user's order.
              POST_FULFILLMENT = 2
            end
          end

          # Product review status.
          # @!attribute [r] destination_statuses
          #   @return [::Array<::Google::Shopping::Merchant::Reviews::V1beta::ProductReviewStatus::ProductReviewDestinationStatus>]
          #     Output only. The intended destinations for the product review.
          # @!attribute [r] item_level_issues
          #   @return [::Array<::Google::Shopping::Merchant::Reviews::V1beta::ProductReviewStatus::ProductReviewItemLevelIssue>]
          #     Output only. A list of all issues associated with the product review.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Date on which the item has been created, in [ISO
          #     8601](http://en.wikipedia.org/wiki/ISO_8601) format.
          # @!attribute [r] last_update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Date on which the item has been last updated, in [ISO
          #     8601](http://en.wikipedia.org/wiki/ISO_8601) format.
          class ProductReviewStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The destination status of the product review status.
            # @!attribute [r] reporting_context
            #   @return [::Google::Shopping::Type::ReportingContext::ReportingContextEnum]
            #     Output only. The name of the reporting context.
            class ProductReviewDestinationStatus
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The ItemLevelIssue of the product review status.
            # @!attribute [r] code
            #   @return [::String]
            #     Output only. The error code of the issue.
            # @!attribute [r] severity
            #   @return [::Google::Shopping::Merchant::Reviews::V1beta::ProductReviewStatus::ProductReviewItemLevelIssue::Severity]
            #     Output only. How this issue affects serving of the product review.
            # @!attribute [r] resolution
            #   @return [::String]
            #     Output only. Whether the issue can be resolved by the merchant.
            # @!attribute [r] attribute
            #   @return [::String]
            #     Output only. The attribute's name, if the issue is caused by a single
            #     attribute.
            # @!attribute [r] reporting_context
            #   @return [::Google::Shopping::Type::ReportingContext::ReportingContextEnum]
            #     Output only. The reporting context the issue applies to.
            # @!attribute [r] description
            #   @return [::String]
            #     Output only. A short issue description in English.
            # @!attribute [r] detail
            #   @return [::String]
            #     Output only. A detailed issue description in English.
            # @!attribute [r] documentation
            #   @return [::String]
            #     Output only. The URL of a web page to help with resolving this issue.
            class ProductReviewItemLevelIssue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # How the issue affects the serving of the product review.
              module Severity
                # Not specified.
                SEVERITY_UNSPECIFIED = 0

                # This issue represents a warning and does not have a direct affect
                # on the product review.
                NOT_IMPACTED = 1

                # Issue disapproves the product review.
                DISAPPROVED = 2
              end
            end
          end
        end
      end
    end
  end
end
