# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Reviews
        module V1beta
          # Request message for the GetProductReview method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The ID of the merchant review.
          #     Format: accounts/\\{account}/productReviews/\\{productReview}
          class GetProductReviewRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `DeleteProductReview` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The ID of the Product review.
          #     Format: accounts/\\{account}/productReviews/\\{productReview}
          class DeleteProductReviewRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the ListProductReviews method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The account to list product reviews for.
          #     Format: accounts/\\{account}
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of products to return. The service may return
          #     fewer than this value.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from a previous `ListProductReviews` call.
          #     Provide this to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to `ListProductReviews`
          #     must match the call that provided the page token.
          class ListProductReviewsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `InsertProductReview` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The account where the product review will be inserted.
          #     Format: accounts/\\{account}
          # @!attribute [rw] product_review
          #   @return [::Google::Shopping::Merchant::Reviews::V1beta::ProductReview]
          #     Required. The product review to insert.
          # @!attribute [rw] data_source
          #   @return [::String]
          #     Required. Format:
          #     `accounts/{account}/dataSources/{datasource}`.
          class InsertProductReviewRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # response message for the ListProductReviews method.
          # @!attribute [rw] product_reviews
          #   @return [::Array<::Google::Shopping::Merchant::Reviews::V1beta::ProductReview>]
          #     The product review.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListProductReviewsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A review for a product. For more information, see
          # [Introduction to Product Review
          # Feeds](https://developers.google.com/product-review-feeds)
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The name of the product review.
          #     Format:
          #     `"{productreview.name=accounts/{account}/productReviews/{productReview}}"`
          # @!attribute [rw] product_review_id
          #   @return [::String]
          #     Required. The permanent, unique identifier for the product review in the
          #     publisher’s system.
          # @!attribute [rw] product_review_attributes
          #   @return [::Google::Shopping::Merchant::Reviews::V1beta::ProductReviewAttributes]
          #     Optional. A list of product review attributes.
          # @!attribute [rw] custom_attributes
          #   @return [::Array<::Google::Shopping::Type::CustomAttribute>]
          #     Optional. A list of custom (merchant-provided) attributes.
          # @!attribute [r] data_source
          #   @return [::String]
          #     Output only. The primary data source of the product review.
          # @!attribute [r] product_review_status
          #   @return [::Google::Shopping::Merchant::Reviews::V1beta::ProductReviewStatus]
          #     Output only. The status of a product review, data validation issues, that
          #     is, information about a product review computed asynchronously.
          class ProductReview
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
