# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Reviews
        module V1beta
          # Attributes.
          # @!attribute [rw] merchant_id
          #   @return [::String]
          #     Required. Must be unique and stable across all requests. In other words, if
          #     a request today and another 90 days ago refer to the same merchant, they
          #     must have the same id.
          # @!attribute [rw] merchant_display_name
          #   @return [::String]
          #     Optional. Human-readable display name for the merchant.
          # @!attribute [rw] merchant_link
          #   @return [::String]
          #     Optional. URL to the merchant's main website. Do not use a redirect URL for
          #     this value. In other words, the value should point directly to the
          #     merchant's site.
          # @!attribute [rw] merchant_rating_link
          #   @return [::String]
          #     Optional. URL to the landing page that hosts the reviews for this merchant.
          #     Do not use a redirect URL.
          # @!attribute [rw] min_rating
          #   @return [::Integer]
          #     Optional. The minimum possible number for the rating. This should be the
          #     worst possible rating and should not be a value for no rating.
          # @!attribute [rw] max_rating
          #   @return [::Integer]
          #     Optional. The maximum possible number for the rating. The value of the max
          #     rating must be greater than the value of the min rating.
          # @!attribute [rw] rating
          #   @return [::Float]
          #     Optional. The reviewer's overall rating of the merchant.
          # @!attribute [rw] title
          #   @return [::String]
          #     Optional. The title of the review.
          # @!attribute [rw] content
          #   @return [::String]
          #     Required. This should be any freeform text provided by the user and should
          #     not be truncated. If multiple responses to different questions are
          #     provided, all responses should be included, with the minimal context for
          #     the responses to make sense. Context should not be provided if questions
          #     were left unanswered.
          # @!attribute [rw] reviewer_id
          #   @return [::String]
          #     Optional. A permanent, unique identifier for the author of the review in
          #     the publisher's system.
          # @!attribute [rw] reviewer_username
          #   @return [::String]
          #     Optional. Display name of the review author.
          # @!attribute [rw] is_anonymous
          #   @return [::Boolean]
          #     Optional. Set to true if the reviewer should remain anonymous.
          # @!attribute [rw] collection_method
          #   @return [::Google::Shopping::Merchant::Reviews::V1beta::MerchantReviewAttributes::CollectionMethod]
          #     Optional. The method used to collect the review.
          # @!attribute [rw] review_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Required. The timestamp indicating when the review was written.
          # @!attribute [rw] review_language
          #   @return [::String]
          #     Optional. The language of the review defined by BCP-47 language code.
          # @!attribute [rw] review_country
          #   @return [::String]
          #     Optional. The country where the reviewer made the order defined by ISO
          #     3166-1 Alpha-2 Country Code.
          class MerchantReviewAttributes
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The method used to collect the review.
            module CollectionMethod
              # Collection method unspecified.
              COLLECTION_METHOD_UNSPECIFIED = 0

              # The user was not responding to a specific solicitation when they
              # submitted the review.
              MERCHANT_UNSOLICITED = 1

              # The user submitted the review in response to a solicitation when the
              # user placed an order.
              POINT_OF_SALE = 2

              # The user submitted the review in response to a solicitation after
              # fulfillment of the user's order.
              AFTER_FULFILLMENT = 3
            end
          end

          # The status of a merchant review, data validation issues, that is, information
          # about a merchant review computed asynchronously.
          # @!attribute [r] destination_statuses
          #   @return [::Array<::Google::Shopping::Merchant::Reviews::V1beta::MerchantReviewStatus::MerchantReviewDestinationStatus>]
          #     Output only. The intended destinations for the merchant review.
          # @!attribute [r] item_level_issues
          #   @return [::Array<::Google::Shopping::Merchant::Reviews::V1beta::MerchantReviewStatus::MerchantReviewItemLevelIssue>]
          #     Output only. A list of all issues associated with the merchant review.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Date on which the item has been created, in [ISO
          #     8601](http://en.wikipedia.org/wiki/ISO_8601) format.
          # @!attribute [r] last_update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Date on which the item has been last updated, in [ISO
          #     8601](http://en.wikipedia.org/wiki/ISO_8601) format.
          class MerchantReviewStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The destination status of the merchant review status.
            # @!attribute [r] reporting_context
            #   @return [::Google::Shopping::Type::ReportingContext::ReportingContextEnum]
            #     Output only. The name of the reporting context.
            class MerchantReviewDestinationStatus
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The ItemLevelIssue of the merchant review status.
            # @!attribute [r] code
            #   @return [::String]
            #     Output only. The error code of the issue.
            # @!attribute [r] severity
            #   @return [::Google::Shopping::Merchant::Reviews::V1beta::MerchantReviewStatus::MerchantReviewItemLevelIssue::Severity]
            #     Output only. How this issue affects serving of the merchant review.
            # @!attribute [r] resolution
            #   @return [::String]
            #     Output only. Whether the issue can be resolved by the merchant.
            # @!attribute [r] attribute
            #   @return [::String]
            #     Output only. The attribute's name, if the issue is caused by a single
            #     attribute.
            # @!attribute [r] reporting_context
            #   @return [::Google::Shopping::Type::ReportingContext::ReportingContextEnum]
            #     Output only. The reporting context the issue applies to.
            # @!attribute [r] description
            #   @return [::String]
            #     Output only. A short issue description in English.
            # @!attribute [r] detail
            #   @return [::String]
            #     Output only. A detailed issue description in English.
            # @!attribute [r] documentation
            #   @return [::String]
            #     Output only. The URL of a web page to help with resolving this issue.
            class MerchantReviewItemLevelIssue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # How the issue affects the serving of the merchant review.
              module Severity
                # Not specified.
                SEVERITY_UNSPECIFIED = 0

                # This issue represents a warning and does not have a direct affect
                # on the merchant review.
                NOT_IMPACTED = 1

                # Issue disapproves the merchant review.
                DISAPPROVED = 2
              end
            end
          end
        end
      end
    end
  end
end
