# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Reviews
        module V1beta
          # Request message for the `GetMerchantReview` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The ID of the merchant review.
          #     Format: accounts/\\{account}/merchantReviews/\\{merchantReview}
          class GetMerchantReviewRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `DeleteMerchantReview` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The ID of the merchant review.
          #     Format: accounts/\\{account}/merchantReviews/\\{merchantReview}
          class DeleteMerchantReviewRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `ListMerchantsReview` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The account to list merchant reviews for.
          #     Format: accounts/\\{account}
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of merchant reviews to return. The service can
          #     return fewer than this value. The maximum value is 1000; values above 1000
          #     are coerced to 1000. If unspecified, the maximum number of reviews is
          #     returned.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from a previous `ListMerchantReviews`
          #     call. Provide this to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to `ListMerchantReviews`
          #     must match the call that provided the page token.
          class ListMerchantReviewsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `InsertMerchantReview` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The account where the merchant review will be inserted.
          #     Format: accounts/\\{account}
          # @!attribute [rw] merchant_review
          #   @return [::Google::Shopping::Merchant::Reviews::V1beta::MerchantReview]
          #     Required. The merchant review to insert.
          # @!attribute [rw] data_source
          #   @return [::String]
          #     Required. The data source of the
          #     [merchantreview](https://support.google.com/merchants/answer/7045996?sjid=5253581244217581976-EU)
          #     Format:
          #     `accounts/{account}/dataSources/{datasource}`.
          class InsertMerchantReviewRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the `ListMerchantsReview` method.
          # @!attribute [rw] merchant_reviews
          #   @return [::Array<::Google::Shopping::Merchant::Reviews::V1beta::MerchantReview>]
          #     The merchant review.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     The token to retrieve the next page of results.
          class ListMerchantReviewsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A review for a merchant. For more information, see
          # [Introduction to Merchant Review
          # Feeds](https://developers.google.com/merchant-review-feeds)
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The name of the merchant review.
          #     Format:
          #     `"{merchantreview.name=accounts/{account}/merchantReviews/{merchantReview}}"`
          # @!attribute [rw] merchant_review_id
          #   @return [::String]
          #     Required. The user provided merchant review ID to uniquely identify the
          #     merchant review.
          # @!attribute [rw] merchant_review_attributes
          #   @return [::Google::Shopping::Merchant::Reviews::V1beta::MerchantReviewAttributes]
          #     Optional. A list of merchant review attributes.
          # @!attribute [rw] custom_attributes
          #   @return [::Array<::Google::Shopping::Type::CustomAttribute>]
          #     Optional. A list of custom (merchant-provided) attributes. It can also be
          #     used for submitting any attribute of the data specification in its generic
          #     form (for example,
          #     `{ "name": "size type", "value": "regular" }`).
          #     This is useful for submitting attributes not explicitly exposed by the
          #     API, such as experimental attributes.
          #     Maximum allowed number of characters for each
          #     custom attribute is 10240 (represents sum of characters for name and
          #     value). Maximum 2500 custom attributes can be set per product, with total
          #     size of 102.4kB. Underscores in custom attribute names are replaced by
          #     spaces upon insertion.
          # @!attribute [r] data_source
          #   @return [::String]
          #     Output only. The primary data source of the merchant review.
          # @!attribute [r] merchant_review_status
          #   @return [::Google::Shopping::Merchant::Reviews::V1beta::MerchantReviewStatus]
          #     Output only. The status of a merchant review, data validation issues, that
          #     is, information about a merchant review computed asynchronously.
          class MerchantReview
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
