# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Reports
        module V1
          # Request message for the `ReportService.Search` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Id of the account making the call. Must be a standalone account
          #     or an MCA subaccount. Format: accounts/\\{account}
          # @!attribute [rw] query
          #   @return [::String]
          #     Required. Query that defines a report to be retrieved.
          #
          #     For details on how to construct your query, see the [Query Language
          #     guide](/merchant/api/guides/reports/query-language). For the full list of
          #     available tables and fields, see the [Available
          #     fields](/merchant/api/reference/rest/reports_v1/accounts.reports).
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. Number of `ReportRows` to retrieve in a single page. Defaults to
          #     1000. Values above 5000 are coerced to 5000.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. Token of the page to retrieve. If not specified, the first page
          #     of results is returned. In order to request the next page of results, the
          #     value obtained from `next_page_token` in the previous response should be
          #     used.
          class SearchRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the `ReportService.Search` method.
          # @!attribute [rw] results
          #   @return [::Array<::Google::Shopping::Merchant::Reports::V1::ReportRow>]
          #     Rows that matched the search query.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token which can be sent as `page_token` to retrieve the next page. If
          #     omitted, there are no subsequent pages.
          class SearchResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Result row returned from the search query.
          #
          # Only the message corresponding to the queried table is populated in the
          # response. Within the populated message, only the fields requested explicitly
          # in the query are populated.
          # @!attribute [rw] product_performance_view
          #   @return [::Google::Shopping::Merchant::Reports::V1::ProductPerformanceView]
          #     Fields available for query in `product_performance_view` table.
          # @!attribute [rw] non_product_performance_view
          #   @return [::Google::Shopping::Merchant::Reports::V1::NonProductPerformanceView]
          #     Fields available for query in `non_product_performance_view` table.
          # @!attribute [rw] product_view
          #   @return [::Google::Shopping::Merchant::Reports::V1::ProductView]
          #     Fields available for query in `product_view` table.
          # @!attribute [rw] price_competitiveness_product_view
          #   @return [::Google::Shopping::Merchant::Reports::V1::PriceCompetitivenessProductView]
          #     Fields available for query in `price_competitiveness_product_view` table.
          # @!attribute [rw] price_insights_product_view
          #   @return [::Google::Shopping::Merchant::Reports::V1::PriceInsightsProductView]
          #     Fields available for query in `price_insights_product_view` table.
          # @!attribute [rw] best_sellers_product_cluster_view
          #   @return [::Google::Shopping::Merchant::Reports::V1::BestSellersProductClusterView]
          #     Fields available for query in `best_sellers_product_cluster_view` table.
          # @!attribute [rw] best_sellers_brand_view
          #   @return [::Google::Shopping::Merchant::Reports::V1::BestSellersBrandView]
          #     Fields available for query in `best_sellers_brand_view` table.
          # @!attribute [rw] competitive_visibility_competitor_view
          #   @return [::Google::Shopping::Merchant::Reports::V1::CompetitiveVisibilityCompetitorView]
          #     Fields available for query in `competitive_visibility_competitor_view`
          #     table.
          # @!attribute [rw] competitive_visibility_top_merchant_view
          #   @return [::Google::Shopping::Merchant::Reports::V1::CompetitiveVisibilityTopMerchantView]
          #     Fields available for query in `competitive_visibility_top_merchant_view`
          #     table.
          # @!attribute [rw] competitive_visibility_benchmark_view
          #   @return [::Google::Shopping::Merchant::Reports::V1::CompetitiveVisibilityBenchmarkView]
          #     Fields available for query in `competitive_visibility_benchmark_view`
          #     table.
          class ReportRow
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Fields available for query in `product_performance_view` table.
          #
          # Product performance data for your account, including performance metrics (for
          # example, `clicks`) and dimensions according to which performance metrics are
          # segmented (for example, `offer_id`). Values of product dimensions, such as
          # `offer_id`, reflect the state of a product at the time of the impression.
          #
          # Segment fields cannot be selected in queries without also selecting at least
          # one metric field.
          #
          # Values are only set for fields requested explicitly in the request's search
          # query.
          # @!attribute [rw] marketing_method
          #   @return [::Google::Shopping::Merchant::Reports::V1::MarketingMethod::MarketingMethodEnum]
          #     Marketing method to which metrics apply. Segment.
          # @!attribute [rw] date
          #   @return [::Google::Type::Date]
          #     Date in the merchant timezone to which metrics apply. Segment.
          #
          #     Condition on `date` is required in the `WHERE` clause.
          # @!attribute [rw] week
          #   @return [::Google::Type::Date]
          #     First day of the week (Monday) of the metrics date in the merchant
          #     timezone. Segment.
          # @!attribute [rw] customer_country_code
          #   @return [::String]
          #     Code of the country where the customer is located at the time of the event.
          #     Represented in the ISO 3166 format. Segment.
          #
          #     If the customer country cannot be determined, a special 'ZZ' code is
          #     returned.
          # @!attribute [rw] offer_id
          #   @return [::String]
          #     Merchant-provided id of the product. Segment.
          # @!attribute [rw] title
          #   @return [::String]
          #     Title of the product. Segment.
          # @!attribute [rw] brand
          #   @return [::String]
          #     Brand of the product. Segment.
          # @!attribute [rw] category_l1
          #   @return [::String]
          #     [Product category (1st
          #     level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
          #     in Google's product taxonomy. Segment.
          # @!attribute [rw] category_l2
          #   @return [::String]
          #     [Product category (2nd
          #     level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
          #     in Google's product taxonomy. Segment.
          # @!attribute [rw] category_l3
          #   @return [::String]
          #     [Product category (3rd
          #     level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
          #     in Google's product taxonomy. Segment.
          # @!attribute [rw] category_l4
          #   @return [::String]
          #     [Product category (4th
          #     level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
          #     in Google's product taxonomy. Segment.
          # @!attribute [rw] category_l5
          #   @return [::String]
          #     [Product category (5th
          #     level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
          #     in Google's product taxonomy. Segment.
          # @!attribute [rw] product_type_l1
          #   @return [::String]
          #     [Product type (1st
          #     level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
          #     in merchant's own product taxonomy. Segment.
          # @!attribute [rw] product_type_l2
          #   @return [::String]
          #     [Product type (2nd
          #     level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
          #     in merchant's own product taxonomy. Segment.
          # @!attribute [rw] product_type_l3
          #   @return [::String]
          #     [Product type (3rd
          #     level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
          #     in merchant's own product taxonomy. Segment.
          # @!attribute [rw] product_type_l4
          #   @return [::String]
          #     [Product type (4th
          #     level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
          #     in merchant's own product taxonomy. Segment.
          # @!attribute [rw] product_type_l5
          #   @return [::String]
          #     [Product type (5th
          #     level)](https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
          #     in merchant's own product taxonomy. Segment.
          # @!attribute [rw] custom_label0
          #   @return [::String]
          #     Custom label 0 for custom grouping of products. Segment.
          # @!attribute [rw] custom_label1
          #   @return [::String]
          #     Custom label 1 for custom grouping of products. Segment.
          # @!attribute [rw] custom_label2
          #   @return [::String]
          #     Custom label 2 for custom grouping of products. Segment.
          # @!attribute [rw] custom_label3
          #   @return [::String]
          #     Custom label 3 for custom grouping of products. Segment.
          # @!attribute [rw] custom_label4
          #   @return [::String]
          #     Custom label 4 for custom grouping of products. Segment.
          # @!attribute [rw] clicks
          #   @return [::Integer]
          #     Number of clicks. Metric.
          # @!attribute [rw] impressions
          #   @return [::Integer]
          #     Number of times merchant's products are shown. Metric.
          # @!attribute [rw] click_through_rate
          #   @return [::Float]
          #     Click-through rate - the number of clicks merchant's products receive
          #     (clicks) divided by the number of times the products are shown
          #     (impressions). Metric.
          # @!attribute [rw] conversions
          #   @return [::Float]
          #     Number of conversions attributed to the product, reported on the conversion
          #     date. Depending on the attribution model, a conversion might be distributed
          #     across multiple clicks, where each click gets its own credit assigned. This
          #     metric is a sum of all such credits. Metric.
          #
          #     Available only for the `FREE` traffic source.
          # @!attribute [rw] conversion_value
          #   @return [::Google::Shopping::Type::Price]
          #     Value of conversions attributed to the product, reported on the conversion
          #     date. Metric.
          #
          #     Available only for the `FREE` traffic source.
          # @!attribute [rw] conversion_rate
          #   @return [::Float]
          #     Number of conversions divided by the number of clicks, reported on the
          #     impression date. Metric.
          #
          #     Available only for the `FREE` traffic source.
          class ProductPerformanceView
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Fields available for query in `product_view` table.
          #
          # Products in the current inventory. Products in this table are the same as in
          # Products sub-API but not all product attributes from Products sub-API are
          # available for query in this table. In contrast to Products sub-API, this
          # table allows to filter the returned list of products by product attributes.
          # To retrieve a single product by `id` or list all products, Products sub-API
          # should be used.
          #
          # Values are only set for fields requested explicitly in the request's search
          # query.
          # @!attribute [rw] id
          #   @return [::String]
          #     REST ID of the product, in the form of
          #     `channel~languageCode~feedLabel~offerId`. Merchant API methods that operate
          #     on products take this as their `name` parameter.
          #
          #     Required in the `SELECT` clause.
          # @!attribute [rw] channel
          #   @return [::Google::Shopping::Type::Channel::ChannelEnum]
          #     Channel of the product. Can be `ONLINE` or `LOCAL`.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     Language code of the product in BCP 47 format.
          # @!attribute [rw] feed_label
          #   @return [::String]
          #     Feed label of the product.
          # @!attribute [rw] offer_id
          #   @return [::String]
          #     Merchant-provided id of the product.
          # @!attribute [rw] title
          #   @return [::String]
          #     Title of the product.
          # @!attribute [rw] brand
          #   @return [::String]
          #     Brand of the product.
          # @!attribute [rw] category_l1
          #   @return [::String]
          #     Product category (1st level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l2
          #   @return [::String]
          #     Product category (2nd level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l3
          #   @return [::String]
          #     Product category (3rd level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l4
          #   @return [::String]
          #     Product category (4th level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l5
          #   @return [::String]
          #     Product category (5th level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] product_type_l1
          #   @return [::String]
          #     Product type (1st level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] product_type_l2
          #   @return [::String]
          #     Product type (2nd level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] product_type_l3
          #   @return [::String]
          #     Product type (3rd level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] product_type_l4
          #   @return [::String]
          #     Product type (4th level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] product_type_l5
          #   @return [::String]
          #     Product type (5th level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] price
          #   @return [::Google::Shopping::Type::Price]
          #     Product price. Absent if the information about the price of the product is
          #     not available.
          # @!attribute [rw] condition
          #   @return [::String]
          #     [Condition](https://support.google.com/merchants/answer/6324469) of the
          #     product.
          # @!attribute [rw] availability
          #   @return [::String]
          #     [Availability](https://support.google.com/merchants/answer/6324448) of the
          #     product.
          # @!attribute [rw] shipping_label
          #   @return [::String]
          #     Normalized [shipping
          #     label](https://support.google.com/merchants/answer/6324504) specified in
          #     the data source.
          # @!attribute [rw] gtin
          #   @return [::Array<::String>]
          #     List of Global Trade Item Numbers (GTINs) of the product.
          # @!attribute [rw] item_group_id
          #   @return [::String]
          #     Item group id provided by the merchant for grouping variants together.
          # @!attribute [rw] thumbnail_link
          #   @return [::String]
          #     Link to the processed image of the product, hosted on the Google
          #     infrastructure.
          # @!attribute [rw] creation_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time the merchant created the product in timestamp seconds.
          # @!attribute [rw] expiration_date
          #   @return [::Google::Type::Date]
          #     Expiration date for the product, specified on insertion.
          # @!attribute [rw] aggregated_reporting_context_status
          #   @return [::Google::Shopping::Merchant::Reports::V1::ProductView::AggregatedReportingContextStatus]
          #     Aggregated status.
          # @!attribute [rw] item_issues
          #   @return [::Array<::Google::Shopping::Merchant::Reports::V1::ProductView::ItemIssue>]
          #     List of item issues for the product.
          #
          #     **This field cannot be used for sorting the results.**
          #
          #     **Only selected attributes of this field (for example,
          #     `item_issues.severity.aggregated_severity`) can be used for filtering the
          #     results.**
          # @!attribute [rw] click_potential
          #   @return [::Google::Shopping::Merchant::Reports::V1::ProductView::ClickPotential]
          #     Estimated performance potential compared to highest performing products of
          #     the merchant.
          # @!attribute [rw] click_potential_rank
          #   @return [::Integer]
          #     Rank of the product based on its click potential. A product with
          #     `click_potential_rank` 1 has the highest click potential among the
          #     merchant's products that fulfill the search query conditions.
          class ProductView
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Item issue associated with the product.
            # @!attribute [rw] type
            #   @return [::Google::Shopping::Merchant::Reports::V1::ProductView::ItemIssue::ItemIssueType]
            #     Item issue type.
            # @!attribute [rw] severity
            #   @return [::Google::Shopping::Merchant::Reports::V1::ProductView::ItemIssue::ItemIssueSeverity]
            #     Item issue severity.
            # @!attribute [rw] resolution
            #   @return [::Google::Shopping::Merchant::Reports::V1::ProductView::ItemIssue::ItemIssueResolution]
            #     Item issue resolution.
            class ItemIssue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Issue type.
              # @!attribute [rw] code
              #   @return [::String]
              #     Error code of the issue, equivalent to the `code` of [Product
              #     issues](https://developers.google.com/shopping-content/guides/product-issues).
              # @!attribute [rw] canonical_attribute
              #   @return [::String]
              #     Canonical attribute name for attribute-specific issues.
              class ItemIssueType
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # How the issue affects the serving of the product.
              # @!attribute [rw] severity_per_reporting_context
              #   @return [::Array<::Google::Shopping::Merchant::Reports::V1::ProductView::ItemIssue::ItemIssueSeverity::IssueSeverityPerReportingContext>]
              #     Issue severity per reporting context.
              # @!attribute [rw] aggregated_severity
              #   @return [::Google::Shopping::Merchant::Reports::V1::ProductView::ItemIssue::ItemIssueSeverity::AggregatedIssueSeverity]
              #     Aggregated severity of the issue for all reporting contexts it affects.
              #
              #     **This field can be used for filtering the results.**
              class ItemIssueSeverity
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # Issue severity per reporting context.
                # @!attribute [rw] reporting_context
                #   @return [::Google::Shopping::Type::ReportingContext::ReportingContextEnum]
                #     Reporting context the issue applies to.
                # @!attribute [rw] disapproved_countries
                #   @return [::Array<::String>]
                #     List of disapproved countries in the reporting context, represented
                #     in ISO 3166 format.
                # @!attribute [rw] demoted_countries
                #   @return [::Array<::String>]
                #     List of demoted countries in the reporting context, represented in
                #     ISO 3166 format.
                class IssueSeverityPerReportingContext
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods
                end

                # Issue severity aggregated for all reporting contexts.
                module AggregatedIssueSeverity
                  # Not specified.
                  AGGREGATED_ISSUE_SEVERITY_UNSPECIFIED = 0

                  # Issue disapproves the product in at least one reporting context.
                  DISAPPROVED = 1

                  # Issue demotes the product in all reporting contexts it affects.
                  DEMOTED = 2

                  # Issue resolution is `PENDING_PROCESSING`.
                  PENDING = 3
                end
              end

              # How to resolve the issue.
              module ItemIssueResolution
                # Not specified.
                ITEM_ISSUE_RESOLUTION_UNSPECIFIED = 0

                # The merchant has to fix the issue.
                MERCHANT_ACTION = 1

                # The issue will be resolved automatically (for example, image crawl) or
                # through a Google review. No merchant action is required now. Resolution
                # might lead to another issue (for example, if crawl fails).
                PENDING_PROCESSING = 2
              end
            end

            # Status of the product aggregated for all reporting contexts.
            #
            # Here's an example of how the aggregated status is computed:
            #
            # Free listings | Shopping ads | Status
            # --------------|--------------|------------------------------
            # Approved      | Approved     | ELIGIBLE
            # Approved      | Pending      | ELIGIBLE
            # Approved      | Disapproved  | ELIGIBLE_LIMITED
            # Pending       | Pending      | PENDING
            # Disapproved   | Disapproved  | NOT_ELIGIBLE_OR_DISAPPROVED
            module AggregatedReportingContextStatus
              # Not specified.
              AGGREGATED_REPORTING_CONTEXT_STATUS_UNSPECIFIED = 0

              # Product is not eligible or is disapproved for all reporting contexts.
              NOT_ELIGIBLE_OR_DISAPPROVED = 1

              # Product's status is pending in all reporting contexts.
              PENDING = 2

              # Product is eligible for some (but not all) reporting contexts.
              ELIGIBLE_LIMITED = 3

              # Product is eligible for all reporting contexts.
              ELIGIBLE = 4
            end

            # A product's [click
            # potential](https://support.google.com/merchants/answer/188488) estimates
            # its performance potential compared to highest performing products of the
            # merchant. Click potential of a product helps merchants to prioritize which
            # products to fix and helps them understand how products are performing
            # against their potential.
            module ClickPotential
              # Unknown predicted clicks impact.
              CLICK_POTENTIAL_UNSPECIFIED = 0

              # Potential to receive a low number of clicks compared to the highest
              # performing products of the merchant.
              LOW = 1

              # Potential to receive a moderate number of clicks compared to the highest
              # performing products of the merchant.
              MEDIUM = 2

              # Potential to receive a similar number of clicks as the highest performing
              # products of the merchant.
              HIGH = 3
            end
          end

          # Fields available for query in `price_competitiveness_product_view` table.
          #
          # [Price competitiveness](https://support.google.com/merchants/answer/9626903)
          # report.
          #
          # Values are only set for fields requested explicitly in the request's search
          # query.
          # @!attribute [rw] report_country_code
          #   @return [::String]
          #     Country of the price benchmark. Represented in the ISO 3166 format.
          #
          #     Required in the `SELECT` clause.
          # @!attribute [rw] id
          #   @return [::String]
          #     REST ID of the product, in the form of
          #     `channel~languageCode~feedLabel~offerId`. Can be used to join data with the
          #     `product_view` table.
          #
          #     Required in the `SELECT` clause.
          # @!attribute [rw] offer_id
          #   @return [::String]
          #     Merchant-provided id of the product.
          # @!attribute [rw] title
          #   @return [::String]
          #     Title of the product.
          # @!attribute [rw] brand
          #   @return [::String]
          #     Brand of the product.
          # @!attribute [rw] category_l1
          #   @return [::String]
          #     Product category (1st level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l2
          #   @return [::String]
          #     Product category (2nd level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l3
          #   @return [::String]
          #     Product category (3rd level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l4
          #   @return [::String]
          #     Product category (4th level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l5
          #   @return [::String]
          #     Product category (5th level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] product_type_l1
          #   @return [::String]
          #     Product type (1st level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] product_type_l2
          #   @return [::String]
          #     Product type (2nd level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] product_type_l3
          #   @return [::String]
          #     Product type (3rd level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] product_type_l4
          #   @return [::String]
          #     Product type (4th level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] product_type_l5
          #   @return [::String]
          #     Product type (5th level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] price
          #   @return [::Google::Shopping::Type::Price]
          #     Current price of the product.
          # @!attribute [rw] benchmark_price
          #   @return [::Google::Shopping::Type::Price]
          #     Latest available price benchmark for the product's catalog in the benchmark
          #     country.
          class PriceCompetitivenessProductView
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Fields available for query in `price_insights_product_view` table.
          #
          # [Price insights](https://support.google.com/merchants/answer/11916926)
          # report.
          #
          # Values are only set for fields requested explicitly in the request's search
          # query.
          # @!attribute [rw] id
          #   @return [::String]
          #     REST ID of the product, in the form of
          #     `channel~languageCode~feedLabel~offerId`. Can be used to join data with the
          #     `product_view` table.
          #
          #     Required in the `SELECT` clause.
          # @!attribute [rw] offer_id
          #   @return [::String]
          #     Merchant-provided id of the product.
          # @!attribute [rw] title
          #   @return [::String]
          #     Title of the product.
          # @!attribute [rw] brand
          #   @return [::String]
          #     Brand of the product.
          # @!attribute [rw] category_l1
          #   @return [::String]
          #     Product category (1st level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l2
          #   @return [::String]
          #     Product category (2nd level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l3
          #   @return [::String]
          #     Product category (3rd level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l4
          #   @return [::String]
          #     Product category (4th level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l5
          #   @return [::String]
          #     Product category (5th level) in [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] product_type_l1
          #   @return [::String]
          #     Product type (1st level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] product_type_l2
          #   @return [::String]
          #     Product type (2nd level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] product_type_l3
          #   @return [::String]
          #     Product type (3rd level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] product_type_l4
          #   @return [::String]
          #     Product type (4th level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] product_type_l5
          #   @return [::String]
          #     Product type (5th level) in merchant's own [product
          #     taxonomy](https://support.google.com/merchants/answer/6324406).
          # @!attribute [rw] price
          #   @return [::Google::Shopping::Type::Price]
          #     Current price of the product.
          # @!attribute [rw] suggested_price
          #   @return [::Google::Shopping::Type::Price]
          #     Latest suggested price for the product.
          # @!attribute [rw] predicted_impressions_change_fraction
          #   @return [::Float]
          #     Predicted change in impressions as a fraction after introducing the
          #     suggested price compared to current active price. For example, 0.05 is a 5%
          #     predicted increase in impressions.
          # @!attribute [rw] predicted_clicks_change_fraction
          #   @return [::Float]
          #     Predicted change in clicks as a fraction after introducing the
          #     suggested price compared to current active price. For example, 0.05 is a 5%
          #     predicted increase in clicks.
          # @!attribute [rw] predicted_conversions_change_fraction
          #   @return [::Float]
          #     Predicted change in conversions as a fraction after introducing the
          #     suggested price compared to current active price. For example, 0.05 is a 5%
          #     predicted increase in conversions).
          # @!attribute [rw] effectiveness
          #   @return [::Google::Shopping::Merchant::Reports::V1::PriceInsightsProductView::Effectiveness]
          #     The predicted effectiveness of applying the price suggestion, bucketed.
          class PriceInsightsProductView
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Predicted effectiveness bucket.
            #
            # Effectiveness indicates which products would benefit most from price
            # changes. This rating takes into consideration the performance boost
            # predicted by adjusting the sale price and the difference between your
            # current price and the suggested price. Price suggestions with `HIGH`
            # effectiveness are predicted to drive the largest increase in performance.
            module Effectiveness
              # Effectiveness is unknown.
              EFFECTIVENESS_UNSPECIFIED = 0

              # Effectiveness is low.
              LOW = 1

              # Effectiveness is medium.
              MEDIUM = 2

              # Effectiveness is high.
              HIGH = 3
            end
          end

          # Fields available for query in `best_sellers_product_cluster_view` table.
          #
          # [Best sellers](https://support.google.com/merchants/answer/9488679) report
          # with top product clusters. A product cluster is a grouping for different
          # offers and variants that represent the same product, for example, Google
          # Pixel 7.
          #
          # Values are only set for fields requested explicitly in the request's search
          # query.
          # @!attribute [rw] report_date
          #   @return [::Google::Type::Date]
          #     Report date. The value of this field can only be one of the following:
          #
          #     *   The first day of the week (Monday) for weekly reports,
          #     *   The first day of the month for monthly reports.
          #
          #     Required in the `SELECT` clause. If a `WHERE` condition on `report_date` is
          #     not specified in the query, the latest available weekly or monthly report
          #     is returned.
          # @!attribute [rw] report_granularity
          #   @return [::Google::Shopping::Merchant::Reports::V1::ReportGranularity::ReportGranularityEnum]
          #     Granularity of the report. The ranking can be done over a week or a month
          #     timeframe.
          #
          #     Required in the `SELECT` clause. Condition on `report_granularity` is
          #     required in the `WHERE` clause.
          # @!attribute [rw] report_country_code
          #   @return [::String]
          #     Country where the ranking is calculated. Represented in the ISO 3166
          #     format.
          #
          #     Required in the `SELECT` clause. Condition on `report_country_code` is
          #     required in the `WHERE` clause.
          # @!attribute [rw] report_category_id
          #   @return [::Integer]
          #     Google product category ID to calculate the ranking for, represented in
          #     [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          #
          #     Required in the `SELECT` clause. If a `WHERE` condition on
          #     `report_category_id` is not specified in the query, rankings for all
          #     top-level categories are returned.
          # @!attribute [rw] title
          #   @return [::String]
          #     Title of the product cluster.
          # @!attribute [rw] brand
          #   @return [::String]
          #     Brand of the product cluster.
          # @!attribute [rw] category_l1
          #   @return [::String]
          #     Product category (1st level) of the product cluster, represented in
          #     [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l2
          #   @return [::String]
          #     Product category (2nd level) of the product cluster, represented in
          #     [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l3
          #   @return [::String]
          #     Product category (3rd level) of the product cluster, represented in
          #     [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l4
          #   @return [::String]
          #     Product category (4th level) of the product cluster, represented in
          #     [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] category_l5
          #   @return [::String]
          #     Product category (5th level) of the product cluster, represented in
          #     [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          # @!attribute [rw] variant_gtins
          #   @return [::Array<::String>]
          #     GTINs of example variants of the product cluster.
          # @!attribute [rw] inventory_status
          #   @return [::Google::Shopping::Merchant::Reports::V1::BestSellersProductClusterView::InventoryStatus]
          #     Whether the product cluster is `IN_STOCK` in your product data source in at
          #     least one of the countries, `OUT_OF_STOCK` in your product data source in
          #     all countries, or `NOT_IN_INVENTORY` at all.
          #
          #     The field doesn't take the Best sellers report country filter into account.
          # @!attribute [rw] brand_inventory_status
          #   @return [::Google::Shopping::Merchant::Reports::V1::BestSellersProductClusterView::InventoryStatus]
          #     Whether there is at least one product of the brand currently `IN_STOCK` in
          #     your product data source in at least one of the countries, all products are
          #     `OUT_OF_STOCK` in your product data source in all countries, or
          #     `NOT_IN_INVENTORY`.
          #
          #     The field doesn't take the Best sellers report country filter into account.
          # @!attribute [rw] rank
          #   @return [::Integer]
          #     Popularity of the product cluster on Ads and organic surfaces, in the
          #     selected category and country, based on the estimated number of units sold.
          # @!attribute [rw] previous_rank
          #   @return [::Integer]
          #     Popularity rank in the previous week or month.
          # @!attribute [rw] relative_demand
          #   @return [::Google::Shopping::Merchant::Reports::V1::RelativeDemand::RelativeDemandEnum]
          #     Estimated demand in relation to the product cluster with the highest
          #     popularity rank in the same category and country.
          # @!attribute [rw] previous_relative_demand
          #   @return [::Google::Shopping::Merchant::Reports::V1::RelativeDemand::RelativeDemandEnum]
          #     Estimated demand in relation to the product cluster with the highest
          #     popularity rank in the same category and country in the previous week or
          #     month.
          # @!attribute [rw] relative_demand_change
          #   @return [::Google::Shopping::Merchant::Reports::V1::RelativeDemandChangeType::RelativeDemandChangeTypeEnum]
          #     Change in the estimated demand. Whether it rose, sank or remained flat.
          class BestSellersProductClusterView
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Status of the product cluster or brand in your inventory.
            module InventoryStatus
              # Not specified.
              INVENTORY_STATUS_UNSPECIFIED = 0

              # You have a product for this product cluster or brand in stock.
              IN_STOCK = 1

              # You have a product for this product cluster or brand in inventory but it
              # is currently out of stock.
              OUT_OF_STOCK = 2

              # You do not have a product for this product cluster or brand in inventory.
              NOT_IN_INVENTORY = 3
            end
          end

          # Fields available for query in `best_sellers_brand_view` table.
          #
          # [Best sellers](https://support.google.com/merchants/answer/9488679) report
          # with top brands.
          #
          # Values are only set for fields requested explicitly in the request's search
          # query.
          # @!attribute [rw] report_date
          #   @return [::Google::Type::Date]
          #     Report date. The value of this field can only be one of the following:
          #
          #     *   The first day of the week (Monday) for weekly reports,
          #     *   The first day of the month for monthly reports.
          #
          #     Required in the `SELECT` clause. If a `WHERE` condition on `report_date` is
          #     not specified in the query, the latest available weekly or monthly report
          #     is returned.
          # @!attribute [rw] report_granularity
          #   @return [::Google::Shopping::Merchant::Reports::V1::ReportGranularity::ReportGranularityEnum]
          #     Granularity of the report. The ranking can be done over a week or a month
          #     timeframe.
          #
          #     Required in the `SELECT` clause. Condition on `report_granularity` is
          #     required in the `WHERE` clause.
          # @!attribute [rw] report_country_code
          #   @return [::String]
          #     Country where the ranking is calculated. Represented in the ISO 3166
          #     format.
          #
          #     Required in the `SELECT` clause. Condition on `report_country_code` is
          #     required in the `WHERE` clause.
          # @!attribute [rw] report_category_id
          #   @return [::Integer]
          #     Google product category ID to calculate the ranking for, represented in
          #     [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          #
          #     Required in the `SELECT` clause. If a `WHERE` condition on
          #     `report_category_id` is not specified in the query, rankings for all
          #     top-level categories are returned.
          # @!attribute [rw] brand
          #   @return [::String]
          #     Name of the brand.
          # @!attribute [rw] rank
          #   @return [::Integer]
          #     Popularity of the brand on Ads and organic surfaces, in the selected
          #     category and country, based on the estimated number of units sold.
          # @!attribute [rw] previous_rank
          #   @return [::Integer]
          #     Popularity rank in the previous week or month.
          # @!attribute [rw] relative_demand
          #   @return [::Google::Shopping::Merchant::Reports::V1::RelativeDemand::RelativeDemandEnum]
          #     Estimated demand in relation to the brand with the highest popularity rank
          #     in the same category and country.
          # @!attribute [rw] previous_relative_demand
          #   @return [::Google::Shopping::Merchant::Reports::V1::RelativeDemand::RelativeDemandEnum]
          #     Estimated demand in relation to the brand with the highest popularity rank
          #     in the same category and country in the previous week or month.
          # @!attribute [rw] relative_demand_change
          #   @return [::Google::Shopping::Merchant::Reports::V1::RelativeDemandChangeType::RelativeDemandChangeTypeEnum]
          #     Change in the estimated demand. Whether it rose, sank or remained flat.
          class BestSellersBrandView
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Fields available for query in `non_product_performance_view` table.
          #
          # Performance data on images and online store links leading to your non-product
          # pages. This includes performance metrics (for example, `clicks`)
          # and dimensions according to which performance metrics are segmented (for
          # example, `date`).
          #
          # Segment fields cannot be selected in queries without also selecting at least
          # one metric field.
          #
          # Values are only set for fields requested explicitly in the request's search
          # query.
          # @!attribute [rw] date
          #   @return [::Google::Type::Date]
          #     Date in the merchant timezone to which metrics apply. Segment.
          #
          #     Condition on `date` is required in the `WHERE` clause.
          # @!attribute [rw] week
          #   @return [::Google::Type::Date]
          #     First day of the week (Monday) of the metrics date in the merchant
          #     timezone. Segment.
          # @!attribute [rw] clicks
          #   @return [::Integer]
          #     Number of clicks on images and online store links leading to your
          #     non-product pages. Metric.
          # @!attribute [rw] impressions
          #   @return [::Integer]
          #     Number of times images and online store links leading to your non-product
          #     pages were shown. Metric.
          # @!attribute [rw] click_through_rate
          #   @return [::Float]
          #     Click-through rate - the number of clicks (`clicks`) divided by the number
          #     of impressions (`impressions`) of images and online store links leading to
          #     your non-product pages. Metric.
          class NonProductPerformanceView
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Fields available for query in `competitive_visibility_competitor_view` table.
          #
          # [Competitive
          # visibility](https://support.google.com/merchants/answer/11366442) report with
          # businesses with similar visibility.
          #
          # Values are only set for fields requested explicitly in the request's search
          # query.
          # @!attribute [rw] date
          #   @return [::Google::Type::Date]
          #     Date of this row.
          #
          #     A condition on `date` is required in the `WHERE` clause.
          # @!attribute [rw] domain
          #   @return [::String]
          #     Domain of your competitor or your domain, if 'is_your_domain' is true.
          #
          #     Required in the `SELECT` clause. Cannot be filtered on in the 'WHERE'
          #     clause.
          # @!attribute [rw] is_your_domain
          #   @return [::Boolean]
          #     True if this row contains data for your domain.
          #
          #     Cannot be filtered on in the 'WHERE' clause.
          # @!attribute [rw] report_country_code
          #   @return [::String]
          #     Country where impressions appeared.
          #
          #     Required in the `SELECT` clause. A condition on `report_country_code` is
          #     required in the `WHERE` clause.
          # @!attribute [rw] report_category_id
          #   @return [::Integer]
          #     Google product category ID to calculate the report for, represented in
          #     [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          #
          #     Required in the `SELECT` clause. A condition on `report_category_id` is
          #     required in the `WHERE` clause.
          # @!attribute [rw] traffic_source
          #   @return [::Google::Shopping::Merchant::Reports::V1::TrafficSource::TrafficSourceEnum]
          #     Traffic source of impressions.
          #
          #     Required in the `SELECT` clause.
          # @!attribute [rw] rank
          #   @return [::Integer]
          #     Position of the domain in the similar businesses ranking for the selected
          #     keys (`date`, `report_category_id`, `report_country_code`,
          #     `traffic_source`) based on impressions. 1 is the highest.
          #
          #     Cannot be filtered on in the 'WHERE' clause.
          # @!attribute [rw] ads_organic_ratio
          #   @return [::Float]
          #     [Ads / organic ratio]
          #     (https://support.google.com/merchants/answer/11366442#zippy=%2Cads-free-ratio)
          #     shows how often the domain receives impressions from Shopping ads compared
          #     to organic traffic. The number is rounded and bucketed.
          #
          #     Cannot be filtered on in the 'WHERE' clause.
          # @!attribute [rw] page_overlap_rate
          #   @return [::Float]
          #     [Page overlap rate]
          #     (https://support.google.com/merchants/answer/11366442#zippy=%2Cpage-overlap-rate)
          #     shows how frequently competing retailers’ offers are shown together with
          #     your offers on the same page.
          #
          #     Cannot be filtered on in the 'WHERE' clause.
          # @!attribute [rw] higher_position_rate
          #   @return [::Float]
          #     [Higher position rate]
          #     (https://support.google.com/merchants/answer/11366442#zippy=%2Chigher-position-rate)
          #     shows how often a competitor’s offer got placed in a higher position on the
          #     page than your offer.
          #
          #     Cannot be filtered on in the 'WHERE' clause.
          # @!attribute [rw] relative_visibility
          #   @return [::Float]
          #     [Relative visibility]
          #     (https://support.google.com/merchants/answer/11366442#zippy=%2Crelative-visibility)
          #     shows how often your competitors’ offers are shown compared to your offers.
          #     In other words, this is the number of displayed impressions of a competitor
          #     retailer divided by the number of your displayed impressions during a
          #     selected time range for a selected product category and country.
          #
          #     Cannot be filtered on in the 'WHERE' clause.
          class CompetitiveVisibilityCompetitorView
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Fields available for query in `competitive_visibility_top_merchant_view`
          # table.
          #
          # [Competitive
          # visibility](https://support.google.com/merchants/answer/11366442) report with
          # business with highest visibility.
          #
          # Values are only set for fields requested explicitly in the request's search
          # query.
          # @!attribute [rw] date
          #   @return [::Google::Type::Date]
          #     Date of this row.
          #
          #     Cannot be selected in the `SELECT` clause. A condition on `date` is
          #     required in the `WHERE` clause.
          # @!attribute [rw] domain
          #   @return [::String]
          #     Domain of your competitor or your domain, if 'is_your_domain' is true.
          #
          #     Required in the `SELECT` clause. Cannot be filtered on in the 'WHERE'
          #     clause.
          # @!attribute [rw] is_your_domain
          #   @return [::Boolean]
          #     True if this row contains data for your domain.
          #
          #     Cannot be filtered on in the 'WHERE' clause.
          # @!attribute [rw] report_country_code
          #   @return [::String]
          #     Country where impressions appeared.
          #
          #     Required in the `SELECT` clause. A condition on `report_country_code` is
          #     required in the `WHERE` clause.
          # @!attribute [rw] report_category_id
          #   @return [::Integer]
          #     Google product category ID to calculate the report for, represented in
          #     [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          #
          #     Required in the `SELECT` clause. A condition on `report_category_id` is
          #     required in the `WHERE` clause.
          # @!attribute [rw] traffic_source
          #   @return [::Google::Shopping::Merchant::Reports::V1::TrafficSource::TrafficSourceEnum]
          #     Traffic source of impressions.
          #
          #     Required in the `SELECT` clause.
          # @!attribute [rw] rank
          #   @return [::Integer]
          #     Position of the domain in the top merchants ranking for the selected keys
          #     (`date`, `report_category_id`, `report_country_code`, `traffic_source`)
          #     based on impressions. 1 is the highest.
          #
          #     Cannot be filtered on in the 'WHERE' clause.
          # @!attribute [rw] ads_organic_ratio
          #   @return [::Float]
          #     [Ads / organic ratio]
          #     (https://support.google.com/merchants/answer/11366442#zippy=%2Cads-free-ratio)
          #     shows how often the domain receives impressions from Shopping ads compared
          #     to organic traffic. The number is rounded and bucketed.
          #
          #     Cannot be filtered on in the 'WHERE' clause.
          # @!attribute [rw] page_overlap_rate
          #   @return [::Float]
          #     [Page overlap rate]
          #     (https://support.google.com/merchants/answer/11366442#zippy=%2Cpage-overlap-rate)
          #     shows how frequently competing retailers’ offers are shown together with
          #     your offers on the same page.
          #
          #     Cannot be filtered on in the 'WHERE' clause.
          # @!attribute [rw] higher_position_rate
          #   @return [::Float]
          #     [Higher position rate]
          #     (https://support.google.com/merchants/answer/11366442#zippy=%2Chigher-position-rate)
          #     shows how often a competitor’s offer got placed in a higher position on the
          #     page than your offer.
          #
          #     Cannot be filtered on in the 'WHERE' clause.
          class CompetitiveVisibilityTopMerchantView
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Fields available for query in `competitive_visibility_benchmark_view` table.
          #
          # [Competitive
          # visibility](https://support.google.com/merchants/answer/11366442) report with
          # the category benchmark.
          #
          # Values are only set for fields requested explicitly in the request's search
          # query.
          # @!attribute [rw] date
          #   @return [::Google::Type::Date]
          #     Date of this row.
          #
          #     Required in the `SELECT` clause. A condition on `date` is required in the
          #     `WHERE` clause.
          # @!attribute [rw] report_country_code
          #   @return [::String]
          #     Country where impressions appeared.
          #
          #     Required in the `SELECT` clause. A condition on `report_country_code` is
          #     required in the `WHERE` clause.
          # @!attribute [rw] report_category_id
          #   @return [::Integer]
          #     Google product category ID to calculate the report for, represented in
          #     [Google's product
          #     taxonomy](https://support.google.com/merchants/answer/6324436).
          #
          #     Required in the `SELECT` clause. A condition on `report_category_id` is
          #     required in the `WHERE` clause.
          # @!attribute [rw] traffic_source
          #   @return [::Google::Shopping::Merchant::Reports::V1::TrafficSource::TrafficSourceEnum]
          #     Traffic source of impressions.
          #
          #     Required in the `SELECT` clause.
          # @!attribute [rw] your_domain_visibility_trend
          #   @return [::Float]
          #     Change in visibility based on impressions for your domain with respect to
          #     the start of the selected time range (or first day with non-zero
          #     impressions).
          #
          #     Cannot be filtered on in the 'WHERE' clause.
          # @!attribute [rw] category_benchmark_visibility_trend
          #   @return [::Float]
          #     Change in visibility based on impressions with respect to the start of the
          #     selected time range (or first day with non-zero impressions) for a
          #     combined set of merchants with highest visibility approximating the
          #     market.
          #
          #     Cannot be filtered on in the 'WHERE' clause.
          class CompetitiveVisibilityBenchmarkView
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Marketing method used to promote your products on Google (organic versus
          # ads).
          class MarketingMethod
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Marketing method values.
            module MarketingMethodEnum
              # Not specified.
              MARKETING_METHOD_ENUM_UNSPECIFIED = 0

              # Organic marketing.
              ORGANIC = 1

              # Ads-based marketing.
              ADS = 2
            end
          end

          # Granularity of the Best sellers report. Best sellers reports are computed
          # over a week and a month timeframe.
          class ReportGranularity
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Report granularity values.
            module ReportGranularityEnum
              # Not specified.
              REPORT_GRANULARITY_ENUM_UNSPECIFIED = 0

              # Report is computed over a week timeframe.
              WEEKLY = 1

              # Report is computed over a month timeframe.
              MONTHLY = 2
            end
          end

          # Relative demand of a product cluster or brand in the Best sellers report.
          class RelativeDemand
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Relative demand values.
            module RelativeDemandEnum
              # Not specified.
              RELATIVE_DEMAND_ENUM_UNSPECIFIED = 0

              # Demand is 0-5% of the demand of the highest ranked product cluster or
              # brand.
              VERY_LOW = 10

              # Demand is 6-10% of the demand of the highest ranked product cluster or
              # brand.
              LOW = 20

              # Demand is 11-20% of the demand of the highest ranked product cluster or
              # brand.
              MEDIUM = 30

              # Demand is 21-50% of the demand of the highest ranked product cluster or
              # brand.
              HIGH = 40

              # Demand is 51-100% of the demand of the highest ranked product cluster or
              # brand.
              VERY_HIGH = 50
            end
          end

          # Relative demand of a product cluster or brand in the Best sellers report
          # compared to the previous time period.
          class RelativeDemandChangeType
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Relative demand change type values.
            module RelativeDemandChangeTypeEnum
              # Not specified.
              RELATIVE_DEMAND_CHANGE_TYPE_ENUM_UNSPECIFIED = 0

              # Relative demand is lower than the previous time period.
              SINKER = 1

              # Relative demand is equal to the previous time period.
              FLAT = 2

              # Relative demand is higher than the previous time period.
              RISER = 3
            end
          end

          # Traffic source of impressions in the Competitive visibility report.
          class TrafficSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Traffic source values.
            module TrafficSourceEnum
              # Not specified.
              TRAFFIC_SOURCE_ENUM_UNSPECIFIED = 0

              # Organic traffic.
              ORGANIC = 1

              # Traffic from ads.
              ADS = 2

              # Organic and ads traffic.
              ALL = 3
            end
          end
        end
      end
    end
  end
end
