# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Quota
        module V1
          # The limit for products.
          # @!attribute [rw] scope
          #   @return [::Google::Shopping::Merchant::Quota::V1::ProductLimit::Scope]
          #     Required. The scope of the product limit.
          # @!attribute [rw] limit
          #   @return [::Integer]
          #     Required. The maximum number of products that are allowed in the account in
          #     the given scope.
          class ProductLimit
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The scope of the limit.
            module Scope
              # Default value. Should not be used.
              SCOPE_UNSPECIFIED = 0

              # Limit for products in non-EEA countries.
              ADS_NON_EEA = 1

              # Limit for products in EEA countries.
              ADS_EEA = 2
            end
          end

          # A limit of a certain type that is applied to an account.
          # @!attribute [rw] products
          #   @return [::Google::Shopping::Merchant::Quota::V1::ProductLimit]
          #     The limit for products.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The limit part of the name will be a combination of the type
          #     and the scope. For example: `accounts/123/limits/products~ADS_NON_EEA`
          #
          #     Format: `accounts/{account}/limits/{limit}`
          class AccountLimit
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `GetAccountLimit` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the limit to retrieve.
          #     Format: `accounts/{account}/limits/{limit}`
          #     For example: `accounts/123/limits/products~ADS_NON_EEA`
          class GetAccountLimitRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `ListAccountLimits` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent account.
          #     Format: `accounts/{account}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of limits to return. The service may return
          #     fewer than this value. If unspecified, at most 100 limits will be returned.
          #     The maximum value is 100; values above 100 will be coerced to 100.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from a previous `ListAccountLimits` call.
          #     Provide this to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to `ListAccountLimits` must
          #     match the call that provided the page token.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Required. A filter on the limit `type` is required, for example, `type =
          #     "products"`.
          class ListAccountLimitsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the `ListAccountLimits` method.
          # @!attribute [rw] account_limits
          #   @return [::Array<::Google::Shopping::Merchant::Quota::V1::AccountLimit>]
          #     The limits for the given account.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListAccountLimitsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
