# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Promotions
        module V1
          # Attributes.
          # @!attribute [rw] product_applicability
          #   @return [::Google::Shopping::Merchant::Promotions::V1::ProductApplicability]
          #     Required. Applicability of the promotion to either all products or
          #     [only specific
          #     products](https://support.google.com/merchants/answer/6396257?ref_topic=6396150&sjid=17642868584668136159-NC).
          # @!attribute [rw] offer_type
          #   @return [::Google::Shopping::Merchant::Promotions::V1::OfferType]
          #     Required.
          #     [Type](https://support.google.com/merchants/answer/13837405?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     of the promotion. Use this attribute to indicate whether or not customers
          #     need a coupon code to redeem your promotion.
          # @!attribute [rw] generic_redemption_code
          #   @return [::String]
          #     Optional. Generic redemption code for the promotion. To be used with the
          #     `offerType` field and must meet the [minimum
          #     requirements](https://support.google.com/merchants/answer/13837405?ref_topic=13773355&sjid=17642868584668136159-NC).
          # @!attribute [rw] long_title
          #   @return [::String]
          #     Required. [Long
          #     title](https://support.google.com/merchants/answer/13838102?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     for the promotion.
          # @!attribute [rw] coupon_value_type
          #   @return [::Google::Shopping::Merchant::Promotions::V1::CouponValueType]
          #     Required. The [coupon value type]
          #     (https://support.google.com/merchants/answer/13861986?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     attribute to signal the type of promotion that you are running. Depending
          #     on type of the selected coupon value [some attributes are
          #     required](https://support.google.com/merchants/answer/6393006?ref_topic=7322920).
          # @!attribute [rw] promotion_destinations
          #   @return [::Array<::Google::Shopping::Type::Destination::DestinationEnum>]
          #     Required. The list of destinations (also known as [Marketing
          #     methods](https://support.google.com/merchants/answer/15130232)) where the
          #     promotion applies to. If you don't specify a destination by including a
          #     supported value in your data source, your promotion will display in
          #     Shopping ads and free listings by default.
          #
          #     You may have previously submitted the following values as destinations for
          #     your products: Shopping Actions, Surfaces across Google, Local surfaces
          #     across Google.  To represent these values use `FREE_LISTINGS`,
          #     `FREE_LOCAL_LISTINGS`, `LOCAL_INVENTORY_ADS`. For more details see
          #     [Promotion
          #     destination](https://support.google.com/merchants/answer/13837465?sjid=5155774230887277618-NC)
          # @!attribute [rw] item_id_inclusion
          #   @return [::Array<::String>]
          #     Optional. Product filter by [item
          #     ID](https://support.google.com/merchants/answer/13861565?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     for the promotion. The product filter attributes only applies when the
          #     products eligible for promotion product applicability
          #     `product_applicability` attribute is set to
          #     [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
          # @!attribute [rw] brand_inclusion
          #   @return [::Array<::String>]
          #     Optional. Product filter by brand for the promotion. The product filter
          #     attributes only applies when the products eligible for promotion product
          #     applicability `product_applicability` attribute is set to
          #     [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
          # @!attribute [rw] item_group_id_inclusion
          #   @return [::Array<::String>]
          #     Optional. Product filter by item group ID for the promotion. The product
          #     filter attributes only applies when the products eligible for promotion
          #     product applicability [product_applicability] attribute is set to
          #     [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
          # @!attribute [rw] product_type_inclusion
          #   @return [::Array<::String>]
          #     Optional. Product filter by product type for the promotion. The product
          #     filter attributes only applies when the products eligible for promotion
          #     product applicability `product_applicability` attribute is set to
          #     [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
          # @!attribute [rw] item_id_exclusion
          #   @return [::Array<::String>]
          #     Optional. Product filter by [item ID
          #     exclusion](https://support.google.com/merchants/answer/13863524?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     for the promotion. The product filter attributes only applies when the
          #     products eligible for promotion product applicability
          #     `product_applicability` attribute is set to
          #     [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
          # @!attribute [rw] brand_exclusion
          #   @return [::Array<::String>]
          #     Optional. Product filter by [brand
          #     exclusion](https://support.google.com/merchants/answer/13861679?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     for the promotion. The product filter attributes only applies when the
          #     products eligible for promotion product applicability
          #     `product_applicability` attribute is set to
          #     [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
          # @!attribute [rw] item_group_id_exclusion
          #   @return [::Array<::String>]
          #     Optional. Product filter by [item group
          #     ID](https://support.google.com/merchants/answer/13837298?ref_topic=13773355&sjid=17642868584668136159-NC).
          #     The product filter attributes only applies when the products eligible for
          #     promotion product applicability `product_applicability` attribute is set to
          #     [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
          #     exclusion for the promotion.
          # @!attribute [rw] product_type_exclusion
          #   @return [::Array<::String>]
          #     Optional. Product filter by [product type
          #     exclusion](https://support.google.com/merchants/answer/13863746?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     for the promotion. The product filter attributes only applies when the
          #     products eligible for promotion product applicability
          #     `product_applicability` attribute is set to
          #     [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
          # @!attribute [rw] minimum_purchase_amount
          #   @return [::Google::Shopping::Type::Price]
          #     Optional. [Minimum purchase
          #     amount](https://support.google.com/merchants/answer/13837705?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     for the promotion.
          # @!attribute [rw] minimum_purchase_quantity
          #   @return [::Integer]
          # @!attribute [rw] limit_quantity
          #   @return [::Integer]
          #     Optional. [Maximum purchase
          #     quantity](https://support.google.com/merchants/answer/13861564?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     for the promotion.
          # @!attribute [rw] limit_value
          #   @return [::Google::Shopping::Type::Price]
          #     Optional. [Maximum product
          #     price](https://support.google.com/merchants/answer/2906014) for
          #     promotion.
          # @!attribute [rw] percent_off
          #   @return [::Integer]
          #     Optional. The [percentage
          #     discount](https://support.google.com/merchants/answer/13837404?sjid=17642868584668136159-NC)
          #     offered in the promotion.
          # @!attribute [rw] money_off_amount
          #   @return [::Google::Shopping::Type::Price]
          #     Optional. The [money off
          #     amount](https://support.google.com/merchants/answer/13838101?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     offered in the promotion.
          # @!attribute [rw] get_this_quantity_discounted
          #   @return [::Integer]
          #     Optional. The number of items discounted in the promotion. The attribute is
          #     set when `couponValueType` is equal to `buy_m_get_n_money_off` or
          #     `buy_m_get_n_percent_off`.
          # @!attribute [rw] free_gift_value
          #   @return [::Google::Shopping::Type::Price]
          #     Optional. [Free gift
          #     value](https://support.google.com/merchants/answer/13844477?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     for the promotion.
          # @!attribute [rw] free_gift_description
          #   @return [::String]
          #     Optional. [Free gift
          #     description](https://support.google.com/merchants/answer/13847245?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     for the promotion.
          # @!attribute [rw] free_gift_item_id
          #   @return [::String]
          #     Optional. [Free gift item
          #     ID](https://support.google.com/merchants/answer/13857152?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     for the promotion.
          # @!attribute [rw] promotion_effective_time_period
          #   @return [::Google::Type::Interval]
          #     Required. `TimePeriod` representation of the promotion's effective dates.
          #     This attribute specifies that the promotion can be tested on your online
          #     store during this time period.
          # @!attribute [rw] promotion_display_time_period
          #   @return [::Google::Type::Interval]
          #     Optional. `TimePeriod` representation of the promotion's display dates.
          #     This attribute specifies the date and time frame when the promotion will be
          #     live on Google.com and Shopping ads. If the display time period for
          #     promotion `promotion_display_time_period` attribute is not specified, the
          #     promotion effective time period `promotion_effective_time_period`
          #     determines the date and time frame when the promotion will be live on
          #     Google.com and Shopping ads.
          # @!attribute [rw] store_applicability
          #   @return [::Google::Shopping::Merchant::Promotions::V1::StoreApplicability]
          #     Optional. Whether the promotion applies to [all stores, or only specified
          #     stores](https://support.google.com/merchants/answer/13857563?sjid=17642868584668136159-NC).
          #     Local Inventory ads promotions throw an error if no store applicability is
          #     included. An `INVALID_ARGUMENT` error is thrown if `store_applicability` is
          #     set to `ALL_STORES` and `store_codes_inclusion` or `score_code_exclusion`
          #     is set to a value.
          # @!attribute [rw] store_codes_inclusion
          #   @return [::Array<::String>]
          #     Optional. [Store codes to
          #     include](https://support.google.com/merchants/answer/13857470?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     for the promotion. The store filter attributes only applies when the
          #     `store_applicability` attribute is set to
          #     [specific_stores](https://support.google.com/merchants/answer/13857563?ref_topic=13773355&sjid=17642868584668136159-NC).
          #
          #     Store code (the store ID from
          #     your Business Profile) of the physical store the product is sold in. See
          #     the [Local product inventory data
          #     specification](https://support.google.com/merchants/answer/3061342) for
          #     more information.
          # @!attribute [rw] store_codes_exclusion
          #   @return [::Array<::String>]
          #     Optional. [Store codes to
          #     exclude](https://support.google.com/merchants/answer/13859586?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     for the promotion. The store filter attributes only applies when the
          #     `store_applicability` attribute is set to
          #     [specific_stores](https://support.google.com/merchants/answer/13857563?ref_topic=13773355&sjid=17642868584668136159-NC).
          # @!attribute [rw] promotion_url
          #   @return [::String]
          #     Optional. URL to the page on the merchant's site where the promotion shows.
          #     Local Inventory ads promotions throw an error if no `promotion_url` is
          #     included. URL is used to confirm that the promotion is valid and can be
          #     redeemed.
          class Attributes
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The status of the promotion.
          # @!attribute [r] destination_statuses
          #   @return [::Array<::Google::Shopping::Merchant::Promotions::V1::PromotionStatus::DestinationStatus>]
          #     Output only. The intended destinations for the promotion.
          # @!attribute [r] item_level_issues
          #   @return [::Array<::Google::Shopping::Merchant::Promotions::V1::PromotionStatus::ItemLevelIssue>]
          #     Output only. A list of issues associated with the promotion.
          # @!attribute [r] creation_date
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Date on which the promotion has been created
          #     in [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time,
          #     and offset, for example `2020-01-02T09:00:00+01:00` or
          #     `2020-01-02T09:00:00Z`
          # @!attribute [r] last_update_date
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Date on which the promotion status has been last updated
          #     in [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time,
          #     and offset, for example `2020-01-02T09:00:00+01:00` or
          #     `2020-01-02T09:00:00Z`
          class PromotionStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The status for the specified destination.
            # @!attribute [r] reporting_context
            #   @return [::Google::Shopping::Type::ReportingContext::ReportingContextEnum]
            #     Output only. The name of the promotion destination.
            # @!attribute [r] status
            #   @return [::Google::Shopping::Merchant::Promotions::V1::PromotionStatus::DestinationStatus::State]
            #     Output only. The status for the specified destination.
            class DestinationStatus
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # The current state of the promotion.
              module State
                # Unknown promotion state.
                STATE_UNSPECIFIED = 0

                # The promotion is under review.
                IN_REVIEW = 1

                # The promotion is disapproved.
                REJECTED = 2

                # The promotion is approved and active.
                LIVE = 3

                # The promotion is stopped by merchant.
                STOPPED = 4

                # The promotion is no longer active.
                EXPIRED = 5

                # The promotion is not stopped, and all reviews are approved, but the
                # active date is in the future.
                PENDING = 6
              end
            end

            # The issue associated with the promotion.
            # @!attribute [r] code
            #   @return [::String]
            #     Output only. The error code of the issue.
            # @!attribute [r] severity
            #   @return [::Google::Shopping::Merchant::Promotions::V1::PromotionStatus::ItemLevelIssue::Severity]
            #     Output only. How this issue affects serving of the promotion.
            # @!attribute [r] resolution
            #   @return [::String]
            #     Output only. Whether the issue can be resolved by the merchant.
            # @!attribute [r] attribute
            #   @return [::String]
            #     Output only. The attribute's name, if the issue is caused by a single
            #     attribute.
            # @!attribute [r] reporting_context
            #   @return [::Google::Shopping::Type::ReportingContext::ReportingContextEnum]
            #     Output only. The destination the issue applies to.
            # @!attribute [r] description
            #   @return [::String]
            #     Output only. A short issue description in English.
            # @!attribute [r] detail
            #   @return [::String]
            #     Output only. A detailed issue description in English.
            # @!attribute [r] documentation
            #   @return [::String]
            #     Output only. The URL of a web page to help with resolving this issue.
            # @!attribute [r] applicable_countries
            #   @return [::Array<::String>]
            #     Output only. List of country codes (ISO 3166-1 alpha-2) where issue
            #     applies to the offer.
            class ItemLevelIssue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # The severity of the issue.
              module Severity
                # Not specified.
                SEVERITY_UNSPECIFIED = 0

                # This issue represents a warning and does not have a direct affect
                # on the promotion.
                NOT_IMPACTED = 1

                # The promotion is demoted and most likely have limited performance
                # in search results
                DEMOTED = 2

                # Issue disapproves the promotion.
                DISAPPROVED = 3
              end
            end
          end

          # Which product or list of products the promotion applies to.
          module ProductApplicability
            # Which products the promotion applies to is unknown.
            PRODUCT_APPLICABILITY_UNSPECIFIED = 0

            # Applicable to all products.
            ALL_PRODUCTS = 1

            # Applicable to only a single product or list of products.
            SPECIFIC_PRODUCTS = 2
          end

          # Store codes or list of store codes the promotion applies to. Only for
          # Local inventory ads promotions.
          module StoreApplicability
            # Which store codes the promotion applies to is unknown.
            STORE_APPLICABILITY_UNSPECIFIED = 0

            # Promotion applies to all stores.
            ALL_STORES = 1

            # Promotion applies to only the specified stores.
            SPECIFIC_STORES = 2
          end

          # Offer type of a promotion.
          module OfferType
            # Unknown offer type.
            OFFER_TYPE_UNSPECIFIED = 0

            # Offer type without a code.
            NO_CODE = 1

            # Offer type with a code. Generic redemption code for the promotion is
            # required when `offerType` = `GENERIC_CODE`.
            GENERIC_CODE = 2
          end

          # Channel of a promotion.
          module RedemptionChannel
            # Indicates that the channel is unspecified.
            REDEMPTION_CHANNEL_UNSPECIFIED = 0

            # Indicates that the channel is in store.
            # This is same as `local` channel used for `products`.
            IN_STORE = 1

            # Indicates that the channel is online.
            ONLINE = 2
          end

          # [Coupon value
          # type](https://support.google.com/merchants/answer/13861986)
          # of a promotion.
          module CouponValueType
            # Indicates that the coupon value type is unspecified.
            COUPON_VALUE_TYPE_UNSPECIFIED = 0

            # Money off coupon value type.
            MONEY_OFF = 1

            # Percent off coupon value type.
            PERCENT_OFF = 2

            # Buy M quantity, get N money off coupon value type.
            # `minimum_purchase_quantity` and `get_this_quantity_discounted` must be
            # present. `money_off_amount` must also be present.
            BUY_M_GET_N_MONEY_OFF = 3

            # Buy M quantity, get N percent off coupon value type.
            # `minimum_purchase_quantity` and `get_this_quantity_discounted` must be
            # present. `percent_off_percentage` must also be present.
            BUY_M_GET_N_PERCENT_OFF = 4

            # Buy M quantity, get money off. `minimum_purchase_quantity` and
            # `money_off_amount` must be present.
            BUY_M_GET_MONEY_OFF = 5

            # Buy M quantity, get money off. `minimum_purchase_quantity` and
            # `percent_off_percentage` must be present.
            BUY_M_GET_PERCENT_OFF = 6

            # Free gift with description only.
            FREE_GIFT = 7

            # Free gift with monetary value.
            FREE_GIFT_WITH_VALUE = 8

            # Free gift with item ID.
            FREE_GIFT_WITH_ITEM_ID = 9

            # Standard free shipping coupon value type. Only available for online
            # promotions.
            FREE_SHIPPING_STANDARD = 10

            # Overnight free shipping coupon value type. Only available for online
            # promotions.
            FREE_SHIPPING_OVERNIGHT = 11

            # Two day free shipping coupon value type. Only available for online
            # promotions.
            FREE_SHIPPING_TWO_DAY = 12
          end
        end
      end
    end
  end
end
