# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Promotions
        module V1
          # Represents a promotion. See the following articles for more details.
          #
          # Required promotion input attributes to pass data validation checks are
          # primarily defined below:
          #
          # * [Promotions data
          # specification](https://support.google.com/merchants/answer/2906014)
          # * [Local promotions data
          # specification](https://support.google.com/merchants/answer/10146130)
          #
          # After inserting, updating a promotion input, it may take several minutes
          # before the final promotion can be retrieved.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The name of the promotion.
          #     Format: `accounts/{account}/promotions/{promotion}`
          # @!attribute [rw] promotion_id
          #   @return [::String]
          #     Required. The user provided promotion ID to uniquely identify the
          #     promotion. Follow [minimum
          #     requirements](https://support.google.com/merchants/answer/7050148?ref_topic=7322920&sjid=871860036916537104-NC#minimum_requirements)
          #     to prevent promotion disapprovals.
          # @!attribute [rw] content_language
          #   @return [::String]
          #     Required. The two-letter [ISO
          #     639-1](http://en.wikipedia.org/wiki/ISO_639-1) language code for the
          #     promotion.
          #
          #     Promotions is only for [selected
          #     languages](https://support.google.com/merchants/answer/4588281?ref_topic=6396150&sjid=18314938579342094533-NC#option3&zippy=).
          # @!attribute [rw] target_country
          #   @return [::String]
          #     Required. The target country used as part of the unique identifier.
          #     Represented as a [CLDR territory
          #     code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml).
          #
          #     Promotions are only available in selected
          #     countries, [Free Listings and Shopping
          #     ads](https://support.google.com/merchants/answer/4588460) [Local Inventory
          #     ads](https://support.google.com/merchants/answer/10146326)
          # @!attribute [rw] redemption_channel
          #   @return [::Array<::Google::Shopping::Merchant::Promotions::V1::RedemptionChannel>]
          #     Required. [Redemption
          #     channel](https://support.google.com/merchants/answer/13837674?ref_topic=13773355&sjid=17642868584668136159-NC)
          #     for the promotion. At least one channel is required.
          # @!attribute [r] data_source
          #   @return [::String]
          #     Output only. The primary data source of the promotion.
          # @!attribute [rw] attributes
          #   @return [::Google::Shopping::Merchant::Promotions::V1::Attributes]
          #     Optional. A list of promotion attributes.
          # @!attribute [rw] custom_attributes
          #   @return [::Array<::Google::Shopping::Type::CustomAttribute>]
          #     Optional. A list of custom (merchant-provided) attributes. It can also be
          #     used for submitting any attribute of the data specification in its generic
          #     form (for example,
          #     `{ "name": "size type", "value": "regular" }`).
          #     This is useful for submitting attributes not explicitly exposed by the
          #     API.
          # @!attribute [r] promotion_status
          #   @return [::Google::Shopping::Merchant::Promotions::V1::PromotionStatus]
          #     Output only. The [status of a
          #     promotion](https://support.google.com/merchants/answer/3398326?ref_topic=7322924&sjid=5155774230887277618-NC),
          #     data validation issues, that is, information about a promotion computed
          #     asynchronously.
          # @!attribute [rw] version_number
          #   @return [::Integer]
          #     Optional. Represents the existing version (freshness) of the promotion,
          #     which can be used to preserve the right order when multiple updates are
          #     done at the same time.
          #
          #     If set, the insertion is prevented when version number is lower than
          #     the current version number of the existing promotion. Re-insertion (for
          #     example, promotion refresh after 30 days) can be performed with the current
          #     `version_number`.
          #
          #     If the operation is prevented, the aborted exception will be
          #     thrown.
          class Promotion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `InsertPromotion` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The account where the promotion will be inserted.
          #     Format: accounts/\\{account}
          # @!attribute [rw] promotion
          #   @return [::Google::Shopping::Merchant::Promotions::V1::Promotion]
          #     Required. The promotion to insert.
          # @!attribute [rw] data_source
          #   @return [::String]
          #     Required. The data source of the
          #     [promotion](https://support.google.com/merchants/answer/6396268?sjid=5155774230887277618-NC)
          #     Format:
          #     `accounts/{account}/dataSources/{datasource}`.
          class InsertPromotionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `GetPromotion` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the promotion to retrieve.
          #     Format: `accounts/{account}/promotions/{promotions}`
          class GetPromotionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `ListPromotions` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The account to list processed promotions for.
          #     Format: `accounts/{account}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of promotions to return. The service may
          #     return fewer than this value. The maximum value is 250; values above 250
          #     will be coerced to 250. If unspecified, the maximum number of promotions
          #     will be returned.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from a previous `ListPromotions` call.
          #     Provide this to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to `ListPromotions` must
          #     match the call that provided the page token.
          class ListPromotionsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the `ListPromotions` method.
          # @!attribute [rw] promotions
          #   @return [::Array<::Google::Shopping::Merchant::Promotions::V1::Promotion>]
          #     The processed promotions from the specified account.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListPromotionsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
