# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/shopping/merchant/products/v1beta/productinputs.proto for package 'google.shopping.merchant.products.v1beta'
# Original file comments:
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/shopping/merchant/products/v1beta/productinputs_pb'

module Google
  module Shopping
    module Merchant
      module Products
        module V1beta
          module ProductInputsService
            # Service to use ProductInput resource.
            # This service works for products with online channel only.
            class Service

              include ::GRPC::GenericService

              self.marshal_class_method = :encode
              self.unmarshal_class_method = :decode
              self.service_name = 'google.shopping.merchant.products.v1beta.ProductInputsService'

              # [Uploads a product input to your Merchant Center
              # account](/merchant/api/guides/products/overview#upload-product-input). You
              # must have a products data source to be able to insert a product. The unique
              # identifier of the data source is passed as a query parameter in the request
              # URL.
              #
              # If an input with the same contentLanguage, offerId, and dataSource already
              # exists, this method replaces that entry.
              #
              # After inserting, updating, or deleting a product input, it may take several
              # minutes before the processed product can be retrieved.
              rpc :InsertProductInput, ::Google::Shopping::Merchant::Products::V1beta::InsertProductInputRequest, ::Google::Shopping::Merchant::Products::V1beta::ProductInput
              # Updates the existing product input in your Merchant Center account.
              #
              # After inserting, updating, or deleting a product input, it may take several
              # minutes before the processed product can be retrieved.
              rpc :UpdateProductInput, ::Google::Shopping::Merchant::Products::V1beta::UpdateProductInputRequest, ::Google::Shopping::Merchant::Products::V1beta::ProductInput
              # Deletes a product input from your Merchant Center account.
              #
              # After inserting, updating, or deleting a product input, it may take several
              # minutes before the processed product can be retrieved.
              rpc :DeleteProductInput, ::Google::Shopping::Merchant::Products::V1beta::DeleteProductInputRequest, ::Google::Protobuf::Empty
            end

            Stub = Service.rpc_stub_class
          end
        end
      end
    end
  end
end
