# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/shopping/merchant/products/v1/productinputs_pb"
require "google/shopping/merchant/products/v1/product_inputs_service"

class ::Google::Shopping::Merchant::Products::V1::ProductInputsService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_insert_product_input
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Products::V1::ProductInput.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    product_input = {}
    data_source = "hello world"

    insert_product_input_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :insert_product_input, name
      assert_kind_of ::Google::Shopping::Merchant::Products::V1::InsertProductInputRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Merchant::Products::V1::ProductInput), request["product_input"]
      assert_equal "hello world", request["data_source"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, insert_product_input_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Products::V1::ProductInputsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.insert_product_input({ parent: parent, product_input: product_input, data_source: data_source }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.insert_product_input parent: parent, product_input: product_input, data_source: data_source do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.insert_product_input ::Google::Shopping::Merchant::Products::V1::InsertProductInputRequest.new(parent: parent, product_input: product_input, data_source: data_source) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.insert_product_input({ parent: parent, product_input: product_input, data_source: data_source }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.insert_product_input(::Google::Shopping::Merchant::Products::V1::InsertProductInputRequest.new(parent: parent, product_input: product_input, data_source: data_source), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, insert_product_input_client_stub.call_rpc_count
    end
  end

  def test_update_product_input
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Products::V1::ProductInput.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    product_input = {}
    update_mask = {}
    data_source = "hello world"

    update_product_input_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_product_input, name
      assert_kind_of ::Google::Shopping::Merchant::Products::V1::UpdateProductInputRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Merchant::Products::V1::ProductInput), request["product_input"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["data_source"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_product_input_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Products::V1::ProductInputsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_product_input({ product_input: product_input, update_mask: update_mask, data_source: data_source }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_product_input product_input: product_input, update_mask: update_mask, data_source: data_source do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_product_input ::Google::Shopping::Merchant::Products::V1::UpdateProductInputRequest.new(product_input: product_input, update_mask: update_mask, data_source: data_source) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_product_input({ product_input: product_input, update_mask: update_mask, data_source: data_source }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_product_input(::Google::Shopping::Merchant::Products::V1::UpdateProductInputRequest.new(product_input: product_input, update_mask: update_mask, data_source: data_source), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_product_input_client_stub.call_rpc_count
    end
  end

  def test_delete_product_input
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    data_source = "hello world"

    delete_product_input_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_product_input, name
      assert_kind_of ::Google::Shopping::Merchant::Products::V1::DeleteProductInputRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["data_source"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_product_input_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Products::V1::ProductInputsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_product_input({ name: name, data_source: data_source }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_product_input name: name, data_source: data_source do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_product_input ::Google::Shopping::Merchant::Products::V1::DeleteProductInputRequest.new(name: name, data_source: data_source) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_product_input({ name: name, data_source: data_source }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_product_input(::Google::Shopping::Merchant::Products::V1::DeleteProductInputRequest.new(name: name, data_source: data_source), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_product_input_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Products::V1::ProductInputsService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Shopping::Merchant::Products::V1::ProductInputsService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Products::V1::ProductInputsService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Shopping::Merchant::Products::V1::ProductInputsService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
