# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Products
        module V1
          # Product attributes.
          # @!attribute [rw] identifier_exists
          #   @return [::Boolean]
          #     Set this value to false when the item does not have unique product
          #     identifiers appropriate to its category, such as GTIN, MPN, and brand.
          #     Defaults to true, if not provided.
          # @!attribute [rw] is_bundle
          #   @return [::Boolean]
          #     Whether the item is a business-defined sub-API. A [sub-API]
          #     (https://support.google.com/merchants/answer/6324449) is a custom
          #     grouping of different products sold by a business for a single price.
          # @!attribute [rw] title
          #   @return [::String]
          #     Title of the item.
          # @!attribute [rw] description
          #   @return [::String]
          #     Description of the item.
          # @!attribute [rw] link
          #   @return [::String]
          #     URL directly linking to your item's page on your online store.
          # @!attribute [rw] mobile_link
          #   @return [::String]
          #     URL for the mobile-optimized version of your item's landing page.
          # @!attribute [rw] canonical_link
          #   @return [::String]
          #     URL for the canonical version of your item's landing page.
          # @!attribute [rw] image_link
          #   @return [::String]
          #     URL of an image of the item.
          # @!attribute [rw] additional_image_links
          #   @return [::Array<::String>]
          #     Additional URLs of images of the item.
          # @!attribute [rw] expiration_date
          #   @return [::Google::Protobuf::Timestamp]
          #     Date on which the item should expire, as specified upon insertion, in
          #     [ISO
          #     8601](http://en.wikipedia.org/wiki/ISO_8601) format. The actual
          #     expiration date is exposed in `productstatuses` as
          #     [googleExpirationDate](https://support.google.com/merchants/answer/6324499)
          #     and might be earlier if `expirationDate` is too far in the future.
          # @!attribute [rw] disclosure_date
          #   @return [::Google::Protobuf::Timestamp]
          #     The date time when an offer becomes visible in search results across
          #     Google’s YouTube surfaces, in [ISO
          #     8601](http://en.wikipedia.org/wiki/ISO_8601) format.
          #     See [Disclosure date](https://support.google.com/merchants/answer/13034208)
          #     for more information.
          # @!attribute [rw] adult
          #   @return [::Boolean]
          #     Set to true if the item is targeted towards adults.
          # @!attribute [rw] age_group
          #   @return [::Google::Shopping::Merchant::Products::V1::AgeGroup]
          #     Target [age group](https://support.google.com/merchants/answer/6324463) of
          #     the item.
          # @!attribute [rw] availability
          #   @return [::Google::Shopping::Merchant::Products::V1::Availability]
          #     [Availability](https://support.google.com/merchants/answer/6324448) status
          #     of the item.
          # @!attribute [rw] availability_date
          #   @return [::Google::Protobuf::Timestamp]
          #     The day a pre-ordered product becomes available for delivery, in [ISO
          #     8601](http://en.wikipedia.org/wiki/ISO_8601) format.
          # @!attribute [rw] brand
          #   @return [::String]
          #     [Brand](https://support.google.com/merchants/answer/6324351) of the item.
          #     For example, "Google".
          # @!attribute [rw] color
          #   @return [::String]
          #     [Color](https://support.google.com/merchants/answer/6324487) of the item.
          #     For example, "red".
          # @!attribute [rw] condition
          #   @return [::Google::Shopping::Merchant::Products::V1::Condition]
          #     [Condition](https://support.google.com/merchants/answer/6324469) or state
          #     of the item.
          # @!attribute [rw] gender
          #   @return [::Google::Shopping::Merchant::Products::V1::Gender]
          #     Target [gender](https://support.google.com/merchants/answer/6324479) of the
          #     item.
          # @!attribute [rw] google_product_category
          #   @return [::String]
          #     Google's category of the item (see [Google product
          #     taxonomy](https://support.google.com/merchants/answer/1705911)). When
          #     querying products, this field will contain the user provided value. There
          #     is currently no way to get back the auto assigned google product
          #     categories through the API.
          # @!attribute [rw] gtins
          #   @return [::Array<::String>]
          #     Global Trade Item Numbers
          #     ([GTIN](https://support.google.com/merchants/answer/188494#gtin)) of the
          #     item.
          #     You can provide up to 10 GTINs.
          # @!attribute [rw] item_group_id
          #   @return [::String]
          #     Shared identifier for all variants of the same product.
          # @!attribute [rw] material
          #   @return [::String]
          #     The [material](https://support.google.com/merchants/answer/6324410) of
          #     which the item is made. For example, "Leather" or "Cotton".
          # @!attribute [rw] mpn
          #   @return [::String]
          #     Manufacturer Part Number
          #     ([MPN](https://support.google.com/merchants/answer/188494#mpn)) of the
          #     item.
          # @!attribute [rw] pattern
          #   @return [::String]
          #     The item's [pattern](https://support.google.com/merchants/answer/6324483).
          #     For example, polka dots.
          # @!attribute [rw] price
          #   @return [::Google::Shopping::Type::Price]
          #     Price of the item.
          # @!attribute [rw] maximum_retail_price
          #   @return [::Google::Shopping::Type::Price]
          #     Maximum retail price (MRP) of the item. Applicable to India only.
          # @!attribute [rw] installment
          #   @return [::Google::Shopping::Merchant::Products::V1::ProductInstallment]
          #     Number and amount of installments to pay for an item.
          # @!attribute [rw] subscription_cost
          #   @return [::Google::Shopping::Merchant::Products::V1::SubscriptionCost]
          #     Number of periods (months or years) and amount of payment per period
          #     for an item with an associated subscription contract.
          # @!attribute [rw] loyalty_points
          #   @return [::Google::Shopping::Merchant::Products::V1::LoyaltyPoints]
          #     Loyalty points that users receive after purchasing the item. Japan only.
          # @!attribute [rw] loyalty_programs
          #   @return [::Array<::Google::Shopping::Merchant::Products::V1::LoyaltyProgram>]
          #     A list of loyalty program information that is used to surface loyalty
          #     benefits (for example, better pricing, points, etc) to the user of this
          #     item.
          # @!attribute [rw] product_types
          #   @return [::Array<::String>]
          #     Categories of the item (formatted as in [product data
          #     specification](https://support.google.com/merchants/answer/7052112#product_category)).
          # @!attribute [rw] sale_price
          #   @return [::Google::Shopping::Type::Price]
          #     Advertised sale price of the item.
          # @!attribute [rw] sale_price_effective_date
          #   @return [::Google::Type::Interval]
          #     Date range during which the item is on sale, see [product data
          #     specification](https://support.google.com/merchants/answer/7052112#price_and_availability).
          # @!attribute [rw] sell_on_google_quantity
          #   @return [::Integer]
          #     The quantity of the product that is available for selling on Google.
          #     Supported only for online products.
          # @!attribute [rw] product_height
          #   @return [::Google::Shopping::Merchant::Products::V1::ProductDimension]
          #     The height of the product in the units provided. The value must be
          #     between
          #     0 (exclusive) and 3000 (inclusive).
          # @!attribute [rw] product_length
          #   @return [::Google::Shopping::Merchant::Products::V1::ProductDimension]
          #     The length of the product in the units provided. The value must be
          #     between 0 (exclusive) and 3000 (inclusive).
          # @!attribute [rw] product_width
          #   @return [::Google::Shopping::Merchant::Products::V1::ProductDimension]
          #     The width of the product in the units provided. The value must be between
          #     0 (exclusive) and 3000 (inclusive).
          # @!attribute [rw] product_weight
          #   @return [::Google::Shopping::Merchant::Products::V1::ProductWeight]
          #     The weight of the product in the units provided. The value must be
          #     between 0 (exclusive) and 2000 (inclusive).
          # @!attribute [rw] shipping
          #   @return [::Array<::Google::Shopping::Merchant::Products::V1::Shipping>]
          #     Shipping rules.
          # @!attribute [rw] carrier_shipping
          #   @return [::Array<::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping>]
          #     Rules for carrier-based shipping.
          # @!attribute [rw] free_shipping_threshold
          #   @return [::Array<::Google::Shopping::Merchant::Products::V1::FreeShippingThreshold>]
          #     Conditions to be met for a product to have free shipping.
          # @!attribute [rw] shipping_weight
          #   @return [::Google::Shopping::Merchant::Products::V1::ShippingWeight]
          #     Weight of the item for shipping.
          # @!attribute [rw] shipping_length
          #   @return [::Google::Shopping::Merchant::Products::V1::ShippingDimension]
          #     Length of the item for shipping.
          # @!attribute [rw] shipping_width
          #   @return [::Google::Shopping::Merchant::Products::V1::ShippingDimension]
          #     Width of the item for shipping.
          # @!attribute [rw] shipping_height
          #   @return [::Google::Shopping::Merchant::Products::V1::ShippingDimension]
          #     Height of the item for shipping.
          # @!attribute [rw] max_handling_time
          #   @return [::Integer]
          #     Maximal product handling time (in business days).
          # @!attribute [rw] min_handling_time
          #   @return [::Integer]
          #     Minimal product handling time (in business days).
          # @!attribute [rw] shipping_label
          #   @return [::String]
          #     The shipping label of the product, used to group product in account-level
          #     shipping rules.
          # @!attribute [rw] transit_time_label
          #   @return [::String]
          #     The transit time label of the product, used to group product in
          #     account-level transit time tables.
          # @!attribute [rw] size
          #   @return [::String]
          #     Size of the item. Only one value is allowed. For variants with different
          #     sizes, insert a separate product for each size with the same
          #     `itemGroupId` value, see
          #     [Size](https://support.google.com/merchants/answer/6324492).
          # @!attribute [rw] size_system
          #   @return [::Google::Shopping::Merchant::Products::V1::SizeSystem]
          #     System in which the size is specified. Recommended for apparel items.
          #     For more information, see
          #     [Size system](https://support.google.com/merchants/answer/6324502).
          # @!attribute [rw] size_types
          #   @return [::Array<::Google::Shopping::Merchant::Products::V1::SizeType>]
          #     The cut of the item. It can be used to represent combined size types for
          #     apparel items. Maximum two of size types can be provided, see
          #     [Size type](https://support.google.com/merchants/answer/6324497).
          # @!attribute [rw] energy_efficiency_class
          #   @return [::Google::Shopping::Merchant::Products::V1::EnergyEfficiencyClass]
          #     The [energy efficiency
          #     class](https://support.google.com/merchants/answer/7562785) as defined in
          #     EU directive 2010/30/EU.
          # @!attribute [rw] min_energy_efficiency_class
          #   @return [::Google::Shopping::Merchant::Products::V1::EnergyEfficiencyClass]
          #     The [energy efficiency
          #     class](https://support.google.com/merchants/answer/7562785) as defined in
          #     EU directive 2010/30/EU.
          # @!attribute [rw] max_energy_efficiency_class
          #   @return [::Google::Shopping::Merchant::Products::V1::EnergyEfficiencyClass]
          #     The [energy efficiency
          #     class](https://support.google.com/merchants/answer/7562785) as defined in
          #     EU directive 2010/30/EU.
          # @!attribute [rw] unit_pricing_measure
          #   @return [::Google::Shopping::Merchant::Products::V1::UnitPricingMeasure]
          #     The measure and dimension of an item.
          # @!attribute [rw] unit_pricing_base_measure
          #   @return [::Google::Shopping::Merchant::Products::V1::UnitPricingBaseMeasure]
          #     The preference of the denominator of the unit price.
          # @!attribute [rw] multipack
          #   @return [::Integer]
          #     The number of identical products in a business-defined multipack.
          # @!attribute [rw] ads_grouping
          #   @return [::String]
          #     Used to group items in an arbitrary way. Only for CPA%, discouraged
          #     otherwise. For more information, see
          #     [Display ads
          #     attribute](https://support.google.com/merchants/answer/6069387).
          # @!attribute [rw] ads_labels
          #   @return [::Array<::String>]
          #     Similar to ads_grouping, but only works on CPC.
          # @!attribute [rw] ads_redirect
          #   @return [::String]
          #     Allows advertisers to override the item URL when the product is shown
          #     within the context of Product ads.
          # @!attribute [rw] cost_of_goods_sold
          #   @return [::Google::Shopping::Type::Price]
          #     Cost of goods sold. Used for gross profit reporting.
          # @!attribute [rw] product_details
          #   @return [::Array<::Google::Shopping::Merchant::Products::V1::ProductDetail>]
          #     Technical specification or additional product details.
          # @!attribute [rw] product_highlights
          #   @return [::Array<::String>]
          #     Bullet points describing the most relevant [product
          #     highlights](https://support.google.com/merchants/answer/9216100).
          # @!attribute [rw] display_ads_id
          #   @return [::String]
          #     An identifier for an item for dynamic remarketing campaigns.
          # @!attribute [rw] display_ads_similar_ids
          #   @return [::Array<::String>]
          #     Advertiser-specified recommendations. For more information, see
          #     [Display ads attribute
          #     specification](https://support.google.com/merchants/answer/6069387).
          # @!attribute [rw] display_ads_title
          #   @return [::String]
          #     Title of an item for dynamic remarketing campaigns.
          # @!attribute [rw] display_ads_link
          #   @return [::String]
          #     URL directly to your item's landing page for dynamic remarketing
          #     campaigns.
          # @!attribute [rw] display_ads_value
          #   @return [::Float]
          #     Offer margin for dynamic remarketing campaigns. For more information, see
          #     [Display ads
          #     attribute](https://support.google.com/merchants/answer/6069387).
          # @!attribute [rw] promotion_ids
          #   @return [::Array<::String>]
          #     The unique ID of a promotion.
          # @!attribute [rw] pickup_method
          #   @return [::Google::Shopping::Merchant::Products::V1::PickupMethod]
          #     The [pickup](https://support.google.com/merchants/answer/14634021) option
          #     for the item.
          # @!attribute [rw] pickup_sla
          #   @return [::Google::Shopping::Merchant::Products::V1::PickupSla]
          #     Item store pickup timeline. For more information, see
          #     [Pickup SLA](https://support.google.com/merchants/answer/14635400).
          # @!attribute [rw] link_template
          #   @return [::String]
          #     [Link template](https://support.google.com/merchants/answer/13871172) for
          #     business hosted local storefront.
          # @!attribute [rw] mobile_link_template
          #   @return [::String]
          #     [Link template](https://support.google.com/merchants/answer/13870216) for
          #     business hosted local storefront optimized for mobile
          #     devices.
          # @!attribute [rw] custom_label_0
          #   @return [::String]
          #     [Custom label 0](https://support.google.com/merchants/answer/6324473) for
          #     custom grouping of items in a Shopping campaign.
          # @!attribute [rw] custom_label_1
          #   @return [::String]
          #     [Custom label 1](https://support.google.com/merchants/answer/6324473)
          #     for custom grouping of items in a Shopping campaign.
          # @!attribute [rw] custom_label_2
          #   @return [::String]
          #     [Custom label 2](https://support.google.com/merchants/answer/6324473)
          #     for custom grouping of items in a Shopping campaign.
          # @!attribute [rw] custom_label_3
          #   @return [::String]
          #     [Custom label 3](https://support.google.com/merchants/answer/6324473)
          #     for custom grouping of items in a Shopping campaign.
          # @!attribute [rw] custom_label_4
          #   @return [::String]
          #     [Custom label 4](https://support.google.com/merchants/answer/6324473) for
          #     custom grouping of items in a Shopping campaign.
          # @!attribute [rw] included_destinations
          #   @return [::Array<::Google::Shopping::Type::Destination::DestinationEnum>]
          #     The list of destinations to include for this target (corresponds to
          #     checked check boxes in Merchant Center). Default destinations are always
          #     included unless provided in `excludedDestinations`.
          #
          #     For more information, see
          #     [Included
          #     destination](https://support.google.com/merchants/answer/7501026).
          #
          #     Note: We recommend setting destinations on datasources level for most use
          #     cases. Use this field within products to only setup exceptions.
          # @!attribute [rw] excluded_destinations
          #   @return [::Array<::Google::Shopping::Type::Destination::DestinationEnum>]
          #     The list of destinations to exclude for this target (corresponds to
          #     unchecked check boxes in Merchant Center).
          #
          #     For more information, see
          #     [Excluded
          #     destination](https://support.google.com/merchants/answer/6324486).
          #
          #     Note: We recommend setting destinations on datasources level for most use
          #     cases. Use this field within products to only setup exceptions.
          # @!attribute [rw] shopping_ads_excluded_countries
          #   @return [::Array<::String>]
          #     List of country codes [(ISO 3166-1
          #     alpha-2)](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) to exclude the
          #     offer from Shopping Ads destination. Countries from this list are removed
          #     from countries configured in data source settings.
          # @!attribute [rw] external_seller_id
          #   @return [::String]
          #     Required for multi-seller accounts. Use this attribute if you're a
          #     marketplace uploading products for various sellers to your multi-seller
          #     account.
          # @!attribute [rw] pause
          #   @return [::Google::Shopping::Merchant::Products::V1::Pause]
          #     Publication of this item will be temporarily
          #     [paused](https://support.google.com/merchants/answer/11909930).
          # @!attribute [rw] lifestyle_image_links
          #   @return [::Array<::String>]
          #     Additional URLs of lifestyle images of the item, used to explicitly
          #     identify images that showcase your item in a real-world context. See the
          #     [Help Center article](https://support.google.com/merchants/answer/9103186)
          #     for more information.
          # @!attribute [rw] cloud_export_additional_properties
          #   @return [::Array<::Google::Shopping::Merchant::Products::V1::CloudExportAdditionalProperties>]
          #     Extra fields to export to the Cloud Retail program.
          # @!attribute [rw] virtual_model_link
          #   @return [::String]
          #     URL of the 3D image of the item. See the
          #     [Help Center article](https://support.google.com/merchants/answer/13674896)
          #     for more information.
          # @!attribute [rw] certifications
          #   @return [::Array<::Google::Shopping::Merchant::Products::V1::ProductCertification>]
          #     Product Certifications, for example for energy efficiency labeling of
          #     products recorded in the [EU EPREL](https://eprel.ec.europa.eu/screen/home)
          #     database. See the [Help
          #     Center](https://support.google.com/merchants/answer/13528839)
          #     article for more information.
          # @!attribute [rw] structured_title
          #   @return [::Google::Shopping::Merchant::Products::V1::StructuredTitle]
          #     Structured title, for algorithmically (AI)-generated titles.
          # @!attribute [rw] structured_description
          #   @return [::Google::Shopping::Merchant::Products::V1::StructuredDescription]
          #     Structured description, for algorithmically (AI)-generated descriptions.
          # @!attribute [rw] auto_pricing_min_price
          #   @return [::Google::Shopping::Type::Price]
          #     A safeguard in the [automated discounts]
          #     (https://support.google.com/merchants/answer/10295759) and
          #     "Dynamic Promotions"
          #     (https://support.google.com/merchants/answer/13949249) projects,
          #     ensuring that discounts on business offers do not fall below this value,
          #     thereby preserving the offer's value and profitability.
          # @!attribute [rw] sustainability_incentives
          #   @return [::Array<::Google::Shopping::Merchant::Products::V1::ProductSustainabilityIncentive>]
          #     The list of sustainability incentive programs.
          class ProductAttributes
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Carrier-based shipping configuration. Allows for setting shipping speed or
            # shipping cost based on a carrier's provided info.
            # @!attribute [rw] country
            #   @return [::String]
            #     The [CLDR territory
            #     code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
            #     of the country to which an item will ship.
            # @!attribute [rw] region
            #   @return [::String]
            #     The geographic region to which a shipping rate applies.
            #     See [region](https://support.google.com/merchants/answer/6324484) for
            #     more information.
            # @!attribute [rw] postal_code
            #   @return [::String]
            #     The postal code range that the shipping rate applies to, represented by
            #     a postal code (eg. `94043`), a postal code prefix followed by a *
            #     wildcard (eg. `94*`), a range between two postal codes (eg.
            #     `94043-98033`) or two postal code prefixes of equal length (eg.
            #     `94*-98*`).
            # @!attribute [rw] origin_postal_code
            #   @return [::String]
            #     The source location postal code from which this offer ships. Represented
            #     only by a full-length postal code.
            # @!attribute [rw] flat_price
            #   @return [::Google::Shopping::Type::Price]
            #     Fixed shipping price, represented as a number with currency. Cannot be
            #     set together with
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#carrier_price carrierPrice}
            #     or its adjustments
            #     ({::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#carrier_price_flat_adjustment carrierPriceFlatAdjustment},
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#carrier_price_percentage_adjustment carrierPricePercentageAdjustment}).
            # @!attribute [rw] carrier_price
            #   @return [::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierPriceOption]
            #     Selected carrier to calculate the shipping price from. Select a carrier
            #     from the [available carriers
            #     list](https://support.google.com/merchants/answer/15449142#Supported),
            #     for example `AUSTRALIA_POST_REGULAR`. Price will be calculated by this
            #     selected carrier, the location expressed in
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#origin_postal_code originPostalCode},
            #     along with the user location to determine the accurate shipping price.
            #     Carrier is represented by a carrier service name or a carrier service ID.
            #     Cannot be set together with
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#flat_price flatPrice}.
            # @!attribute [rw] carrier_price_flat_adjustment
            #   @return [::Google::Shopping::Type::Price]
            #     A flat adjustment on the carrier price. Can be either positive or
            #     negative. Cannot be zero. Requires `carrier_price` to be present. Cannot
            #     be set together with
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#flat_price flatPrice}
            #     and
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#carrier_price_percentage_adjustment carrierPricePercentageAdjustment}.
            # @!attribute [rw] carrier_price_percentage_adjustment
            #   @return [::Float]
            #     A percentual adjustment on the carrier price. Can be either positive or
            #     negative. Cannot be zero. Requires `carrier_price` to be present. Cannot
            #     be set together with
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#flat_price flatPrice}
            #     and
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#carrier_price_flat_adjustment carrierPriceFlatAdjustment}.
            # @!attribute [rw] min_handling_time
            #   @return [::Integer]
            #     Minimum handling time (inclusive) between when the order is received and
            #     shipped in business days. 0 means that the order is shipped on the same
            #     day as it is received if it happens before the cut-off time.
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#min_handling_time minHandlingTime}
            #     can only be set if
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#max_handling_time maxHandlingTime}
            #     is also set.
            # @!attribute [rw] max_handling_time
            #   @return [::Integer]
            #     Maximum handling time (inclusive) between when the order is received and
            #     shipped in business days. 0 means that the order is shipped on the same
            #     day as it is received if it happens before the cut-off time. Both
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#max_handling_time maxHandlingTime}
            #     and
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#fixed_max_transit_time fixedMaxTransitTime}
            #     or
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#carrier_transit_time carrierTransitTime}
            #     are required if providing shipping speeds.
            # @!attribute [rw] fixed_min_transit_time
            #   @return [::Integer]
            #     Minimum transit time (inclusive) between when the order has shipped and
            #     when it is delivered in business days. 0 means that the order is
            #     delivered on the same day as it ships.
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#fixed_min_transit_time fixedMinTransitTime}
            #     can only be set if
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#fixed_max_transit_time fixedMaxTransitTime}
            #     is set. Cannot be set if
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#carrier_transit_time carrierTransitTime}
            #     is present.
            # @!attribute [rw] fixed_max_transit_time
            #   @return [::Integer]
            #     Maximum transit time (inclusive) between when the order has shipped and
            #     when it is delivered in business days. 0 means that the order is
            #     delivered on the same day as it ships. Needs to be provided together with
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#max_handling_time maxHandlingTime}.
            #     Cannot be set if
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#carrier_transit_time carrierTransitTime}
            #     is present.
            # @!attribute [rw] carrier_transit_time
            #   @return [::Google::Shopping::Merchant::Products::V1::CarrierTransitTimeOption]
            #     Selected carrier to calculate the shipping speed from. Select a carrier
            #     from the [available carriers
            #     list](https://support.google.com/merchants/answer/15449142#Supported),
            #     for example `AUSTRALIA_POST_REGULAR`. Speed will be calculated by this
            #     selected carrier, the location expressed in
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#origin_postal_code originPostalCode},
            #     along with the user location to determine the accurate delivery speed.
            #     Carrier is represented by a carrier service name or a carrier service ID.
            #     Cannot be set together with
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#fixed_max_transit_time fixedMaxTransitTime}
            #     or
            #     {::Google::Shopping::Merchant::Products::V1::ProductAttributes::CarrierShipping#fixed_min_transit_time fixedMinTransitTime}.
            class CarrierShipping
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Possible carrier where price is coming from.
            module CarrierPriceOption
              # Carrier price option is unspecified.
              CARRIER_PRICE_OPTION_UNSPECIFIED = 0

              # Australia Post Regular shipping service.
              AUSTRALIA_POST_REGULAR = 1

              # Australia Post Express shipping service.
              AUSTRALIA_POST_EXPRESS = 2

              # Australia Post Regular Small shipping service.
              AUSTRALIA_POST_REGULAR_S = 3

              # Australia Post Regular Medium shipping service.
              AUSTRALIA_POST_REGULAR_M = 4

              # Australia Post Regular Large shipping service.
              AUSTRALIA_POST_REGULAR_L = 5

              # Australia Post Regular XL shipping service.
              AUSTRALIA_POST_REGULAR_XL = 6

              # Australia Post Express Small shipping service.
              AUSTRALIA_POST_EXPRESS_S = 7

              # Australia Post Express Medium shipping service.
              AUSTRALIA_POST_EXPRESS_M = 8

              # Australia Post Express Large shipping service.
              AUSTRALIA_POST_EXPRESS_L = 9

              # Australia Post Express XL shipping service.
              AUSTRALIA_POST_EXPRESS_XL = 10

              # TNT Road Express shipping service.
              TNT_ROAD_EXPRESS = 11

              # TNT Overnight Express shipping service.
              TNT_OVERNIGHT_EXPRESS = 12

              # Toll Road Delivery shipping service.
              TOLL_ROAD_DELIVERY = 13

              # Toll Overnight Priority shipping service.
              TOLL_OVERNIGHT_PRIORITY = 14

              # DHL Paket shipping service.
              DHL_PAKET = 15

              # DHL Packchen shipping service.
              DHL_PACKCHEN = 16

              # DPD Express 12 shipping service.
              DPD_EXPRESS_12 = 17

              # DPD Express shipping service.
              DPD_EXPRESS = 18

              # DPD Classic Parcel shipping service.
              DPD_CLASSIC_PARCEL = 19

              # Hermes Packchen shipping service.
              HERMES_PACKCHEN = 20

              # Hermes Paketklasse S shipping service.
              HERMES_PAKETKLASSE_S = 21

              # Hermes Paketklasse M shipping service.
              HERMES_PAKETKLASSE_M = 22

              # Hermes Paketklasse L shipping service.
              HERMES_PAKETKLASSE_L = 23

              # UPS Express shipping service.
              UPS_EXPRESS = 24

              # UPS Express Saver shipping service.
              UPS_EXPRESS_SAVER = 25

              # UPS Express Standard shipping service.
              UPS_EXPRESS_STANDARD = 26

              # DHL Express shipping service.
              DHL_EXPRESS = 27

              # DHL Express 12 shipping service.
              DHL_EXPRESS_12 = 28

              # DPD Next Day shipping service.
              DPD_NEXT_DAY = 29

              # DPD Standard Next Day shipping service.
              DPD_STANDARD_NEXT_DAY = 30

              # DPD Standard Two Day shipping service.
              DPD_STANDARD_TWO_DAY = 31

              # RMG 1st Class Small shipping service.
              RMG_1ST_CLASS_SMALL = 32

              # RMG 1st Class Medium shipping service.
              RMG_1ST_CLASS_MEDIUM = 33

              # RMG 2nd Class Small shipping service.
              RMG_2ND_CLASS_SMALL = 34

              # RMG 2nd Class Medium shipping service.
              RMG_2ND_CLASS_MEDIUM = 35

              # TNT Express shipping service.
              TNT_EXPRESS = 36

              # TNT Express 10 shipping service.
              TNT_EXPRESS_10 = 37

              # TNT Express 12 shipping service.
              TNT_EXPRESS_12 = 38

              # Yodel B2C 48HR shipping service.
              YODEL_B2C_48HR = 39

              # Yodel B2C 72HR shipping service.
              YODEL_B2C_72HR = 40

              # Yodel B2C Packet shipping service.
              YODEL_B2C_PACKET = 41

              # FedEx Ground shipping service.
              FEDEX_GROUND = 42

              # FedEx Home Delivery shipping service.
              FEDEX_HOME_DELIVERY = 43

              # FedEx Express Saver shipping service.
              FEDEX_EXPRESS_SAVER = 44

              # FedEx First Overnight shipping service.
              FEDEX_FIRST_OVERNIGHT = 45

              # FedEx Priority Overnight shipping service.
              FEDEX_PRIORITY_OVERNIGHT = 46

              # FedEx Standard Overnight shipping service.
              FEDEX_STANDARD_OVERNIGHT = 47

              # FedEx 2Day shipping service.
              FEDEX_2DAY = 48

              # UPS Standard shipping service.
              UPS_STANDARD = 49

              # UPS 2nd Day Air shipping service.
              UPS_2ND_DAY_AIR = 50

              # UPS 2nd Day AM shipping service.
              UPS_2ND_DAY_AM = 51

              # UPS 3 Day Select shipping service.
              UPS_3_DAY_SELECT = 52

              # UPS Ground shipping service.
              UPS_GROUND = 53

              # UPS Next Day Air shipping service.
              UPS_NEXT_DAY_AIR = 54

              # UPS Next Day Air Early AM shipping service.
              UPS_NEXT_DAY_AIR_EARLY_AM = 55

              # UPS Next Day Air Saver shipping service.
              UPS_NEXT_DAY_AIR_SAVER = 56

              # USPS Priority Mail Express shipping service.
              USPS_PRIORITY_MAIL_EXPRESS = 57

              # USPS Media Mail shipping service.
              USPS_MEDIA_MAIL = 58

              # USPS Ground Advantage Retail shipping service.
              USPS_GROUND_ADVANTAGE_RETAIL = 59

              # USPS Priority Mail shipping service.
              USPS_PRIORITY_MAIL = 60

              # USPS Ground Advantage Commercial shipping service.
              USPS_GROUND_ADVANTAGE_COMMERCIAL = 61
            end
          end

          # The ShippingWeight of the product.
          # @!attribute [rw] value
          #   @return [::Float]
          #     The weight of the product used to calculate the shipping cost of the
          #     item.
          # @!attribute [rw] unit
          #   @return [::String]
          #     The unit of value.
          class ShippingWeight
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The ShippingDimension of the product.
          # @!attribute [rw] value
          #   @return [::Float]
          #     The dimension of the product used to calculate the shipping cost of the
          #     item.
          # @!attribute [rw] unit
          #   @return [::String]
          #     The unit of value.
          class ShippingDimension
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The UnitPricingBaseMeasure of the product.
          # @!attribute [rw] value
          #   @return [::Integer]
          #     The denominator of the unit price.
          # @!attribute [rw] unit
          #   @return [::String]
          #     The unit of the denominator.
          class UnitPricingBaseMeasure
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The UnitPricingMeasure of the product.
          # @!attribute [rw] value
          #   @return [::Float]
          #     The measure of an item.
          # @!attribute [rw] unit
          #   @return [::String]
          #     The unit of the measure.
          class UnitPricingMeasure
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The SubscriptionCost of the product.
          # @!attribute [rw] period
          #   @return [::Google::Shopping::Merchant::Products::V1::SubscriptionPeriod]
          #     The type of subscription period.
          #     Supported values are:
          #       * "`month`"
          #       * "`year`"
          # @!attribute [rw] period_length
          #   @return [::Integer]
          #     The number of subscription periods the buyer has to pay.
          # @!attribute [rw] amount
          #   @return [::Google::Shopping::Type::Price]
          #     The amount the buyer has to pay per subscription period.
          class SubscriptionCost
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A message that represents installment.
          # @!attribute [rw] months
          #   @return [::Integer]
          #     The number of installments the buyer has to pay.
          # @!attribute [rw] amount
          #   @return [::Google::Shopping::Type::Price]
          #     The amount the buyer has to pay per month.
          # @!attribute [rw] downpayment
          #   @return [::Google::Shopping::Type::Price]
          #     The up-front down payment amount the buyer has to pay.
          # @!attribute [rw] credit_type
          #   @return [::Google::Shopping::Merchant::Products::V1::CreditType]
          #     Type of installment payments.
          class ProductInstallment
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A message that represents loyalty points.
          # @!attribute [rw] name
          #   @return [::String]
          #     Name of loyalty points program. It is recommended to limit the name to
          #     12 full-width characters or 24 Roman characters.
          # @!attribute [rw] points_value
          #   @return [::Integer]
          #     The retailer's loyalty points in absolute value.
          # @!attribute [rw] ratio
          #   @return [::Float]
          #     The ratio of a point when converted to currency. Google assumes currency
          #     based on Merchant Center settings. If ratio is left out, it defaults to
          #     1.0.
          class LoyaltyPoints
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A message that represents loyalty program.
          # @!attribute [rw] program_label
          #   @return [::String]
          #     The label of the loyalty program. This is an internal label that uniquely
          #     identifies the relationship between a business entity and a loyalty
          #     program entity. The label must be provided so that the system can associate
          #     the assets below (for example, price and points) with a business. The
          #     corresponding program must be linked to the Merchant Center account.
          # @!attribute [rw] tier_label
          #   @return [::String]
          #     The label of the tier within the loyalty program.
          #     Must match one of the labels within the program.
          # @!attribute [rw] price
          #   @return [::Google::Shopping::Type::Price]
          #     The price for members of the given tier, that is, the instant discount
          #     price. Must be smaller or equal to the regular price.
          # @!attribute [rw] cashback_for_future_use
          #   @return [::Google::Shopping::Type::Price]
          #     The cashback that can be used for future purchases.
          # @!attribute [rw] loyalty_points
          #   @return [::Integer]
          #     The amount of loyalty points earned on a purchase.
          # @!attribute [rw] member_price_effective_date
          #   @return [::Google::Type::Interval]
          #     A date range during which the item is eligible for member price. If not
          #     specified, the member price is always applicable. The date range is
          #     represented by a pair of ISO 8601 dates separated by a space,
          #     comma, or slash.
          # @!attribute [rw] shipping_label
          #   @return [::String]
          #     The label of the shipping benefit. If the field has value, this offer has
          #     loyalty shipping benefit. If the field value isn't provided, the item is
          #     not eligible for loyalty shipping for the given loyalty tier.
          class LoyaltyProgram
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The Shipping of the product.
          # @!attribute [rw] price
          #   @return [::Google::Shopping::Type::Price]
          #     Fixed shipping price, represented as a number.
          # @!attribute [rw] country
          #   @return [::String]
          #     The [CLDR territory
          #     code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
          #     of the country to which an item will ship.
          # @!attribute [rw] region
          #   @return [::String]
          #     The geographic region to which a shipping rate applies.
          #     See [region](https://support.google.com/merchants/answer/6324484) for more
          #     information.
          # @!attribute [rw] service
          #   @return [::String]
          #     A free-form description of the service class or delivery speed.
          # @!attribute [rw] location_id
          #   @return [::Integer]
          #     The numeric ID of a location that the shipping rate applies to as
          #     defined in the [AdWords
          #     API](https://developers.google.com/adwords/api/docs/appendix/geotargeting).
          # @!attribute [rw] location_group_name
          #   @return [::String]
          #     The location where the shipping is applicable, represented by a
          #     location group name.
          # @!attribute [rw] postal_code
          #   @return [::String]
          #     The postal code range that the shipping rate applies to, represented by
          #     a postal code, a postal code prefix followed by a * wildcard, a range
          #     between two postal codes or two postal code prefixes of equal length.
          # @!attribute [rw] min_handling_time
          #   @return [::Integer]
          #     Minimum handling time (inclusive) between when the order is received and
          #     shipped in business days. 0 means that the order is shipped on the same
          #     day as it is received if it happens before the cut-off time.
          #     {::Google::Shopping::Merchant::Products::V1::Shipping#min_handling_time minHandlingTime}
          #     can only be present together with
          #     {::Google::Shopping::Merchant::Products::V1::Shipping#max_handling_time maxHandlingTime};
          #     but it is not required if
          #     {::Google::Shopping::Merchant::Products::V1::Shipping#max_handling_time maxHandlingTime}
          #     is present.
          # @!attribute [rw] max_handling_time
          #   @return [::Integer]
          #     Maximum handling time (inclusive) between when the order is received and
          #     shipped in business days. 0 means that the order is shipped on the same
          #     day as it is received if it happens before the cut-off time. Both
          #     {::Google::Shopping::Merchant::Products::V1::Shipping#max_handling_time maxHandlingTime}
          #     and
          #     {::Google::Shopping::Merchant::Products::V1::Shipping#max_transit_time maxTransitTime}
          #     are required if providing shipping speeds.
          #     {::Google::Shopping::Merchant::Products::V1::Shipping#min_handling_time minHandlingTime}
          #     is optional if
          #     {::Google::Shopping::Merchant::Products::V1::Shipping#max_handling_time maxHandlingTime}
          #     is present.
          # @!attribute [rw] min_transit_time
          #   @return [::Integer]
          #     Minimum transit time (inclusive) between when the order has shipped and
          #     when it is delivered in business days. 0 means that the order is
          #     delivered on the same day as it ships.
          #     {::Google::Shopping::Merchant::Products::V1::Shipping#min_transit_time minTransitTime}
          #     can only be present together with
          #     {::Google::Shopping::Merchant::Products::V1::Shipping#max_transit_time maxTransitTime};
          #     but it is not required if
          #     {::Google::Shopping::Merchant::Products::V1::Shipping#max_transit_time maxTransitTime}
          #     is present.
          # @!attribute [rw] max_transit_time
          #   @return [::Integer]
          #     Maximum transit time (inclusive) between when the order has shipped and
          #     when it is delivered in business days. 0 means that the order is
          #     delivered on the same day as it ships. Both
          #     {::Google::Shopping::Merchant::Products::V1::Shipping#max_handling_time maxHandlingTime}
          #     and
          #     {::Google::Shopping::Merchant::Products::V1::Shipping#max_transit_time maxTransitTime}
          #     are required if providing shipping speeds.
          #     {::Google::Shopping::Merchant::Products::V1::Shipping#min_transit_time minTransitTime}
          #     is optional if
          #     {::Google::Shopping::Merchant::Products::V1::Shipping#max_transit_time maxTransitTime}
          #     is present.
          class Shipping
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Conditions to be met for a product to have free shipping.
          # @!attribute [rw] country
          #   @return [::String]
          #     The [CLDR territory
          #     code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
          #     of the country to which an item will ship.
          # @!attribute [rw] price_threshold
          #   @return [::Google::Shopping::Type::Price]
          #     The minimum product price for the shipping cost to become free. Represented
          #     as a number.
          class FreeShippingThreshold
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The product details.
          # @!attribute [rw] section_name
          #   @return [::String]
          #     The section header used to group a set of product details.
          # @!attribute [rw] attribute_name
          #   @return [::String]
          #     The name of the product detail.
          # @!attribute [rw] attribute_value
          #   @return [::String]
          #     The value of the product detail.
          class ProductDetail
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Product
          # [certification](https://support.google.com/merchants/answer/13528839),
          # initially introduced for EU energy efficiency labeling compliance using the
          # EU EPREL database.
          # @!attribute [rw] certification_authority
          #   @return [::Google::Shopping::Merchant::Products::V1::CertificationAuthority]
          #     The certification authority.
          # @!attribute [rw] certification_name
          #   @return [::Google::Shopping::Merchant::Products::V1::CertificationName]
          #     The name of the certification.
          # @!attribute [rw] certification_code
          #   @return [::String]
          #     The certification code.
          #     Maximum length is 2000 characters.
          # @!attribute [rw] certification_value
          #   @return [::String]
          #     The certification value (also known as class, level or grade), for
          #     example "A+", "C", "gold". Maximum length is 2000 characters.
          class ProductCertification
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Structured title, for algorithmically (AI)-generated titles.
          # @!attribute [rw] digital_source_type
          #   @return [::Google::Shopping::Merchant::Products::V1::DigitalSourceType]
          #     The digital source type.
          #     Following [IPTC](https://cv.iptc.org/newscodes/digitalsourcetype).
          # @!attribute [rw] content
          #   @return [::String]
          #     The title text
          #     Maximum length is 150 characters
          class StructuredTitle
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Structured description, for algorithmically (AI)-generated descriptions.
          # @!attribute [rw] digital_source_type
          #   @return [::Google::Shopping::Merchant::Products::V1::DigitalSourceType]
          #     The digital source type.
          #     Following [IPTC](https://cv.iptc.org/newscodes/digitalsourcetype).
          # @!attribute [rw] content
          #   @return [::String]
          #     The description text
          #     Maximum length is 5000 characters
          class StructuredDescription
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The dimension of the product.
          # @!attribute [rw] value
          #   @return [::Float]
          #     Required. The dimension value represented as a number. The value can have a
          #     maximum precision of four decimal places.
          # @!attribute [rw] unit
          #   @return [::String]
          #     Required. The dimension units.
          #     Acceptable values are:
          #       * "`in`"
          #       * "`cm`"
          class ProductDimension
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The weight of the product.
          # @!attribute [rw] value
          #   @return [::Float]
          #     Required. The weight represented as a number. The weight can have a maximum
          #     precision of four decimal places.
          # @!attribute [rw] unit
          #   @return [::String]
          #     Required. The weight unit.
          #     Acceptable values are:
          #       * "`g`"
          #       * "`kg`"
          #       * "`oz`"
          #       * "`lb`"
          class ProductWeight
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The status of a product, data validation issues, that is, information about
          # a product computed asynchronously.
          # @!attribute [rw] destination_statuses
          #   @return [::Array<::Google::Shopping::Merchant::Products::V1::ProductStatus::DestinationStatus>]
          #     The intended destinations for the product.
          # @!attribute [rw] item_level_issues
          #   @return [::Array<::Google::Shopping::Merchant::Products::V1::ProductStatus::ItemLevelIssue>]
          #     A list of all issues associated with the product.
          # @!attribute [rw] creation_date
          #   @return [::Google::Protobuf::Timestamp]
          #     Date on which the item has been created, in [ISO
          #     8601](http://en.wikipedia.org/wiki/ISO_8601) format.
          # @!attribute [rw] last_update_date
          #   @return [::Google::Protobuf::Timestamp]
          #     Date on which the item has been last updated, in [ISO
          #     8601](http://en.wikipedia.org/wiki/ISO_8601) format.
          # @!attribute [rw] google_expiration_date
          #   @return [::Google::Protobuf::Timestamp]
          #     Date on which the item expires, in [ISO
          #     8601](http://en.wikipedia.org/wiki/ISO_8601) format.
          class ProductStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The destination status of the product status.
            # @!attribute [rw] reporting_context
            #   @return [::Google::Shopping::Type::ReportingContext::ReportingContextEnum]
            #     The name of the reporting context.
            # @!attribute [rw] approved_countries
            #   @return [::Array<::String>]
            #     List of country codes (ISO 3166-1 alpha-2) where the offer is approved.
            # @!attribute [rw] pending_countries
            #   @return [::Array<::String>]
            #     List of country codes (ISO 3166-1 alpha-2) where the offer is pending
            #     approval.
            # @!attribute [rw] disapproved_countries
            #   @return [::Array<::String>]
            #     List of country codes (ISO 3166-1 alpha-2) where the offer is
            #     disapproved.
            class DestinationStatus
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The ItemLevelIssue of the product status.
            # @!attribute [rw] code
            #   @return [::String]
            #     The error code of the issue.
            # @!attribute [rw] severity
            #   @return [::Google::Shopping::Merchant::Products::V1::ProductStatus::ItemLevelIssue::Severity]
            #     How this issue affects serving of the offer.
            # @!attribute [rw] resolution
            #   @return [::String]
            #     Whether the issue can be resolved by the business.
            # @!attribute [rw] attribute
            #   @return [::String]
            #     The attribute's name, if the issue is caused by a single attribute.
            # @!attribute [rw] reporting_context
            #   @return [::Google::Shopping::Type::ReportingContext::ReportingContextEnum]
            #     The reporting context the issue applies to.
            # @!attribute [rw] description
            #   @return [::String]
            #     A short issue description in English.
            # @!attribute [rw] detail
            #   @return [::String]
            #     A detailed issue description in English.
            # @!attribute [rw] documentation
            #   @return [::String]
            #     The URL of a web page to help with resolving this issue.
            # @!attribute [rw] applicable_countries
            #   @return [::Array<::String>]
            #     List of country codes (ISO 3166-1 alpha-2) where issue applies to the
            #     offer.
            class ItemLevelIssue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # How the issue affects the serving of the product.
              module Severity
                # Not specified.
                SEVERITY_UNSPECIFIED = 0

                # This issue represents a warning and does not have a direct affect
                # on the product.
                NOT_IMPACTED = 1

                # The product is demoted and most likely have limited performance
                # in search results
                DEMOTED = 2

                # Issue disapproves the product.
                DISAPPROVED = 3
              end
            end
          end

          # Product property for the Cloud Retail API.
          # For example, properties for a TV product could be "Screen-Resolution" or
          # "Screen-Size".
          # @!attribute [rw] property_name
          #   @return [::String]
          #     Name of the given property. For example,
          #     "Screen-Resolution" for a TV product. Maximum string size is 256
          #     characters.
          # @!attribute [rw] text_value
          #   @return [::Array<::String>]
          #     Text value of the given property. For example,
          #     "8K(UHD)" could be a text value for a TV product. Maximum
          #     repeatedness of this value is 400. Values are stored in an arbitrary but
          #     consistent order. Maximum string size is 256 characters.
          # @!attribute [rw] bool_value
          #   @return [::Boolean]
          #     Boolean value of the given property. For example for a TV product,
          #     "True" or "False" if the screen is UHD.
          # @!attribute [rw] int_value
          #   @return [::Array<::Integer>]
          #     Integer values of the given property. For example, 1080 for a TV
          #     product's Screen Resolution. Maximum repeatedness of this value
          #     is 400. Values are stored in an arbitrary but consistent order.
          # @!attribute [rw] float_value
          #   @return [::Array<::Float>]
          #     Float values of the given property. For example for a TV product
          #     1.2345. Maximum repeatedness of this value is 400. Values
          #     are stored in an arbitrary but consistent order.
          # @!attribute [rw] min_value
          #   @return [::Float]
          #     Minimum float value of the given property. For example for a TV
          #     product 1.00.
          # @!attribute [rw] max_value
          #   @return [::Float]
          #     Maximum float value of the given property. For example for a TV
          #     product 100.00.
          # @!attribute [rw] unit_code
          #   @return [::String]
          #     Unit of the given property. For example, "Pixels" for a TV product. Maximum
          #     string size is 256B.
          class CloudExportAdditionalProperties
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Information regarding sustainability-related incentive programs such as
          # rebates or tax relief.
          # @!attribute [rw] amount
          #   @return [::Google::Shopping::Type::Price]
          #     The fixed amount of the incentive.
          #
          #     Note: The following fields are mutually exclusive: `amount`, `percentage`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] percentage
          #   @return [::Float]
          #     The percentage of the sale price that the incentive is applied to.
          #
          #     Note: The following fields are mutually exclusive: `percentage`, `amount`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] type
          #   @return [::Google::Shopping::Merchant::Products::V1::ProductSustainabilityIncentive::Type]
          #     Sustainability incentive program.
          class ProductSustainabilityIncentive
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Types of supported sustainability incentive programs.
            module Type
              # Unspecified or unknown sustainability incentive type.
              TYPE_UNSPECIFIED = 0

              # Program offering tax liability reductions for electric vehicles and, in
              # some countries, plug-in hybrids. These reductions can be based on a
              # specific amount or a percentage of the sale price.
              EV_TAX_CREDIT = 1

              # A subsidy program, often called an environmental bonus, provides a
              # purchase grant for electric vehicles and, in some countries, plug-in
              # hybrids. The grant amount may be a fixed sum or a percentage of the sale
              # price.
              EV_PRICE_DISCOUNT = 2
            end
          end

          # Information regarding Automated Discounts.
          # @!attribute [rw] prior_price
          #   @return [::Google::Shopping::Type::Price]
          #     The price prior to the application of the first price reduction.
          #     Absent if the information about the prior price of the product is not
          #     available.
          # @!attribute [rw] prior_price_progressive
          #   @return [::Google::Shopping::Type::Price]
          #     The price prior to the application of consecutive price reductions.
          #     Absent if the information about the prior price of the product is not
          #     available.
          # @!attribute [rw] gad_price
          #   @return [::Google::Shopping::Type::Price]
          #     The current sale price for products with a price optimized using Google
          #     Automated Discounts (GAD). Absent if the information about the GAD_price of
          #     the product is not available.
          class AutomatedDiscounts
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The subscription period of the product.
          module SubscriptionPeriod
            # Indicates that the subscription period is unspecified.
            SUBSCRIPTION_PERIOD_UNSPECIFIED = 0

            # Indicates that the subscription period is month.
            MONTH = 1

            # Indicates that the subscription period is year.
            YEAR = 2
          end

          # Target [age group](https://support.google.com/merchants/answer/6324463) of
          # the item.
          module AgeGroup
            # Age group is not specified.
            AGE_GROUP_UNSPECIFIED = 0

            # Teens or older.
            ADULT = 1

            # 5-13 years old.
            KIDS = 2

            # 1-5 years old.
            TODDLER = 3

            # 3-12 months old.
            INFANT = 4

            # 0-3 months old.
            NEWBORN = 5
          end

          # [Availability](https://support.google.com/merchants/answer/6324448) status
          # of the item.
          module Availability
            # Availability is not specified.
            AVAILABILITY_UNSPECIFIED = 0

            # In stock.
            IN_STOCK = 1

            # Out of stock.
            OUT_OF_STOCK = 2

            # Pre-order.
            PREORDER = 3

            # Limited availability.
            LIMITED_AVAILABILITY = 4

            # Backorder.
            BACKORDER = 5
          end

          # [Condition](https://support.google.com/merchants/answer/6324469) or state
          # of the item.
          module Condition
            # Default value. This value is unused.
            CONDITION_UNSPECIFIED = 0

            # Brand new, original, unopened packaging.
            NEW = 1

            # Previously used, original packaging opened or missing.
            USED = 2

            # Professionally restored to working order, comes with a warranty, may or
            # may not have the original packaging.
            REFURBISHED = 3
          end

          # Target [gender](https://support.google.com/merchants/answer/6324479) of the
          # item.
          module Gender
            # Gender is not specified.
            GENDER_UNSPECIFIED = 0

            # Male.
            MALE = 1

            # Female.
            FEMALE = 2

            # Unisex.
            UNISEX = 3
          end

          # Type of installment payments.
          module CreditType
            # Default value. This value is unused.
            CREDIT_TYPE_UNSPECIFIED = 0

            # Finance.
            FINANCE = 1

            # Lease.
            LEASE = 2
          end

          # System in which the size is specified. Recommended for apparel items.
          # For more information, see
          # [Size system](https://support.google.com/merchants/answer/6324502).
          module SizeSystem
            # Unspecified size system.
            SIZE_SYSTEM_UNSPECIFIED = 0

            # AU.
            AU = 1

            # BR.
            BR = 2

            # CN.
            CN = 3

            # DE.
            DE = 4

            # EU.
            EU = 5

            # FR.
            FR = 6

            # IT.
            IT = 7

            # JP.
            JP = 8

            # MEX.
            MEX = 9

            # UK.
            UK = 10

            # US.
            US = 11
          end

          # The cut of the item. It can be used to represent combined size types for
          # apparel items. Maximum two of size types can be provided, see
          # [Size type](https://support.google.com/merchants/answer/6324497).
          module SizeType
            # The size type is not specified.
            SIZE_TYPE_UNSPECIFIED = 0

            # Regular size.
            REGULAR = 1

            # Petite size.
            PETITE = 2

            # Maternity size.
            MATERNITY = 3

            # Big size.
            BIG = 4

            # Tall size.
            TALL = 5

            # Plus size.
            PLUS = 6
          end

          # The [energy efficiency
          # class](https://support.google.com/merchants/answer/7562785) as defined in EU
          # directive 2010/30/EU.
          module EnergyEfficiencyClass
            # The energy efficiency class is unspecified.
            ENERGY_EFFICIENCY_CLASS_UNSPECIFIED = 0

            # A+++.
            APPP = 1

            # A++.
            APP = 2

            # A+.
            AP = 3

            # A.
            A = 4

            # B.
            B = 5

            # C.
            C = 6

            # D.
            D = 7

            # E.
            E = 8

            # F.
            F = 9

            # G.
            G = 10
          end

          # The [pickup](https://support.google.com/merchants/answer/14634021) option
          # for the item.
          module PickupMethod
            # Pickup method is not specified.
            PICKUP_METHOD_UNSPECIFIED = 0

            # The item is not available for store pickup.
            NOT_SUPPORTED = 1

            # The entire transaction occurs online.
            BUY = 2

            # The item is reserved online and the transaction occurs in-store.
            RESERVE = 3

            # The item is purchased online and shipped to a local store for the customer
            # to pick up.
            SHIP_TO_STORE = 4
          end

          # Item store pickup timeline. For more information, see
          # [Pickup SLA](https://support.google.com/merchants/answer/14635400).
          module PickupSla
            # Pickup SLA is not specified.
            PICKUP_SLA_UNSPECIFIED = 0

            # Indicates that the product is available for pickup the same day that the
            # order is placed, subject to cut off times.
            SAME_DAY = 1

            # Indicates that the product is available for pickup the following day that
            # the order is placed.
            NEXT_DAY = 2

            # Indicates that the product will be shipped to a store for a customer to
            # pick up in 2 days.
            TWO_DAY = 3

            # Indicates that the product will be shipped to a store for a customer to
            # pick up in 3 days.
            THREE_DAY = 4

            # Indicates that the product will be shipped to a store for a customer to
            # pick up in 4 days
            FOUR_DAY = 5

            # Indicates that the product will be shipped to a store for a customer to
            # pick up in 5 days.
            FIVE_DAY = 6

            # Indicates that the product will be shipped to a store for a customer to
            # pick up in 6 days.
            SIX_DAY = 7

            # Indicates that the product will be shipped to a store for a customer to
            # pick up in one week or more.
            MULTI_WEEK = 8
          end

          # Publication of this item will be temporarily
          # [paused](https://support.google.com/merchants/answer/11909930).
          module Pause
            # The pause is unspecified.
            PAUSE_UNSPECIFIED = 0

            # You’re currently pausing your product for all ads locations (including
            # Shopping Ads, Display Ads, and local inventory ads).
            ADS = 1

            # You’re currently pausing your product for all Shopping locations
            # (including Shopping Ads, Display Ads, local inventory ads, Buy on Google,
            # and free listings).
            ALL = 2
          end

          # The certification authority.
          module CertificationAuthority
            # Certification authority is not specified.
            CERTIFICATION_AUTHORITY_UNSPECIFIED = 0

            # For the French CO2 emissions class for vehicles.
            ADEME = 1

            # For the German CO2 emissions classes for vehicles.
            BMWK = 2

            # Environment Protection Agency.
            EPA = 3

            # European Commission for energy labels in the EU.
            EC = 4
          end

          # The name of the certification.
          module CertificationName
            # Certification name is not specified.
            CERTIFICATION_NAME_UNSPECIFIED = 0

            # Energy Star.
            ENERGY_STAR = 1

            # Energy Star Most Efficient.
            ENERGY_STAR_MOST_EFFICIENT = 2

            # Represents energy efficiency certifications in the EU European
            # Registry for Energy Labeling (EPREL) database.
            EPREL = 3

            # EU Ecolabel.
            EU_ECOLABEL = 4

            # The overall CO2 class of a vehicle
            VEHICLE_ENERGY_EFFICIENCY = 5

            # For the CO2 class of a vehicle with a discharged battery.
            VEHICLE_ENERGY_EFFICIENCY_DISCHARGED_BATTERY = 6
          end

          # The digital source type.
          # Following [IPTC](https://cv.iptc.org/newscodes/digitalsourcetype).
          module DigitalSourceType
            # Digital source type is unspecified.
            DIGITAL_SOURCE_TYPE_UNSPECIFIED = 0

            # Text created algorithmically using a model derived from sampled
            # content.
            TRAINED_ALGORITHMIC_MEDIA = 1

            # Text NOT created algorithmically using a model derived from sampled
            # content (the default)
            DEFAULT = 2
          end

          # Possible carrier where transit time is coming from.
          module CarrierTransitTimeOption
            # Carrier transit time option is unspecified.
            CARRIER_TRANSIT_TIME_OPTION_UNSPECIFIED = 0

            # DHL Paket shipping service.
            DHL_PAKET = 1

            # DHL Packchen shipping service.
            DHL_PACKCHEN = 2

            # DHL Express Easy shipping service.
            DHL_EXPRESSEASY = 3

            # DPD Express shipping service.
            DPD_EXPRESS = 4

            # DPD Classic Parcel shipping service.
            DPD_CLASSIC_PARCEL = 5

            # Hermes Haustur shipping service.
            HERMES_HAUSTUR = 6

            # Hermes Paketshop shipping service.
            HERMES_PAKETSHOP = 7

            # GLS Business shipping service.
            GLS_BUSINESS = 8

            # GLS Express shipping service.
            GLS_EXPRESS = 9

            # GLS Private shipping service.
            GLS_PRIVATE = 10

            # Colissimo Domicile shipping service.
            COLISSIMO_DOMICILE = 11

            # DHL Express 12 AM shipping service.
            DHL_EXPRESS_12AM = 12

            # DHL Express 9 AM shipping service.
            DHL_EXPRESS_9AM = 13

            # GEODIS Express shipping service.
            GEODIS_EXPRESS = 14

            # GEODIS Pack 30 shipping service.
            GEODIS_PACK_30 = 15

            # GEODIS Same Day shipping service.
            GEODIS_SAME_DAY = 16

            # GEODIS Top 24 shipping service.
            GEODIS_TOP_24 = 17

            # TNT Essentiel 24H shipping service.
            TNT_ESSENTIEL_24H = 18

            # TNT Essentiel Flexibilite shipping service.
            TNT_ESSENTIEL_FLEXIBILITE = 19

            # FedEx Ground shipping service.
            FEDEX_GROUND = 20

            # FedEx Home Delivery shipping service.
            FEDEX_HOME_DELIVERY = 21

            # FedEx Express Saver shipping service.
            FEDEX_EXPRESS_SAVER = 22

            # FedEx First Overnight shipping service.
            FEDEX_FIRST_OVERNIGHT = 23

            # FedEx Priority Overnight shipping service.
            FEDEX_PRIORITY_OVERNIGHT = 24

            # FedEx Standard Overnight shipping service.
            FEDEX_STANDARD_OVERNIGHT = 25

            # FedEx 2Day shipping service.
            FEDEX_2DAY = 26

            # UPS 2nd Day Air shipping service.
            UPS_2ND_DAY_AIR = 27

            # UPS 2nd Day AM shipping service.
            UPS_2ND_DAY_AM = 28

            # UPS 3 Day Select shipping service.
            UPS_3_DAY_SELECT = 29

            # UPS Ground shipping service.
            UPS_GROUND = 30

            # UPS Next Day Air shipping service.
            UPS_NEXT_DAY_AIR = 31

            # UPS Next Day Air Early AM shipping service.
            UPS_NEXT_DAY_AIR_EARLY_AM = 32

            # UPS Next Day Air Saver shipping service.
            UPS_NEXT_DAY_AIR_SAVER = 33

            # USPS Priority Mail Express shipping service.
            USPS_PRIORITY_MAIL_EXPRESS = 34

            # USPS Media Mail shipping service.
            USPS_MEDIA_MAIL = 35

            # USPS Ground Advantage Retail shipping service.
            USPS_GROUND_ADVANTAGE_RETAIL = 36

            # USPS Priority Mail shipping service.
            USPS_PRIORITY_MAIL = 37

            # USPS Ground Advantage Commercial shipping service.
            USPS_GROUND_ADVANTAGE_COMMERCIAL = 38

            # USPS First Class Mail shipping service.
            USPS_FIRST_CLASS_MAIL = 39
          end
        end
      end
    end
  end
end
