# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Products
        module V1
          # The processed product, built from multiple [product
          # inputs][google.shopping.merchant.products.v1main.ProductInput]
          # after applying rules and supplemental data sources. This processed product
          # matches what is shown in your Merchant Center account. Each product is built
          # from exactly one primary data source product input, and multiple supplemental
          # data source inputs. After inserting, updating, or deleting a product input,
          # it may take several minutes before the updated processed product can be
          # retrieved.
          #
          # All fields in the processed product and its sub-messages match the name of
          # their corresponding attribute in the [Product data
          # specification](https://support.google.com/merchants/answer/7052112) with some
          # exceptions.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the product.
          #     Format:
          #     `accounts/{account}/products/{product}` where the last
          #     section `product` consists of:
          #     `content_language~feed_label~offer_id`
          #     example for product name is `accounts/123/products/en~US~sku123`. A legacy
          #     local product name would be `accounts/123/products/local~en~US~sku123`.
          #     Note: For calls to the v1beta version, the `product` section consists
          #     of: `channel~content_language~feed_label~offer_id`, for example:
          #     `accounts/123/products/online~en~US~sku123`.
          # @!attribute [r] legacy_local
          #   @return [::Boolean]
          #     Output only. Determines whether the product is **only** targeting
          #     local destinations and whether the product name should be distinguished
          #     with a `local~` prefix. For example,
          #     `accounts/123/products/local~en~US~sku123`.
          # @!attribute [r] offer_id
          #   @return [::String]
          #     Output only. Your unique identifier for the product. This is the same for
          #     the product input and processed product. Leading and trailing whitespaces
          #     are stripped and multiple whitespaces are replaced by a single whitespace
          #     upon submission. See the [product data
          #     specification](https://support.google.com/merchants/answer/188494#id) for
          #     details.
          # @!attribute [r] content_language
          #   @return [::String]
          #     Output only. The two-letter [ISO
          #     639-1](http://en.wikipedia.org/wiki/ISO_639-1) language code for the
          #     product.
          # @!attribute [r] feed_label
          #   @return [::String]
          #     Output only. The feed label lets you categorize and identify your products.
          #     The maximum allowed characters is 20 and the supported characters are`A-Z`,
          #     `0-9`, hyphen and underscore. The feed label must not include any spaces.
          #     For more information, see [Using feed
          #     labels](//support.google.com/merchants/answer/14994087)
          # @!attribute [r] data_source
          #   @return [::String]
          #     Output only. The primary data source of the product.
          # @!attribute [r] version_number
          #   @return [::Integer]
          #     Output only. Represents the existing version (freshness) of the product,
          #     which can be used to preserve the right order when multiple updates are
          #     done at the same time.
          #
          #     If set, the insertion is prevented when version number is lower than
          #     the current version number of the existing product. Re-insertion (for
          #     example, product refresh after 30 days) can be performed with the current
          #     `version_number`.
          #
          #     Only supported for insertions into primary data sources.
          #
          #     If the operation is prevented, the aborted exception will be
          #     thrown.
          # @!attribute [r] product_attributes
          #   @return [::Google::Shopping::Merchant::Products::V1::ProductAttributes]
          #     Output only. A list of strongly-typed product attributes.
          # @!attribute [r] custom_attributes
          #   @return [::Array<::Google::Shopping::Type::CustomAttribute>]
          #     Output only. A list of custom (merchant-provided) attributes. It can also
          #     be used to submit any attribute of the data specification in its generic
          #     form (for example,
          #     `{ "name": "size type", "value": "regular" }`).
          #     This is useful for submitting attributes not explicitly exposed by the
          #     API, such as additional attributes used for Buy on Google.
          # @!attribute [r] product_status
          #   @return [::Google::Shopping::Merchant::Products::V1::ProductStatus]
          #     Output only. The status of a product, data validation issues, that is,
          #     information about a product computed asynchronously.
          # @!attribute [r] automated_discounts
          #   @return [::Google::Shopping::Merchant::Products::V1::AutomatedDiscounts]
          #     Output only. The automated discounts information for the product.
          class Product
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the GetProduct method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the product to retrieve.
          #     Format:
          #     `accounts/{account}/products/{product}` where the last
          #     section `product` consists of:
          #     `content_language~feed_label~offer_id`
          #     example for product name is `accounts/123/products/en~US~sku123`. A legacy
          #     local product name would be `accounts/123/products/local~en~US~sku123`.
          #     Note: For calls to the v1beta version, the `product` section consists
          #     of: `channel~content_language~feed_label~offer_id`, for example:
          #     `accounts/123/products/online~en~US~sku123`.
          class GetProductRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the ListProducts method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The account to list processed products for.
          #     Format: `accounts/{account}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of products to return. The service may return fewer than
          #     this value.
          #     The maximum value is 1000; values above 1000 will be coerced to 1000.
          #     If unspecified, the default page size of 25 products will be returned.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     A page token, received from a previous `ListProducts` call.
          #     Provide this to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to `ListProducts` must
          #     match the call that provided the page token.
          class ListProductsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the ListProducts method.
          # @!attribute [rw] products
          #   @return [::Array<::Google::Shopping::Merchant::Products::V1::Product>]
          #     The processed products from the specified account. These are your processed
          #     products after applying rules and supplemental data sources.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListProductsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
