# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Notifications
        module V1beta
          module NotificationsApiService
            # Path helper methods for the NotificationsApiService API.
            module Paths
              ##
              # Create a fully-qualified Account resource string.
              #
              # The resource will be in the following format:
              #
              # `accounts/{account}`
              #
              # @param account [String]
              #
              # @return [::String]
              def account_path account:
                "accounts/#{account}"
              end

              ##
              # Create a fully-qualified NotificationSubscription resource string.
              #
              # The resource will be in the following format:
              #
              # `accounts/{account}/notificationsubscriptions/{notification_subscription}`
              #
              # @param account [String]
              # @param notification_subscription [String]
              #
              # @return [::String]
              def notification_subscription_path account:, notification_subscription:
                raise ::ArgumentError, "account cannot contain /" if account.to_s.include? "/"

                "accounts/#{account}/notificationsubscriptions/#{notification_subscription}"
              end

              extend self
            end
          end
        end
      end
    end
  end
end
