# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Notifications
        module V1
          # Request message for the GetNotificationSubscription method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The `name` of the notification subscription.
          class GetNotificationSubscriptionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the CreateNotificationSubscription method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The merchant account that owns the new notification subscription.
          #     Format: `accounts/{account}`
          # @!attribute [rw] notification_subscription
          #   @return [::Google::Shopping::Merchant::Notifications::V1::NotificationSubscription]
          #     Required. The notification subscription to create.
          class CreateNotificationSubscriptionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the UpdateNotificationSubscription method.
          # @!attribute [rw] notification_subscription
          #   @return [::Google::Shopping::Merchant::Notifications::V1::NotificationSubscription]
          #     Required. The new version of the notification subscription that should be
          #     updated.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     List of fields being updated.
          class UpdateNotificationSubscriptionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the DeleteNotificationSubscription method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the notification subscription to be deleted.
          class DeleteNotificationSubscriptionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the ListNotificationSubscription method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The merchant account who owns the notification subscriptions.
          #     Format: `accounts/{account}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of notification subscriptions to return in a page.
          #     The default value for `page_size` is 100. The
          #     maximum value is `200`. Values above `200` will be coerced to `200`.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Token (if provided) to retrieve the subsequent page. All other parameters
          #     must match the original call that provided the page token.
          class ListNotificationSubscriptionsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the ListNotificationSubscription method.
          # @!attribute [rw] notification_subscriptions
          #   @return [::Array<::Google::Shopping::Merchant::Notifications::V1::NotificationSubscription>]
          #     The list of notification subscriptions requested by the merchant.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListNotificationSubscriptionsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a notification subscription owned by a Merchant account.
          # @!attribute [rw] all_managed_accounts
          #   @return [::Boolean]
          #     If this value is true, the requesting account is notified of the
          #     specified event for all managed accounts (can be subaccounts or other
          #     linked accounts) including newly added accounts on a daily basis.
          #
          #     Note: The following fields are mutually exclusive: `all_managed_accounts`, `target_account`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] target_account
          #   @return [::String]
          #     The `name` of the account you want to receive notifications for.
          #     Format: `accounts/{account}`
          #
          #     Note: The following fields are mutually exclusive: `target_account`, `all_managed_accounts`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The `name` of the notification configuration. Generated by the
          #     Content API upon creation of a new `NotificationSubscription`. The
          #     `account` represents the merchant ID of the merchant that owns the
          #     configuration. Format:
          #     `accounts/{account}/notificationsubscriptions/{notification_subscription}`
          # @!attribute [rw] registered_event
          #   @return [::Google::Shopping::Merchant::Notifications::V1::NotificationSubscription::NotificationEventType]
          #     The event that the merchant wants to be notified about.
          # @!attribute [rw] call_back_uri
          #   @return [::String]
          #     URL to be used to push the notification to the merchant.
          class NotificationSubscription
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents the event type that the merchant is interested in receiving
            # notifications for.
            module NotificationEventType
              # Notifications event type is unspecified.
              NOTIFICATION_EVENT_TYPE_UNSPECIFIED = 0

              # Notification of product status changes, for example when product becomes
              # disapproved.
              PRODUCT_STATUS_CHANGE = 1
            end
          end

          # Request for notification subscription health metrics.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The `name` of the notification subscription for which metrics are
          #     retrieved.
          #     Format:
          #     `accounts/{account}/notificationsubscriptions/{notification_subscription}`
          class GetNotificationSubscriptionHealthMetricsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a notification subscription health metrics.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. Identifier. The name of the notification configuration.
          #     Generated by the Content API upon creation of a new
          #     NotificationSubscription. The account represents the merchant ID of the
          #     merchant that owns the configuration.
          # @!attribute [rw] acknowledged_messages_count
          #   @return [::Integer]
          #     The number of retained acknowledged messages for the last 24 hours
          # @!attribute [rw] undelivered_messages_count
          #   @return [::Integer]
          #     The number of unacknowledged messages for the last 7 days, we will attempt
          #     to re-deliver the unacknowledged message later and once successfully
          #     delivered it will not be counted within unacknowledged messages (the number
          #     of unacknowledged messages should gradually decrease to zero once the issue
          #     is fixed).
          # @!attribute [rw] oldest_unacknowledged_message_waiting_time
          #   @return [::Integer]
          #     The time since the oldest unacknowledged message was sent in seconds
          class NotificationSubscriptionHealthMetrics
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
