# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/shopping/merchant/notifications/v1/notificationsapi.proto for package 'Google.Shopping.Merchant.Notifications.V1'
# Original file comments:
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/shopping/merchant/notifications/v1/notificationsapi_pb'

module Google
  module Shopping
    module Merchant
      module Notifications
        module V1
          module NotificationsApiService
            # Service to manage notification subscriptions for merchants
            class Service

              include ::GRPC::GenericService

              self.marshal_class_method = :encode
              self.unmarshal_class_method = :decode
              self.service_name = 'google.shopping.merchant.notifications.v1.NotificationsApiService'

              # Gets notification subscriptions for an account.
              rpc :GetNotificationSubscription, ::Google::Shopping::Merchant::Notifications::V1::GetNotificationSubscriptionRequest, ::Google::Shopping::Merchant::Notifications::V1::NotificationSubscription
              # Creates a notification subscription for a business.
              # For standalone or subaccounts accounts, the business can create a
              # subscription for self. For MCAs, the business can create a
              # subscription for all managed accounts or for a specific subaccount.
              #
              # We will allow the following types of notification subscriptions to exist
              # together (per business as a subscriber per event type):
              #
              # 1. Subscription for all managed accounts + subscription for self.
              #
              # 2. Multiple "partial" subscriptions for managed accounts + subscription
              # for self.
              #
              # we will not allow (per business as a subscriber per event type):
              #
              # 1. Multiple self subscriptions.
              #
              # 2. Multiple "all managed accounts" subscriptions.
              #
              # 3. "All managed accounts" subscription and partial subscriptions at the
              # same time.
              #
              # 4. Multiple partial subscriptions for the same target account.
              rpc :CreateNotificationSubscription, ::Google::Shopping::Merchant::Notifications::V1::CreateNotificationSubscriptionRequest, ::Google::Shopping::Merchant::Notifications::V1::NotificationSubscription
              # Updates an existing notification subscription for a merchant.
              rpc :UpdateNotificationSubscription, ::Google::Shopping::Merchant::Notifications::V1::UpdateNotificationSubscriptionRequest, ::Google::Shopping::Merchant::Notifications::V1::NotificationSubscription
              # Deletes a notification subscription for a merchant.
              rpc :DeleteNotificationSubscription, ::Google::Shopping::Merchant::Notifications::V1::DeleteNotificationSubscriptionRequest, ::Google::Protobuf::Empty
              # Gets all the notification subscriptions for a merchant.
              rpc :ListNotificationSubscriptions, ::Google::Shopping::Merchant::Notifications::V1::ListNotificationSubscriptionsRequest, ::Google::Shopping::Merchant::Notifications::V1::ListNotificationSubscriptionsResponse
              # Retrieves notification subscription health metrics for a merchant.
              # We recommend calling this periodically (hourly or daily) to monitor health
              # of your callback endpoint.
              rpc :GetNotificationSubscriptionHealthMetrics, ::Google::Shopping::Merchant::Notifications::V1::GetNotificationSubscriptionHealthMetricsRequest, ::Google::Shopping::Merchant::Notifications::V1::NotificationSubscriptionHealthMetrics
            end

            Stub = Service.rpc_stub_class
          end
        end
      end
    end
  end
end
