# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/shopping/merchant/lfp/version"

require "googleauth"

module Google
  module Shopping
    module Merchant
      module Lfp
        ##
        # Create a new client object for LfpInventoryService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Lfp::V1beta::LfpInventoryService::Client](https://rubydoc.info/gems/google-shopping-merchant-lfp-v1beta/Google/Shopping/Merchant/Lfp/V1beta/LfpInventoryService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the LfpInventoryService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the LfpInventoryService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Lfp.lfp_inventory_service_available?}.
        #
        # ## About LfpInventoryService
        #
        # Service for a [LFP
        # partner](https://support.google.com/merchants/answer/7676652) to submit local
        # inventories for a merchant.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.lfp_inventory_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/lfp/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Lfp
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Lfp.const_get(package_name).const_get(:LfpInventoryService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the LfpInventoryService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Lfp.lfp_inventory_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the LfpInventoryService service,
        # or if the versioned client gem needs an update to support the LfpInventoryService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.lfp_inventory_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/lfp/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Lfp
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Lfp.const_get package_name
          return false unless service_module.const_defined? :LfpInventoryService
          service_module = service_module.const_get :LfpInventoryService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for LfpMerchantStateService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Lfp::V1beta::LfpMerchantStateService::Client](https://rubydoc.info/gems/google-shopping-merchant-lfp-v1beta/Google/Shopping/Merchant/Lfp/V1beta/LfpMerchantStateService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the LfpMerchantStateService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the LfpMerchantStateService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Lfp.lfp_merchant_state_service_available?}.
        #
        # ## About LfpMerchantStateService
        #
        # Service for a [LFP
        # partner](https://support.google.com/merchants/answer/7676652) to get the
        # state of a merchant.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.lfp_merchant_state_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/lfp/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Lfp
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Lfp.const_get(package_name).const_get(:LfpMerchantStateService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the LfpMerchantStateService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Lfp.lfp_merchant_state_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the LfpMerchantStateService service,
        # or if the versioned client gem needs an update to support the LfpMerchantStateService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.lfp_merchant_state_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/lfp/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Lfp
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Lfp.const_get package_name
          return false unless service_module.const_defined? :LfpMerchantStateService
          service_module = service_module.const_get :LfpMerchantStateService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for LfpSaleService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Lfp::V1beta::LfpSaleService::Client](https://rubydoc.info/gems/google-shopping-merchant-lfp-v1beta/Google/Shopping/Merchant/Lfp/V1beta/LfpSaleService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the LfpSaleService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the LfpSaleService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Lfp.lfp_sale_service_available?}.
        #
        # ## About LfpSaleService
        #
        # Service for a [LFP
        # partner](https://support.google.com/merchants/answer/7676652) to submit sales
        # data for a merchant.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.lfp_sale_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/lfp/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Lfp
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Lfp.const_get(package_name).const_get(:LfpSaleService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the LfpSaleService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Lfp.lfp_sale_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the LfpSaleService service,
        # or if the versioned client gem needs an update to support the LfpSaleService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.lfp_sale_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/lfp/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Lfp
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Lfp.const_get package_name
          return false unless service_module.const_defined? :LfpSaleService
          service_module = service_module.const_get :LfpSaleService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for LfpStoreService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Lfp::V1beta::LfpStoreService::Client](https://rubydoc.info/gems/google-shopping-merchant-lfp-v1beta/Google/Shopping/Merchant/Lfp/V1beta/LfpStoreService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the LfpStoreService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the LfpStoreService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Lfp.lfp_store_service_available?}.
        #
        # ## About LfpStoreService
        #
        # Service for a [LFP
        # partner](https://support.google.com/merchants/answer/7676652) to submit local
        # stores for a merchant.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.lfp_store_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/lfp/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Lfp
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Lfp.const_get(package_name).const_get(:LfpStoreService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the LfpStoreService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Lfp.lfp_store_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the LfpStoreService service,
        # or if the versioned client gem needs an update to support the LfpStoreService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.lfp_store_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/lfp/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Lfp
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Lfp.const_get package_name
          return false unless service_module.const_defined? :LfpStoreService
          service_module = service_module.const_get :LfpStoreService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "lfp", "helpers.rb"
require "google/shopping/merchant/lfp/helpers" if ::File.file? helper_path
