# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Lfp
        module V1
          # A sale for the merchant.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. Identifier. The name of the `LfpSale` resource.
          #     Format:
          #     `accounts/{account}/lfpSales/{sale}`
          # @!attribute [rw] target_account
          #   @return [::Integer]
          #     Required. The Merchant Center ID of the merchant to submit the sale for.
          # @!attribute [rw] store_code
          #   @return [::String]
          #     Required. The identifier of the merchant's store. Either a `storeCode`
          #     inserted through the API or the code of the store in the Business Profile.
          # @!attribute [rw] offer_id
          #   @return [::String]
          #     Required. A unique identifier for the product. If both inventories and
          #     sales are submitted for a merchant, this id should match for the same
          #     product.
          #
          #     **Note**: if the merchant sells the same product new and used, they should
          #     have different IDs.
          # @!attribute [rw] region_code
          #   @return [::String]
          #     Required. The [CLDR territory
          #     code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml)
          #     for the country where the product is sold.
          # @!attribute [rw] content_language
          #   @return [::String]
          #     Required. The two-letter ISO 639-1 language code for the item.
          # @!attribute [rw] gtin
          #   @return [::String]
          #     Required. The Global Trade Item Number of the sold product.
          # @!attribute [rw] price
          #   @return [::Google::Shopping::Type::Price]
          #     Required. The unit price of the product.
          # @!attribute [rw] quantity
          #   @return [::Integer]
          #     Required. The relative change of the available quantity. Negative for items
          #     returned.
          # @!attribute [rw] sale_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Required. The timestamp for the sale.
          # @!attribute [r] uid
          #   @return [::String]
          #     Output only. System generated globally unique ID for the `LfpSale`.
          # @!attribute [rw] feed_label
          #   @return [::String]
          #     Optional. The [feed
          #     label](https://developers.google.com/shopping-content/guides/products/feed-labels)
          #     for the product. If this is not set, it will default to `regionCode`.
          class LfpSale
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the InsertLfpSale method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The LFP provider account.
          #     Format: `accounts/{lfp_partner}`
          # @!attribute [rw] lfp_sale
          #   @return [::Google::Shopping::Merchant::Lfp::V1::LfpSale]
          #     Required. The sale to insert.
          class InsertLfpSaleRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
