# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Lfp
        module V1
          # Local Inventory for the merchant.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. Identifier. The name for the `LfpInventory` resource.
          #     Format:
          #     `accounts/{account}/lfpInventories/{target_merchant}~{store_code}~{offer}`
          # @!attribute [rw] target_account
          #   @return [::Integer]
          #     Required. The Merchant Center ID of the merchant to submit the inventory
          #     for.
          # @!attribute [rw] store_code
          #   @return [::String]
          #     Required. The identifier of the merchant's store. Either the store code
          #     inserted through `InsertLfpStore` or the store code in the Business
          #     Profile.
          # @!attribute [rw] offer_id
          #   @return [::String]
          #     Required. Immutable. A unique identifier for the product. If both
          #     inventories and sales are submitted for a merchant, this id should match
          #     for the same product.
          #
          #     **Note**: if the merchant sells the same product new and used, they should
          #     have different IDs.
          # @!attribute [rw] region_code
          #   @return [::String]
          #     Required. The [CLDR territory
          #     code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml)
          #     for the country where the product is sold.
          # @!attribute [rw] content_language
          #   @return [::String]
          #     Required. The two-letter ISO 639-1 language code for the item.
          # @!attribute [rw] gtin
          #   @return [::String]
          #     Optional. The Global Trade Item Number of the product.
          # @!attribute [rw] price
          #   @return [::Google::Shopping::Type::Price]
          #     Optional. The current price of the product.
          # @!attribute [rw] availability
          #   @return [::String]
          #     Required. Availability of the product at this store.
          #     For accepted attribute values, see the [local product inventory data
          #     specification](https://support.google.com/merchants/answer/3061342)
          # @!attribute [rw] quantity
          #   @return [::Integer]
          #     Optional. Quantity of the product available at this store. Must be greater
          #     than or equal to zero.
          # @!attribute [rw] collection_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Optional. The time when the inventory is collected. If not set, it will be
          #     set to the time when the inventory is submitted.
          # @!attribute [rw] pickup_method
          #   @return [::String]
          #     Optional. Supported pickup method for this offer. Unless the value is "not
          #     supported", this field must be submitted together with `pickupSla`. For
          #     accepted attribute values, see the [local product inventory data
          #     specification](https://support.google.com/merchants/answer/3061342).
          # @!attribute [rw] pickup_sla
          #   @return [::String]
          #     Optional. Expected date that an order will be ready for pickup relative to
          #     the order date. Must be submitted together with `pickupMethod`. For
          #     accepted attribute values, see the [local product inventory data
          #     specification](https://support.google.com/merchants/answer/3061342).
          # @!attribute [rw] feed_label
          #   @return [::String]
          #     Optional. The [feed
          #     label](https://developers.google.com/shopping-content/guides/products/feed-labels)
          #     for the product. If this is not set, it will default to `regionCode`.
          class LfpInventory
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `InsertLfpInventory` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The LFP provider account.
          #     Format: `accounts/{account}`
          # @!attribute [rw] lfp_inventory
          #   @return [::Google::Shopping::Merchant::Lfp::V1::LfpInventory]
          #     Required. The inventory to insert.
          class InsertLfpInventoryRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
