# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module IssueResolution
        module V1beta
          # Request message for the `ListAggregateProductStatuses` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The account to list aggregate product statuses for.
          #     Format: `accounts/{account}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of aggregate product statuses to return. The
          #     service may return fewer than this value. If unspecified, at most 25
          #     aggregate product statuses are returned. The maximum value is 250; values
          #     above 250 are coerced to 250.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from a previous
          #     `ListAggregateProductStatuses` call. Provide this to retrieve the
          #     subsequent page.
          #
          #     When paginating, all other parameters provided to
          #     `ListAggregateProductStatuses` must match the call that provided the page
          #     token.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. A filter expression that filters the aggregate product statuses.
          #     Filtering is only supported by the `reporting_context` and `country` field.
          #     For example: `reporting_context = "SHOPPING_ADS" AND country = "US"`.
          class ListAggregateProductStatusesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the `ListAggregateProductStatuses` method.
          # @!attribute [rw] aggregate_product_statuses
          #   @return [::Array<::Google::Shopping::Merchant::IssueResolution::V1beta::AggregateProductStatus>]
          #     The `AggregateProductStatuses` resources for the given account.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `pageToken` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListAggregateProductStatusesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Aggregate product statuses for a given reporting context and country.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The name of the `AggregateProductStatuses` resource.
          #     Format:
          #     `accounts/{account}/aggregateProductStatuses/{aggregateProductStatuses}`
          # @!attribute [rw] reporting_context
          #   @return [::Google::Shopping::Type::ReportingContext::ReportingContextEnum]
          #     The reporting context of the aggregate product statuses.
          # @!attribute [rw] country
          #   @return [::String]
          #     The country of the aggregate product statuses. Represented as a
          #     [CLDR territory
          #     code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml).
          # @!attribute [rw] stats
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1beta::AggregateProductStatus::Stats]
          #     Products statistics for the given reporting context and country.
          # @!attribute [rw] item_level_issues
          #   @return [::Array<::Google::Shopping::Merchant::IssueResolution::V1beta::AggregateProductStatus::ItemLevelIssue>]
          #     The product issues that affect the given reporting context and country.
          class AggregateProductStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Products statistics.
            # @!attribute [rw] active_count
            #   @return [::Integer]
            #     The number of products that are active.
            # @!attribute [rw] pending_count
            #   @return [::Integer]
            #     The number of products that are pending.
            # @!attribute [rw] disapproved_count
            #   @return [::Integer]
            #     The number of products that are disapproved.
            # @!attribute [rw] expiring_count
            #   @return [::Integer]
            #     The number of products that are expiring.
            class Stats
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The ItemLevelIssue of the product status.
            # @!attribute [rw] code
            #   @return [::String]
            #     The error code of the issue.
            # @!attribute [rw] severity
            #   @return [::Google::Shopping::Merchant::IssueResolution::V1beta::AggregateProductStatus::ItemLevelIssue::Severity]
            #     How this issue affects serving of the offer.
            # @!attribute [rw] resolution
            #   @return [::Google::Shopping::Merchant::IssueResolution::V1beta::AggregateProductStatus::ItemLevelIssue::Resolution]
            #     Whether the issue can be resolved by the merchant.
            # @!attribute [rw] attribute
            #   @return [::String]
            #     The attribute's name, if the issue is caused by a single attribute.
            # @!attribute [rw] description
            #   @return [::String]
            #     A short issue description in English.
            # @!attribute [rw] detail
            #   @return [::String]
            #     A detailed issue description in English.
            # @!attribute [rw] documentation_uri
            #   @return [::String]
            #     The URL of a web page to help with resolving this issue.
            # @!attribute [rw] product_count
            #   @return [::Integer]
            #     The number of products affected by this issue.
            class ItemLevelIssue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # How the issue affects the serving of the product.
              module Severity
                # Not specified.
                SEVERITY_UNSPECIFIED = 0

                # This issue represents a warning and does not have a direct affect
                # on the product.
                NOT_IMPACTED = 1

                # The product is demoted and most likely have limited performance
                # in search results
                DEMOTED = 2

                # Issue disapproves the product.
                DISAPPROVED = 3
              end

              # How the issue can be resolved.
              module Resolution
                # Not specified.
                RESOLUTION_UNSPECIFIED = 0

                # The issue can be resolved by the merchant.
                MERCHANT_ACTION = 1

                # The issue will be resolved auomatically.
                PENDING_PROCESSING = 2
              end
            end
          end
        end
      end
    end
  end
end
