# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/shopping/merchant/issueresolution/v1/issueresolution_pb"
require "google/shopping/merchant/issue_resolution/v1/issue_resolution_service"

class ::Google::Shopping::Merchant::IssueResolution::V1::IssueResolutionService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_render_account_issues
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::IssueResolution::V1::RenderAccountIssuesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    language_code = "hello world"
    time_zone = "hello world"
    payload = {}

    render_account_issues_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :render_account_issues, name
      assert_kind_of ::Google::Shopping::Merchant::IssueResolution::V1::RenderAccountIssuesRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["language_code"]
      assert_equal "hello world", request["time_zone"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Merchant::IssueResolution::V1::RenderIssuesRequestPayload), request["payload"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, render_account_issues_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::IssueResolution::V1::IssueResolutionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.render_account_issues({ name: name, language_code: language_code, time_zone: time_zone, payload: payload }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.render_account_issues name: name, language_code: language_code, time_zone: time_zone, payload: payload do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.render_account_issues ::Google::Shopping::Merchant::IssueResolution::V1::RenderAccountIssuesRequest.new(name: name, language_code: language_code, time_zone: time_zone, payload: payload) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.render_account_issues({ name: name, language_code: language_code, time_zone: time_zone, payload: payload }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.render_account_issues(::Google::Shopping::Merchant::IssueResolution::V1::RenderAccountIssuesRequest.new(name: name, language_code: language_code, time_zone: time_zone, payload: payload), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, render_account_issues_client_stub.call_rpc_count
    end
  end

  def test_render_product_issues
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::IssueResolution::V1::RenderProductIssuesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    language_code = "hello world"
    time_zone = "hello world"
    payload = {}

    render_product_issues_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :render_product_issues, name
      assert_kind_of ::Google::Shopping::Merchant::IssueResolution::V1::RenderProductIssuesRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["language_code"]
      assert_equal "hello world", request["time_zone"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Merchant::IssueResolution::V1::RenderIssuesRequestPayload), request["payload"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, render_product_issues_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::IssueResolution::V1::IssueResolutionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.render_product_issues({ name: name, language_code: language_code, time_zone: time_zone, payload: payload }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.render_product_issues name: name, language_code: language_code, time_zone: time_zone, payload: payload do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.render_product_issues ::Google::Shopping::Merchant::IssueResolution::V1::RenderProductIssuesRequest.new(name: name, language_code: language_code, time_zone: time_zone, payload: payload) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.render_product_issues({ name: name, language_code: language_code, time_zone: time_zone, payload: payload }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.render_product_issues(::Google::Shopping::Merchant::IssueResolution::V1::RenderProductIssuesRequest.new(name: name, language_code: language_code, time_zone: time_zone, payload: payload), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, render_product_issues_client_stub.call_rpc_count
    end
  end

  def test_trigger_action
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::IssueResolution::V1::TriggerActionResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    payload = {}
    language_code = "hello world"

    trigger_action_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :trigger_action, name
      assert_kind_of ::Google::Shopping::Merchant::IssueResolution::V1::TriggerActionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Merchant::IssueResolution::V1::TriggerActionPayload), request["payload"]
      assert_equal "hello world", request["language_code"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, trigger_action_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::IssueResolution::V1::IssueResolutionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.trigger_action({ name: name, payload: payload, language_code: language_code }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.trigger_action name: name, payload: payload, language_code: language_code do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.trigger_action ::Google::Shopping::Merchant::IssueResolution::V1::TriggerActionRequest.new(name: name, payload: payload, language_code: language_code) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.trigger_action({ name: name, payload: payload, language_code: language_code }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.trigger_action(::Google::Shopping::Merchant::IssueResolution::V1::TriggerActionRequest.new(name: name, payload: payload, language_code: language_code), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, trigger_action_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::IssueResolution::V1::IssueResolutionService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Shopping::Merchant::IssueResolution::V1::IssueResolutionService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::IssueResolution::V1::IssueResolutionService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Shopping::Merchant::IssueResolution::V1::IssueResolutionService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
