# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module IssueResolution
        module V1
          # Response containing an issue resolution content and actions for listed
          # account issues.
          # @!attribute [rw] rendered_issues
          #   @return [::Array<::Google::Shopping::Merchant::IssueResolution::V1::RenderedIssue>]
          #     List of account issues for a given account.
          #
          #     This list can be shown with compressed, expandable items. In the compressed
          #     form, the title and impact should be shown for each issue. Once the issue
          #     is expanded, the detailed
          #     {::Google::Shopping::Merchant::IssueResolution::V1::RenderedIssue#prerendered_content content}
          #     and available
          #     {::Google::Shopping::Merchant::IssueResolution::V1::RenderedIssue#actions actions}
          #     should be rendered.
          class RenderAccountIssuesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request to provide issue resolution content and actions for business's
          # account issues.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The account to fetch issues for.
          #     Format: `accounts/{account}`
          # @!attribute [rw] language_code
          #   @return [::String]
          #     Optional. The [IETF BCP-47](https://tools.ietf.org/html/bcp47) language
          #     code used to localize issue resolution content. If not set, the result will
          #     be in default language `en-US`.
          # @!attribute [rw] time_zone
          #   @return [::String]
          #     Optional. The [IANA](https://www.iana.org/time-zones) timezone used to
          #     localize times in an issue resolution content. For example
          #     'America/Los_Angeles'. If not set, results will use as a default UTC.
          # @!attribute [rw] payload
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::RenderIssuesRequestPayload]
          #     Optional. The payload for configuring how the content should be rendered.
          class RenderAccountIssuesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The payload for configuring how the content should be rendered.
          # @!attribute [rw] content_option
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::ContentOption]
          #     Optional. How the detailed content should be returned. Default option is to
          #     return the content as a pre-rendered HTML text.
          # @!attribute [rw] user_input_action_option
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::UserInputActionRenderingOption]
          #     Optional. How actions with user input form should be handled. If not
          #     provided, actions will be returned as links that points the business to
          #     Merchant Center where they can request the action.
          class RenderIssuesRequestPayload
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response containing an issue resolution content and actions for listed
          # product issues.
          # @!attribute [rw] rendered_issues
          #   @return [::Array<::Google::Shopping::Merchant::IssueResolution::V1::RenderedIssue>]
          #     List of issues for a given product.
          #
          #     This list can be shown with compressed, expandable items. In the compressed
          #     form, the
          #     {::Google::Shopping::Merchant::IssueResolution::V1::RenderedIssue#title title}
          #     and
          #     {::Google::Shopping::Merchant::IssueResolution::V1::RenderedIssue#impact impact}
          #     should be shown for each issue. Once the issue is expanded, the detailed
          #     {::Google::Shopping::Merchant::IssueResolution::V1::RenderedIssue#prerendered_content content}
          #     and available
          #     {::Google::Shopping::Merchant::IssueResolution::V1::RenderedIssue#actions actions}
          #     should be rendered.
          class RenderProductIssuesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request to provide an issue resolution content and actions for product issues
          # of business's product.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the product to fetch issues for.
          #     Format: `accounts/{account}/products/{product}`
          # @!attribute [rw] language_code
          #   @return [::String]
          #     Optional. The [IETF BCP-47](https://tools.ietf.org/html/bcp47) language
          #     code used to localize an issue resolution content. If not set, the result
          #     will be in default language `en-US`.
          # @!attribute [rw] time_zone
          #   @return [::String]
          #     Optional. The [IANA](https://www.iana.org/time-zones) timezone used to
          #     localize times in an issue resolution content. For example
          #     'America/Los_Angeles'. If not set, results will use as a default UTC.
          # @!attribute [rw] payload
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::RenderIssuesRequestPayload]
          #     Optional. The payload for configuring how the content should be rendered.
          class RenderProductIssuesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An issue affecting specific business or their product.
          # @!attribute [rw] prerendered_content
          #   @return [::String]
          #     Details of the issue as a pre-rendered HTML. HTML elements contain CSS
          #     classes that can be used to customize the style of the content.
          #
          #     Always sanitize the HTML before embedding it directly to your
          #     application. The sanitizer needs to allow basic HTML tags, such as:
          #     `div`, `span`, `p`, `a`, `ul`, `li`, `table`, `tr`, `td`. For example,
          #     you can use [DOMPurify](https://www.npmjs.com/package/dompurify).
          #
          #     CSS classes:
          #
          #     * `issue-detail` - top level container for the detail of the issue
          #     * `callout-banners` - section of the `issue-detail` with callout banners
          #     * `callout-banner` - single callout banner, inside `callout-banners`
          #     * `callout-banner-info` - callout with important information (default)
          #     * `callout-banner-warning` - callout with a warning
          #     * `callout-banner-error` - callout informing about an error (most severe)
          #     * `issue-content` - section of the `issue-detail`, contains multiple
          #     `content-element`
          #     * `content-element` - content element such as a list, link or paragraph,
          #     inside `issue-content`
          #     * `root-causes` - unordered list with items describing root causes of the
          #     issue, inside `issue-content`
          #     * `root-causes-intro` - intro text before the `root-causes` list, inside
          #     `issue-content`
          #     * `segment` - section of the text, `span` inside paragraph
          #     * `segment-attribute` - section of the text that represents a product
          #     attribute, for example 'image\_link'
          #     * `segment-literal` - section of the text that contains a special value,
          #     for example '0-1000 kg'
          #     * `segment-bold` - section of the text that should be rendered as bold
          #     * `segment-italic` - section of the text that should be rendered as
          #     italic
          #     * `tooltip` - used on paragraphs that should be rendered with a tooltip.
          #     A section of the text in such a paragraph will have a class
          #     `tooltip-text` and is intended to be shown in a mouse over dialog. If the
          #     style is not used, the `tooltip-text` section would be shown on a new
          #     line, after the main part of the text.
          #     * `tooltip-text` - marks a section of the text within a `tooltip`, that
          #     is intended to be shown in a mouse over dialog.
          #     * `tooltip-icon` - marks a section of the text within a `tooltip`, that
          #     can be replaced with a tooltip icon, for example '?' or 'i'. By default,
          #     this section contains a `br` tag, that is separating the main text and
          #     the tooltip text when the style is not used.
          #     * `tooltip-style-question` - the tooltip shows helpful information,
          #     can use the '?' as an icon.
          #     * `tooltip-style-info` - the tooltip adds additional information fitting
          #     to the context, can use the 'i' as an icon.
          #     * `content-moderation` - marks the paragraph that explains how the issue
          #     was identified.
          #     * `new-element` - Present for new elements added to the pre-rendered
          #     content in the future. To make sure that a new content element does not
          #     break your style, you can hide everything with this class.
          # @!attribute [rw] prerendered_out_of_court_dispute_settlement
          #   @return [::String]
          #     Pre-rendered HTML that contains a link to the external location where the
          #     ODS can be requested and instructions for how to request it. HTML
          #     elements contain CSS classes that can be used to customize the style of
          #     this snippet.
          #
          #     Always sanitize the HTML before embedding it directly to your
          #     application. The sanitizer needs to allow basic HTML tags, such as:
          #     `div`, `span`, `p`, `a`, `ul`, `li`, `table`, `tr`, `td`. For example,
          #     you can use [DOMPurify](https://www.npmjs.com/package/dompurify).
          #
          #     CSS classes:
          #
          #     * `ods-section`* - wrapper around the out-of-court dispute resolution
          #     section
          #     * `ods-description`* - intro text for the out-of-court dispute
          #     resolution. It may contain multiple segments and a link.
          #     * `ods-param`* - wrapper around the header-value pair for parameters that
          #     the business may need to provide during the ODS process.
          #     * `ods-routing-id`* - ods param for the Routing ID.
          #     * `ods-reference-id`* - ods param for the Routing ID.
          #     * `ods-param-header`* - header for the ODS parameter
          #     * `ods-param-value`* - value of the ODS parameter. This value should be
          #     rendered in a way that it is easy for the user to identify and copy.
          #     * `segment` - section of the text, `span` inside paragraph
          #     * `segment-attribute` - section of the text that represents a product
          #     attribute, for example 'image\_link'
          #     * `segment-literal` - section of the text that contains a special value,
          #     for example '0-1000 kg'
          #     * `segment-bold` - section of the text that should be rendered as bold
          #     * `segment-italic` - section of the text that should be rendered as
          #     italic
          #     * `tooltip` - used on paragraphs that should be rendered with a tooltip.
          #     A section of the text in such a paragraph will have a class
          #     `tooltip-text` and is intended to be shown in a mouse over dialog. If the
          #     style is not used, the `tooltip-text` section would be shown on a new
          #     line, after the main part of the text.
          #     * `tooltip-text` - marks a section of the text within a `tooltip`, that
          #     is intended to be shown in a mouse over dialog.
          #     * `tooltip-icon` - marks a section of the text within a `tooltip`, that
          #     can be replaced with a tooltip icon, for example '?' or 'i'. By default,
          #     this section contains a `br` tag, that is separating the main text and
          #     the tooltip text when the style is not used.
          #     * `tooltip-style-question` - the tooltip shows helpful information,
          #     can use the '?' as an icon.
          #     * `tooltip-style-info` - the tooltip adds additional information fitting
          #     to the context, can use the 'i' as an icon.
          # @!attribute [rw] title
          #   @return [::String]
          #     Title of the issue.
          # @!attribute [rw] impact
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::Impact]
          #     Clarifies the severity of the issue.
          #
          #     The [summarizing
          #     message][google.shopping.merchant.issueresolution.v1.Impact.message], if
          #     present, should be shown right under the title for each issue. It helps
          #     business to quickly understand the impact of the issue.
          #
          #     The detailed
          #     {::Google::Shopping::Merchant::IssueResolution::V1::Impact#breakdowns breakdown}
          #     helps the business to fully understand the impact of the issue. It can be
          #     rendered as dialog that opens when the business mouse over the summarized
          #     impact statement.
          #
          #     Issues with different
          #     {::Google::Shopping::Merchant::IssueResolution::V1::Impact#severity severity} can
          #     be styled differently. They may use a different color or icon to signal the
          #     difference between `ERROR`, `WARNING` and `INFO`.
          # @!attribute [rw] actions
          #   @return [::Array<::Google::Shopping::Merchant::IssueResolution::V1::Action>]
          #     A list of actionable steps that can be executed to solve the issue. An
          #     example is requesting a re-review or providing arguments when business
          #     disagrees with the issue.
          #
          #     Actions that are supported in (your) third-party application can be
          #     rendered as buttons and should be available to the business when they
          #     expand the issue.
          class RenderedIssue
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Overall impact of the issue.
          # @!attribute [rw] message
          #   @return [::String]
          #     Optional. Message summarizing the overall impact of the issue. If present,
          #     it should be rendered to the business. For example: "Disapproves 90k offers
          #     in 25 countries"
          # @!attribute [rw] severity
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::Severity]
          #     The severity of the issue.
          # @!attribute [rw] breakdowns
          #   @return [::Array<::Google::Shopping::Merchant::IssueResolution::V1::Breakdown>]
          #     Detailed impact breakdown. Explains the types of restriction the issue has
          #     in different shopping destinations and territory. If present, it should be
          #     rendered to the business. Can be shown as a mouse over dropdown or a
          #     dialog. Each breakdown item represents a group of regions with the same
          #     impact details.
          class Impact
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A detailed impact breakdown for a group of regions where the impact of the
          # issue on different shopping destinations is the same.
          # @!attribute [rw] regions
          #   @return [::Array<::Google::Shopping::Merchant::IssueResolution::V1::Breakdown::Region>]
          #     Lists of regions. Should be rendered as a title for this group of details.
          #     The full list should be shown to the business. If the list is too long, it
          #     is recommended to make it expandable.
          # @!attribute [rw] details
          #   @return [::Array<::String>]
          #     Human readable, localized description of issue's effect on different
          #     targets. Should be rendered as a list.
          #
          #     For example:
          #
          #     * "Products not showing in ads"
          #     * "Products not showing organically"
          class Breakdown
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Region with code and localized name.
            # @!attribute [rw] code
            #   @return [::String]
            #     The [CLDR territory code]
            #     (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
            # @!attribute [rw] name
            #   @return [::String]
            #     The localized name of the region.
            #     For region with code='001' the value is 'All countries' or the equivalent
            #     in other languages.
            class Region
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # An actionable step that can be executed to solve the issue.
          # @!attribute [rw] builtin_simple_action
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::BuiltInSimpleAction]
          #     Action implemented and performed in (your) third-party application. The
          #     application should point the business to the place, where they can access
          #     the corresponding functionality or provide instructions, if the specific
          #     functionality is not available.
          #
          #     Note: The following fields are mutually exclusive: `builtin_simple_action`, `external_action`, `builtin_user_input_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] external_action
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::ExternalAction]
          #     Action that is implemented and performed outside of (your) third-party
          #     application. The application needs to redirect the business to the
          #     external location where they can perform the action.
          #
          #     Note: The following fields are mutually exclusive: `external_action`, `builtin_simple_action`, `builtin_user_input_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] builtin_user_input_action
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::BuiltInUserInputAction]
          #     Action implemented and performed in (your) third-party application.
          #     The application needs to show an additional content and input form to the
          #     business as specified for given action. They can trigger the action only
          #     when they provided all required inputs.
          #
          #     Note: The following fields are mutually exclusive: `builtin_user_input_action`, `builtin_simple_action`, `external_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] button_label
          #   @return [::String]
          #     Label of the action button.
          # @!attribute [rw] is_available
          #   @return [::Boolean]
          #     Controlling whether the button is active or disabled. The value is 'false'
          #     when the action was already requested or is not available. If the action is
          #     not available then a
          #     {::Google::Shopping::Merchant::IssueResolution::V1::Action#reasons reason} will
          #     be present. If (your) third-party application shows a disabled button for
          #     action that is not available, then it should also show reasons.
          # @!attribute [rw] reasons
          #   @return [::Array<::Google::Shopping::Merchant::IssueResolution::V1::Action::Reason>]
          #     List of reasons why the action is not available. The list of reasons is
          #     empty if the action is available. If there is only one reason, it can be
          #     displayed next to the disabled button. If there are more reasons, all of
          #     them should be displayed, for example in a pop-up dialog.
          class Action
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A single reason why the action is not available.
            # @!attribute [rw] message
            #   @return [::String]
            #     Messages summarizing the reason, why the action is not available.
            #     For example: "Review requested on Jan 03. Review requests can take a few
            #     days to complete."
            # @!attribute [rw] detail
            #   @return [::String]
            #     Detailed explanation of the reason. Should be displayed as a hint if
            #     present.
            # @!attribute [rw] action
            #   @return [::Google::Shopping::Merchant::IssueResolution::V1::Action]
            #     Optional. An action that needs to be performed to solve the problem
            #     represented by this reason. This action will always be available. Should
            #     be rendered as a link or button next to the summarizing message.
            #
            #     For example, the review may be available only once the business configure
            #     all required attributes. In such a situation this action can be a link to
            #     the form, where they can fill the missing attribute to unblock the main
            #     action.
            class Reason
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Action that is implemented and performed in (your) third-party application.
          # Represents various functionality that is expected to be available to business
          # and will help them with resolving the issue. The application should point the
          # business to the place, where they can access the corresponding functionality.
          # If the functionality is not supported, it is recommended to explain the
          # situation to the business and provide them with instructions how to solve the
          # issue.
          # @!attribute [rw] type
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::BuiltInSimpleAction::BuiltInSimpleActionType]
          #     The type of action that represents a functionality that is expected to be
          #     available in third-party application.
          # @!attribute [rw] attribute_code
          #   @return [::String]
          #     The attribute that needs to be updated. Present when the
          #     {::Google::Shopping::Merchant::IssueResolution::V1::BuiltInSimpleAction#type type}
          #     is `EDIT_ITEM_ATTRIBUTE`.
          #
          #     This field contains a code for attribute, represented in snake_case. You
          #     can find a list of product's attributes, with their codes
          #     [here](https://support.google.com/merchants/answer/7052112).
          # @!attribute [rw] additional_content
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::BuiltInSimpleAction::AdditionalContent]
          #     Long text from an external source that should be available to the business.
          #     Present when the
          #     {::Google::Shopping::Merchant::IssueResolution::V1::BuiltInSimpleAction#type type}
          #     is `SHOW_ADDITIONAL_CONTENT`.
          class BuiltInSimpleAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Long text from external source.
            # @!attribute [rw] title
            #   @return [::String]
            #     Title of the additional content;
            # @!attribute [rw] paragraphs
            #   @return [::Array<::String>]
            #     Long text organized into paragraphs.
            class AdditionalContent
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Enum specifying the type of action in third-party application.
            module BuiltInSimpleActionType
              # Default value. Will never be provided by the API.
              BUILT_IN_SIMPLE_ACTION_TYPE_UNSPECIFIED = 0

              # Redirect the business to the part of your application where they can
              # verify their phone.
              VERIFY_PHONE = 1

              # Redirect the business to the part of your application where they can
              # claim their website.
              CLAIM_WEBSITE = 2

              # Redirect the business to the part of your application where they can add
              # products.
              ADD_PRODUCTS = 3

              # Open a form where the business can edit their contact information.
              ADD_CONTACT_INFO = 4

              # Redirect the business to the part of your application where they can link
              # ads account.
              LINK_ADS_ACCOUNT = 5

              # Open a form where the business can add their business registration
              # number.
              ADD_BUSINESS_REGISTRATION_NUMBER = 6

              # Open a form where the business can edit an attribute. The attribute that
              # needs to be updated is specified in
              # {::Google::Shopping::Merchant::IssueResolution::V1::BuiltInSimpleAction#attribute_code attribute_code}
              # field of the action.
              EDIT_ITEM_ATTRIBUTE = 7

              # Redirect the business from the product issues to the diagnostic page with
              # their account issues in your application.
              #
              # This action will be returned only for product issues that are caused by
              # an account issue and thus the business should resolve the problem on the
              # account level.
              FIX_ACCOUNT_ISSUE = 8

              # Show [additional
              # content][google.shopping.merchant.issueresolution.v1.BuiltInSimpleAction.additional_content]
              # to the business.
              #
              # This action will be used for example to deliver a justification from
              # national authority.
              SHOW_ADDITIONAL_CONTENT = 9
            end
          end

          # Action that is implemented and performed in (your) third-party application.
          # The application needs to show an additional content and input form to the
          # business. They can start the action only when they provided all required
          # inputs. The application will request processing of the action by calling the
          # [triggeraction
          # method](https://developers.google.com/merchant/api/reference/rest/issueresolution_v1/issueresolution/triggeraction).
          # @!attribute [rw] action_context
          #   @return [::String]
          #     Contains the action's context that must be included as part of the
          #     {::Google::Shopping::Merchant::IssueResolution::V1::TriggerActionPayload#action_context TriggerActionPayload.action_context}
          #     in
          #     {::Google::Shopping::Merchant::IssueResolution::V1::TriggerActionRequest#payload TriggerActionRequest.payload}
          #     to call the `triggeraction` method. The content should be treated as opaque
          #     and must not be modified.
          # @!attribute [rw] flows
          #   @return [::Array<::Google::Shopping::Merchant::IssueResolution::V1::ActionFlow>]
          #     Actions may provide multiple different flows. Business selects one that
          #     fits best to their intent. Selecting the flow is the first step in user's
          #     interaction with the action. It affects what input fields will be available
          #     and required and also how the request will be processed.
          class BuiltInUserInputAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Flow that can be selected for an action. When a business selects a flow,
          # application should open a dialog with more information and input form.
          # @!attribute [rw] id
          #   @return [::String]
          #     Not for display but need to be sent back for the selected action flow.
          # @!attribute [rw] label
          #   @return [::String]
          #     Text value describing the intent for the action flow. It can be used as an
          #     input label if business needs to pick one of multiple flows. For example:
          #     "I disagree with the issue"
          # @!attribute [rw] inputs
          #   @return [::Array<::Google::Shopping::Merchant::IssueResolution::V1::InputField>]
          #     A list of input fields.
          # @!attribute [rw] dialog_title
          #   @return [::String]
          #     Title of the request dialog. For example: "Before you request a review"
          # @!attribute [rw] dialog_message
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::TextWithTooltip]
          #     Message displayed in the request dialog. For example: "Make sure you've
          #     fixed all your country-specific issues. If not, you may have to wait 7 days
          #     to request another review". There may be an more information to be shown in
          #     a tooltip.
          # @!attribute [rw] dialog_callout
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::Callout]
          #     Important message to be highlighted in the request dialog. For example:
          #     "You can only request a review for disagreeing with this issue once. If
          #     it's not approved, you'll need to fix the issue and wait a few days before
          #     you can request another review."
          # @!attribute [rw] dialog_button_label
          #   @return [::String]
          #     Label for the button to trigger the action from the action dialog. For
          #     example: "Request review"
          class ActionFlow
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Input field that needs to be available to the business. If the field is
          # marked as required, then a value needs to be provided for a successful
          # processing of the request.
          # @!attribute [rw] text_input
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::InputField::TextInput]
          #     Input field to provide text information.
          #     Corresponds to the [html input
          #     type=text](https://www.w3.org/TR/2012/WD-html-markup-20121025/input.text.html#input.text)
          #     or [html
          #     textarea](https://www.w3.org/TR/2012/WD-html-markup-20121025/textarea.html#textarea).
          #
          #     Note: The following fields are mutually exclusive: `text_input`, `choice_input`, `checkbox_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] choice_input
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::InputField::ChoiceInput]
          #     Input field to select one of the offered choices.
          #     Corresponds to the [html input
          #     type=radio](https://www.w3.org/TR/2012/WD-html-markup-20121025/input.radio.html#input.radio).
          #
          #     Note: The following fields are mutually exclusive: `choice_input`, `text_input`, `checkbox_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] checkbox_input
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::InputField::CheckboxInput]
          #     Input field to provide a boolean value.
          #     Corresponds to the [html input
          #     type=checkbox](https://www.w3.org/TR/2012/WD-html-markup-20121025/input.checkbox.html#input.checkbox).
          #
          #     Note: The following fields are mutually exclusive: `checkbox_input`, `text_input`, `choice_input`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] id
          #   @return [::String]
          #     Not for display but need to be sent back for the given input field.
          # @!attribute [rw] label
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::TextWithTooltip]
          #     Input field label. There may be more information to be shown in a tooltip.
          # @!attribute [rw] required
          #   @return [::Boolean]
          #     Whether the field is required. The action button needs to stay disabled
          #     till values for all required fields are provided.
          class InputField
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Text input allows the business to provide a text value.
            # @!attribute [rw] type
            #   @return [::Google::Shopping::Merchant::IssueResolution::V1::InputField::TextInput::TextInputType]
            #     Type of the text input
            # @!attribute [rw] additional_info
            #   @return [::Google::Shopping::Merchant::IssueResolution::V1::TextWithTooltip]
            #     Additional info regarding the field to be displayed to the business. For
            #     example, warning to not include personal identifiable information. There
            #     may be more information to be shown in a tooltip.
            # @!attribute [rw] format_info
            #   @return [::String]
            #     Information about the required format. If present, it should be shown
            #     close to the input field to help the business to provide a correct value.
            #     For example: "VAT numbers should be in a format similar to SK9999999999"
            # @!attribute [rw] aria_label
            #   @return [::String]
            #     Text to be used as the
            #     [aria-label](https://www.w3.org/TR/WCAG20-TECHS/ARIA14.html) for the
            #     input.
            class TextInput
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Enum specifying the type of the text input and how it should be rendered.
              module TextInputType
                # Default value. Will never be provided by the API.
                TEXT_INPUT_TYPE_UNSPECIFIED = 0

                # Used when a short text is expected. The field can be rendered as a
                # [text
                # field](https://www.w3.org/TR/2012/WD-html-markup-20121025/input.text.html#input.text).
                GENERIC_SHORT_TEXT = 1

                # Used when a longer text is expected. The field should be rendered as a
                # [textarea](https://www.w3.org/TR/2012/WD-html-markup-20121025/textarea.html#textarea).
                GENERIC_LONG_TEXT = 2
              end
            end

            # Choice input allows the business to select one of the offered choices. Some
            # choices may be linked to additional input fields that should be displayed
            # under or next to the choice option. The value for the additional input
            # field needs to be provided only when the specific choice is selected by the
            # the business. For example, additional input field can be hidden or disabled
            # until the business selects the specific choice.
            # @!attribute [rw] options
            #   @return [::Array<::Google::Shopping::Merchant::IssueResolution::V1::InputField::ChoiceInput::ChoiceInputOption>]
            #     A list of choices. Only one option can be selected.
            class ChoiceInput
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # A choice that the business can select.
              # @!attribute [rw] id
              #   @return [::String]
              #     Not for display but need to be sent back for the selected choice
              #     option.
              # @!attribute [rw] label
              #   @return [::Google::Shopping::Merchant::IssueResolution::V1::TextWithTooltip]
              #     Short description of the choice option. There may be more information
              #     to be shown as a tooltip.
              # @!attribute [rw] additional_input
              #   @return [::Google::Shopping::Merchant::IssueResolution::V1::InputField]
              #     Input that should be displayed when this option is selected.
              #     The additional input will not contain a `ChoiceInput`.
              class ChoiceInputOption
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # Checkbox input allows the business to provide a boolean value. Corresponds
            # to the [html input
            # type=checkbox](https://www.w3.org/TR/2012/WD-html-markup-20121025/input.checkbox.html#input.checkbox).
            #
            # If the business checks the box, the input value for the field is `true`,
            # otherwise it is `false`.
            #
            # This type of input is often used as a confirmation that the business
            # completed required steps before they are allowed to start the action. In
            # such a case, the input field is marked as
            # {::Google::Shopping::Merchant::IssueResolution::V1::InputField#required required}
            # and the button to trigger the action should stay disabled until the
            # business checks the box.
            class CheckboxInput
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Block of text that may contain a tooltip with more information.
          # @!attribute [rw] simple_value
          #   @return [::String]
          #     Value of the message as a simple text.
          # @!attribute [rw] simple_tooltip_value
          #   @return [::String]
          #     Value of the tooltip as a simple text.
          # @!attribute [rw] tooltip_icon_style
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::TextWithTooltip::TooltipIconStyle]
          #     The suggested type of an icon for tooltip, if a tooltip is present.
          class TextWithTooltip
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum specifying the type of an icon that is being used to display a
            # corresponding tooltip in the Merchant Center.
            module TooltipIconStyle
              # Default value. Will never be provided by the API.
              TOOLTIP_ICON_STYLE_UNSPECIFIED = 0

              # Used when the tooltip adds additional information to the context,
              # the 'i' can be used as an icon.
              INFO = 1

              # Used when the tooltip shows helpful information, the '?' can be used as
              # an icon.
              QUESTION = 2
            end
          end

          # An important message that should be highlighted. Usually displayed as a
          # banner.
          # @!attribute [rw] style_hint
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::Callout::CalloutStyleHint]
          #     Can be used to render messages with different severity in different styles.
          #     Snippets off all types contain important information that should be
          #     displayed to the business.
          # @!attribute [rw] full_message
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::TextWithTooltip]
          #     A full message that needs to be shown to the business.
          class Callout
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum specifying the suggested style, how the message should be rendered.
            module CalloutStyleHint
              # Default value. Will never be provided by the API.
              CALLOUT_STYLE_HINT_UNSPECIFIED = 0

              # The most important type of information highlighting problems, like an
              # unsuccessful outcome of previously requested actions.
              ERROR = 1

              # Information warning about pending problems, risks or deadlines.
              WARNING = 2

              # Default severity for important information like pending status of
              # previously requested action or cooldown for re-review.
              INFO = 3
            end
          end

          # Action that is implemented and performed outside of the third-party
          # application. It should redirect the business to the provided URL of an
          # external system where they can perform the action. For example to request a
          # review in the Merchant Center.
          # @!attribute [rw] type
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::ExternalAction::ExternalActionType]
          #     The type of external action.
          # @!attribute [rw] uri
          #   @return [::String]
          #     URL to external system, for example Merchant Center, where the business can
          #     perform the action.
          class ExternalAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum specifying the type of action that requires to redirect the business
            # to an external location.
            module ExternalActionType
              # Default value. Will never be provided by the API.
              EXTERNAL_ACTION_TYPE_UNSPECIFIED = 0

              # Redirect to Merchant Center where the business can request a review for
              # issue related to their product.
              REVIEW_PRODUCT_ISSUE_IN_MERCHANT_CENTER = 1

              # Redirect to Merchant Center where the business can request a review for
              # issue related to their account.
              REVIEW_ACCOUNT_ISSUE_IN_MERCHANT_CENTER = 2

              # Redirect to the form in Help Center where the business can request a
              # legal appeal for the issue.
              LEGAL_APPEAL_IN_HELP_CENTER = 3

              # Redirect to Merchant Center where the business can perform identity
              # verification.
              VERIFY_IDENTITY_IN_MERCHANT_CENTER = 4
            end
          end

          # Request to start the selected action
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The business's account that is triggering the action.
          #     Format: `accounts/{account}`
          # @!attribute [rw] payload
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::TriggerActionPayload]
          #     Required. The payload for the triggered action.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     Optional. Language code [IETF BCP 47
          #     syntax](https://tools.ietf.org/html/bcp47) used to localize the response.
          #     If not set, the result will be in default language `en-US`.
          class TriggerActionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The payload for the triggered action.
          # @!attribute [rw] action_context
          #   @return [::String]
          #     Required. The
          #     {::Google::Shopping::Merchant::IssueResolution::V1::BuiltInUserInputAction#action_context context}
          #     from the selected action. The value is obtained from rendered issues and
          #     needs to be sent back to identify the
          #     {::Google::Shopping::Merchant::IssueResolution::V1::Action#builtin_user_input_action action}
          #     that is being triggered.
          # @!attribute [rw] action_input
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::ActionInput]
          #     Required. Input provided by the business.
          class TriggerActionPayload
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response informing about the started action.
          # @!attribute [rw] message
          #   @return [::String]
          #     The message for the business.
          class TriggerActionResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Input provided by the business.
          # @!attribute [rw] action_flow_id
          #   @return [::String]
          #     Required. {::Google::Shopping::Merchant::IssueResolution::V1::ActionFlow#id Id}
          #     of the selected action flow.
          # @!attribute [rw] input_values
          #   @return [::Array<::Google::Shopping::Merchant::IssueResolution::V1::InputValue>]
          #     Required. Values for input fields.
          class ActionInput
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Input provided by the business for input field.
          # @!attribute [rw] text_input_value
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::InputValue::TextInputValue]
          #     Value for [text
          #     input][google.shopping.merchant.issueresolution.v1.InputField.TextInput]
          #     field.
          #
          #     Note: The following fields are mutually exclusive: `text_input_value`, `choice_input_value`, `checkbox_input_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] choice_input_value
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::InputValue::ChoiceInputValue]
          #     Value for [choice
          #     input][google.shopping.merchant.issueresolution.v1.InputField.ChoiceInput]
          #     field.
          #
          #     Note: The following fields are mutually exclusive: `choice_input_value`, `text_input_value`, `checkbox_input_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] checkbox_input_value
          #   @return [::Google::Shopping::Merchant::IssueResolution::V1::InputValue::CheckboxInputValue]
          #     Value for [checkbox
          #     input][google.shopping.merchant.issueresolution.v1.InputField.CheckboxInput]
          #     field.
          #
          #     Note: The following fields are mutually exclusive: `checkbox_input_value`, `text_input_value`, `choice_input_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] input_field_id
          #   @return [::String]
          #     Required. {::Google::Shopping::Merchant::IssueResolution::V1::InputField#id Id}
          #     of the corresponding input field.
          class InputValue
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Value for [text
            # input][google.shopping.merchant.issueresolution.v1.InputField.TextInput]
            # field.
            # @!attribute [rw] value
            #   @return [::String]
            #     Required. Text provided by the business.
            class TextInputValue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Value for [choice
            # input][google.shopping.merchant.issueresolution.v1.InputField.ChoiceInput]
            # field.
            # @!attribute [rw] choice_input_option_id
            #   @return [::String]
            #     Required. [Id][InputField.ChoiceInput.id] of the option that was selected
            #     by the business.
            class ChoiceInputValue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Value for [checkbox
            # input][google.shopping.merchant.issueresolution.v1.InputField.CheckboxInput]
            # field.
            # @!attribute [rw] value
            #   @return [::Boolean]
            #     Required. True if the business checked the box field. False otherwise.
            class CheckboxInputValue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Enum specifying the severity of the issue.
          module Severity
            # Default value. Will never be provided by the API.
            SEVERITY_UNSPECIFIED = 0

            # Causes either an account suspension or an item disapproval. Errors should
            # be resolved as soon as possible to ensure items are eligible to appear in
            # results again.
            ERROR = 1

            # Warnings can negatively impact the performance of ads and can lead to item
            # or account suspensions in the future unless the issue is resolved.
            WARNING = 2

            # Infos are suggested optimizations to increase data quality. Resolving these
            # issues is recommended, but not required.
            INFO = 3
          end

          # Enum specifying how is the content returned.
          module ContentOption
            # Default value. Will never be provided by the API.
            CONTENT_OPTION_UNSPECIFIED = 0

            # Returns the detail of the issue as a pre-rendered HTML text.
            PRE_RENDERED_HTML = 1
          end

          # Enum specifying how actions with user input forms, such as requesting
          # re-review, are handled.
          module UserInputActionRenderingOption
            # Default value. Will never be provided by the API.
            USER_INPUT_ACTION_RENDERING_OPTION_UNSPECIFIED = 0

            # Actions that require user input are represented only as links that points
            # the business to Merchant Center where they can request the action. Provides
            # easier to implement alternative to `BUILT_IN_USER_INPUT_ACTIONS`.
            REDIRECT_TO_MERCHANT_CENTER = 1

            # Returns content and input form definition for each complex action. Your
            # application needs to display this content and input form to the business
            # before they can request processing of the action. To start the action, your
            # application needs to call the `triggeraction` method.
            BUILT_IN_USER_INPUT_ACTIONS = 2
          end
        end
      end
    end
  end
end
