# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Inventories
        module V1
          # Regional inventory information for the product. Represents specific
          # information like price and availability for a given product in a specific
          # {::Google::Shopping::Merchant::Inventories::V1::RegionalInventory#region `region`}.
          # For a list of all accepted attribute values, see the [regional product
          # inventory data
          # specification](https://support.google.com/merchants/answer/9698880).
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The name of the `RegionalInventory` resource.
          #     Format:
          #     `{regional_inventory.name=accounts/{account}/products/{product}/regionalInventories/{region}`
          # @!attribute [r] account
          #   @return [::Integer]
          #     Output only. The account that owns the product. This field will be ignored
          #     if set by the client.
          # @!attribute [rw] region
          #   @return [::String]
          #     Required. Immutable. ID of the region for this
          #     `RegionalInventory` resource. See the [Regional availability and
          #     pricing](https://support.google.com/merchants/answer/9698880) for more
          #     details.
          # @!attribute [rw] regional_inventory_attributes
          #   @return [::Google::Shopping::Merchant::Inventories::V1::RegionalInventoryAttributes]
          #     Optional. A list of regional inventory attributes.
          class RegionalInventory
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `ListRegionalInventories` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The `name` of the parent product to list `RegionalInventory`
          #     resources for. Format: `accounts/{account}/products/{product}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of `RegionalInventory` resources for the given product
          #     to return. The service returns fewer than this value if the number of
          #     inventories for the given product is less that than the `pageSize`. The
          #     default value is 25000. The maximum value is 100000; If a value higher than
          #     the maximum is specified, then the `pageSize` will default to the maximum.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     A page token, received from a previous `ListRegionalInventories` call.
          #     Provide the page token to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to `ListRegionalInventories`
          #     must match the call that provided the page token. The token returned as
          #     {::Google::Shopping::Merchant::Inventories::V1::ListRegionalInventoriesResponse#next_page_token nextPageToken}
          #     in the response to the previous request.
          class ListRegionalInventoriesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the `ListRegionalInventories` method.
          # @!attribute [rw] regional_inventories
          #   @return [::Array<::Google::Shopping::Merchant::Inventories::V1::RegionalInventory>]
          #     The `RegionalInventory` resources for the given product from the specified
          #     account.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `pageToken` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListRegionalInventoriesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `InsertRegionalInventory` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The account and product where this inventory will be inserted.
          #     Format: `accounts/{account}/products/{product}`
          # @!attribute [rw] regional_inventory
          #   @return [::Google::Shopping::Merchant::Inventories::V1::RegionalInventory]
          #     Required. Regional inventory information to add to the product. If the
          #     product already has a `RegionalInventory` resource for the same `region`,
          #     full replacement of the `RegionalInventory` resource is performed.
          class InsertRegionalInventoryRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `DeleteRegionalInventory` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the `RegionalInventory` resource to delete.
          #     Format:
          #     `accounts/{account}/products/{product}/regionalInventories/{region}`
          class DeleteRegionalInventoryRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
