# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Inventories
        module V1
          # Local inventory attributes.
          # @!attribute [rw] price
          #   @return [::Google::Shopping::Type::Price]
          #     Optional. Price of the product at this store.
          # @!attribute [rw] sale_price
          #   @return [::Google::Shopping::Type::Price]
          #     Optional. Sale price of the product at this store. Mandatory if
          #     [`salePriceEffectiveDate`][LocalInventory.sale_price_effective_date] is
          #     defined.
          # @!attribute [rw] sale_price_effective_date
          #   @return [::Google::Type::Interval]
          #     Optional. The `TimePeriod` of the
          #     sale at this store.
          # @!attribute [rw] availability
          #   @return [::Google::Shopping::Merchant::Inventories::V1::LocalInventoryAttributes::Availability]
          #     [Availability](https://support.google.com/merchants/answer/3061342) of the
          #     product at this store.
          # @!attribute [rw] quantity
          #   @return [::Integer]
          #     Optional. Quantity of the product available at this store. Must be greater
          #     than or equal to zero.
          # @!attribute [rw] pickup_method
          #   @return [::Google::Shopping::Merchant::Inventories::V1::LocalInventoryAttributes::PickupMethod]
          #     Optional. Supported [pickup
          #     method](https://support.google.com/merchants/answer/3061342) for this
          #     product. Unless the value is `"not supported"`, this field must be
          #     submitted together with `pickupSla`.
          # @!attribute [rw] pickup_sla
          #   @return [::Google::Shopping::Merchant::Inventories::V1::LocalInventoryAttributes::PickupSla]
          #     Optional. Relative time period from the order date for an order for this
          #     product, from this store, to be ready for pickup. Must be submitted with
          #     `pickupMethod`. See more details
          #     [here](https://support.google.com/merchants/answer/3061342).
          # @!attribute [rw] instore_product_location
          #   @return [::String]
          #     Optional. Location of the product inside the store. Maximum length is 20
          #     bytes.
          class LocalInventoryAttributes
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # [Availability](https://support.google.com/merchants/answer/3061342) of the
            # product at this store.
            module Availability
              # Indicates that the availability is unspecified.
              LOCAL_INVENTORY_AVAILABILITY_UNSPECIFIED = 0

              # Indicates that the product is in stock.
              IN_STOCK = 1

              # Indicates that the product is out of stock.
              LIMITED_AVAILABILITY = 2

              # Indicates that the product is on display to order.
              ON_DISPLAY_TO_ORDER = 3

              # Indicates that the product is out of stock.
              OUT_OF_STOCK = 4
            end

            # Supported [pickup
            # method](https://support.google.com/merchants/answer/3061342) for this
            # product. Unless the value is `"not supported"`, this field must be
            # submitted together with `pickupSla`.
            module PickupMethod
              # Indicates that the pickup method is unspecified.
              PICKUP_METHOD_UNSPECIFIED = 0

              # Indicates that the pickup method is Buy.
              BUY = 1

              # Indicates that the pickup method is Reserve.
              RESERVE = 2

              # Indicates that the pickup method is Ship to store.
              SHIP_TO_STORE = 3

              # Indicates that the pickup method is not supported.
              NOT_SUPPORTED = 4
            end

            # Relative time period from the order date for an order for this product,
            # from this store, to be ready for pickup. Must be submitted with
            # `pickupMethod`. See more details
            # [here](https://support.google.com/merchants/answer/3061342).
            module PickupSla
              # Indicates that the pickup SLA is unspecified.
              PICKUP_SLA_UNSPECIFIED = 0

              # Indicates that the pickup SLA is same day.
              SAME_DAY = 1

              # Indicates that the pickup SLA is next day.
              NEXT_DAY = 2

              # Indicates that the pickup SLA is two days.
              TWO_DAY = 3

              # Indicates that the pickup SLA is three days.
              THREE_DAY = 4

              # Indicates that the pickup SLA is four days.
              FOUR_DAY = 5

              # Indicates that the pickup SLA is five days.
              FIVE_DAY = 6

              # Indicates that the pickup SLA is six days.
              SIX_DAY = 7

              # Indicates that the pickup SLA is seven days.
              SEVEN_DAY = 8

              # Indicates that the pickup SLA is multi-week.
              MULTI_WEEK = 9
            end
          end

          # Regional inventory attributes.
          # @!attribute [rw] price
          #   @return [::Google::Shopping::Type::Price]
          #     Optional. Price of the product in this region.
          # @!attribute [rw] sale_price
          #   @return [::Google::Shopping::Type::Price]
          #     Optional. Sale price of the product in this region. Mandatory if
          #     [`salePriceEffectiveDate`][RegionalInventory.sale_price_effective_date] is
          #     defined.
          # @!attribute [rw] sale_price_effective_date
          #   @return [::Google::Type::Interval]
          #     Optional. The `TimePeriod` of the
          #     sale price in this region.
          # @!attribute [rw] availability
          #   @return [::Google::Shopping::Merchant::Inventories::V1::RegionalInventoryAttributes::Availability]
          #     Optional.
          #     [Availability](https://support.google.com/merchants/answer/14644124) of the
          #     product in this region.
          class RegionalInventoryAttributes
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # [Availability](https://support.google.com/merchants/answer/14644124) of the
            # product in this region.
            module Availability
              # Indicates that the availability is unspecified.
              REGIONAL_INVENTORY_AVAILABILITY_UNSPECIFIED = 0

              # Indicates that the product is in stock.
              IN_STOCK = 1

              # Indicates that the product is out of stock.
              OUT_OF_STOCK = 2
            end
          end
        end
      end
    end
  end
end
