# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/shopping/merchant/inventories/v1/localinventory.proto for package 'Google.Shopping.Merchant.Inventories.V1'
# Original file comments:
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/shopping/merchant/inventories/v1/localinventory_pb'

module Google
  module Shopping
    module Merchant
      module Inventories
        module V1
          module LocalInventoryService
            # Service to manage local inventory for products
            class Service

              include ::GRPC::GenericService

              self.marshal_class_method = :encode
              self.unmarshal_class_method = :decode
              self.service_name = 'google.shopping.merchant.inventories.v1.LocalInventoryService'

              # Lists the `LocalInventory` resources for the given product in your merchant
              # account. The response might contain fewer items than specified by
              # `pageSize`. If `pageToken` was returned in previous request, it can be used
              # to obtain additional results.
              #
              # `LocalInventory` resources are listed per product for a given account.
              rpc :ListLocalInventories, ::Google::Shopping::Merchant::Inventories::V1::ListLocalInventoriesRequest, ::Google::Shopping::Merchant::Inventories::V1::ListLocalInventoriesResponse
              # Inserts a `LocalInventory` resource to a product in your merchant
              # account.
              #
              # Replaces the full `LocalInventory` resource if an entry with the same
              # [`storeCode`][google.shopping.merchant.inventories.v1.LocalInventory.store_code]
              # already exists for the product.
              #
              # It might take up to 30 minutes for the new or updated `LocalInventory`
              # resource to appear in products.
              rpc :InsertLocalInventory, ::Google::Shopping::Merchant::Inventories::V1::InsertLocalInventoryRequest, ::Google::Shopping::Merchant::Inventories::V1::LocalInventory
              # Deletes the specified `LocalInventory` from the given product in your
              # merchant account. It might take a up to an hour for the
              # `LocalInventory` to be deleted from the specific product.
              # Once you have received a successful delete response, wait for that
              # period before attempting a delete again.
              rpc :DeleteLocalInventory, ::Google::Shopping::Merchant::Inventories::V1::DeleteLocalInventoryRequest, ::Google::Protobuf::Empty
            end

            Stub = Service.rpc_stub_class
          end
        end
      end
    end
  end
end
