# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module DataSources
        module V1beta
          # The file upload of a specific data source, that is, the result of the
          # retrieval of the data source at a certain timestamp computed asynchronously
          # when the data source processing is finished. Only applicable to file data
          # sources.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The name of the data source file upload.
          #     Format:
          #     `{datasource.name=accounts/{account}/dataSources/{datasource}/fileUploads/{fileupload}}`
          # @!attribute [r] data_source_id
          #   @return [::Integer]
          #     Output only. The data source id.
          # @!attribute [r] processing_state
          #   @return [::Google::Shopping::Merchant::DataSources::V1beta::FileUpload::ProcessingState]
          #     Output only. The processing state of the data source.
          # @!attribute [r] issues
          #   @return [::Array<::Google::Shopping::Merchant::DataSources::V1beta::FileUpload::Issue>]
          #     Output only. The list of issues occurring in the data source.
          # @!attribute [r] items_total
          #   @return [::Integer]
          #     Output only. The number of items in the data source that were processed.
          # @!attribute [r] items_created
          #   @return [::Integer]
          #     Output only. The number of items in the data source that were created.
          # @!attribute [r] items_updated
          #   @return [::Integer]
          #     Output only. The number of items in the data source that were updated.
          # @!attribute [r] upload_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The date at which the file of the data source was uploaded.
          class FileUpload
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # An error occurring in the data source, like "invalid price".
            # @!attribute [r] title
            #   @return [::String]
            #     Output only. The title of the issue, for example, "Item too big".
            # @!attribute [r] description
            #   @return [::String]
            #     Output only. The error description, for example, "Your data source
            #     contains items which have too many attributes, or are too big. These
            #     items will be dropped".
            # @!attribute [r] code
            #   @return [::String]
            #     Output only. The code of the error, for example,
            #     "validation/invalid_value". Returns
            #     "?" if the code is unknown.
            # @!attribute [r] count
            #   @return [::Integer]
            #     Output only. The number of occurrences of the error in the file upload.
            # @!attribute [r] severity
            #   @return [::Google::Shopping::Merchant::DataSources::V1beta::FileUpload::Issue::Severity]
            #     Output only. The severity of the issue.
            # @!attribute [r] documentation_uri
            #   @return [::String]
            #     Output only. Link to the documentation explaining the issue in more
            #     details, if available.
            class Issue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # The severity of the issue.
              module Severity
                # Severity unspecified.
                SEVERITY_UNSPECIFIED = 0

                # The issue is the warning.
                WARNING = 1

                # The issue is an error.
                ERROR = 2
              end
            end

            # The processing state of the data source.
            module ProcessingState
              # Processing state unspecified.
              PROCESSING_STATE_UNSPECIFIED = 0

              # The data source could not be processed or all the items had errors.
              FAILED = 1

              # The data source is being processed.
              IN_PROGRESS = 2

              # The data source was processed successfully, though some items might have
              # had errors.
              SUCCEEDED = 3
            end
          end

          # Request message for the GetFileUploadRequest method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the data source file upload to retrieve.
          #     Format:
          #     `accounts/{account}/dataSources/{datasource}/fileUploads/latest`
          class GetFileUploadRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
