# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module DataSources
        module V1beta
          # The primary data source for local and online products.
          # @!attribute [rw] channel
          #   @return [::Google::Shopping::Merchant::DataSources::V1beta::PrimaryProductDataSource::Channel]
          #     Optional. Immutable. Specifies the type of data source channel.
          # @!attribute [rw] feed_label
          #   @return [::String]
          #     Optional. Immutable. The feed label that is specified on the data source
          #     level.
          #
          #     Must be less than or equal to 20 uppercase letters (A-Z), numbers (0-9),
          #     and dashes (-).
          #
          #     See also [migration to feed
          #     labels](https://developers.google.com/shopping-content/guides/products/feed-labels).
          #
          #     `feedLabel` and `contentLanguage` must be either both set or unset for data
          #     sources with product content type.
          #     They must be set for data sources with a file input.
          #
          #     If set, the data source will only accept products matching this
          #     combination. If unset, the data source will accept products without that
          #     restriction.
          # @!attribute [rw] content_language
          #   @return [::String]
          #     Optional. Immutable. The two-letter ISO 639-1 language of the items in the
          #     data source.
          #
          #     `feedLabel` and `contentLanguage` must be either both set or unset.
          #     The fields can only be unset for data sources without file input.
          #
          #     If set, the data source will only accept products matching this
          #     combination. If unset, the data source will accept products without that
          #     restriction.
          # @!attribute [rw] countries
          #   @return [::Array<::String>]
          #     Optional. The countries where the items may be displayed. Represented as a
          #     [CLDR territory
          #     code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml).
          # @!attribute [rw] default_rule
          #   @return [::Google::Shopping::Merchant::DataSources::V1beta::PrimaryProductDataSource::DefaultRule]
          #     Optional. Default rule management of the data source. If set, the linked
          #     data sources will be replaced.
          # @!attribute [rw] destinations
          #   @return [::Array<::Google::Shopping::Merchant::DataSources::V1beta::PrimaryProductDataSource::Destination>]
          #     Optional. A list of destinations describing where products of the data
          #     source can be shown.
          #
          #     When retrieving the data source, the list contains all the destinations
          #     that can be used for the data source, including the ones that are disabled
          #     for the data source but enabled for the account.
          #
          #     Only destinations that are enabled on the account, for example through
          #     program participation, can be enabled on the data source.
          #
          #     If unset, during creation, the destinations will be inherited based on the
          #     account level program participation.
          #
          #     If set, during creation or update, the data source will be set only for the
          #     specified destinations.
          #
          #     Updating this field requires at least one destination.
          class PrimaryProductDataSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Default rule management of the data source.
            # @!attribute [rw] take_from_data_sources
            #   @return [::Array<::Google::Shopping::Merchant::DataSources::V1beta::DataSourceReference>]
            #     Required. The list of data sources linked in the [default
            #     rule](https://support.google.com/merchants/answer/7450276).
            #     This list is ordered by the default rule priority of joining the data.
            #     It might include none or multiple references to `self` and supplemental
            #     data sources.
            #
            #     The list must not be empty.
            #
            #     To link the data source to the default rule, you need to add a
            #     new reference to this list (in sequential order).
            #
            #     To unlink the data source from the default rule, you need to
            #     remove the given reference from this list.
            #
            #     Changing the order of this list will result in changing the priority of
            #     data sources in the default rule.
            #
            #     For example, providing the following list: [`1001`, `self`] will
            #     take attribute values from supplemental data source `1001`, and fallback
            #     to `self` if the attribute is not set in `1001`.
            class DefaultRule
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Destinations also known as [Marketing
            # methods](https://support.google.com/merchants/answer/15130232) selections.
            # @!attribute [rw] destination
            #   @return [::Google::Shopping::Type::Destination::DestinationEnum]
            #     [Marketing methods](https://support.google.com/merchants/answer/15130232)
            #     (also known as destination) selections.
            # @!attribute [rw] state
            #   @return [::Google::Shopping::Merchant::DataSources::V1beta::PrimaryProductDataSource::Destination::State]
            #     The state of the destination.
            class Destination
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # The state of the destination.
              module State
                # Not specified.
                STATE_UNSPECIFIED = 0

                # Indicates that the destination is enabled.
                ENABLED = 1

                # Indicates that the destination is disabled.
                DISABLED = 2
              end
            end

            # Data Source Channel.
            #
            # Channel is used to distinguish between data sources for different product
            # verticals.
            module Channel
              # Not specified.
              CHANNEL_UNSPECIFIED = 0

              # Online product.
              ONLINE_PRODUCTS = 1

              # Local product.
              LOCAL_PRODUCTS = 2

              # Unified data source for both local and online products.
              # Note: Products management through the API is not possible for this
              # channel.
              PRODUCTS = 3
            end
          end

          # The supplemental data source for local and online products. After creation,
          # you should make sure to link the supplemental product data source into one or
          # more primary product data sources.
          # @!attribute [rw] feed_label
          #   @return [::String]
          #     Optional. Immutable. The feed label that is specified on the data source
          #     level.
          #
          #     Must be less than or equal to 20 uppercase letters (A-Z), numbers (0-9),
          #     and dashes (-).
          #
          #     See also [migration to feed
          #     labels](https://developers.google.com/shopping-content/guides/products/feed-labels).
          #
          #     `feedLabel` and `contentLanguage` must be either both set or unset for data
          #     sources with product content type.
          #
          #     They must be set for data sources with a [file
          #     input][google.shopping.merchant.datasources.v1main.FileInput].
          #     The fields must be unset for data sources without [file
          #     input][google.shopping.merchant.datasources.v1main.FileInput].
          #
          #     If set, the data source will only accept products matching this
          #     combination. If unset, the data source will accept produts without that
          #     restriction.
          # @!attribute [rw] content_language
          #   @return [::String]
          #     Optional. Immutable. The two-letter ISO 639-1 language of the items in the
          #     data source.
          #
          #     `feedLabel` and `contentLanguage` must be either both set or unset.
          #     The fields can only be unset for data sources without file input.
          #
          #     If set, the data source will only accept products matching this
          #     combination. If unset, the data source will accept produts without that
          #     restriction.
          # @!attribute [r] referencing_primary_data_sources
          #   @return [::Array<::Google::Shopping::Merchant::DataSources::V1beta::DataSourceReference>]
          #     Output only. The (unordered and deduplicated) list of all primary data
          #     sources linked to this data source in either default or custom rules.
          #     Supplemental data source cannot be deleted before all links are removed.
          class SupplementalProductDataSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The local inventory data source.
          # @!attribute [rw] feed_label
          #   @return [::String]
          #     Required. Immutable. The feed label of the offers to which the local
          #     inventory is provided.
          #
          #     Must be less than or equal to 20 uppercase letters (A-Z), numbers (0-9),
          #     and dashes (-).
          #
          #     See also [migration to feed
          #     labels](https://developers.google.com/shopping-content/guides/products/feed-labels).
          # @!attribute [rw] content_language
          #   @return [::String]
          #     Required. Immutable. The two-letter ISO 639-1 language of the items to
          #     which the local inventory is provided.
          class LocalInventoryDataSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The regional inventory data source.
          # @!attribute [rw] feed_label
          #   @return [::String]
          #     Required. Immutable. The feed label of the offers to which the regional
          #     inventory is provided.
          #
          #     Must be less than or equal to 20 uppercase letters (A-Z), numbers (0-9),
          #     and dashes (-).
          #
          #     See also [migration to feed
          #     labels](https://developers.google.com/shopping-content/guides/products/feed-labels).
          # @!attribute [rw] content_language
          #   @return [::String]
          #     Required. Immutable. The two-letter ISO 639-1 language of the items to
          #     which the regional inventory is provided.
          class RegionalInventoryDataSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The promotion data source.
          # @!attribute [rw] target_country
          #   @return [::String]
          #     Required. Immutable. The target country used as part of the unique
          #     identifier. Represented as a [CLDR territory
          #     code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml).
          #
          #     Promotions are only available in selected
          #     [countries](https://support.google.com/merchants/answer/4588460).
          # @!attribute [rw] content_language
          #   @return [::String]
          #     Required. Immutable. The two-letter ISO 639-1 language of the items in the
          #     data source.
          class PromotionDataSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The product review data source.
          class ProductReviewDataSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The merchant review data source.
          class MerchantReviewDataSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Data source reference can be used to manage related data sources within the
          # data source service.
          # @!attribute [rw] self
          #   @return [::Boolean]
          #     Self should be used to reference the primary data source itself.
          #
          #     Note: The following fields are mutually exclusive: `self`, `primary_data_source_name`, `supplemental_data_source_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] primary_data_source_name
          #   @return [::String]
          #     Optional. The name of the primary data source.
          #     Format:
          #     `accounts/{account}/dataSources/{datasource}`
          #
          #     Note: The following fields are mutually exclusive: `primary_data_source_name`, `self`, `supplemental_data_source_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] supplemental_data_source_name
          #   @return [::String]
          #     Optional. The name of the supplemental data source.
          #     Format:
          #     `accounts/{account}/dataSources/{datasource}`
          #
          #     Note: The following fields are mutually exclusive: `supplemental_data_source_name`, `self`, `primary_data_source_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class DataSourceReference
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
