# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/shopping/merchant/datasources/v1beta/datasources_pb"

module Google
  module Shopping
    module Merchant
      module DataSources
        module V1beta
          module DataSourcesService
            ##
            # Client for the DataSourcesService service.
            #
            # Service to manage primary, supplemental, inventory and other data sources.
            # See more in the [Merchant
            # Center](https://support.google.com/merchants/answer/7439058) help article.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "merchantapi.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :data_sources_service_stub

              ##
              # Configure the DataSourcesService Client class.
              #
              # See {::Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all DataSourcesService clients
              #   ::Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Shopping", "Merchant", "DataSources", "V1beta"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the DataSourcesService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @data_sources_service_stub.universe_domain
              end

              ##
              # Create a new DataSourcesService client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the DataSourcesService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/shopping/merchant/datasources/v1beta/datasources_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @data_sources_service_stub = ::Gapic::ServiceStub.new(
                  ::Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @data_sources_service_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @data_sources_service_stub.logger
              end

              # Service calls

              ##
              # Retrieves the data source configuration for the given account.
              #
              # @overload get_data_source(request, options = nil)
              #   Pass arguments to `get_data_source` via a request object, either of type
              #   {::Google::Shopping::Merchant::DataSources::V1beta::GetDataSourceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Shopping::Merchant::DataSources::V1beta::GetDataSourceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_data_source(name: nil)
              #   Pass arguments to `get_data_source` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the data source to retrieve.
              #     Format: `accounts/{account}/dataSources/{datasource}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Shopping::Merchant::DataSources::V1beta::DataSource]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Shopping::Merchant::DataSources::V1beta::DataSource]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/shopping/merchant/data_sources/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Shopping::Merchant::DataSources::V1beta::GetDataSourceRequest.new
              #
              #   # Call the get_data_source method.
              #   result = client.get_data_source request
              #
              #   # The returned object is of type Google::Shopping::Merchant::DataSources::V1beta::DataSource.
              #   p result
              #
              def get_data_source request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::DataSources::V1beta::GetDataSourceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_data_source.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Shopping::Merchant::DataSources::V1beta::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_data_source.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_data_source.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_sources_service_stub.call_rpc :get_data_source, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the configurations for data sources for the given account.
              #
              # @overload list_data_sources(request, options = nil)
              #   Pass arguments to `list_data_sources` via a request object, either of type
              #   {::Google::Shopping::Merchant::DataSources::V1beta::ListDataSourcesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Shopping::Merchant::DataSources::V1beta::ListDataSourcesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_data_sources(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_data_sources` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The account to list data sources for.
              #     Format: `accounts/{account}`
              #   @param page_size [::Integer]
              #     Optional. The maximum number of data sources to return. The service may
              #     return fewer than this value. The maximum value is 1000; values above 1000
              #     will be coerced to 1000. If unspecified, the maximum number of data sources
              #     will be returned.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListDataSources` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListDataSources`
              #     must match the call that provided the page token.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Shopping::Merchant::DataSources::V1beta::DataSource>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Shopping::Merchant::DataSources::V1beta::DataSource>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/shopping/merchant/data_sources/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Shopping::Merchant::DataSources::V1beta::ListDataSourcesRequest.new
              #
              #   # Call the list_data_sources method.
              #   result = client.list_data_sources request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Shopping::Merchant::DataSources::V1beta::DataSource.
              #     p item
              #   end
              #
              def list_data_sources request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::DataSources::V1beta::ListDataSourcesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_data_sources.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Shopping::Merchant::DataSources::V1beta::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_data_sources.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_data_sources.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_sources_service_stub.call_rpc :list_data_sources, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @data_sources_service_stub, :list_data_sources, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates the new data source configuration for the given account.
              #
              # @overload create_data_source(request, options = nil)
              #   Pass arguments to `create_data_source` via a request object, either of type
              #   {::Google::Shopping::Merchant::DataSources::V1beta::CreateDataSourceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Shopping::Merchant::DataSources::V1beta::CreateDataSourceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_data_source(parent: nil, data_source: nil)
              #   Pass arguments to `create_data_source` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The account where this data source will be created.
              #     Format: `accounts/{account}`
              #   @param data_source [::Google::Shopping::Merchant::DataSources::V1beta::DataSource, ::Hash]
              #     Required. The data source to create.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Shopping::Merchant::DataSources::V1beta::DataSource]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Shopping::Merchant::DataSources::V1beta::DataSource]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/shopping/merchant/data_sources/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Shopping::Merchant::DataSources::V1beta::CreateDataSourceRequest.new
              #
              #   # Call the create_data_source method.
              #   result = client.create_data_source request
              #
              #   # The returned object is of type Google::Shopping::Merchant::DataSources::V1beta::DataSource.
              #   p result
              #
              def create_data_source request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::DataSources::V1beta::CreateDataSourceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_data_source.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Shopping::Merchant::DataSources::V1beta::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_data_source.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_data_source.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_sources_service_stub.call_rpc :create_data_source, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the existing data source configuration. The fields that are
              # set in the update mask but not provided in the resource will be deleted.
              #
              # @overload update_data_source(request, options = nil)
              #   Pass arguments to `update_data_source` via a request object, either of type
              #   {::Google::Shopping::Merchant::DataSources::V1beta::UpdateDataSourceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Shopping::Merchant::DataSources::V1beta::UpdateDataSourceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_data_source(data_source: nil, update_mask: nil)
              #   Pass arguments to `update_data_source` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param data_source [::Google::Shopping::Merchant::DataSources::V1beta::DataSource, ::Hash]
              #     Required. The data source resource to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of data source fields to be updated.
              #
              #     Fields specified in the update mask without a value specified in the
              #     body will be deleted from the data source.
              #
              #     Providing special "*" value for full data source replacement is not
              #     supported.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Shopping::Merchant::DataSources::V1beta::DataSource]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Shopping::Merchant::DataSources::V1beta::DataSource]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/shopping/merchant/data_sources/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Shopping::Merchant::DataSources::V1beta::UpdateDataSourceRequest.new
              #
              #   # Call the update_data_source method.
              #   result = client.update_data_source request
              #
              #   # The returned object is of type Google::Shopping::Merchant::DataSources::V1beta::DataSource.
              #   p result
              #
              def update_data_source request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::DataSources::V1beta::UpdateDataSourceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_data_source.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Shopping::Merchant::DataSources::V1beta::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.data_source&.name
                  header_params["data_source.name"] = request.data_source.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_data_source.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_data_source.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_sources_service_stub.call_rpc :update_data_source, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a data source from your Merchant Center account.
              #
              # @overload delete_data_source(request, options = nil)
              #   Pass arguments to `delete_data_source` via a request object, either of type
              #   {::Google::Shopping::Merchant::DataSources::V1beta::DeleteDataSourceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Shopping::Merchant::DataSources::V1beta::DeleteDataSourceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_data_source(name: nil)
              #   Pass arguments to `delete_data_source` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the data source to delete.
              #     Format: `accounts/{account}/dataSources/{datasource}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/shopping/merchant/data_sources/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Shopping::Merchant::DataSources::V1beta::DeleteDataSourceRequest.new
              #
              #   # Call the delete_data_source method.
              #   result = client.delete_data_source request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_data_source request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::DataSources::V1beta::DeleteDataSourceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_data_source.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Shopping::Merchant::DataSources::V1beta::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_data_source.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_data_source.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_sources_service_stub.call_rpc :delete_data_source, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Performs the data fetch immediately (even outside fetch schedule) on a
              # data source from your Merchant Center Account. If you need to call
              # this method more than once per day, you should use the Products service to
              # update your product data instead.
              # This method only works on data sources with a file input set.
              #
              # @overload fetch_data_source(request, options = nil)
              #   Pass arguments to `fetch_data_source` via a request object, either of type
              #   {::Google::Shopping::Merchant::DataSources::V1beta::FetchDataSourceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Shopping::Merchant::DataSources::V1beta::FetchDataSourceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload fetch_data_source(name: nil)
              #   Pass arguments to `fetch_data_source` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the data source resource to fetch.
              #     Format: `accounts/{account}/dataSources/{datasource}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/shopping/merchant/data_sources/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Shopping::Merchant::DataSources::V1beta::FetchDataSourceRequest.new
              #
              #   # Call the fetch_data_source method.
              #   result = client.fetch_data_source request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def fetch_data_source request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::DataSources::V1beta::FetchDataSourceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.fetch_data_source.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Shopping::Merchant::DataSources::V1beta::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.fetch_data_source.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.fetch_data_source.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_sources_service_stub.call_rpc :fetch_data_source, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the DataSourcesService API.
              #
              # This class represents the configuration for DataSourcesService,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_data_source to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_data_source.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_data_source.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Shopping::Merchant::DataSources::V1beta::DataSourcesService::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "merchantapi.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the DataSourcesService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_data_source`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_data_source
                  ##
                  # RPC-specific configuration for `list_data_sources`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_data_sources
                  ##
                  # RPC-specific configuration for `create_data_source`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_data_source
                  ##
                  # RPC-specific configuration for `update_data_source`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_data_source
                  ##
                  # RPC-specific configuration for `delete_data_source`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_data_source
                  ##
                  # RPC-specific configuration for `fetch_data_source`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :fetch_data_source

                  # @private
                  def initialize parent_rpcs = nil
                    get_data_source_config = parent_rpcs.get_data_source if parent_rpcs.respond_to? :get_data_source
                    @get_data_source = ::Gapic::Config::Method.new get_data_source_config
                    list_data_sources_config = parent_rpcs.list_data_sources if parent_rpcs.respond_to? :list_data_sources
                    @list_data_sources = ::Gapic::Config::Method.new list_data_sources_config
                    create_data_source_config = parent_rpcs.create_data_source if parent_rpcs.respond_to? :create_data_source
                    @create_data_source = ::Gapic::Config::Method.new create_data_source_config
                    update_data_source_config = parent_rpcs.update_data_source if parent_rpcs.respond_to? :update_data_source
                    @update_data_source = ::Gapic::Config::Method.new update_data_source_config
                    delete_data_source_config = parent_rpcs.delete_data_source if parent_rpcs.respond_to? :delete_data_source
                    @delete_data_source = ::Gapic::Config::Method.new delete_data_source_config
                    fetch_data_source_config = parent_rpcs.fetch_data_source if parent_rpcs.respond_to? :fetch_data_source
                    @fetch_data_source = ::Gapic::Config::Method.new fetch_data_source_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
