# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module DataSources
        module V1
          # The data specific for file data sources. This field is empty for other
          # data source inputs.
          # @!attribute [rw] fetch_settings
          #   @return [::Google::Shopping::Merchant::DataSources::V1::FileInput::FetchSettings]
          #     Optional. Fetch details to deliver the data source. It contains settings
          #     for `FETCH` and `GOOGLE_SHEETS` file input types. The required fields vary
          #     based on the frequency of fetching.
          # @!attribute [rw] file_name
          #   @return [::String]
          #     Optional. The file name of the data source. Required for `UPLOAD` file
          #     input type.
          # @!attribute [r] file_input_type
          #   @return [::Google::Shopping::Merchant::DataSources::V1::FileInput::FileInputType]
          #     Output only. The type of file input.
          class FileInput
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Fetch details to deliver the data source.
            # @!attribute [rw] enabled
            #   @return [::Boolean]
            #     Optional. Enables or pauses the fetch schedule.
            # @!attribute [rw] day_of_month
            #   @return [::Integer]
            #     Optional. The day of the month when the data source file should be
            #     fetched (1-31). This field can only be set for monthly frequency.
            # @!attribute [rw] time_of_day
            #   @return [::Google::Type::TimeOfDay]
            #     Optional. The hour of the day when the data source file should be
            #     fetched. Minutes and seconds are not supported and will be ignored.
            # @!attribute [rw] day_of_week
            #   @return [::Google::Type::DayOfWeek]
            #     Optional. The day of the week when the data source file should be
            #     fetched. This field can only be set for weekly frequency.
            # @!attribute [rw] time_zone
            #   @return [::String]
            #     Optional. [Time zone](https://cldr.unicode.org) used for schedule. UTC by
            #     default. For example, "America/Los_Angeles".
            # @!attribute [rw] frequency
            #   @return [::Google::Shopping::Merchant::DataSources::V1::FileInput::FetchSettings::Frequency]
            #     Required. The frequency describing fetch schedule.
            # @!attribute [rw] fetch_uri
            #   @return [::String]
            #     Optional. The URL where the data source file can be fetched. Google
            #     Merchant Center supports automatic scheduled uploads using the HTTP,
            #     HTTPS or SFTP protocols, so the value will need to be a valid link using
            #     one of those three protocols. Immutable for Google Sheets files.
            # @!attribute [rw] username
            #   @return [::String]
            #     Optional. An optional user name for
            #     {::Google::Shopping::Merchant::DataSources::V1::FileInput::FetchSettings#fetch_uri fetch_uri}.
            #     Used for [submitting data sources through
            #     SFTP](https://support.google.com/merchants/answer/13813117).
            # @!attribute [rw] password
            #   @return [::String]
            #     Optional. An optional password for
            #     {::Google::Shopping::Merchant::DataSources::V1::FileInput::FetchSettings#fetch_uri fetch_uri}.
            #     Used for [submitting data sources through
            #     SFTP](https://support.google.com/merchants/answer/13813117).
            class FetchSettings
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # The required fields vary based on the frequency of fetching. For a
              # monthly fetch schedule, `day of month` and [hour of
              # day](../Shared.Types/TimeOfDay) are required. For a weekly fetch
              # schedule, [day of week](../Shared.Types/DayOfWeek) and [hour of
              # day](../Shared.Types/TimeOfDay) are required. For a daily fetch schedule,
              # only an [hour of day](../Shared.Types/TimeOfDay) is required.
              module Frequency
                # Frequency unspecified.
                FREQUENCY_UNSPECIFIED = 0

                # The fetch happens every day.
                FREQUENCY_DAILY = 1

                # The fetch happens every week.
                FREQUENCY_WEEKLY = 2

                # The fetch happens every month.
                FREQUENCY_MONTHLY = 3
              end
            end

            # The method of file delivery.
            module FileInputType
              # File input type unspecified.
              FILE_INPUT_TYPE_UNSPECIFIED = 0

              # The file is uploaded through SFTP, Google Cloud Storage or manually in
              # the Merchant Center.
              UPLOAD = 1

              # The file is fetched from the configured
              # {::Google::Shopping::Merchant::DataSources::V1::FileInput::FetchSettings#fetch_uri fetch_uri}.
              FETCH = 2

              # The file is fetched from Google Sheets specified in the
              # {::Google::Shopping::Merchant::DataSources::V1::FileInput::FetchSettings#fetch_uri fetch_uri}.
              # However, you can't set up `GOOGLE_SHEETS` as a data source through the
              # API. To add `GOOGLE_SHEETS` as a data source through the Merchant Center,
              # see [Add products to Merchant
              # Center](https://support.google.com/merchants/answer/12158053).
              GOOGLE_SHEETS = 3
            end
          end
        end
      end
    end
  end
end
