# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/shopping/merchant/datasources/v1/datasources.proto for package 'Google.Shopping.Merchant.DataSources.V1'
# Original file comments:
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/shopping/merchant/datasources/v1/datasources_pb'

module Google
  module Shopping
    module Merchant
      module DataSources
        module V1
          module DataSourcesService
            # Service to manage primary, supplemental, inventory and other data sources.
            # See more in the [Merchant
            # Center](https://support.google.com/merchants/answer/7439058) help article.
            class Service

              include ::GRPC::GenericService

              self.marshal_class_method = :encode
              self.unmarshal_class_method = :decode
              self.service_name = 'google.shopping.merchant.datasources.v1.DataSourcesService'

              # Retrieves the data source configuration for the given account.
              rpc :GetDataSource, ::Google::Shopping::Merchant::DataSources::V1::GetDataSourceRequest, ::Google::Shopping::Merchant::DataSources::V1::DataSource
              # Lists the configurations for data sources for the given account.
              rpc :ListDataSources, ::Google::Shopping::Merchant::DataSources::V1::ListDataSourcesRequest, ::Google::Shopping::Merchant::DataSources::V1::ListDataSourcesResponse
              # Creates the new data source configuration for the given account.
              # This method always creates a new data source.
              rpc :CreateDataSource, ::Google::Shopping::Merchant::DataSources::V1::CreateDataSourceRequest, ::Google::Shopping::Merchant::DataSources::V1::DataSource
              # Updates the existing data source configuration. The fields that are
              # set in the update mask but not provided in the resource will be deleted.
              rpc :UpdateDataSource, ::Google::Shopping::Merchant::DataSources::V1::UpdateDataSourceRequest, ::Google::Shopping::Merchant::DataSources::V1::DataSource
              # Deletes a data source from your Merchant Center account.
              rpc :DeleteDataSource, ::Google::Shopping::Merchant::DataSources::V1::DeleteDataSourceRequest, ::Google::Protobuf::Empty
              # Performs the data fetch immediately (even outside fetch schedule) on a
              # data source from your Merchant Center Account. If you need to call
              # this method more than once per day, you should use the Products service to
              # update your product data instead.
              # This method only works on data sources with a file input set.
              rpc :FetchDataSource, ::Google::Shopping::Merchant::DataSources::V1::FetchDataSourceRequest, ::Google::Protobuf::Empty
            end

            Stub = Service.rpc_stub_class
          end
        end
      end
    end
  end
end
