# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/shopping/merchant/conversions/v1beta/conversionsources_pb"
require "google/shopping/merchant/conversions/v1beta/conversion_sources_service"

class ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_conversion_source
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    conversion_source = {}

    create_conversion_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_conversion_source, name
      assert_kind_of ::Google::Shopping::Merchant::Conversions::V1beta::CreateConversionSourceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource), request["conversion_source"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_conversion_source_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_conversion_source({ parent: parent, conversion_source: conversion_source }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_conversion_source parent: parent, conversion_source: conversion_source do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_conversion_source ::Google::Shopping::Merchant::Conversions::V1beta::CreateConversionSourceRequest.new(parent: parent, conversion_source: conversion_source) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_conversion_source({ parent: parent, conversion_source: conversion_source }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_conversion_source(::Google::Shopping::Merchant::Conversions::V1beta::CreateConversionSourceRequest.new(parent: parent, conversion_source: conversion_source), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_conversion_source_client_stub.call_rpc_count
    end
  end

  def test_update_conversion_source
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    conversion_source = {}
    update_mask = {}

    update_conversion_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_conversion_source, name
      assert_kind_of ::Google::Shopping::Merchant::Conversions::V1beta::UpdateConversionSourceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource), request["conversion_source"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_conversion_source_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_conversion_source({ conversion_source: conversion_source, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_conversion_source conversion_source: conversion_source, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_conversion_source ::Google::Shopping::Merchant::Conversions::V1beta::UpdateConversionSourceRequest.new(conversion_source: conversion_source, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_conversion_source({ conversion_source: conversion_source, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_conversion_source(::Google::Shopping::Merchant::Conversions::V1beta::UpdateConversionSourceRequest.new(conversion_source: conversion_source, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_conversion_source_client_stub.call_rpc_count
    end
  end

  def test_delete_conversion_source
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_conversion_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_conversion_source, name
      assert_kind_of ::Google::Shopping::Merchant::Conversions::V1beta::DeleteConversionSourceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_conversion_source_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_conversion_source({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_conversion_source name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_conversion_source ::Google::Shopping::Merchant::Conversions::V1beta::DeleteConversionSourceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_conversion_source({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_conversion_source(::Google::Shopping::Merchant::Conversions::V1beta::DeleteConversionSourceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_conversion_source_client_stub.call_rpc_count
    end
  end

  def test_undelete_conversion_source
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    undelete_conversion_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :undelete_conversion_source, name
      assert_kind_of ::Google::Shopping::Merchant::Conversions::V1beta::UndeleteConversionSourceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, undelete_conversion_source_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.undelete_conversion_source({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.undelete_conversion_source name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.undelete_conversion_source ::Google::Shopping::Merchant::Conversions::V1beta::UndeleteConversionSourceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.undelete_conversion_source({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.undelete_conversion_source(::Google::Shopping::Merchant::Conversions::V1beta::UndeleteConversionSourceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, undelete_conversion_source_client_stub.call_rpc_count
    end
  end

  def test_get_conversion_source
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_conversion_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_conversion_source, name
      assert_kind_of ::Google::Shopping::Merchant::Conversions::V1beta::GetConversionSourceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_conversion_source_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_conversion_source({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_conversion_source name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_conversion_source ::Google::Shopping::Merchant::Conversions::V1beta::GetConversionSourceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_conversion_source({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_conversion_source(::Google::Shopping::Merchant::Conversions::V1beta::GetConversionSourceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_conversion_source_client_stub.call_rpc_count
    end
  end

  def test_list_conversion_sources
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Conversions::V1beta::ListConversionSourcesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    show_deleted = true

    list_conversion_sources_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_conversion_sources, name
      assert_kind_of ::Google::Shopping::Merchant::Conversions::V1beta::ListConversionSourcesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal true, request["show_deleted"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_conversion_sources_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_conversion_sources({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_conversion_sources parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_conversion_sources ::Google::Shopping::Merchant::Conversions::V1beta::ListConversionSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_conversion_sources({ parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_conversion_sources(::Google::Shopping::Merchant::Conversions::V1beta::ListConversionSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, show_deleted: show_deleted), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_conversion_sources_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
