# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Conversions
        module V1beta
          # Represents a conversion source owned by a Merchant account. A merchant
          # account can have up to 200 conversion sources.
          # @!attribute [rw] google_analytics_link
          #   @return [::Google::Shopping::Merchant::Conversions::V1beta::GoogleAnalyticsLink]
          #     Immutable. Conversion Source of type "Link to Google Analytics Property".
          #
          #     Note: The following fields are mutually exclusive: `google_analytics_link`, `merchant_center_destination`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] merchant_center_destination
          #   @return [::Google::Shopping::Merchant::Conversions::V1beta::MerchantCenterDestination]
          #     Conversion Source of type "Merchant Center Tag Destination".
          #
          #     Note: The following fields are mutually exclusive: `merchant_center_destination`, `google_analytics_link`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. Identifier. Generated by the Content API upon creation of a
          #     new `ConversionSource`. Format: [a-z]\\{4}:.+ The four characters before the
          #     colon represent the type of conversio source. Content after the colon
          #     represents the ID of the conversion source within that type. The ID of two
          #     different conversion sources might be the same across different types. The
          #     following type prefixes are supported:
          #     - galk: For GoogleAnalyticsLink sources.
          #     - mcdn: For MerchantCenterDestination sources.
          # @!attribute [r] state
          #   @return [::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource::State]
          #     Output only. Current state of this conversion source. Can't be edited
          #     through the API.
          # @!attribute [r] expire_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when an archived conversion source becomes
          #     permanently deleted and is no longer available to undelete.
          # @!attribute [r] controller
          #   @return [::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource::Controller]
          #     Output only. Controller of the conversion source.
          class ConversionSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents state of the conversion source.
            module State
              # Conversion source has unspecified state.
              STATE_UNSPECIFIED = 0

              # Conversion source is fully functional.
              ACTIVE = 1

              # Conversion source has been archived in the last 30 days and not
              # currently functional. Can be restored using the undelete method.
              ARCHIVED = 2

              # Conversion source creation has started but not fully finished yet.
              PENDING = 3
            end

            # Entity controlling the conversion source.
            module Controller
              # Default value. This value is unused.
              CONTROLLER_UNSPECIFIED = 0

              # Controlled by the Merchant who owns the Conversion Source.
              MERCHANT = 1

              # Controlled by the YT Affiliates program.
              YOUTUBE_AFFILIATES = 2
            end
          end

          # Represents attribution settings for conversion sources receiving
          # pre-attribution data.
          # @!attribute [rw] attribution_lookback_window_days
          #   @return [::Integer]
          #     Required. Lookback windows (in days) used for attribution in this source.
          #     Supported values are 7, 30, 40.
          # @!attribute [rw] attribution_model
          #   @return [::Google::Shopping::Merchant::Conversions::V1beta::AttributionSettings::AttributionModel]
          #     Required. Attribution model.
          # @!attribute [rw] conversion_type
          #   @return [::Array<::Google::Shopping::Merchant::Conversions::V1beta::AttributionSettings::ConversionType>]
          #     Immutable. Unordered list. List of different conversion types a conversion
          #     event can be classified as. A standard "purchase" type will be
          #     automatically created if this list is empty at creation time.
          class AttributionSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Message representing a types of conversion events
            # @!attribute [r] name
            #   @return [::String]
            #     Output only. Conversion event name, as it'll be reported by the client.
            # @!attribute [r] report
            #   @return [::Boolean]
            #     Output only. Option indicating if the type should be included in Merchant
            #     Center reporting.
            class ConversionType
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The attribution model used for this source. We support the same set of
            # models offered by Google Analytics 4, as described in:
            # https://support.google.com/analytics/answer/10596866.
            module AttributionModel
              # Unspecified model.
              ATTRIBUTION_MODEL_UNSPECIFIED = 0

              # Cross-channel Last Click model.
              CROSS_CHANNEL_LAST_CLICK = 1

              # Ads-preferred Last Click model.
              ADS_PREFERRED_LAST_CLICK = 2

              # Cross-channel Data Driven model.
              CROSS_CHANNEL_DATA_DRIVEN = 5

              # Cross-channel First Click model.
              CROSS_CHANNEL_FIRST_CLICK = 6

              # Cross-channel Linear model.
              CROSS_CHANNEL_LINEAR = 7

              # Cross-channel Position Based model.
              CROSS_CHANNEL_POSITION_BASED = 8

              # Cross-channel Time Decay model.
              CROSS_CHANNEL_TIME_DECAY = 9
            end
          end

          # "Google Analytics Link" sources can be used to get conversion data from an
          # existing Google Analytics property into the linked Merchant Center account.
          # @!attribute [rw] property_id
          #   @return [::Integer]
          #     Required. Immutable. ID of the Google Analytics property the merchant is
          #     linked to.
          # @!attribute [r] attribution_settings
          #   @return [::Google::Shopping::Merchant::Conversions::V1beta::AttributionSettings]
          #     Output only. Attribution settings for the linked Google Analytics property.
          # @!attribute [r] property
          #   @return [::String]
          #     Output only. Name of the Google Analytics property the merchant is linked
          #     to.
          class GoogleAnalyticsLink
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # "Merchant Center Destination" sources can be used to send conversion events
          # from an online store using a Google tag directly to a Merchant Center account
          # where the source is created.
          # @!attribute [r] destination
          #   @return [::String]
          #     Output only. Merchant Center Destination ID.
          # @!attribute [rw] attribution_settings
          #   @return [::Google::Shopping::Merchant::Conversions::V1beta::AttributionSettings]
          #     Required. Attribution settings being used for the Merchant Center
          #     Destination.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Required. Merchant-specified display name for the destination. This is the
          #     name that identifies the conversion source within the Merchant Center UI.
          #     Limited to 64 characters.
          # @!attribute [rw] currency_code
          #   @return [::String]
          #     Required. Three-letter currency code (ISO 4217). The currency code defines
          #     in which currency the conversions sent to this destination will be reported
          #     in Merchant Center.
          class MerchantCenterDestination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the CreateConversionSource method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The merchant account that will own the new conversion source.
          #     Format: accounts/\\{account}
          # @!attribute [rw] conversion_source
          #   @return [::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource]
          #     Required. The conversion source description. A new ID will be automatically
          #     assigned to it upon creation.
          class CreateConversionSourceRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the UpdateConversionSource method.
          # @!attribute [rw] conversion_source
          #   @return [::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource]
          #     Required. The new version of the conversion source data.
          #     Format: accounts/\\{account}/conversionSources/\\{conversion_source}
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. List of fields being updated.
          class UpdateConversionSourceRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the DeleteConversionSource method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the conversion source to be deleted.
          #     Format: accounts/\\{account}/conversionSources/\\{conversion_source}
          class DeleteConversionSourceRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the UndeleteConversionSource method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the conversion source to be undeleted.
          #     Format: accounts/\\{account}/conversionSources/\\{conversion_source}
          class UndeleteConversionSourceRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the GetConversionSource method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the conversion source to be fetched.
          #     Format: accounts/\\{account}/conversionsources/\\{conversion_source}
          class GetConversionSourceRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the ListConversionSources method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The merchant account who owns the collection of conversion
          #     sources. Format: accounts/\\{account}
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of conversion sources to return in a page.
          #     If no `page_size` is specified, `100` is used as the default value. The
          #     maximum value is `200`. Values above `200` will be coerced to `200`.
          #     Regardless of pagination, at most `200` conversion sources are returned
          #     in total.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. Page token.
          # @!attribute [rw] show_deleted
          #   @return [::Boolean]
          #     Optional. Show deleted (archived) option.
          class ListConversionSourcesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the ListConversionSources method.
          # @!attribute [rw] conversion_sources
          #   @return [::Array<::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource>]
          #     List of conversion sources.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to be used to fetch the next results page.
          class ListConversionSourcesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
