# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/shopping/merchant/conversions/v1beta/conversionsources_pb"
require "google/shopping/merchant/conversions/v1beta/conversion_sources_service/rest/service_stub"

module Google
  module Shopping
    module Merchant
      module Conversions
        module V1beta
          module ConversionSourcesService
            module Rest
              ##
              # REST client for the ConversionSourcesService service.
              #
              # Service for managing conversion sources for a merchant account.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "merchantapi.$UNIVERSE_DOMAIN$"

                include Paths

                # @private
                attr_reader :conversion_sources_service_stub

                ##
                # Configure the ConversionSourcesService Client class.
                #
                # See {::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all ConversionSourcesService clients
                #   ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Shopping", "Merchant", "Conversions", "V1beta"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.timeout = 60.0
                    default_config.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the ConversionSourcesService Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @conversion_sources_service_stub.universe_domain
                end

                ##
                # Create a new ConversionSourcesService REST client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the ConversionSourcesService client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end

                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @conversion_sources_service_stub = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::ServiceStub.new(
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    credentials: credentials,
                    logger: @config.logger
                  )

                  @conversion_sources_service_stub.logger(stub: true)&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end
                end

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @conversion_sources_service_stub.logger
                end

                # Service calls

                ##
                # Creates a new conversion source.
                #
                # @overload create_conversion_source(request, options = nil)
                #   Pass arguments to `create_conversion_source` via a request object, either of type
                #   {::Google::Shopping::Merchant::Conversions::V1beta::CreateConversionSourceRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Shopping::Merchant::Conversions::V1beta::CreateConversionSourceRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_conversion_source(parent: nil, conversion_source: nil)
                #   Pass arguments to `create_conversion_source` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The merchant account that will own the new conversion source.
                #     Format: accounts/\\{account}
                #   @param conversion_source [::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource, ::Hash]
                #     Required. The conversion source description. A new ID will be automatically
                #     assigned to it upon creation.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/shopping/merchant/conversions/v1beta"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Shopping::Merchant::Conversions::V1beta::CreateConversionSourceRequest.new
                #
                #   # Call the create_conversion_source method.
                #   result = client.create_conversion_source request
                #
                #   # The returned object is of type Google::Shopping::Merchant::Conversions::V1beta::ConversionSource.
                #   p result
                #
                def create_conversion_source request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::Conversions::V1beta::CreateConversionSourceRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_conversion_source.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Shopping::Merchant::Conversions::V1beta::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_conversion_source.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_conversion_source.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @conversion_sources_service_stub.create_conversion_source request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Updates information of an existing conversion source. Available only for
                # Merchant Center Destination conversion sources.
                #
                # @overload update_conversion_source(request, options = nil)
                #   Pass arguments to `update_conversion_source` via a request object, either of type
                #   {::Google::Shopping::Merchant::Conversions::V1beta::UpdateConversionSourceRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Shopping::Merchant::Conversions::V1beta::UpdateConversionSourceRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_conversion_source(conversion_source: nil, update_mask: nil)
                #   Pass arguments to `update_conversion_source` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param conversion_source [::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource, ::Hash]
                #     Required. The new version of the conversion source data.
                #     Format: accounts/\\{account}/conversionSources/\\{conversion_source}
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Required. List of fields being updated.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/shopping/merchant/conversions/v1beta"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Shopping::Merchant::Conversions::V1beta::UpdateConversionSourceRequest.new
                #
                #   # Call the update_conversion_source method.
                #   result = client.update_conversion_source request
                #
                #   # The returned object is of type Google::Shopping::Merchant::Conversions::V1beta::ConversionSource.
                #   p result
                #
                def update_conversion_source request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::Conversions::V1beta::UpdateConversionSourceRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_conversion_source.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Shopping::Merchant::Conversions::V1beta::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_conversion_source.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_conversion_source.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @conversion_sources_service_stub.update_conversion_source request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Archives an existing conversion source. If the conversion source is a
                # Merchant Center Destination, it will be recoverable for 30 days. If the
                # conversion source is a Google Analytics Link, it will be deleted
                # immediately and can be restored by creating a new one.
                #
                # @overload delete_conversion_source(request, options = nil)
                #   Pass arguments to `delete_conversion_source` via a request object, either of type
                #   {::Google::Shopping::Merchant::Conversions::V1beta::DeleteConversionSourceRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Shopping::Merchant::Conversions::V1beta::DeleteConversionSourceRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_conversion_source(name: nil)
                #   Pass arguments to `delete_conversion_source` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the conversion source to be deleted.
                #     Format: accounts/\\{account}/conversionSources/\\{conversion_source}
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/shopping/merchant/conversions/v1beta"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Shopping::Merchant::Conversions::V1beta::DeleteConversionSourceRequest.new
                #
                #   # Call the delete_conversion_source method.
                #   result = client.delete_conversion_source request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_conversion_source request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::Conversions::V1beta::DeleteConversionSourceRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_conversion_source.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Shopping::Merchant::Conversions::V1beta::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_conversion_source.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_conversion_source.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @conversion_sources_service_stub.delete_conversion_source request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Re-enables an archived conversion source. Only Available for Merchant
                # Center Destination conversion sources.
                #
                # @overload undelete_conversion_source(request, options = nil)
                #   Pass arguments to `undelete_conversion_source` via a request object, either of type
                #   {::Google::Shopping::Merchant::Conversions::V1beta::UndeleteConversionSourceRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Shopping::Merchant::Conversions::V1beta::UndeleteConversionSourceRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload undelete_conversion_source(name: nil)
                #   Pass arguments to `undelete_conversion_source` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the conversion source to be undeleted.
                #     Format: accounts/\\{account}/conversionSources/\\{conversion_source}
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/shopping/merchant/conversions/v1beta"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Shopping::Merchant::Conversions::V1beta::UndeleteConversionSourceRequest.new
                #
                #   # Call the undelete_conversion_source method.
                #   result = client.undelete_conversion_source request
                #
                #   # The returned object is of type Google::Shopping::Merchant::Conversions::V1beta::ConversionSource.
                #   p result
                #
                def undelete_conversion_source request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::Conversions::V1beta::UndeleteConversionSourceRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.undelete_conversion_source.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Shopping::Merchant::Conversions::V1beta::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.undelete_conversion_source.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.undelete_conversion_source.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @conversion_sources_service_stub.undelete_conversion_source request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Fetches a conversion source.
                #
                # @overload get_conversion_source(request, options = nil)
                #   Pass arguments to `get_conversion_source` via a request object, either of type
                #   {::Google::Shopping::Merchant::Conversions::V1beta::GetConversionSourceRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Shopping::Merchant::Conversions::V1beta::GetConversionSourceRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_conversion_source(name: nil)
                #   Pass arguments to `get_conversion_source` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param name [::String]
                #     Required. The name of the conversion source to be fetched.
                #     Format: accounts/\\{account}/conversionsources/\\{conversion_source}
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/shopping/merchant/conversions/v1beta"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Shopping::Merchant::Conversions::V1beta::GetConversionSourceRequest.new
                #
                #   # Call the get_conversion_source method.
                #   result = client.get_conversion_source request
                #
                #   # The returned object is of type Google::Shopping::Merchant::Conversions::V1beta::ConversionSource.
                #   p result
                #
                def get_conversion_source request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::Conversions::V1beta::GetConversionSourceRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_conversion_source.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Shopping::Merchant::Conversions::V1beta::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_conversion_source.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_conversion_source.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @conversion_sources_service_stub.get_conversion_source request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Retrieves the list of conversion sources the caller has access to.
                #
                # @overload list_conversion_sources(request, options = nil)
                #   Pass arguments to `list_conversion_sources` via a request object, either of type
                #   {::Google::Shopping::Merchant::Conversions::V1beta::ListConversionSourcesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Shopping::Merchant::Conversions::V1beta::ListConversionSourcesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_conversion_sources(parent: nil, page_size: nil, page_token: nil, show_deleted: nil)
                #   Pass arguments to `list_conversion_sources` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param parent [::String]
                #     Required. The merchant account who owns the collection of conversion
                #     sources. Format: accounts/\\{account}
                #   @param page_size [::Integer]
                #     Optional. The maximum number of conversion sources to return in a page.
                #     If no `page_size` is specified, `100` is used as the default value. The
                #     maximum value is `200`. Values above `200` will be coerced to `200`.
                #     Regardless of pagination, at most `200` conversion sources are returned
                #     in total.
                #   @param page_token [::String]
                #     Optional. Page token.
                #   @param show_deleted [::Boolean]
                #     Optional. Show deleted (archived) option.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/shopping/merchant/conversions/v1beta"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Shopping::Merchant::Conversions::V1beta::ListConversionSourcesRequest.new
                #
                #   # Call the list_conversion_sources method.
                #   result = client.list_conversion_sources request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSource.
                #     p item
                #   end
                #
                def list_conversion_sources request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::Conversions::V1beta::ListConversionSourcesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_conversion_sources.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Shopping::Merchant::Conversions::V1beta::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_conversion_sources.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_conversion_sources.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @conversion_sources_service_stub.list_conversion_sources request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @conversion_sources_service_stub, :list_conversion_sources, "conversion_sources", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the ConversionSourcesService REST API.
                #
                # This class represents the configuration for ConversionSourcesService REST,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # create_conversion_source to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.create_conversion_source.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Shopping::Merchant::Conversions::V1beta::ConversionSourcesService::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.create_conversion_source.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`String`) The path to a service account key file in JSON format
                #    *  (`Hash`) A service account key as a Hash
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`nil`) indicating no credentials
                #
                #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "merchantapi.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration RPC class for the ConversionSourcesService API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `create_conversion_source`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_conversion_source
                    ##
                    # RPC-specific configuration for `update_conversion_source`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_conversion_source
                    ##
                    # RPC-specific configuration for `delete_conversion_source`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_conversion_source
                    ##
                    # RPC-specific configuration for `undelete_conversion_source`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :undelete_conversion_source
                    ##
                    # RPC-specific configuration for `get_conversion_source`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_conversion_source
                    ##
                    # RPC-specific configuration for `list_conversion_sources`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_conversion_sources

                    # @private
                    def initialize parent_rpcs = nil
                      create_conversion_source_config = parent_rpcs.create_conversion_source if parent_rpcs.respond_to? :create_conversion_source
                      @create_conversion_source = ::Gapic::Config::Method.new create_conversion_source_config
                      update_conversion_source_config = parent_rpcs.update_conversion_source if parent_rpcs.respond_to? :update_conversion_source
                      @update_conversion_source = ::Gapic::Config::Method.new update_conversion_source_config
                      delete_conversion_source_config = parent_rpcs.delete_conversion_source if parent_rpcs.respond_to? :delete_conversion_source
                      @delete_conversion_source = ::Gapic::Config::Method.new delete_conversion_source_config
                      undelete_conversion_source_config = parent_rpcs.undelete_conversion_source if parent_rpcs.respond_to? :undelete_conversion_source
                      @undelete_conversion_source = ::Gapic::Config::Method.new undelete_conversion_source_config
                      get_conversion_source_config = parent_rpcs.get_conversion_source if parent_rpcs.respond_to? :get_conversion_source
                      @get_conversion_source = ::Gapic::Config::Method.new get_conversion_source_config
                      list_conversion_sources_config = parent_rpcs.list_conversion_sources if parent_rpcs.respond_to? :list_conversion_sources
                      @list_conversion_sources = ::Gapic::Config::Method.new list_conversion_sources_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
